/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game
implements FlowHandler {
    public static boolean smMainMenuSeen = false;
    private ApplicationControl mApplicationControl;
    private GameEngine mGameEngine;
    private SpriteObject mDChocLogo;
    private SpriteObject mTitleLogo;
    private int mLogoCounter = 5000;
    private static boolean smLevelSelectionLoaded = false;
    private MenuObject mCurrentMenu;
    private int mCurrentState;
    private boolean mPauseEventScheduled;
    private int mCurrentMusic = -1;
    private boolean mGMGBrowserStarted;
    private boolean mGMGVisited;
    private int mPreviousState;
    private int mSelectedLanguage = -1;
    private static final int[] CHEAT_CODE = new int[]{50, 50, 54, 50, 54, 50, 55, 50, 54, 50};
    private boolean mCheatsEnabled;
    private int[] mCheatCodeInputBuffer;
    private int mCheatCodeInputBufferIndex;
    private MenuObject mCheatBox;
    private int mCheatBoxTimer;
    public static int smMenuTimer = 0;
    private boolean mEnableTellAFriend;
    private boolean mEnableGetMoreGames;
    private boolean mFreeTrialMode = false;
    private ILicenseManager mLicenseManager;
    private boolean mDemoTimerEnabled;
    private boolean mLicenseManagerAppStarted;
    private boolean mLicenseManagerActivated;
    private ImageFont mSimpleFont;
    private ImageFont mTitleFont;
    private boolean mMenuGroup;
    private boolean mMenuResourcesLoaded;
    CutScene mCutScene;
    private String mLockedStr;

    public Game(ApplicationControl applicationControl, ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3) {
        this.mApplicationControl = applicationControl;
        this.mGameEngine = new GameEngine();
        this.mTitleFont = imageFont;
        GameEngine.setImageFonts(imageFont, imageFont2, imageFont3, this.mSimpleFont);
        MenuObject.setDefaultImageFonts(imageFont, imageFont2, imageFont3);
        this.mEnableTellAFriend = false;
        this.mEnableGetMoreGames = Toolkit.getToolkitProperty(5) != null;
        this.mLicenseManager = Toolkit.getLicenseManager();
        this.mFreeTrialMode = this.mLicenseManager.getLicenseMode() == 4;
        String string = Toolkit.getToolkitProperty(11);
        int n = 0;
        if (string != null) {
            n = Integer.parseInt(string) * 1000;
        }
        this.mGameEngine.setLicenseManager(this.mLicenseManager, this.mFreeTrialMode, n);
        try {
            this.mSimpleFont = new ImageFont(null, null, Font.getFont((int)32, (int)0, (int)8), 0, -1);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        GameEngine.loadGame();
        this.mCurrentMusic = -1;
        this.loadSettings();
    }

    private void freeCheatBox() {
        if (this.mCheatBox != null) {
            this.mCheatBox.releaseScreen();
            this.mCheatBox = null;
        }
    }

    private void createCheatBox() {
        int n = Toolkit.getScreenWidth() - (Toolkit.getScreenWidth() >> 2);
        int n2 = Toolkit.getScreenHeight() - (Toolkit.getScreenHeight() >> 2) - Toolkit.getSoftKeyAreaHeight();
        int n3 = Toolkit.getScreenWidth() - n >> 1;
        int n4 = Toolkit.getScreenHeight() - n2 >> 1;
        this.mCheatBoxTimer = 2000;
        this.mCheatBox = new MenuObject();
        this.mCheatBox.setScreen(1, 1, 3);
        this.mCheatBox.setItem(0, 1, Toolkit.getText(20), null, -1);
        this.mCheatBox.setSoftkey(1, 0);
        this.mCheatBox.setStyle(4);
        this.mCheatBox.setBounds(n3, n4, n, n2);
    }

    public void pauseGame() {
        this.mPauseEventScheduled = true;
        this.mCurrentMusic = -1;
    }

    public int logicUpdate(int n, int n2) {
        if (n != 10 && n != 4) {
            this.updateMusic(n);
        }
        if (n != 30 || GameEngine.smGameState != 0) {
            DChocMIDlet.skipTimer();
        }
        if (this.mLicenseManagerActivated) {
            this.mLicenseManagerActivated = false;
            return 0;
        }
        if (this.mPauseEventScheduled) {
            this.mPauseEventScheduled = false;
            if (n == 30) {
                return 22;
            }
        }
        switch (n) {
            case 22: {
                if (this.mDChocLogo.isFinishedAnimation()) {
                    return -2;
                }
                this.mDChocLogo.logicUpdate(n2);
                break;
            }
            case 23: {
                this.mLogoCounter -= n2;
                this.mTitleLogo.logicUpdate(n2);
                if (this.mLogoCounter >= 0 && !this.mTitleLogo.isFinishedAnimation()) break;
                return -2;
            }
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: {
                int n3 = this.mLicenseManager.logicUpdate(n2);
                if (n3 == 0) break;
                boolean bl = this.mFreeTrialMode = n3 == 4;
                if (n == 29) {
                    return -3;
                }
                return -2;
            }
            case 38: {
                int n3 = GameEngine.updateLevelSelection(n2);
                if (n3 == 1) {
                    return 33;
                }
                if (n3 == 3) {
                    return 35;
                }
                if (n3 != 2) break;
                return 34;
            }
            case 30: {
                int n3 = this.mGameEngine.logicUpdate(n2);
                if (n3 == 1) {
                    return 22;
                }
                if (n3 == 3) {
                    if (GameEngine.smQuickGame) {
                        GameEngine.smGameState = 0;
                        GameEngine.smPlayerState = 0;
                        return 25;
                    }
                    GameEngine.smDrawBlankScreen = false;
                    return 26;
                }
                if (n3 != 2) break;
                GameEngine.smLevelSelectionLevel = GameEngine.getLastUnlockedLevel();
                if (GameEngine.smLevelSelectionLevel >= 10) {
                    GameEngine.smLevelSelectionLevel = GameEngine.getLastUnlockedLevel();
                    if (++GameEngine.smLevelSelectionArea >= 5) {
                        GameEngine.smLevelSelectionArea = 4;
                    }
                }
                if (!this.mCheatsEnabled) {
                    boolean bl = false;
                }
                return 24;
            }
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 34: {
                int n4 = GetMoreGamesMultiLink.logicUpdate(n2);
                if (n4 == 0) break;
                this.mGMGBrowserStarted = n4 == 1;
                this.mGMGVisited = true;
                this.saveSettings();
                return -3;
            }
            case 35: 
            case 36: 
            case 37: 
            case 40: {
                int n3 = 0;
                this.mCutScene.logicUpdate(n2);
                if (!this.mCutScene.isCutSceneFinished()) break;
                n3 = 40;
                GameEngine.saveGame();
                return n3;
            }
            case 41: {
                int n3 = 0;
                this.mCutScene.logicUpdate(n2);
                if (!this.mCutScene.isCutSceneFinished()) break;
                n3 = 39;
                GameEngine.saveGame();
                return n3;
            }
            case 39: {
                int n3 = 0;
                this.mCutScene.logicUpdate(n2);
                if (!this.mCutScene.isCutSceneFinished()) break;
                n3 = 41;
                GameEngine.smIntroShown = true;
                GameEngine.saveGame();
                return n3;
            }
            case 44: {
                int n3 = 0;
                this.mCutScene.logicUpdate(n2);
                if (!this.mCutScene.isCutSceneFinished()) break;
                n3 = 35;
                return n3;
            }
            case 42: {
                int n4 = GameEngine.updateAchievementsScreen(n2);
                if (n4 != 3) break;
                return 42;
            }
            case 0: {
                break;
            }
            case 43: {
                int n4 = GameEngine.updateWardrobe(n2);
                if (n4 != 4) break;
                return 36;
            }
        }
        if (this.mCheatBoxTimer > 0) {
            this.mCheatBoxTimer -= n2;
            if (this.mCheatBoxTimer <= 0) {
                this.freeCheatBox();
            }
        }
        if (this.mMenuResourcesLoaded && this.mMenuGroup && GameEngine.smBackgroundIsDrawn && GameEngine.smDrawApeMenuBackground) {
            GameEngine.smAccumulatedTime += n2;
            while (GameEngine.smAccumulatedTime > 33) {
                GameEngine.updateMenuBackground(false, 0, 0);
                GameEngine.smAccumulatedTime -= 33;
            }
            smMenuTimer += n2;
            GameEngine.smTimer += n2;
        }
        return -1;
    }

    private void drawTitleScreen(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        this.mTitleLogo.draw(graphics, Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
    }

    public void doDraw(int n, Graphics graphics) {
        GameEngine.smBackgroundIsDrawn = false;
        switch (n) {
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: {
                this.drawMenuBackground(graphics, n, 0);
                this.mLicenseManager.doDraw(graphics);
                break;
            }
            case 22: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
                this.mDChocLogo.draw(graphics, Toolkit.getScreenWidth() >> 1, Toolkit.getScreenHeight() >> 1);
                break;
            }
            case 23: {
                this.drawTitleScreen(graphics);
                break;
            }
            case 38: {
                GameEngine.drawLevelSelection(graphics);
                break;
            }
            case 30: {
                this.mGameEngine.doDraw(graphics, n);
                break;
            }
            case 24: 
            case 31: 
            case 34: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                this.drawMenuBackground(graphics, n, 0);
                GetMoreGamesMultiLink.doDraw(graphics);
                break;
            }
            case 40: 
            case 41: {
                this.mGameEngine.doDraw(graphics, n);
                this.mCutScene.draw(graphics, VisualEngine.smScreenWidth / 2, VisualEngine.smScreenHeight / 2);
                break;
            }
            case 44: {
                VisualEngine.drawLevelSelectionBackground(graphics);
                this.mCutScene.draw(graphics, VisualEngine.smScreenWidth / 2, VisualEngine.smScreenHeight / 2);
                break;
            }
            case 39: {
                this.mCutScene.draw(graphics, VisualEngine.smScreenWidth / 2, VisualEngine.smScreenHeight / 2);
                break;
            }
            case 42: {
                this.drawMenuBackground(graphics, n, 0);
                GameEngine.drawAchievementsScreen(graphics);
                break;
            }
            case 10: 
            case 11: 
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 43: {
                VisualEngine.drawLevelSelectionBackground(graphics);
                VisualEngine.drawWardrobe(graphics);
                break;
            }
        }
    }

    public void switchState(int n, int n2, MenuObject menuObject) {
        switch (n2) {
            case 0: {
                this.mDemoTimerEnabled = false;
                smMainMenuSeen = true;
                break;
            }
            case 2: {
                if (n == 0) {
                    GameEngine.smDrawApeMenuBackground = true;
                }
                if (n != 10) break;
                GameEngine.smDrawApeMenuBackground = false;
                break;
            }
            case 30: {
                this.mDemoTimerEnabled = true;
                if (!GameEngine.smQuickGame || n != 55) break;
                GameEngine.startQuickGame();
                break;
            }
            case 38: {
                GameEngine.startLevelSelection();
                break;
            }
            case 42: {
                GameEngine.smUpdateSoftKeys = true;
                break;
            }
            case 43: {
                GameEngine.smUpdateSoftKeys = true;
            }
        }
        if (n == 4 || n == 10) {
            this.saveSettings();
        }
        this.mPreviousState = n;
        if (n2 == 10 || n2 == 4) {
            this.updateMusic(n2);
        }
        this.mCurrentMenu = menuObject;
        this.mCurrentState = n2;
    }

    private void loadMenuResources() {
        VisualEngine.loadMenuSprites();
        this.mMenuResourcesLoaded = true;
    }

    private void resetMenuResources() {
        GameEngine.resetMenuLogic();
    }

    private void freeMenuResources() {
        this.mMenuGroup = false;
        VisualEngine.freeMenuSprites();
        this.mMenuResourcesLoaded = false;
    }

    public void keyEventOccurred(int n, int n2, int n3) {
        int n4 = Toolkit.getToolkitGameAction(n2);
        boolean bl = n3 == 0 && n4 == 53 || n3 == 3 && Toolkit.getSoftKeyType(n2) == 0;
        switch (n) {
            case 8: {
                if (n3 != 0 || n4 != 50 && n4 != 56) break;
                int n5 = this.mCurrentMenu.getSelectedItem();
                Toolkit.setSoftKeyLabel(0, Toolkit.getLanguageDescriptions()[n5][1]);
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 32: 
            case 33: {
                this.mLicenseManager.keyEventOccurred(n2, n3);
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 34: {
                GetMoreGamesMultiLink.keyEventOccurred(n2, n3);
                break;
            }
            case 30: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 42: {
                this.mGameEngine.keyEventOccurred(n2, n3);
                break;
            }
            case 43: {
                this.mGameEngine.keyEventOccurred(n2, n3);
                VisualEngine.smShopTexts[GameEngine.smSelectedWardrobePowerup].keyEventOccurred(n2, n3);
                break;
            }
            case 22: {
                if (bl) {
                    this.mDChocLogo.setAnimationFrame(this.mDChocLogo.getFrameCount() - 1);
                }
            }
            case 23: {
                if (n != 23 || !bl) break;
                this.mLogoCounter = 0;
                break;
            }
            case 0: {
                if (n3 != 0 || Toolkit.getToolkitProperty(16) == null) break;
                if (this.mCheatCodeInputBuffer == null) {
                    this.mCheatCodeInputBuffer = new int[CHEAT_CODE.length];
                }
                this.mCheatCodeInputBuffer[this.mCheatCodeInputBufferIndex % Game.CHEAT_CODE.length] = n4;
                boolean bl2 = false;
                for (int i = 0; i < CHEAT_CODE.length && !bl2; ++i) {
                    int n6 = this.mCheatCodeInputBuffer[(this.mCheatCodeInputBufferIndex + i + 1) % CHEAT_CODE.length];
                    if (n6 == CHEAT_CODE[i]) continue;
                    bl2 = true;
                }
                if (!bl2) {
                    this.mCheatsEnabled = true;
                    this.mGameEngine.enableCheats();
                    this.createCheatBox();
                }
                ++this.mCheatCodeInputBufferIndex;
                break;
            }
            case 7: {
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 44: {
                this.mCutScene.keyEventOccurred(n2, n3);
            }
        }
    }

    public boolean evaluateBranchCondition(int n) {
        switch (n) {
            case 59: 
            case 60: 
            case 61: {
                return true;
            }
            case 62: {
                if (this.mGameEngine.newAreaUnlocked) {
                    this.mGameEngine.newAreaUnlocked = false;
                    return true;
                }
                return false;
            }
            case 45: {
                return this.mSelectedLanguage == -1;
            }
            case 47: {
                return true;
            }
            case 51: {
                return false;
            }
            case 46: {
                return this.mLicenseManagerAppStarted;
            }
            case 48: {
                return false;
            }
            case 49: {
                return this.mLicenseManager.setState(3);
            }
            case 50: {
                return this.mLicenseManager.setState(5);
            }
            case 52: {
                return false;
            }
            case 54: {
                return GameEngine.isPreGameCutScene();
            }
            case 57: {
                boolean bl = !GameEngine.smQuickGame && Tuner.DATA_CUTSCENE_LEVELS[GameEngine.smCurrentLevel * 2 + 1] != null && Tuner.DATA_CUTSCENE_LEVELS[GameEngine.smCurrentLevel * 2 + 1].length > 0;
                return bl;
            }
            case 53: {
                GameEngine.smLevelSelectionArea = GameEngine.getLastUnlockedArea();
                GameEngine.smLevelSelectionLevel = GameEngine.getLastUnlockedLevel();
                if (GameEngine.smIntroShown) {
                    return false;
                }
                GameEngine.smIntroShown = true;
                GameEngine.saveGame();
                return true;
            }
            case 58: {
                if (GameEngine.smFruitsStored > Tuner.POWERUP_PRICES[1] && !GameEngine.smWardrobeIntroShown) {
                    GameEngine.smWardrobeIntroShown = true;
                    GameEngine.smSelectedWardrobePowerup = 1;
                    GameEngine.saveGame();
                    return true;
                }
                return false;
            }
            case 56: {
                GameEngine.smGameState = 0;
                GameEngine.smPlayerState = 0;
                return !GameEngine.smQuickGame;
            }
            case 55: {
                return GameEngine.smQuickGame;
            }
        }
        return false;
    }

    public void drawMenu(int n, Graphics graphics, MenuObject menuObject) {
        this.drawMenuBackground(graphics, n, menuObject.mTitleBarHeight);
        menuObject.doDraw(graphics);
        if (n == 0 && this.mCheatBox != null) {
            this.mCheatBox.doDraw(graphics);
        }
    }

    private void drawMenuBackground(Graphics graphics, int n, int n2) {
        GameEngine.smBackgroundIsDrawn = true;
        VisualEngine.drawMenuBackground(graphics, n, n2);
    }

    public void eventOccurred(int n, int n2) {
        switch (n2) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                VisualEngine.smLevelBackground = GameEngine.smLevelSelectionArea = this.mCurrentMenu.getSelectedItem();
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                GameEngine.smCurrentLevel = GameEngine.smLevelSelectionLevel = GameEngine.getCurrentLevel(GameEngine.smLevelSelectionArea, this.mCurrentMenu.getSelectedItem());
                this.mGameEngine.startGame();
                break;
            }
            case 51: {
                this.mSelectedLanguage = this.mCurrentMenu.getSelectedItem();
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                this.saveSettings();
                break;
            }
            case 47: {
                this.mSelectedLanguage = this.mCurrentMenu.getSelectedItem();
                if (this.mSelectedLanguage == Toolkit.getSelectedLanguageIndex()) break;
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                this.saveSettings();
                break;
            }
            case 5: {
                DChocMIDlet.getInstance().m_exitApplication = true;
                break;
            }
            case 49: {
                this.setSoundsEnabled(true);
                break;
            }
            case 50: {
                this.setSoundsEnabled(false);
                break;
            }
            case 28: 
            case 29: 
            case 43: 
            case 44: {
                int n3 = n2 == 44 ? 1 : 2;
                int n4 = this.mCurrentMenu.getItemIntValue(n3);
                Toolkit.setMusicVolume(n4);
                Toolkit.playMusic(65544, 1);
                break;
            }
            case 30: 
            case 31: 
            case 45: 
            case 46: 
            case 48: {
                GameEngine.resetRecords();
                this.mApplicationControl.setLanguage(this.mSelectedLanguage);
                break;
            }
            case 27: {
                GameEngine.continueGame();
                break;
            }
            case 37: {
                GameEngine.restartLevel();
                break;
            }
            case 3: {
                GameEngine.smQuickGame = false;
                GameEngine.startLevelSelection();
                break;
            }
            case 4: {
                GameEngine.smQuickGame = true;
                break;
            }
            case 33: {
                this.mGameEngine.startGame();
                break;
            }
            case 2: {
                this.mGMGVisited = true;
            }
        }
    }

    public String processText(int n, int n2, int n3) {
        if (n == 3) {
            if (n3 == 0 && this.mFreeTrialMode) {
                n2 = 18;
            }
            if (n2 == 22) {
                // empty if block
            }
        } else if (n == 0) {
            if (n3 == 0) {
                return this.mLicenseManager.getLicenseManagerMenuItemLabel();
            }
            if (n3 == 13) {
                return null;
            }
            if (n3 == 6) {
                return null;
            }
            if (n3 == 7) {
                return null;
            }
        } else {
            if (n2 == -2 && (n == 4 && n3 == 3 || n == 10 && n3 == 3)) {
                return null;
            }
            if (n == 11 && n3 == 0 && GameEngine.smQuickGame) {
                return Toolkit.getText(40);
            }
        }
        return Toolkit.getText(n2);
    }

    public void processMenu(int n, MenuObject menuObject, int n2) {
        if (n2 != 0) {
            if (n2 == 1) {
                switch (n) {
                    case 8: {
                        menuObject.setImageFonts(null, this.mSimpleFont, this.mSimpleFont);
                        break;
                    }
                    case 7: {
                        menuObject.setImageFonts(null, this.mSimpleFont, this.mSimpleFont);
                    }
                }
            } else if (n2 == 2) {
                int n3 = Toolkit.getMusicVolume();
                switch (n) {
                    case 20: {
                        break;
                    }
                    case 19: {
                        break;
                    }
                    case 10: {
                        menuObject.setItemIntValue(2, n3);
                        break;
                    }
                    case 4: {
                        menuObject.setItemIntValue(1, n3);
                    }
                }
            } else if (n2 == 3) {
                // empty if block
            }
        }
    }

    public boolean isMenuNeeded(int n) {
        if (n == 8 || n == 9) {
            if (n == 8 && this.mSelectedLanguage != -1) {
                return false;
            }
            if (Toolkit.getLanguageDescriptions().length == 1) {
                return false;
            }
        }
        return true;
    }

    public boolean isChildGroup(int n, int n2) {
        if (n2 == 1) {
            return n == 0 || n == 2;
        }
        return false;
    }

    public int getStateGroupLoadingCount(int n) {
        switch (n) {
            case 3: {
                return 6;
            }
            case 4: {
                return 2;
            }
            case 0: 
            case 1: 
            case 6: 
            case 8: {
                return this.mMenuResourcesLoaded ? 0 : 1;
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    public void loadStateGroup(int n, int n2) {
        switch (n) {
            case 3: {
                if (n2 == 0) {
                    this.mLicenseManagerAppStarted = this.mLicenseManager.setState(2);
                    break;
                }
                if (n2 == 1) {
                    if (!this.mLicenseManagerAppStarted) break;
                    this.mLicenseManager.initMenus();
                    break;
                }
                if (n2 == 2 || n2 == 3 || n2 == 4 || n2 != 5) break;
                break;
            }
            case 4: {
                if (n2 == 0) {
                    this.loadTitleScreen();
                    break;
                }
                if (n2 != 1) break;
                this.mDChocLogo = new SpriteObject(DavinciUtilities.loadAnimation(196643), false);
                break;
            }
            case 0: 
            case 1: {
                this.mMenuGroup = true;
                if (!this.mMenuResourcesLoaded) {
                    this.loadMenuResources();
                    if (!GameEngine.smDrawApeMenuBackground) break;
                    this.resetMenuResources();
                    break;
                }
                if (!GameEngine.smDrawApeMenuBackground) break;
                this.resetMenuResources();
                break;
            }
            case 6: 
            case 8: {
                if (this.mLockedStr == null) {
                    this.mLockedStr = Toolkit.getText(225);
                }
                this.mMenuGroup = true;
                if (!this.mMenuResourcesLoaded) {
                    this.loadMenuResources();
                    if (!GameEngine.smDrawApeMenuBackground) break;
                    this.resetMenuResources();
                    break;
                }
                if (!GameEngine.smDrawApeMenuBackground) break;
                this.resetMenuResources();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    public void unloadStateGroup(int n, int n2) {
        switch (n) {
            case 4: {
                this.mTitleLogo.freeResources();
                this.mTitleLogo = null;
                this.mDChocLogo.freeResources();
                this.mDChocLogo = null;
                SpriteObject.releaseEffectBuffer();
                break;
            }
            case 0: 
            case 6: 
            case 8: {
                this.mLockedStr = null;
                this.freeMenuResources();
                break;
            }
        }
    }

    public int getStateLoadingCount(int n) {
        switch (n) {
            case 24: 
            case 25: 
            case 26: 
            case 29: 
            case 37: {
                return 100;
            }
            case 30: {
                if (GameEngine.isPreGameCutScene()) {
                    return 0;
                }
                return this.mGameEngine.getLoadingCount();
            }
            case 42: {
                return GameEngine.getAchievementLoadingStepCount();
            }
            case 38: {
                if (!smLevelSelectionLoaded) {
                    return Math.max(100, this.mGameEngine.getLoadingCount());
                }
                return 0;
            }
            case 43: {
                return 0;
            }
            case 39: 
            case 40: 
            case 41: 
            case 44: {
                return Math.max(100, this.mGameEngine.getLoadingCount());
            }
        }
        return 0;
    }

    public int getDavinciLoadingPercentage(int n) {
        return 75;
    }

    public void setLoading(int n, boolean bl) {
        if (bl) {
            Toolkit.stopMusic();
            this.mCurrentMusic = -1;
        } else {
            DChocMIDlet.getInstance().resetTimer();
        }
    }

    public void loadState(int n, int n2) {
        switch (n) {
            case 25: 
            case 26: {
                if (n2 != 1) break;
                GetMoreGamesMultiLink.initMenus();
                break;
            }
            case 24: 
            case 29: {
                if (n2 != 1) break;
                this.mLicenseManager.setState(4);
                this.mLicenseManager.initMenus();
                break;
            }
            case 30: 
            case 37: {
                this.mGameEngine.load(n2);
                break;
            }
            case 38: {
                GameEngine.loadLevelSelection(n2);
                break;
            }
            case 39: {
                if (n2 == 0) {
                    GameEngine.smCurrentLevel = GameEngine.smLevelSelectionLevel = 0;
                    this.mGameEngine.startGame();
                    if (this.mCutScene != null) {
                        this.mCutScene.freeResources();
                    }
                    this.mCutScene = new CutScene(Tuner.DATA_CUTSCENE_INTRO);
                }
                this.mCutScene.load(n2);
                break;
            }
            case 44: {
                if (n2 == 0) {
                    if (this.mCutScene != null) {
                        this.mCutScene.freeResources();
                    }
                    this.mCutScene = new CutScene(Tuner.DATA_CUTSCENE_WARDROBE);
                }
                this.mCutScene.load(n2);
                break;
            }
            case 42: {
                GameEngine.loadAchievementScreen(n2);
                break;
            }
            case 40: {
                if (n2 == 0) {
                    this.mGameEngine.startGame();
                    if (this.mCutScene != null) {
                        this.mCutScene.freeResources();
                    }
                    this.mCutScene = new CutScene(Tuner.DATA_CUTSCENE_LEVELS[GameEngine.smCurrentLevel * 2]);
                }
                this.mCutScene.load(n2);
                this.mGameEngine.load(n2);
                break;
            }
            case 41: {
                if (n2 == 0) {
                    if (this.mCutScene != null) {
                        this.mCutScene.freeResources();
                    }
                    this.mCutScene = new CutScene(Tuner.DATA_CUTSCENE_LEVELS[GameEngine.smCurrentLevel * 2 + 1]);
                }
                this.mCutScene.load(n2);
                break;
            }
        }
    }

    private void loadTitleScreen() {
        if (this.mTitleLogo == null) {
            this.mTitleLogo = new SpriteObject(DavinciUtilities.loadAnimation(196911), false);
        }
    }

    public void unloadState(int n, int n2) {
        switch (n) {
            case 10: {
                if (n2 != 2) break;
                GameEngine.smDrawApeMenuBackground = false;
                break;
            }
            case 0: {
                if (n2 != 2) break;
                GameEngine.smDrawApeMenuBackground = true;
                break;
            }
            case 38: {
                break;
            }
        }
    }

    private void setSoundsEnabled(boolean bl) {
        int n = Toolkit.getMusicVolume();
        if (bl) {
            if (n == 0) {
                n = 3;
            }
        } else {
            n = 0;
        }
        Toolkit.setMusicVolume(n);
    }

    private void updateMusic(int n) {
        int n2 = -1;
        boolean bl = true;
        if (!this.mGMGBrowserStarted || n != 26 && this.mPreviousState != 26) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 38: 
                case 42: 
                case 43: {
                    n2 = 65543;
                    break;
                }
                case 39: 
                case 40: 
                case 41: 
                case 44: {
                    n2 = 65547;
                    break;
                }
                case 30: {
                    if (GameEngine.smGameState == 1 || GameEngine.smGameState == 4 || GameEngine.smGameState == 3) {
                        n2 = 65546;
                        bl = false;
                        break;
                    }
                    if (GameEngine.smGameState == 2) {
                        n2 = 65545;
                        bl = false;
                        break;
                    }
                    n2 = 65548;
                }
            }
        }
        if (n2 == -1) {
            Toolkit.stopMusic();
        } else if (n2 != this.mCurrentMusic) {
            Toolkit.playMusic(n2, bl ? -1 : 1);
        }
        this.mCurrentMusic = n2;
    }

    private void saveSettings() {
        byte[] byArray = new byte[4];
        byArray[0] = (byte)this.mSelectedLanguage;
        byArray[1] = (byte)Toolkit.getMusicVolume();
        byArray[3] = this.mGMGVisited ? (byte)1 : 0;
        Toolkit.writeRecord("settings", byArray, 1);
    }

    private void loadSettings() {
        if (Toolkit.getToolkitProperty(7) != null) {
            this.mSelectedLanguage = Toolkit.getSelectedLanguageIndex();
        } else if (Toolkit.getLanguageDescriptions().length == 1) {
            this.mSelectedLanguage = 0;
        }
        byte[] byArray = Toolkit.readRecord("settings");
        if (byArray != null) {
            this.mSelectedLanguage = byArray[0];
            this.mApplicationControl.setLanguage(this.mSelectedLanguage);
            byte by = byArray[1];
            Toolkit.setMusicVolume(by);
            this.mGMGVisited = byArray[3] == 1;
        }
    }

    public void licenseManagerActivated() {
        this.mLicenseManagerActivated = true;
    }

    private boolean isMenuItemVisible(int n, int n2) {
        switch (n) {
            case 4: {
                if (n2 == 0) {
                    return false;
                }
                if (n2 == 1) {
                    return true;
                }
                if (n2 == 2) {
                    return false;
                }
                if (n2 == 4) {
                    return Toolkit.getLanguageDescriptions().length > 1;
                }
                if (n2 != 3) break;
                return false;
            }
            case 10: {
                if (n2 == 1) {
                    return false;
                }
                if (n2 == 2) {
                    return true;
                }
                if (n2 == 4) {
                    return false;
                }
                if (n2 == 3) {
                    return false;
                }
                if (n2 != 5) break;
                return true;
            }
            case 0: {
                if (n2 == 10) {
                    return false;
                }
                if (n2 == 1) {
                    return this.mEnableGetMoreGames && !this.mGMGVisited;
                }
                if (n2 == 9) {
                    return this.mEnableGetMoreGames && this.mGMGVisited;
                }
                if (n2 == 6) {
                    return false;
                }
                if (n2 == 0) {
                    return this.mLicenseManager.getLicenseManagerMenuItemLabel() != null;
                }
                if (n2 == 13) {
                    return false;
                }
                if (n2 == 7) {
                    return false;
                }
                if (n2 == 4) {
                    return true;
                }
                if (n2 == 3) {
                    return true;
                }
                if (n2 != 5) break;
                return true;
            }
            case 2: {
                if (n2 != 2 && n2 != 3) break;
                return true;
            }
            case 19: {
                if (n2 == 5) {
                    return true;
                }
                if (n2 != 2 && n2 != 3 && n2 != 4) break;
                return true;
            }
            case 20: {
                if (n2 != 6 && n2 != 7 && n2 != 8 && n2 != 9) break;
                return true;
            }
        }
        return true;
    }

    public void menuSetScreen(int n, MenuObject menuObject, int n2, int n3, int n4) {
        if (n == 8 || n == 9) {
            String[][] stringArray = Toolkit.getLanguageDescriptions();
            menuObject.setScreen(n2, stringArray.length, n4);
            int n5 = n == 8 ? 51 : 47;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i][0];
                menuObject.setItem(i, 0, string, null, n5);
            }
        } else {
            menuObject.setScreen(n2, n3, n4);
        }
    }

    public void menuSetTitleBarDvc(int n, MenuObject menuObject, String string, SpriteObject spriteObject, int n2) {
        menuObject.setTitleBarDvc(spriteObject == null ? string : null, spriteObject, n2);
    }

    public void menuSetTitleBar(int n, MenuObject menuObject, String string, Image image, int n2) {
        menuObject.setTitleBar(image == null ? string : null, image, n2);
    }

    public void menuSetSoftkey(int n, MenuObject menuObject, int n2, int n3) {
        menuObject.setSoftkey(n2, n3);
    }

    public void menuSetItem(int n, MenuObject menuObject, int n2, int n3, String string, SpriteObject spriteObject, Image[] imageArray, int n4) {
        if (this.isMenuItemVisible(n, n2)) {
            if (n == 17 && (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4)) {
                int[] nArray = new int[]{10, 90};
                int[] nArray2 = new int[]{0, 0};
                String[] stringArray = new String[2];
                int n5 = n2 - 0;
                stringArray[0] = n5 + 1 + ".";
                stringArray[1] = "" + GameEngine.smQuickGameRecordTable[n5];
                menuObject.setTableItemDvc(n5, nArray, nArray2, stringArray, null);
                return;
            }
            if (spriteObject != null) {
                menuObject.setItemDvc(n2, n3, string, spriteObject, n4);
            } else {
                menuObject.setItem(n2, n3, string, imageArray, n4);
            }
            if (n == 0 && n2 == 1) {
                menuObject.setItemBlink(n2, new int[]{300, 300, 300, 300, 1000, 300});
            }
        }
    }

    public void menuSetSwitchItem(int n, MenuObject menuObject, int n2, String string, SpriteObject spriteObject, Image[] imageArray, String[] stringArray, SpriteObject spriteObject2, Image[] imageArray2, int n3) {
        if (this.isMenuItemVisible(n, n2)) {
            if (spriteObject != null || spriteObject2 != null) {
                menuObject.setSwitchItemDvc(n2, string, spriteObject, stringArray, spriteObject2, n3);
            } else {
                menuObject.setSwitchItem(n2, string, imageArray, stringArray, imageArray2, n3);
            }
        }
    }

    public void menuSetSliderItem(int n, MenuObject menuObject, int n2, String string, SpriteObject spriteObject, Image[] imageArray, int n3, int n4, int n5) {
        if (this.isMenuItemVisible(n, n2)) {
            if (spriteObject != null) {
                menuObject.setSliderItemDvc(n2, string, spriteObject, n3, n4, n5);
            } else {
                menuObject.setSliderItem(n2, string, imageArray, n3, n4, n5);
            }
        }
    }

    public void menuSetStyle(int n, MenuObject menuObject, int n2) {
        menuObject.setStyle(n2);
    }

    public void menuSetSize(int n, MenuObject menuObject) {
        int n2 = Toolkit.getScreenWidth();
        int n3 = Toolkit.getScreenHeight();
        int n4 = 0;
        int n5 = 0;
        if (GameEngine.drawTextboxBackground(n)) {
            menuObject.setStyle(2);
            int n6 = Toolkit.getScreenWidth() * 80 / 100;
            int n7 = (Toolkit.getScreenHeight() - Toolkit.getSoftKeyAreaHeight()) * 75 / 100;
            n4 = n2 - n6 >> 1;
            n5 = n3 - n7 >> 1;
            menuObject.setBounds(n4, n5, n6, n7);
        } else {
            menuObject.setBounds(n4, n5, n2, n3);
        }
    }

    public boolean shouldStoreStateToHistory(int n) {
        switch (n) {
            case 7: 
            case 8: 
            case 17: 
            case 22: 
            case 23: 
            case 42: {
                return false;
            }
        }
        return true;
    }

    public void drawLoadingScreen(Graphics graphics, int n) {
        this.mPauseEventScheduled = false;
        VisualEngine.drawLoadingScreen(graphics, n, !smMainMenuSeen);
    }
}

