/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class GameEngine {
    public static boolean smBackgroundIsDrawn;
    public static boolean smDrawApeMenuBackground;
    public static boolean smEndSoundPlayed;
    public static int smLastGoalParticleTime;
    public static boolean smCheatsEnabled;
    public static boolean smWardrobeIntroShown;
    public static int smQuickGameGoal;
    public static int smPowerupHatWorn;
    public static int smShootLevelPlayerCanJumpCounter;
    public static boolean smQuickGame;
    public static int smQuickGameTimeLeft;
    public static int smQuickGameTimeLimit;
    public static int smQuickGameTimeElapsed;
    public static int smQuickGameStage;
    public static int smQuickGameHighscore;
    public static int[] smQuickGameRecordTable;
    public static boolean smQuickGameAllowNewJump;
    public static boolean smDrawBlankScreen;
    public static int smQuickGameFiveToGoTimer;
    private static int smKeys;
    private static int smKeysHold;
    private static int smKeysReleased;
    private static int smKeyPressTimesLevel;
    public static int smLevelSettings;
    public static int smGoalX;
    public static int smGoalY;
    public static int smGoalFreeSpaceBelow;
    public static int smGoalDroppingTime;
    public static boolean smGoalDropParticlesDropped;
    private static int smPressedSK;
    public static int smGameState;
    private static int smNextGameState;
    public static int smAccumulatedTime;
    public static int smStateTime;
    public static int smTimer;
    public static boolean smUpdateSoftKeys;
    public static boolean smNoNeedToLoad;
    public static int smCurrentLevel;
    public static ImageFont smTextImageFont;
    public static ImageFont smSelectionImageFont;
    public static ImageFont smTitleBarImageFont;
    public static int smHudFullTimer;
    public static int smLevelTilesWidth;
    public static int smLevelTilesHeight;
    public static int smLevelWidth;
    public static int smLevelHeight;
    public static byte[] smLevelTiles;
    public static long smCurrentTime;
    public static long smPrevTime;
    public static int smHighestCombo;
    public static int smFruitCount;
    public static int smFruitsCollected;
    public static int smFruitsCollectedNoDelay;
    public static int smBabyPandasLevel;
    public static int smBabyPandasCount;
    public static int smBabyPandasCollected;
    public static byte POWERUP_TYPE_NONE;
    public static int smPowerupData1;
    public static int smPowerupData2;
    public static int smPowerupData3;
    public static byte smPowerupCollected;
    public static int smPowerupAnimationTimer;
    public static int smChargeMeterCount;
    public static GameObject smTargetPeg;
    public static int smWaterTimer;
    public static int smWaterTimerGoal;
    public static int smWaterStoppedTimer;
    public static boolean smIntroShown;
    public static boolean smOutroShown;
    public static int smLevelSelectionShakeId;
    public static int smLevelSelectionShakeTime;
    public static int smLevelSelectionState;
    public static int smLevelSelectionStateTimer;
    public static int smLevelSelectionArea;
    public static int smLevelSelectionAreaOld;
    public static int smLevelSelectionMoveAnimTimer;
    public static int smLevelSelectionLevel;
    public static byte[] smLevelRanks;
    public static boolean[] smLevelCompleteWithCrown;
    public static boolean[] smLevelUnlocked;
    public static boolean smLevelHasShark;
    public static byte smSharkState;
    public static int smSharkStateHpLeft;
    public static int smSharkStateTimer;
    public static int smSharkTimer;
    public static int smSharkStateGoalTime;
    public static boolean smSharkMovingLeft;
    public static int smStoredSharkTime;
    public static int smSharkTeethsLeft;
    public static GameObject smSharkObject;
    public static GameObject smSharkSwallowedPeg;
    public static int smSharkSwallowedPegTimer;
    public static String smQuickGameLevelCompleteString;
    public static String smQuickGameLevelStartsString;
    public static String smQuickGameFiveToGo;
    private static ImageFont smSimpleImageFont;
    public boolean newAreaUnlocked;
    private ILicenseManager mLicenseManager;
    private boolean mFreeTrialMode = false;
    private int mDemoTimeLimit;
    public static int smMoverCount;
    public static int[] smMoverData;
    public static int[] smMoverLinks;
    private static byte[] smDis;
    private static byte[] smQuickGameDis;
    public static int smPlayerState;
    public static int smPlayerStateTimer;
    public static int smCirclingTouchPointX;
    public static int smCirclingTouchPointY;
    public static GameObject smPlayerCirclingCenter;
    public static int smPlayerCirclingTimer;
    public static int smPlayerHoldRopeTimer;
    public static boolean smPlayerRopeMovingLeft;
    public static int smPlayerLastHoldRotatingDot;
    public static int smFruitsStored;
    public static byte smPowerupStored;
    public static byte smPowerupOpened;
    public static int smPlayerFanFieldX;
    public static int smPlayerFanFieldY;
    public static int smPlayerX;
    public static int smPlayerY;
    public static int smPlayerOldX;
    public static int smPlayerOldY;
    private static boolean smPlayerHasHitWall;
    private static int smPlayerBumperBouncesInARow;
    private static int smPlayerBananasInARowNoGravity;
    public static int smPlayerCollisionX;
    public static int smPlayerCollisionY;
    public static int smPlayerOldCollisionX;
    public static int smPlayerOldCollisionY;
    public static int smPlayerVelocityX;
    public static int smPlayerVelocityY;
    public static int smPlayerAngle;
    public static int smPlayerAngleVelocity;
    public static int smPlayerAngleVelocitySpeedUp;
    public static int smPlayerAngleVelocityExtra;
    public static boolean smPlayerCanJump;
    public static boolean smPlayerJumpedOnLastFrame;
    public static GameObject smPlayerStartObject;
    public static byte smPlayerCollectedBananasJump;
    public static boolean smPlayerRotatingCCW;
    public static int[] smRigidBodyItems;
    public static final int[] RIGID_BODY_LOCATIONS;
    private static final int[] RIGID_BODY_LENGTHS;
    public static int smGravityX;
    public static int smGravityY;
    public static int smGorillaStartX;
    public static int smGorillaStartY;
    public static int smGorillaEndX;
    public static int smGorillaEndY;
    public static boolean smGorillaSeenPlayer;
    public static int smGorillaMoveLeftRightTime;
    public static int smGorillaMoveTimer;
    public static int smGorillaIdleTimer;
    public static boolean smGorillaMovingLeft;
    public static boolean smLevelHasGorilla;
    public static GameObject smHippoObject;
    public static int smHippoStartX;
    public static int smHippoStartY;
    public static int smHippoEndX;
    public static int smHippoEndY;
    public static int smHippoTimer;
    public static GameObject[] smHippoPegs;
    public static int smPandaCount;
    public static int[] smPandaData;
    public static final int[] ACHIEVEMENT_GOAL_COUNTS;
    private static final int[] ACHIEVEMENT_TEXT_IDS;
    public static MenuObject smTextBox;
    public static int smTextboxWidth;
    public static int smTextboxHeight;
    public static int[] smAchievementStatistics;
    public static int smAchievementsPending;
    public static int smPostGameVisibleAchievement;
    public static int smAchievementAnimTimer;
    public static int smAchievementIconVisibleTimer;
    public static String smUnlockedAchievementName;
    public static int smAchievementObjectTypes;
    private static String[] smAchievementTexts;
    private static Ticker smAchievementTitleTicker;
    private static int smLastSoftkeySK;
    private static int smCurrentAchievement;
    private static int smAchievementTravelTime;
    public static int smHardRobotShakeTimer;
    public static int smHardBossPositionX;
    public static int smHardBossPositionY;
    public static boolean smLevelHasHardBoss;
    public static boolean smLevelHasEasyBoss;
    public static int smHardBossPegLeft;
    public static int smRobotHardState;
    public static int smRobotHardStateTimer;
    public static int smRobotShotTimes;
    public static int smRobotShootingTimer;
    public static GameObject smRobotArmLeft;
    public static int smRobotArmLeftWaypoint;
    public static int[] smRobotWaypointsLeft;
    private static int smRobotArmLeftTargetX;
    private static int smRobotArmLeftTargetY;
    public static GameObject smRobotArmRight;
    public static int smRobotArmRightWaypoint;
    public static int[] smRobotWaypointsRight;
    private static int smRobotArmRightTargetX;
    private static int smRobotArmRightTargetY;
    private static int smRobotHandState;
    private static int smRobotHandStateGoalTime;
    private static int smRobotHandStateTimer;
    private static int smRobotHandIdleTimer;
    private static final boolean[] ROBOT_LEFT_HAND;
    private static final boolean[] ROBOT_RIGHT_HAND;
    private static boolean smRobotRightHandActionDone;
    private static boolean smRobotLeftHandActionDone;
    private static int smTickerClosingTime;
    public static byte smTickerBoxState;
    public static int smTutorialTimer;
    public static int smTickerScrollingTimer;
    public static boolean smTickerScrollingLeft;
    public static int smTickerScrollingOffset;
    public static boolean smTickerTimedClosing;
    public static String smTickerText;
    public static int smTickerTextLength;
    public static int smTickerTextTimer;
    public static int smTutorialsCompletedThisLevel;
    public static int smTutorialsCompleted;
    public static int smSelectedWardrobePowerup;

    public GameEngine() {
        VisualEngine.init();
        Util.initializeTables();
        ObjectManager.initialize();
        SpriteObject.setFiltering(true);
    }

    public static final boolean drawTextboxBackground(int n) {
        return n == 6 || n == 11 || n == 18 || n == 5 || n == 14 || n == 1 || n == 16 || n == 15 || n == 3 || n == 12 || n == 17;
    }

    public int getLoadingCount() {
        if (smNoNeedToLoad) {
            smNoNeedToLoad = false;
            return 0;
        }
        return 100;
    }

    public void load(int n) {
        if (n == 0) {
            if (smQuickGame) {
                smQuickGameLevelCompleteString = Toolkit.getText(231);
                smQuickGameLevelStartsString = Toolkit.getText(230);
                smQuickGameFiveToGo = Toolkit.getText(232);
            }
        } else {
            VisualEngine.loadSprites(n - 1);
        }
    }

    public static final void reset() {
        smAchievementIconVisibleTimer = 0;
        smTickerBoxState = 0;
        smKeyPressTimesLevel = 0;
        smTutorialsCompletedThisLevel = 0;
        VisualEngine.reset();
        smTimer = 0;
        GameEngine.changeGameState(0);
        GameEngine.updateGameState(false);
        GameEngine.resetTimer();
        ObjectManager.reset();
        GameEngine.loadLevelData();
        byte[] byArray = smDis;
        if (smQuickGame) {
            smQuickGameFiveToGoTimer = 0;
            byArray = smQuickGameDis;
        }
        GameEngine.loadLevel(byArray, smCurrentLevel);
        smPlayerStartObject = ObjectManager.findNearestRotationPoint(smPlayerX, smPlayerY, null);
        GameEngine.resetPlayer();
        GameEngine.resetPandas();
        if (smQuickGameStage == 1) {
            smAchievementsPending = 0;
        }
    }

    public static final void changeGameState(int n) {
        smNextGameState = n;
    }

    private static final void updateGameState(boolean bl) {
        switch (smNextGameState) {
            case 0: {
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                if (!smQuickGame) break;
                smTextBox = new MenuObject();
                smTextBox.setScreen(1, 10, 3);
                smTextBox.setStyle(2);
                int n = 0;
                smTextBox.setItem(++n, 1, Toolkit.getText(19), null, -1);
                smTextBox.setItem(++n, 1, "", null, -1);
                smTextBox.setItemDvc(++n, 1, null, VisualEngine.smLineOrnament1, -1);
                String[] stringArray = new String[]{"" + smQuickGameHighscore};
                String string = Toolkit.replaceParameters(Toolkit.getText(107), stringArray);
                smTextBox.setItem(++n, 1, string, null, -1);
                String[] stringArray2 = new String[]{"" + smQuickGameStage};
                String string2 = Toolkit.replaceParameters(Toolkit.getText(106), stringArray2);
                smTextBox.setItem(++n, 1, string2, null, -1);
                smTextBox.setItem(++n, 1, "", null, -1);
                smTextBox.setItemDvc(++n, 1, null, VisualEngine.smLineOrnament2, -1);
                if (smQuickGameHighscore > smQuickGameRecordTable[0]) {
                    smTextBox.setItem(++n, 1, Toolkit.getText(104), null, -1);
                } else {
                    String[] stringArray3 = new String[]{"" + Math.max(smQuickGameHighscore, smQuickGameRecordTable[0])};
                    String string3 = Toolkit.replaceParameters(Toolkit.getText(105), stringArray3);
                    smTextBox.setItem(++n, 1, string3, null, -1);
                }
                smTextBox.setImageFonts(smTextImageFont, smTextImageFont, smSelectionImageFont);
                smTextboxWidth = VisualEngine.smScreenWidth * 70 / 100;
                smTextboxHeight = VisualEngine.smScreenHeight * 75 / 100;
                smTextBox.setSize(smTextboxWidth, smTextboxHeight);
                GameEngine.saveQuickGameScore(smQuickGameHighscore);
                GameEngine.saveGame();
                break;
            }
            case 1: {
                String string;
                String[] stringArray;
                smTextBox = new MenuObject();
                smTextBox.setScreen(1, 10, 3);
                smTextBox.setStyle(2);
                int n = 0;
                smTextBox.setItem(++n, 1, Toolkit.getText(100), null, -1);
                smTextBox.setItemDvc(++n, 1, null, VisualEngine.smLineOrnament1, -1);
                String[] stringArray4 = new String[]{"" + smFruitCount, "" + smFruitsCollected};
                String string4 = Toolkit.replaceParameters(Toolkit.getText(101), stringArray4);
                smTextBox.setItem(++n, 1, string4, null, -1);
                if (smHighestCombo > 0) {
                    stringArray = new String[]{"" + smHighestCombo};
                    string = Toolkit.replaceParameters(Toolkit.getText(102), stringArray);
                    smTextBox.setItem(++n, 1, string, null, -1);
                }
                smTextBox.setItemDvc(++n, 1, null, VisualEngine.smLineOrnament2, -1);
                if (smFruitsCollected >= smFruitCount) {
                    smTextBox.setItemDvc(++n, 1, null, VisualEngine.smScorecardCollectAll, -1);
                }
                stringArray = new String[]{"" + (smFruitsStored + smFruitsCollected + smHighestCombo)};
                string = Toolkit.replaceParameters(Toolkit.getText(103), stringArray);
                smTextBox.setItem(++n, 1, string, null, -1);
                smTextBox.setImageFonts(smTextImageFont, smTextImageFont, smSelectionImageFont);
                smTextboxWidth = VisualEngine.smScreenWidth * 70 / 100;
                smTextboxHeight = VisualEngine.smScreenHeight * 75 / 100;
                smTextBox.setSize(smTextboxWidth, smTextboxHeight);
            }
        }
        smDrawBlankScreen = false;
        smStateTime = 0;
        smGameState = smNextGameState;
        smNextGameState = -1;
        GameEngine.resetKeys();
        if (bl) {
            GameEngine.updateSoftKeys();
        }
    }

    public int logicUpdate(int n) {
        if (smNextGameState != -1) {
            GameEngine.updateGameState(true);
            return 0;
        }
        if (smUpdateSoftKeys) {
            GameEngine.updateSoftKeys();
            smUpdateSoftKeys = false;
        }
        int n2 = -1;
        if (smPressedSK != -1) {
            n2 = smPressedSK;
            GameEngine.resetKeys();
            smLastSoftkeySK = n2;
            if (n2 == 9) {
                return 1;
            }
            if (n2 == 14) {
                VisualEngine.stopCameraDrive();
            }
            if (n2 == 38 && smGameState == 0) {
                if (smPowerupStored != POWERUP_TYPE_NONE) {
                    GameEngine.activateHatPowerup();
                }
                smKeys &= 0xFFFFFFF7;
            }
        }
        if ((smKeys & 8) != 0 && smGameState == 0 && GameEngine.allowPowerupHatUsage()) {
            if (smPowerupStored != POWERUP_TYPE_NONE) {
                GameEngine.activateHatPowerup();
            }
            smKeys &= 0xFFFFFFF7;
        }
        if ((n = (int)((smCurrentTime = System.currentTimeMillis()) - smPrevTime)) >= 200) {
            n = 200;
        }
        smPrevTime = smCurrentTime;
        smStateTime += n;
        smTimer += n;
        switch (smGameState) {
            case 0: {
                VisualEngine.logicUpdate(n);
                if (VisualEngine.smCameraDriveActive) {
                    if ((smKeys & 0x10) != 0) {
                        ++smKeyPressTimesLevel;
                        smKeys &= 0xFFFFFFEF;
                        VisualEngine.stopCameraDrive();
                    }
                } else {
                    if (smQuickGame) {
                        if (smQuickGameFiveToGoTimer > 0) {
                            smQuickGameFiveToGoTimer += n;
                        }
                        smQuickGameTimeElapsed += n;
                        if ((smQuickGameTimeLeft -= n) < 0) {
                            GameEngine.playerHitLethalBlock();
                        }
                    }
                    GameEngine.updateMovers(n);
                    GameEngine.updatePhysics(n);
                    GameEngine.updateRobot(n);
                    GameEngine.updateWater(n);
                    GameEngine.updateTickerTutorialLogic(n);
                    GameEngine.updateTickerBox(n);
                }
                GameEngine.updateAchievement(n);
                GameEngine.updateGoal();
                break;
            }
            case 1: {
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                if ((smLastGoalParticleTime -= n) < 0) {
                    ParticleSystem.startGoalFx(VisualEngine.smCameraX, VisualEngine.smCameraY, VisualEngine.smScreenWidth, VisualEngine.smScreenHeight);
                    smLastGoalParticleTime = 500 + Util.getRandom() % 1000;
                }
                if (smTextBox != null) {
                    smTextBox.logicUpdate(n);
                }
                GameEngine.updateMovers(n);
                VisualEngine.logicUpdate(n);
                if ((smKeys & 0x10) == 0 && smLastSoftkeySK != 15 && smLastSoftkeySK != 23) break;
                if (smStateTime < 800) {
                    smLastSoftkeySK = -1;
                    smKeys = 0;
                    break;
                }
                smLastSoftkeySK = -1;
                smKeys = 0;
                smFruitsStored += smFruitsCollected;
                smFruitsStored += smHighestCombo;
                int n8 = smCurrentLevel % 10;
                if (n8 < 9) {
                    n7 = smCurrentLevel + 1;
                    GameEngine.smLevelUnlocked[n7] = true;
                }
                if (n8 == 5 && (n7 = smCurrentLevel / 10 + 1) < 5 && !smLevelUnlocked[n7 * 10]) {
                    GameEngine.smLevelUnlocked[n7 * 10] = true;
                    smLevelSelectionState = 2;
                    smLevelSelectionStateTimer = 0;
                    smUpdateSoftKeys = true;
                    GameEngine.resetKeys();
                    this.newAreaUnlocked = true;
                    if (this.mFreeTrialMode) {
                        // empty if block
                    }
                }
                n7 = 0;
                n7 = 49;
                if (smCurrentLevel == n7 && smLevelRanks[n7] == 0) {
                    smPowerupOpened = (byte)(smPowerupOpened | 1 << Tuner.POWERUPS.length - 1);
                }
                if (smLevelRanks[smCurrentLevel] != 5) {
                    GameEngine.smLevelRanks[GameEngine.smCurrentLevel] = 1;
                    if (smFruitsCollected == smFruitCount) {
                        GameEngine.smLevelRanks[GameEngine.smCurrentLevel] = 5;
                    }
                }
                if (smCurrentLevel == 9) {
                    GameEngine.addAchievement(15, 1);
                }
                if (smCurrentLevel == 19) {
                    GameEngine.addAchievement(16, 1);
                }
                if (smCurrentLevel == 29) {
                    GameEngine.addAchievement(17, 1);
                }
                if (smCurrentLevel == 39) {
                    GameEngine.addAchievement(18, 1);
                }
                if (smCurrentLevel == n7) {
                    GameEngine.addAchievement(7, 1);
                }
                for (n6 = 0; n6 < 5; ++n6) {
                    n5 = n6 * 10;
                    n4 = 1;
                    for (n3 = 0; n3 < 10; ++n3) {
                        if (smLevelRanks[n5 + n3] == 5) continue;
                        n4 = 0;
                    }
                    if (n4 != 1) continue;
                    GameEngine.addAchievement(5, 1);
                }
                n6 = 1;
                n5 = 1;
                for (n4 = 0; n4 < smLevelRanks.length; ++n4) {
                    if (smLevelRanks[n4] != 5) {
                        n5 = 0;
                    }
                    if (smLevelRanks[n4] != 0) continue;
                    n6 = 0;
                }
                if (n5 != 0) {
                    GameEngine.addAchievement(6, 1);
                }
                if (n6 != 0) {
                    GameEngine.addAchievement(8, 1);
                }
                if (smPowerupStored == 37) {
                    GameEngine.smLevelCompleteWithCrown[GameEngine.smCurrentLevel] = true;
                    n4 = 1;
                    for (n3 = 0; n3 < smLevelCompleteWithCrown.length; ++n3) {
                        if (smLevelCompleteWithCrown[n3]) continue;
                        n4 = 0;
                    }
                    if (n4 != 0) {
                        GameEngine.addAchievement(1, 1);
                    }
                }
                if (!smPlayerHasHitWall) {
                    GameEngine.addAchievement(2, 1);
                }
                GameEngine.saveGame();
                n4 = GameEngine.getNextPendingAchievement(-1);
                if (n4 >= 0) {
                    smPostGameVisibleAchievement = n4;
                    GameEngine.updateAchievementTexts();
                    GameEngine.changeGameState(4);
                    break;
                }
                return 2;
            }
            case 2: {
                if (smTextBox != null) {
                    smTextBox.logicUpdate(n);
                }
                GameEngine.updatePhysics(n);
                ParticleSystem.updateEffects(n);
                if (smStateTime > 1000 && n2 == 13) {
                    smDrawBlankScreen = true;
                    smUpdateSoftKeys = true;
                    return 3;
                }
                if ((smStateTime <= 1000 || (smKeys & 0x10) == 0) && n2 != 15 && n2 != 23) break;
                if (smQuickGame) {
                    GameEngine.startQuickGame();
                    break;
                }
                GameEngine.restartPlayer();
                GameEngine.resetKeys();
                GameEngine.changeGameState(0);
                if (smQuickGame || GameEngine.getTutorialCompleted(131072) || smFruitCount <= 0) break;
                GameEngine.setTickerBoxText(125, false, -1);
                GameEngine.setTutorialCompleted(131072);
                break;
            }
            case 3: {
                ParticleSystem.updateEffects(n);
                VisualEngine.logicUpdate(n);
                if (!smQuickGame && smStateTime > smGoalDroppingTime + 750 || (smKeys & 0x10) != 0 || n2 == 14) {
                    GameEngine.resetKeys();
                    GameEngine.changeGameState(1);
                }
                if ((smLastGoalParticleTime -= n) >= 0) break;
                ParticleSystem.startGoalFx(VisualEngine.smCameraX, VisualEngine.smCameraY, VisualEngine.smScreenWidth, VisualEngine.smScreenHeight);
                smLastGoalParticleTime = 500 + Util.getRandom() % 1000;
                break;
            }
            case 4: {
                VisualEngine.logicUpdate(n);
                smTextBox.logicUpdate(n);
                smAchievementAnimTimer = Math.max(smAchievementAnimTimer - n, 0);
                if (smStateTime <= 500 || smLastSoftkeySK != 1 && (smKeys & 0x10) == 0) break;
                smStateTime = 0;
                smPostGameVisibleAchievement = GameEngine.getNextPendingAchievement(smPostGameVisibleAchievement);
                smLastSoftkeySK = -1;
                smKeys &= 0xFFFFFFEF;
                if (smPostGameVisibleAchievement < 0) {
                    Toolkit.removeAllSoftKeys();
                    smAchievementsPending = 0;
                    if (smQuickGame) {
                        GameEngine.changeGameState(2);
                        break;
                    }
                    return 2;
                }
                GameEngine.updateAchievementTexts();
                break;
            }
            case 5: {
                if (!smQuickGame) break;
                ParticleSystem.updateEffects(n);
                VisualEngine.logicUpdate(n);
                if (smStateTime <= 1500) break;
                ++smQuickGameStage;
                ++smCurrentLevel;
                smCurrentLevel %= 12;
                GameEngine.reset();
                GameEngine.resetKeys();
                GameEngine.changeGameState(0);
                break;
            }
        }
        return 0;
    }

    public void doDraw(Graphics graphics, int n) {
        VisualEngine.doDraw(graphics, n);
    }

    public void keyEventOccurred(int n, int n2) {
        if (smTextBox != null) {
            smTextBox.keyEventOccurred(n, n2);
        }
        if (n2 == 0 || n2 == 1) {
            int n3 = Toolkit.getToolkitGameAction(n);
            int n4 = 0;
            switch (n3) {
                case 52: {
                    n4 = 1;
                    break;
                }
                case 54: {
                    n4 = 2;
                    break;
                }
                case 50: {
                    n4 = 4;
                    break;
                }
                case 56: {
                    n4 = 8;
                    break;
                }
                case 48: {
                    n4 = 32;
                    break;
                }
                case 53: {
                    n4 = 16;
                }
            }
            if (n2 == 0) {
                smKeys |= n4;
                smKeysHold |= n4;
                smKeysReleased &= ~n4;
            } else {
                smKeysHold &= ~n4;
                smKeysReleased |= n4;
            }
        } else if (n2 == 3) {
            smPressedSK = n;
        }
    }

    public void enableCheats() {
        smCheatsEnabled = true;
    }

    public static void continueGame() {
        smNoNeedToLoad = true;
        GameEngine.resetKeys();
        smUpdateSoftKeys = true;
        GameEngine.resetTimer();
    }

    public static void restartLevel() {
        smEndSoundPlayed = false;
        if (smQuickGame) {
            smCurrentLevel = 0;
            smQuickGameStage = 1;
        }
        GameEngine.reset();
        smAchievementIconVisibleTimer = 0;
        smNoNeedToLoad = true;
        smUpdateSoftKeys = true;
        GameEngine.resetKeys();
        smTutorialsCompleted &= ~smTutorialsCompletedThisLevel;
        smTutorialsCompletedThisLevel = 0;
        if (!smQuickGame) {
            GameEngine.changeGameState(0);
            smDrawBlankScreen = true;
        }
        if (smQuickGame) {
            smQuickGameHighscore = 0;
        }
    }

    public final void startGame() {
        smUpdateSoftKeys = true;
        GameEngine.reset();
    }

    private static final void resetKeys() {
        smPressedSK = -1;
        smKeys = 0;
    }

    private static final void updateSoftKeys() {
        Toolkit.removeAllSoftKeys();
        switch (smGameState) {
            case 0: {
                if (VisualEngine.smCameraDriveActive) {
                    Toolkit.setSoftKey(14, 3);
                } else if (GameEngine.allowPowerupHatUsage()) {
                    Toolkit.setSoftKey(38, 0);
                }
                if (VisualEngine.smCameraDriveActive) break;
                Toolkit.setSoftKey(9, 0);
                break;
            }
            case 1: {
                Toolkit.setSoftKey(15, 0);
                break;
            }
            case 3: {
                Toolkit.setSoftKey(14, 3);
                break;
            }
            case 2: {
                Toolkit.setSoftKey(13, 0);
                Toolkit.setSoftKey(23, 0);
                break;
            }
            case 4: {
                Toolkit.setSoftKey(1, 0);
                break;
            }
            case 6: {
                break;
            }
        }
    }

    private static final void updateMovers(int n) {
        if (smMoverCount == 0) {
            return;
        }
        for (int i = 0; i < smMoverCount; ++i) {
            int n2 = i * 24;
            GameEngine.updateMover(n, n2);
        }
    }

    private static final void updateMover(int n, int n2) {
        int n3 = smMoverData[n2 + 0] & 0xFF;
        switch (n3) {
            case 0: {
                if (smMoverData[n2 + 16] < 0) {
                    int n4 = n2 + 16;
                    smMoverData[n4] = smMoverData[n4] + n;
                    if (smMoverData[n2 + 16] < 0) break;
                    int n5 = n2 + 18;
                    smMoverData[n5] = smMoverData[n5] + 1;
                    int n6 = smMoverData[n2 + 18] * 2;
                    if (smMoverData[n2 + 4 + n6] == Integer.MIN_VALUE && smMoverData[n2 + 5 + n6] == Integer.MIN_VALUE) {
                        GameEngine.smMoverData[n2 + 18] = 0;
                        n6 = 0;
                    }
                    int n7 = smMoverData[n2 + 4 + n6];
                    int n8 = smMoverData[n2 + 5 + n6];
                    int n9 = smMoverData[n2 + 4 + n6 + 2];
                    int n10 = smMoverData[n2 + 5 + n6 + 2];
                    if (n9 == Integer.MIN_VALUE && n9 == Integer.MIN_VALUE) {
                        n9 = smMoverData[n2 + 4];
                        n10 = smMoverData[n2 + 5];
                    }
                    int n11 = n9 - n7;
                    int n12 = n10 - n8;
                    int n13 = Util.sqrtApproximate(n11, n12);
                    GameEngine.smMoverData[n2 + 16] = 0;
                    int n14 = smMoverData[n2 + 3] * 32 >> 4;
                    if (n14 == 0) {
                        n14 = 1;
                    }
                    GameEngine.smMoverData[n2 + 17] = n13 * 1000 / n14;
                    break;
                }
                int n15 = n2 + 16;
                smMoverData[n15] = smMoverData[n15] + n;
                if (smMoverData[n2 + 16] > smMoverData[n2 + 17]) {
                    GameEngine.smMoverData[n2 + 16] = -smMoverData[n2 + 2];
                    return;
                }
                int n16 = (smMoverData[n2 + 1] & 0xFF) * 2;
                int n17 = smMoverData[n2 + 18] * 2;
                int n18 = smMoverData[n2 + 4 + n17];
                int n19 = smMoverData[n2 + 5 + n17];
                int n20 = smMoverData[n2 + 4 + n17 + 2];
                int n21 = smMoverData[n2 + 5 + n17 + 2];
                if (n20 == Integer.MIN_VALUE && n20 == Integer.MIN_VALUE) {
                    n20 = smMoverData[n2 + 4];
                    n21 = smMoverData[n2 + 5];
                }
                int n22 = n20 - n18;
                int n23 = n2 + 1;
                smMoverData[n23] = smMoverData[n23] & 0xFFFFFEFF;
                int n24 = n2 + 1;
                smMoverData[n24] = smMoverData[n24] | (n22 < 0 ? 1 : 0) << 8;
                int n25 = n21 - n19;
                int n26 = smMoverData[n2 + 17];
                if (n26 == 0) {
                    n26 = 1;
                }
                if (n16 == 0) {
                    n22 = n22 * smMoverData[n2 + 16] / n26;
                    n25 = n25 * smMoverData[n2 + 16] / n26;
                } else {
                    int n27 = Util.smoothStep(smMoverData[n2 + 16], 0, n26);
                    n22 = n22 * n27 >> 10;
                    n25 = n25 * n27 >> 10;
                }
                GameEngine.smMoverData[n2 + 19] = n18 + n22;
                GameEngine.smMoverData[n2 + 20] = n19 + n25;
                break;
            }
            case 1: {
                int n28 = smMoverData[n2 + 14];
                int n29 = smMoverData[n2 + 3] - 64;
                int n30 = n2 + 16;
                smMoverData[n30] = smMoverData[n30] + n;
                int n31 = smMoverData[n2 + 16];
                int n32 = smMoverData[n2 + 15] - 64;
                if (n32 != 0) {
                    n28 += (n28 >> 1) * Util.getSin(n31 * n32 >> 6) >> 12;
                }
                int n33 = smMoverData[n2 + 10] - 64;
                int n34 = smMoverData[n2 + 11];
                int n35 = smMoverData[n2 + 12] - 64;
                int n36 = smMoverData[n2 + 13];
                int n37 = 0;
                if (n33 != 0 && n34 != 0) {
                    n37 = Util.getSin(n31 * n33 >> 6) * n34 >> 12;
                }
                int n38 = 0;
                if (n35 != 0 && n36 != 0) {
                    n38 = Util.getCos(n31 * n35 >> 6) * n36 >> 12;
                }
                GameEngine.smMoverData[n2 + 19] = n37 + (Util.getSin(n31 * n29 >> 6) * n28 >> 12);
                GameEngine.smMoverData[n2 + 20] = n38 + (Util.getCos(n31 * n29 >> 6) * n28 >> 12);
                break;
            }
            case 2: {
                int n39 = n2 + 16;
                smMoverData[n39] = smMoverData[n39] + n;
                int n40 = smMoverData[n2 + 3] * smMoverData[n2 + 16] / 1000;
                int n41 = Util.getSin(n40) * 100 >> 12;
                GameEngine.smMoverData[n2 + 19] = Util.getSin(512 + n41) * smMoverData[n2 + 14] >> 12;
                GameEngine.smMoverData[n2 + 20] = Util.getCos(512 + n41) * smMoverData[n2 + 14] >> 12;
            }
        }
    }

    private static final void initMovers(int n) {
        int n2;
        smMoverData = new int[smMoverCount * 24];
        for (n2 = 0; n2 < smMoverData.length; ++n2) {
            GameEngine.smMoverData[n2] = Integer.MIN_VALUE;
        }
        for (n2 = 0; n2 < 32; ++n2) {
            GameEngine.smMoverLinks[n2] = 0;
        }
    }

    public static final void updateGameObjectLinkedToMover(GameObject gameObject) {
        byte by = gameObject.mLinkedMover;
        int n = smMoverLinks[by];
        int n2 = smMoverData[n + 4];
        int n3 = smMoverData[n + 5];
        int n4 = smMoverData[n + 19];
        int n5 = smMoverData[n + 20];
        int n6 = gameObject.mStartPosX;
        int n7 = gameObject.mStartPosY;
        int n8 = smMoverData[n + 0] & 0xFF;
        switch (n8) {
            case 0: {
                gameObject.mPosX = n6 + (n4 - n2) << 8;
                gameObject.mPosY = n7 + (n5 - n3) << 8;
                break;
            }
            case 1: {
                gameObject.mPosX = n6 + n4 << 8;
                gameObject.mPosY = n7 + n5 << 8;
                break;
            }
            case 2: {
                gameObject.mPosX = n6 + n4 << 8;
                gameObject.mPosY = n7 + n5 << 8;
                break;
            }
        }
    }

    public static final void loadLevelData() {
        if (smDis == null) {
            smDis = Toolkit.getResourceBytes(131072);
        }
        if (smQuickGameDis == null) {
            smQuickGameDis = Toolkit.getResourceBytes(131073);
        }
    }

    public static final void loadLevel(byte[] byArray, int n) {
        int n2;
        smLevelSettings = 0;
        smFruitCount = 0;
        VisualEngine.smDrawMoverTracks = false;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        smBabyPandasCount = 0;
        smBabyPandasLevel = 0;
        smBabyPandasCollected = 0;
        smLevelHasShark = false;
        smHippoObject = null;
        smLevelHasGorilla = false;
        n6 = 0;
        n5 = 0;
        n4 = 0;
        n3 = 0;
        GameEngine.resetRobot();
        smWaterTimer = 1;
        Debugger.verbose("------");
        Debugger.verbose("Load level " + smCurrentLevel);
        int n7 = 0;
        ++n7;
        int n8 = byArray[(n7 += n * 4) + 3] & 0xFF | (byArray[n7 + 2] & 0xFF) << 8 | (byArray[n7 + 1] & 0xFF) << 16 | (byArray[n7] & 0xFF) << 24;
        n7 += n8 + 4;
        smLevelTilesWidth = (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
        smLevelTilesHeight = (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
        smLevelWidth = smLevelTilesWidth * 32;
        smLevelHeight = smLevelTilesHeight * 32;
        int n9 = smLevelTilesWidth * smLevelTilesHeight;
        smLevelTiles = new byte[n9];
        for (n2 = 0; n2 < n9; ++n2) {
            GameEngine.smLevelTiles[n2] = byArray[n7++];
        }
        int n10 = byArray[n7++];
        int n11 = n7++;
        VisualEngine.smBreakableBoxes = null;
        if ((n10 += byArray[n11]) > 0) {
            VisualEngine.smBreakableBoxes = new GameObject[n10];
        }
        int n12 = byArray[n7++];
        n12 += byArray[n7++];
        n12 += byArray[n7++];
        smMoverCount = n12 += byArray[n7++];
        if (n12 > 0) {
            GameEngine.initMovers(n12);
        }
        int n13 = (byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF;
        block39: for (n2 = 0; n2 < n13; ++n2) {
            byte by = byArray[n7++];
            switch (by) {
                case 0: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    smPlayerX = n14 + 16 << 8;
                    smPlayerY = n15 + 16 << 8;
                    smPlayerOldX = smPlayerX;
                    smPlayerOldY = smPlayerY;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    smGoalX = n16;
                    smGoalY = n17;
                    int n18 = byArray[n7++];
                    if ((n18 >> 1 & 1) != 0) {
                        smLevelSettings |= 4;
                    }
                    if ((n18 & 1) != 0) {
                        smLevelSettings |= 1;
                    }
                    Debugger.verbose("OBJECTTYPE_LEVEL_ATTRIBUTES");
                    continue block39;
                }
                case 1: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n18 = byArray[n7++];
                    byte by2 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)1, n14 + n18, n15 + by2);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    continue block39;
                }
                case 2: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n18 = byArray[n7++];
                    byte by2 = byArray[n7++];
                    byte by3 = byArray[n7++];
                    byte by4 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)1, n14 + n18, n15 + by2);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    gameObject.mLinkedMover = by3;
                    if (by4 == 0) continue block39;
                    gameObject.setBoolean(128, true);
                    VisualEngine.smDrawMoverTracks = true;
                    continue block39;
                }
                case 3: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n18 = byArray[n7++];
                    byte by2 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)1, n14 + n18, n15 + by2);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    gameObject.setBoolean(16, true);
                    continue block39;
                }
                case 4: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n18 = byArray[n7++];
                    byte by2 = byArray[n7++];
                    byte by3 = byArray[n7++];
                    byte by4 = byArray[n7++];
                    byte by5 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)1, n14 + n18, n15 + by2);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    gameObject.mLinkedMover = by3;
                    gameObject.setBoolean(8, (by4 & 1) != 0);
                    if ((by4 >> 1 & 1) != 0) {
                        gameObject.setBoolean(128, true);
                        VisualEngine.smDrawMoverTracks = true;
                    }
                    gameObject.mLinkedSwitch = by5;
                    continue block39;
                }
                case 35: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n18 = byArray[n7++];
                    byte by2 = byArray[n7++];
                    byte by3 = byArray[n7++];
                    byte by4 = byArray[n7++];
                    byte by5 = byArray[n7++];
                    byte by6 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)1, n14 + n18, n15 + by2);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    gameObject.mTypeData = by3;
                    gameObject.mLinkedMover = by4;
                    gameObject.mLinkedSwitch = by5;
                    gameObject.setBoolean(64, true);
                    gameObject.setBoolean(512, (by6 & 1) != 0);
                    continue block39;
                }
                case 36: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    if (GameEngine.getTutorialCompleted(256)) continue block39;
                    GameObject gameObject = ObjectManager.addObject((byte)63, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    continue block39;
                }
                case 19: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)35, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    gameObject.mTypeData = 0;
                    continue block39;
                }
                case 20: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)36, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = 32;
                    gameObject.mHeight = 32;
                    gameObject.mTypeData = 0;
                    smLevelSettings |= 2;
                    ++smBabyPandasCount;
                    ++smBabyPandasLevel;
                    continue block39;
                }
                case 21: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFE) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFE) * 32;
                    int n18 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)62, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    gameObject.setBoolean(2, true);
                    gameObject.setBoolean(8, true);
                    ObjectManager.smBackgroundLayerObjectExists = true;
                    gameObject.mTypeData = n18;
                    continue block39;
                }
                case 5: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n16 = 32;
                    byte by2 = byArray[n7++];
                    byte by3 = byArray[n7++];
                    byte by4 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)2, n14 + by2, n15 + by3);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = n16;
                    gameObject.mElasticity = 256;
                    gameObject.mLinkedMover = by4;
                    gameObject.mLifeTimer = 250;
                    Debugger.verbose("OBJECTTYPE_ROUND_OBSTACLE");
                    continue block39;
                }
                case 6: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n18 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)3, n14, n15);
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    gameObject.mCollisionType = 0;
                    gameObject.mElasticity = 256;
                    gameObject.setBoolean(4, (n18 & 1) == 1);
                    Debugger.verbose("OBJECTTYPE_RECT_OBSTACLE");
                    continue block39;
                }
                case 8: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)100, n14, n15);
                    gameObject.mWidth = 32;
                    gameObject.mHeight = 32;
                    ++smFruitCount;
                    Debugger.verbose("OBJECTTYPE_BANANA");
                    continue block39;
                }
                case 9: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)99, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mElasticity = 256;
                    gameObject.mWidth = 45;
                    gameObject.mHeight = 45;
                    gameObject.mTypeData = 8;
                    smFruitCount += 5;
                    VisualEngine.smBreakableBoxes[--n10] = gameObject;
                    Debugger.verbose("OBJECTTYPE_BANANA_BOX");
                    continue block39;
                }
                case 10: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n18 = byArray[n7++];
                    n18 = (byte)(n18 + 4);
                    GameObject gameObject = ObjectManager.addObject((byte)n18, n14, n15);
                    gameObject.mElasticity = 640;
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    gameObject.setBoolean(2, true);
                    ObjectManager.smBackgroundLayerObjectExists = true;
                    Debugger.verbose("OBJECTTYPE_TRAMPOLINE");
                    continue block39;
                }
                case 11: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)8, n14, n15);
                    gameObject.mWidth = 32;
                    gameObject.mHeight = 32;
                    Debugger.verbose("OBJECTTYPE_SPIKE");
                    continue block39;
                }
                case 12: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    GameObject gameObject = ObjectManager.addObject((byte)9, n14, n15);
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    Debugger.verbose("OBJECTTYPE_SPIKE_AREA");
                    continue block39;
                }
                case 14: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n18 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)11, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = n16;
                    gameObject.mHeight = n17;
                    gameObject.mTypeData = n18;
                    Debugger.verbose("OBJECTTYPE_FAN");
                    continue block39;
                }
                case 15: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    GameObject gameObject = ObjectManager.addObject((byte)12, n14, n15);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    Debugger.verbose("OBJECTTYPE_VALVE");
                    continue block39;
                }
                case 16: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    GameObject gameObject = ObjectManager.addObject((byte)13, n14, n15);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 16;
                    Debugger.verbose("OBJECTTYPE_WATERSWITCH");
                    continue block39;
                }
                case 17: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)60, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = 32;
                    gameObject.mHeight = 32;
                    gameObject.setBoolean(2, true);
                    ObjectManager.smBackgroundLayerObjectExists = true;
                    gameObject.mTypeData = n16;
                    gameObject.mLifeTimer = 1000;
                    Debugger.verbose("OBJECTTYPE_NAVIGATION_AID_VERTICAL");
                    continue block39;
                }
                case 18: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)61, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mWidth = 32;
                    gameObject.mHeight = 32;
                    gameObject.setBoolean(2, true);
                    ObjectManager.smBackgroundLayerObjectExists = true;
                    gameObject.mTypeData = n16;
                    gameObject.mLifeTimer = 1000;
                    Debugger.verbose("OBJECTTYPE_NAVIGATION_AID_HORIZONTAL");
                    continue block39;
                }
                case 13: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    if (n14 == n16) {
                        n14 += 16;
                        n16 += 16;
                    }
                    if (n16 < n14) {
                        int n19 = n16;
                        int n20 = n17;
                        n16 = n14;
                        n17 = n15;
                        n14 = n19;
                        n15 = n20;
                    }
                    if (n14 != n16) {
                        n16 += 32;
                    }
                    GameObject gameObject = ObjectManager.addObject((byte)10, n14, n15);
                    gameObject.mCollisionType = (byte)2;
                    gameObject.mWidth = n16 << 8;
                    gameObject.mHeight = n17 << 8;
                    Debugger.verbose("OBJECTTYPE_LEFT_RIGHT_ROPE");
                    continue block39;
                }
                case 7: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n18 = byArray[n7++];
                    GameObject gameObject = ObjectManager.addObject((byte)98, n14, n15);
                    gameObject.mCollisionType = 0;
                    gameObject.mElasticity = 256;
                    gameObject.mWidth = 45;
                    gameObject.mHeight = 45;
                    gameObject.mTypeData = 1 + n18 * 3;
                    VisualEngine.smBreakableBoxes[--n10] = gameObject;
                    Debugger.verbose("OBJECTTYPE_BREAKABLE_RECT_BLOCK");
                    continue block39;
                }
                case 22: {
                    n7 += 4;
                    Debugger.verbose("OBJECTTYPE_PARROT");
                    continue block39;
                }
                case 23: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 32;
                    int n18 = byArray[n7++];
                    int n21 = 32;
                    GameObject gameObject = ObjectManager.addObject((byte)65, n14, n15 - n21);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = n21;
                    GameEngine.resetGorilla();
                    smGorillaStartX = n14;
                    smGorillaStartY = n15;
                    smGorillaEndX = n16;
                    smGorillaEndY = n17;
                    smGorillaMoveLeftRightTime = n18 * 500 | 1;
                    GameEngine.updateGorilla(gameObject);
                    smLevelHasGorilla = true;
                    Debugger.verbose("OBJECTTYPE_GORILLA");
                    continue block39;
                }
                case 25: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 32;
                    int n16 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32;
                    int n17 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 32;
                    smHippoStartX = n14;
                    smHippoStartY = n15;
                    smHippoEndX = n16;
                    smHippoEndY = n17;
                    smHippoTimer = -1;
                    GameObject gameObject = ObjectManager.addObject((byte)67, smHippoStartX, smHippoStartY);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 60;
                    smHippoObject = gameObject;
                    for (int i = 0; i < 4; ++i) {
                        GameEngine.smHippoPegs[i] = ObjectManager.addObject((byte)1, smHippoStartX, smHippoStartY);
                        GameEngine.smHippoPegs[i].mCollisionType = 1;
                        GameEngine.smHippoPegs[i].mRadius = 16;
                        smHippoPegs[i].setBoolean(1024, true);
                    }
                    GameEngine.updateHippo(gameObject);
                    gameObject.setBoolean(2, true);
                    ObjectManager.smBackgroundLayerObjectExists = true;
                    Debugger.verbose("OBJECTTYPE_HIPPO");
                    continue block39;
                }
                case 24: {
                    GameObject gameObject = ObjectManager.addObject((byte)66, smLevelWidth >> 1, smLevelHeight >> 1);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 30;
                    smSharkObject = gameObject;
                    smLevelHasShark = true;
                    GameEngine.resetShark();
                    GameEngine.updateShark(smSharkObject);
                    Debugger.verbose("OBJECTTYPE_SHARK");
                    continue block39;
                }
                case 26: 
                case 27: {
                    int n22;
                    GameObject gameObject = ObjectManager.addObject((byte)68, 0, 0);
                    gameObject.mCollisionType = (byte)3;
                    gameObject.mRadius = 30;
                    smRobotArmLeft = gameObject;
                    gameObject = ObjectManager.addObject((byte)68, 0, 0);
                    gameObject.mCollisionType = (byte)4;
                    gameObject.mRadius = 30;
                    smRobotArmRight = gameObject;
                    if (by == 26) {
                        int n23;
                        if ((n22 = byArray[n7++]) > 6) {
                            n22 = 6;
                        }
                        smRobotWaypointsLeft = new int[n22 * 2];
                        for (n23 = 0; n23 < n22; ++n23) {
                            GameEngine.smRobotWaypointsLeft[n23 * 2] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                            GameEngine.smRobotWaypointsLeft[n23 * 2 + 1] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                        }
                        if ((n22 = byArray[n7++]) > 6) {
                            n22 = 6;
                        }
                        smRobotWaypointsRight = new int[n22 * 2];
                        for (n23 = 0; n23 < n22; ++n23) {
                            GameEngine.smRobotWaypointsRight[n23 * 2] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                            GameEngine.smRobotWaypointsRight[n23 * 2 + 1] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                        }
                        smLevelHasEasyBoss = true;
                    } else {
                        smHardBossPositionX = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32;
                        smHardBossPositionY = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                        n22 = 90;
                        GameObject gameObject2 = ObjectManager.addObject((byte)1, smHardBossPositionX - n22, smHardBossPositionY);
                        gameObject2.mCollisionType = 1;
                        gameObject2.mRadius = 16;
                        gameObject2.setBoolean(32768, true);
                        gameObject2 = ObjectManager.addObject((byte)1, smHardBossPositionX + n22, smHardBossPositionY);
                        gameObject2.mCollisionType = 1;
                        gameObject2.mRadius = 16;
                        gameObject2.setBoolean(32768, true);
                        n3 = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32;
                        n4 = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32;
                        n5 = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32;
                        n6 = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32;
                        smLevelHasHardBoss = true;
                    }
                    Debugger.verbose("OBJECTTYPE_ROBOT");
                    continue block39;
                }
                case 31: {
                    int n24;
                    int n25;
                    int n26;
                    if (n12 <= 0) continue block39;
                    int n27 = 24 * --n12;
                    GameEngine.smMoverData[n27 + 0] = 0;
                    GameEngine.smMoverData[n27 + 16] = 0;
                    GameEngine.smMoverData[n27 + 23] = byArray[n7++];
                    GameEngine.smMoverLinks[GameEngine.smMoverData[n27 + 23]] = n27;
                    GameEngine.smMoverData[n27 + 1] = byArray[n7++];
                    GameEngine.smMoverData[n27 + 3] = byArray[n7++];
                    if (smMoverData[n27 + 3] == 0) {
                        GameEngine.smMoverData[n27 + 3] = 1;
                    }
                    GameEngine.smMoverData[n27 + 2] = byArray[n7++];
                    if (smMoverData[n27 + 2] == 0) {
                        GameEngine.smMoverData[n27 + 2] = 1;
                    }
                    int n28 = n27 + 2;
                    smMoverData[n28] = smMoverData[n28] * 50;
                    if ((n26 = byArray[n7++]) > 5) {
                        n26 = 5;
                    }
                    for (n25 = 0; n25 < n26; ++n25) {
                        n24 = n25 * 2;
                        GameEngine.smMoverData[n27 + 4 + n24] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                        GameEngine.smMoverData[n27 + 5 + n24] = ((byArray[n7++] & 0xFF) << 8 | byArray[n7++] & 0xFF) * 32 + 16;
                    }
                    GameEngine.smMoverData[n27 + 18] = -1;
                    GameEngine.smMoverData[n27 + 19] = smMoverData[n27 + 4];
                    GameEngine.smMoverData[n27 + 20] = smMoverData[n27 + 5];
                    n25 = Integer.MAX_VALUE;
                    n24 = Integer.MAX_VALUE;
                    int n29 = Integer.MIN_VALUE;
                    int n30 = Integer.MIN_VALUE;
                    for (int i = 0; i < n26; ++i) {
                        int n31 = i * 2;
                        n25 = Math.min(smMoverData[n27 + 4 + n31], n25);
                        n24 = Math.min(smMoverData[n27 + 5 + n31], n24);
                        n29 = Math.max(smMoverData[n27 + 4 + n31], n29);
                        n30 = Math.max(smMoverData[n27 + 5 + n31], n30);
                    }
                    GameEngine.smMoverData[n27 + 21] = n29 - n25;
                    GameEngine.smMoverData[n27 + 22] = n30 - n24;
                    continue block39;
                }
                case 32: {
                    if (n12 <= 0) continue block39;
                    int n32 = 24 * --n12;
                    for (int i = 0; i < 24; ++i) {
                        GameEngine.smMoverData[n32 + i] = 0;
                    }
                    GameEngine.smMoverData[n32 + 0] = 1;
                    GameEngine.smMoverData[n32 + 16] = 0;
                    GameEngine.smMoverData[n32 + 23] = byArray[n7++];
                    GameEngine.smMoverLinks[GameEngine.smMoverData[n32 + 23]] = n32;
                    GameEngine.smMoverData[n32 + 3] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 14] = byArray[n7++] * 32 >> 3;
                    GameEngine.smMoverData[n32 + 15] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 10] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 11] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 12] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 13] = byArray[n7++];
                    GameEngine.smMoverData[n32 + 21] = 0;
                    GameEngine.smMoverData[n32 + 22] = 0;
                    continue block39;
                }
                case 33: {
                    if (n12 <= 0) continue block39;
                    int n33 = 24 * --n12;
                    for (int i = 0; i < 24; ++i) {
                        GameEngine.smMoverData[n33 + i] = 0;
                    }
                    GameEngine.smMoverData[n33 + 0] = 2;
                    GameEngine.smMoverData[n33 + 23] = byArray[n7++];
                    GameEngine.smMoverLinks[GameEngine.smMoverData[n33 + 23]] = n33;
                    GameEngine.smMoverData[n33 + 3] = byArray[n7++] << 2;
                    GameEngine.smMoverData[n33 + 14] = -byArray[n7++] * 32 >> 3;
                    GameEngine.smMoverData[n33 + 15] = 0;
                    GameEngine.smMoverData[n33 + 10] = 0;
                    GameEngine.smMoverData[n33 + 11] = 0;
                    GameEngine.smMoverData[n33 + 12] = 0;
                    GameEngine.smMoverData[n33 + 13] = 0;
                    GameEngine.smMoverData[n33 + 16] = byArray[n7++] * 100;
                    GameEngine.smMoverData[n33 + 21] = 0;
                    GameEngine.smMoverData[n33 + 22] = 0;
                    continue block39;
                }
                case 34: {
                    int n34;
                    int n29;
                    int n24;
                    int n14 = byArray[n7++];
                    int n15 = byArray[n7++];
                    int n16 = byArray[n7++];
                    boolean bl = false;
                    int n35 = 24 * --n12;
                    for (n34 = 0; n34 < smMoverCount; ++n34) {
                        n24 = n34 * 24;
                        if (n15 != smMoverData[n24 + 23]) continue;
                        for (n29 = 0; n29 < 24; ++n29) {
                            GameEngine.smMoverData[n35 + n29] = smMoverData[n24 + n29];
                        }
                    }
                    GameEngine.smMoverData[n35 + 23] = n14;
                    for (n34 = 0; n34 < n16; ++n34) {
                        GameEngine.updateMover(100, n35);
                    }
                    continue block39;
                }
                case 28: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    GameObject gameObject = ObjectManager.addObject((byte)32, n14, n15);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 15;
                    Debugger.verbose("OBJECTTYPE_STICKY_GLUE");
                    continue block39;
                }
                case 29: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    GameObject gameObject = ObjectManager.addObject((byte)33, n14, n15);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 15;
                    Debugger.verbose("OBJECTTYPE_BEANS");
                    continue block39;
                }
                case 30: {
                    int n14 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    int n15 = (byArray[n7++] & 0xFF) << 8 | (byArray[n7++] & 0xFF) * 32 + 16;
                    GameObject gameObject = ObjectManager.addObject((byte)34, n14, n15);
                    gameObject.mCollisionType = 1;
                    gameObject.mRadius = 15;
                    Debugger.verbose("OBJECTTYPE_NO_GRAVITY");
                    continue block39;
                }
                default: {
                    throw new IllegalArgumentException("objectType == " + by + " not supported");
                }
            }
        }
        VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
        VisualEngine.updateCamera(1);
        smWaterTimerGoal = smLevelHeight * 700 / 32;
        if (smLevelHasHardBoss) {
            ObjectManager.markPegsBoss(n3 << 8, n4 << 8, n5 << 8, n6 << 8);
        }
        if (!(smQuickGame || smLevelHasShark || smLevelHasHardBoss)) {
            GameObject gameObject = ObjectManager.addObject((byte)1, smGoalX, smGoalY);
            gameObject.mCollisionType = 1;
            gameObject.mRadius = 16;
            gameObject.setBoolean(4096, true);
        }
        ObjectManager.startPreLevelCameraDrive();
        if (smQuickGame) {
            int n36 = Tuner.QUICK_GAME_BANANAS_IN_LEVEL[Math.min(smCurrentLevel, Tuner.QUICK_GAME_TIME_IN_LEVEL.length - 1)];
            for (int i = 0; i < n36; ++i) {
                ObjectManager.spawnBanana();
            }
            smQuickGameGoal = Tuner.QUICK_GAME_BANANAS_REQUIRED_IN_LEVEL[Math.min(smCurrentLevel, Tuner.QUICK_GAME_TIME_IN_LEVEL.length - 1)];
        }
        if (VisualEngine.smBreakableBoxes != null) {
            int n37 = VisualEngine.smBreakableBoxes.length;
            boolean bl = false;
            while (!bl) {
                bl = true;
                for (int i = 0; i < n37 - 1; ++i) {
                    if (VisualEngine.smBreakableBoxes[i].mPosY >= VisualEngine.smBreakableBoxes[i + 1].mPosY) continue;
                    GameObject gameObject = VisualEngine.smBreakableBoxes[i];
                    VisualEngine.smBreakableBoxes[i] = VisualEngine.smBreakableBoxes[i + 1];
                    VisualEngine.smBreakableBoxes[i + 1] = gameObject;
                    bl = false;
                }
            }
        }
        Debugger.verbose("Level loaded");
        Debugger.verbose("------");
    }

    public static final void updatePhysics(int n) {
        smAccumulatedTime += n;
        while (smAccumulatedTime > 33) {
            GameEngine.updatePhysics();
            smAccumulatedTime -= 33;
        }
    }

    public static final void updatePhysics() {
        if (smGameState == 0) {
            GameEngine.updatePlayer(33);
            GameEngine.updatePandas();
        }
        ObjectManager.logicUpdate(33);
        if (smGameState == 0) {
            ObjectManager.collidePlayerWithItems((smPlayerCollisionX >> 8) - 12, (smPlayerCollisionY >> 8) - 12, 24, 24);
            if (smPlayerState != 4) {
                GameEngine.updateRigidBodyPieces();
            }
        }
    }

    public static final void resetMenuLogic() {
        smPlayerX = VisualEngine.smScreenWidth << 7;
        smPlayerY = VisualEngine.smScreenHeight << 7;
        VisualEngine.setCameraPosition(0, 0, 0, 0);
        GameEngine.initRigidBodyPieces();
        ObjectManager.reset();
        int n = 40 + Util.getRandom() % (VisualEngine.smScreenWidth - 40 - 40);
        int n2 = 40 + Util.getRandom() % (VisualEngine.smScreenHeight - 40 - 40);
        n = (n << 7) / 96;
        n2 = (n2 << 7) / 96;
        GameObject gameObject = ObjectManager.addObject((byte)100, n, n2);
        gameObject.mWidth = 32;
        gameObject.mHeight = 32;
    }

    public static final void updateMenuBackground(boolean bl, int n, int n2) {
        int n3 = VisualEngine.smScreenWidth;
        int n4 = VisualEngine.smScreenHeight;
        n3 = (n3 << 7) / 96;
        n4 = (n4 << 7) / 96;
        if (Util.getManhattanDistance(smPlayerOldX, smPlayerOldY, smPlayerX, smPlayerY) >> 8 > Math.max(n4, n3)) {
            smPlayerX = n3 << 7;
            smPlayerY = n4 << 7;
            smPlayerVelocityX = 0;
            smPlayerVelocityY = 0;
        }
        smPlayerOldX = smPlayerX;
        smPlayerOldY = smPlayerY;
        if (bl) {
            smPlayerVelocityX += n;
            smPlayerVelocityY += n2;
        } else {
            GameObject gameObject = ObjectManager.getObjects()[0];
            int n5 = gameObject.mPosX - smPlayerX >> 8;
            int n6 = gameObject.mPosY - smPlayerY >> 8;
            int n7 = Util.sqrtApproximate(n5, n6);
            int n8 = n7 * 175;
            int n9 = n7 * n7 | 1;
            n5 = n5 * n8 / n9;
            n6 = n6 * n8 / n9;
            smPlayerVelocityX += n5;
            smPlayerVelocityY += n6;
        }
        smPlayerAngle = Util.atan2(smPlayerVelocityY, smPlayerVelocityX);
        smPlayerAngle <<= 2;
        smPlayerVelocityX = smPlayerVelocityX * 240 >> 8;
        smPlayerVelocityY = smPlayerVelocityY * 240 >> 8;
        smPlayerX += smPlayerVelocityX;
        smPlayerY += smPlayerVelocityY;
        smPlayerX = Math.max(7680, Math.min(smPlayerX, n3 - 30 << 8));
        smPlayerY = Math.max(7680, Math.min(smPlayerY, n4 - 30 << 8));
        ObjectManager.collidePlayerWithItems((smPlayerX >> 8) - 12, (smPlayerY >> 8) - 12, 24, 24);
        GameEngine.updateRigidBodyPieces();
        ParticleSystem.updateEffects(33);
    }

    public static final void updateGoal() {
        if ((smLevelSettings & 1) != 0 && smFruitCount > smFruitsCollected) {
            return;
        }
        if ((smLevelSettings & 2) != 0) {
            if (smPlayerCirclingCenter.getBoolean(4096) && smPlayerState == 1) {
                smBabyPandasCount -= smBabyPandasCollected;
                smBabyPandasCollected = 0;
            }
            if (!(smCheatsEnabled && (smKeysHold & 0x20) != 0 || smBabyPandasCount <= smBabyPandasCollected)) {
                return;
            }
        }
        if (GameEngine.collideGoal()) {
            ParticleSystem.startCageBrokeFx(smGoalX - 30, smGoalY + 35, 60, 70);
            VisualEngine.smGoalCage.setAnimationFrame(0);
            int n = smGoalX - 22;
            int n2 = smGoalY + 89;
            int n3 = 44;
            int n4 = 10;
            int n5 = 0;
            boolean bl = false;
            while (!bl) {
                int n6 = ObjectManager.collideRectWithGeometry(n, n2 + (n5 += 32), n3, n4);
                if (n6 < 0) continue;
                n5 += n6 - 32;
                bl = true;
            }
            smGoalFreeSpaceBelow = n5;
            smGoalDropParticlesDropped = false;
            smGoalDroppingTime = smGoalFreeSpaceBelow * 10;
            if (smGoalDroppingTime < 750) {
                smGoalDroppingTime = 750;
            }
            if (smGoalDroppingTime > 3000) {
                smGoalDroppingTime = 3000;
            }
            GameEngine.vibrate(450);
            VisualEngine.startCameraShake(200);
            GameEngine.changeGameState(3);
        }
        if (smLevelHasShark && smSharkStateHpLeft <= 0) {
            GameEngine.changeGameState(1);
        }
        if ((smLevelSettings & 4) != 0 && smFruitsCollected >= smFruitCount) {
            GameEngine.changeGameState(1);
        }
        if (smQuickGame && smFruitsCollected >= smQuickGameGoal) {
            GameEngine.changeGameState(5);
        }
    }

    public static final boolean collideGoal() {
        if (!GameEngine.getTutorialCompleted(32) && !smQuickGame && Util.getManhattanDistance(smGoalX, smGoalY, smPlayerX >> 8, smPlayerY >> 8) < 175) {
            GameEngine.setTickerBoxText(113, false, -1);
            GameEngine.setTutorialCompleted(32);
        }
        if (smCheatsEnabled && (smKeysHold & 0x20) != 0) {
            smFruitsCollected = smFruitCount;
            smKeysHold &= 0xFFFFFFDF;
            return true;
        }
        if (smLevelHasShark || smLevelHasHardBoss || smQuickGame) {
            return false;
        }
        return smPlayerCirclingCenter.getBoolean(4096) && smPlayerState == 1;
    }

    public static final void changePlayerState(int n) {
        smPlayerStateTimer = 0;
        smPlayerState = n;
    }

    public static final void initRigidBodyPieces() {
        int n;
        for (n = 0; n < 5; ++n) {
            int n2 = n * 6;
            GameEngine.smRigidBodyItems[n2 + 0] = smPlayerX + (RIGID_BODY_LOCATIONS[n * 2] << 8);
            GameEngine.smRigidBodyItems[n2 + 1] = smPlayerY + (RIGID_BODY_LOCATIONS[n * 2 + 1] << 8);
            GameEngine.smRigidBodyItems[n2 + 2] = smRigidBodyItems[n2 + 0] + Util.getRandom(500) - 250;
            GameEngine.smRigidBodyItems[n2 + 3] = smRigidBodyItems[n2 + 1] + 50;
            GameEngine.smRigidBodyItems[n2 + 4] = RIGID_BODY_LOCATIONS[n * 2] << 8;
            GameEngine.smRigidBodyItems[n2 + 5] = RIGID_BODY_LOCATIONS[n * 2 + 1] << 8;
        }
        for (n = 0; n < 5; ++n) {
            GameEngine.updateRigidBodyPieces();
        }
    }

    public static final void addSpeedToRigidBodyPiece(int n, int n2, int n3) {
        int n4 = (n *= 6) + 2;
        smRigidBodyItems[n4] = smRigidBodyItems[n4] + (n2 << 8);
        int n5 = n + 3;
        smRigidBodyItems[n5] = smRigidBodyItems[n5] + (n3 << 8);
    }

    public static final void updateRigidBodyPieces() {
        boolean bl = false;
        if (smPowerupCollected == 32 && smPlayerJumpedOnLastFrame) {
            bl = true;
        }
        int n = 0;
        for (int i = 0; i < smRigidBodyItems.length; i += 6) {
            int n2 = RIGID_BODY_LOCATIONS[n << 1];
            int n3 = RIGID_BODY_LOCATIONS[(n << 1) + 1];
            int n4 = smPlayerAngle + 65536 >> 8;
            if (smPlayerState == 2 || smPlayerState == 3) {
                n4 = 0;
            }
            GameEngine.smRigidBodyItems[i + 4] = (Util.getCos(n4) * n2 >> 12) - (Util.getSin(n4) * n3 >> 12) << 8;
            GameEngine.smRigidBodyItems[i + 5] = (Util.getSin(n4) * n2 >> 12) + (Util.getCos(n4) * n3 >> 12) << 8;
            int n5 = 10;
            if (smPlayerState == 2) {
                n5 = 40 + n * 10;
            }
            if (smGravityY < 0) {
                if (n == 0) {
                    n5 = -250;
                }
                if (n == 3 || n == 4) {
                    n5 = -25;
                }
            }
            int n6 = i + 1;
            smRigidBodyItems[n6] = smRigidBodyItems[n6] + n5;
            int n7 = smRigidBodyItems[i + 0];
            int n8 = smRigidBodyItems[i + 1];
            int n9 = smRigidBodyItems[i + 0] - smRigidBodyItems[i + 2];
            int n10 = smRigidBodyItems[i + 1] - smRigidBodyItems[i + 3];
            n9 = n9 * 252 >> 8;
            n10 = n10 * 252 >> 8;
            int n11 = i + 0;
            smRigidBodyItems[n11] = smRigidBodyItems[n11] + n9;
            int n12 = i + 1;
            smRigidBodyItems[n12] = smRigidBodyItems[n12] + n10;
            GameEngine.smRigidBodyItems[i + 2] = n7;
            GameEngine.smRigidBodyItems[i + 3] = n8;
            int n13 = RIGID_BODY_LENGTHS[n];
            int n14 = n13 * n13;
            for (int j = 0; j < 5; ++j) {
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                if (smPlayerState == 2 && (n == 3 || n == 4)) {
                    n19 = Util.getSin(smStateTime + 512 * n);
                    n19 = smPlayerRopeMovingLeft ? Math.min(n19, -1096) : Math.max(n19, 1096);
                    n18 = 30;
                    n17 = n19 * n18 >> 12;
                    n16 = smPlayerX + smRigidBodyItems[i + 4];
                    GameEngine.smRigidBodyItems[i + 0] = n16 + (n17 <<= 8);
                    n15 = smPlayerY + smRigidBodyItems[i + 5];
                    GameEngine.smRigidBodyItems[i + 1] = n15 - 7680;
                }
                if (n == 0 && smTargetPeg != null && smPlayerState != 1 && ((n19 = GameEngine.smTargetPeg.mPosX - smRigidBodyItems[i + 0]) < 0 ? -n19 : n19) + ((n18 = GameEngine.smTargetPeg.mPosY - smRigidBodyItems[i + 1]) < 0 ? -n18 : n18) < 25600) {
                    int n20 = i + 0;
                    smRigidBodyItems[n20] = smRigidBodyItems[n20] + (n19 >> 7);
                    int n21 = i + 1;
                    smRigidBodyItems[n21] = smRigidBodyItems[n21] + (n18 >> 7);
                }
                if (smPlayerState == 1 && n == 0) {
                    GameEngine.smRigidBodyItems[i + 0] = smPlayerCirclingCenter.getRotatingPointX();
                    GameEngine.smRigidBodyItems[i + 1] = smPlayerCirclingCenter.getRotatingPointY();
                } else if (smPlayerState == 3 && n != 0) {
                    GameEngine.smRigidBodyItems[i + 0] = smPlayerX + (smRigidBodyItems[i + 4] - smPowerupData2 * n13);
                    GameEngine.smRigidBodyItems[i + 1] = smPlayerY + (smRigidBodyItems[i + 5] - smPowerupData3 * n13);
                }
                n19 = smPlayerX + smRigidBodyItems[i + 4] - smRigidBodyItems[i + 0] >> 4;
                n18 = smPlayerY + smRigidBodyItems[i + 5] - smRigidBodyItems[i + 1] >> 4;
                n17 = n19 * n19 + n18 * n18 >> 8;
                n16 = (n14 << 4) / (n17 + n14) - 8;
                int n22 = n19 * n16;
                n15 = n18 * n16;
                int n23 = i + 0;
                smRigidBodyItems[n23] = smRigidBodyItems[n23] - n22;
                int n24 = i + 1;
                smRigidBodyItems[n24] = smRigidBodyItems[n24] - n15;
            }
            if (bl && n != 0) {
                ParticleSystem.addGlueFx(smRigidBodyItems[i + 0] >> 8, smRigidBodyItems[i + 1] >> 8);
            }
            ++n;
        }
    }

    public static final void playerHitLethalBlock() {
        int n;
        if (!smQuickGame && smFruitsCollected > 0) {
            n = Math.min(6, smFruitsCollected);
            ObjectManager.respawnFruits(n, smPlayerX, smPlayerY);
            smChargeMeterCount = Math.max(0, smChargeMeterCount - n);
        }
        if (smQuickGame) {
            n = GameEngine.getNextPendingAchievement(-1);
            if (n >= 0) {
                smPostGameVisibleAchievement = n;
                GameEngine.updateAchievementTexts();
                GameEngine.changeGameState(4);
            } else {
                GameEngine.changeGameState(2);
            }
        } else {
            GameEngine.changeGameState(2);
        }
    }

    public static final void restartPlayer() {
        smTickerBoxState = 0;
        ParticleSystem.resetEffects();
        if (smPlayerStartObject != null) {
            smPlayerX = GameEngine.smPlayerStartObject.mPosX;
            smPlayerY = GameEngine.smPlayerStartObject.mPosY;
        }
        smPlayerOldX = smPlayerX;
        smPlayerOldY = smPlayerY;
        smPlayerStateTimer = 0;
        if (smPlayerStartObject != null) {
            GameEngine.attachToRotationPoint(smPlayerStartObject);
        }
        smPlayerVelocityX = 0;
        smPlayerVelocityY = 0;
        smPlayerFanFieldX = 0;
        smPlayerFanFieldY = 0;
        smPlayerAngle = 0;
        smPlayerCanJump = true;
        smPlayerCollectedBananasJump = 0;
        smPowerupCollected = POWERUP_TYPE_NONE;
        smPowerupHatWorn = -1;
        smWaterTimer = 0;
        smWaterStoppedTimer = 0;
        ObjectManager.resetItems();
        GameEngine.initRigidBodyPieces();
        VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
        GameEngine.resetHippo();
        GameEngine.resetGorilla();
        GameEngine.restartRobot();
        if (smLevelHasShark) {
            smSharkState = 0;
        }
        if (smQuickGame) {
            smQuickGameTimeLeft = smQuickGameTimeLimit = Tuner.QUICK_GAME_TIME_IN_LEVEL[Math.min(smCurrentLevel, Tuner.QUICK_GAME_TIME_IN_LEVEL.length - 1)] - 1000 * (smQuickGameStage - 1);
            smQuickGameTimeElapsed = 0;
        }
        smPlayerBumperBouncesInARow = 0;
        smPlayerBananasInARowNoGravity = 0;
    }

    public static final void resetPlayer() {
        if (smPlayerStartObject != null) {
            smPlayerX = GameEngine.smPlayerStartObject.mPosX;
            smPlayerY = GameEngine.smPlayerStartObject.mPosY;
        }
        smPlayerOldX = smPlayerX;
        smPlayerOldY = smPlayerY;
        if (smPlayerStartObject != null) {
            GameEngine.attachToRotationPoint(smPlayerStartObject);
        }
        GameEngine.initRigidBodyPieces();
        smChargeMeterCount = 0;
        smFruitsCollected = 0;
        smFruitsCollectedNoDelay = 0;
        smHighestCombo = 0;
        smPlayerVelocityX = 0;
        smPlayerVelocityY = 0;
        smPlayerFanFieldX = 0;
        smPlayerFanFieldY = 0;
        smPlayerAngle = 0;
        smPlayerCanJump = true;
        smPowerupCollected = POWERUP_TYPE_NONE;
        smPowerupHatWorn = -1;
        smWaterTimer = 0;
        smWaterStoppedTimer = 0;
        smPlayerRotatingCCW = false;
        smPlayerCollectedBananasJump = 0;
        if (smQuickGame) {
            smQuickGameTimeLeft = smQuickGameTimeLimit = Tuner.QUICK_GAME_TIME_IN_LEVEL[Math.min(smCurrentLevel, Tuner.QUICK_GAME_TIME_IN_LEVEL.length - 1)] - 1000 * (smQuickGameStage - 1);
            smQuickGameTimeElapsed = 0;
        }
        smPlayerHasHitWall = false;
        smPlayerBumperBouncesInARow = 0;
        smPlayerBananasInARowNoGravity = 0;
    }

    public static final void updatePlayer(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        if (!smQuickGame && smSharkObject == null && !smLevelHasHardBoss && smFruitCount <= smFruitsCollected && (smHudFullTimer -= n) < 0) {
            int n10 = 0;
            n9 = 0;
            n10 = 10 + Util.getRandom(VisualEngine.smHudNumbers.getWidth() * 4);
            n9 = 10 + Util.getRandom(VisualEngine.smHudNumbers.getHeight());
            ParticleSystem.addHudFullFx(n10, n9);
            ParticleSystem.addHudFullFx(n10, n9);
            ParticleSystem.addHudFullFx(n10, n9);
            smHudFullTimer = 250;
        }
        smPlayerJumpedOnLastFrame = false;
        smPlayerOldX = smPlayerX;
        smPlayerOldY = smPlayerY;
        smPlayerOldCollisionX = smPlayerCollisionX;
        smPlayerOldCollisionY = smPlayerCollisionY;
        smPlayerStateTimer += n;
        if (smPowerupCollected != POWERUP_TYPE_NONE && (smPowerupAnimationTimer += n) > 100 && smPlayerState != 4) {
            ParticleSystem.addPowerupActiveFx(smPlayerX >> 8, smPlayerY >> 8, 0, 0);
            smPowerupAnimationTimer = 0;
        }
        if (smPlayerState == 2) {
            n9 = GameEngine.smPlayerCirclingCenter.mPosX;
            n8 = GameEngine.smPlayerCirclingCenter.mWidth;
            n7 = GameEngine.smPlayerCirclingCenter.mPosY;
            n6 = GameEngine.smPlayerCirclingCenter.mHeight;
            n5 = Util.sqrtApproximate(n8 - n9 >> 8, n7 - n6 >> 8);
            n4 = n5 * 512 / 32;
            if (smPlayerHoldRopeTimer == 0) {
                if (smPlayerVelocityX >= 0 && n9 - n8 != 0) {
                    n3 = Util.sqrtApproximate(smPlayerX - n9 >> 8, smPlayerY - n7 >> 8);
                    smPlayerHoldRopeTimer = n3 * 512 / 32;
                } else {
                    n3 = Util.sqrtApproximate(smPlayerX - n8 >> 8, smPlayerY - n6 >> 8);
                    smPlayerHoldRopeTimer = n4 + n3 * 512 / 32;
                }
                smPlayerVelocityX = 0;
                smPlayerVelocityY = 0;
            }
            if ((n3 = smPlayerHoldRopeTimer % (n4 << 1)) < n4) {
                smPlayerX = n9 + ((n8 - n9 >> 8) * n3 / n4 << 8);
                smPlayerY = n7 + ((n6 - n7 >> 8) * n3 / n4 << 8) + 1280;
                smPlayerRopeMovingLeft = false;
            } else {
                smPlayerX = n8 - ((n8 - n9 >> 8) * (n3 -= n4) / n4 << 8);
                smPlayerY = n6 - ((n6 - n7 >> 8) * n3 / n4 << 8) + 1280;
                smPlayerRopeMovingLeft = true;
            }
            smPlayerHoldRopeTimer += n;
        }
        if (smPlayerState == 1) {
            if (smPlayerCirclingCenter.getBoolean(16) && !smPlayerCirclingCenter.getBoolean(32)) {
                GameEngine.smPlayerCirclingCenter.mTypeData += n;
                if (GameEngine.smPlayerCirclingCenter.mTypeData > 1800) {
                    ParticleSystem.startFallingPegFx(GameEngine.smPlayerCirclingCenter.mPosX >> 8, GameEngine.smPlayerCirclingCenter.mPosY >> 8);
                    smPlayerCirclingCenter.setBoolean(32, true);
                }
            }
            n7 = Math.min(smPlayerCirclingTimer, 350);
            n6 = 8960 * n7 / 350;
            n2 = Math.min(smPlayerCirclingTimer, 1000);
            n4 = 30720;
            if (smPowerupStored == 37 && !smQuickGame) {
                n4 = n4 * 15 / 10;
            }
            n3 = 0;
            int n11 = smPlayerAngleVelocityExtra * 25 / n4 << 8;
            n3 = Util.getSin(n2 * 1024 / 2000) * n11 >> 12;
            n11 = smRigidBodyItems[4];
            int n12 = smRigidBodyItems[5];
            int n13 = smPlayerCirclingCenter.getRotatingPointX();
            int n14 = smPlayerCirclingCenter.getRotatingPointY();
            if (n7 < 350) {
                n13 = smCirclingTouchPointX + (n13 - smCirclingTouchPointX) * n7 / 350;
                n14 = smCirclingTouchPointY + (n14 - smCirclingTouchPointY) * n7 / 350;
            }
            smPlayerX = n13 + n11 + (Util.getCos(smPlayerAngle >> 8) * (n6 + n3) >> 12);
            smPlayerY = n14 + n12 + (Util.getSin(smPlayerAngle >> 8) * (n6 + n3) >> 12);
            smPlayerCollisionX = n13 + n11 + (Util.getCos(smPlayerAngle >> 8) * n6 >> 12);
            smPlayerCollisionY = n14 + n12 + (Util.getSin(smPlayerAngle >> 8) * n6 >> 12);
            smPlayerCirclingTimer += n;
        }
        n9 = smPlayerAngleVelocity;
        if (smPlayerState == 1) {
            n8 = 3000;
            if (smPowerupStored == 37 && !smQuickGame) {
                n8 += 2500;
            }
            smPlayerAngleVelocityExtra = smPlayerAngleVelocitySpeedUp - Math.min(smPlayerCirclingTimer, n8) * smPlayerAngleVelocitySpeedUp / n8;
            n9 = smPlayerAngleVelocity + smPlayerAngleVelocityExtra;
        }
        smPlayerAngle += (smPlayerRotatingCCW ? -n9 : n9) * n >> 8;
        if (smPlayerState == 0) {
            n8 = Util.atan2(smPlayerVelocityY, smPlayerVelocityX);
            smPlayerAngle = n8 * 1024 >> 16 << 8;
        }
        GameEngine.updatePowerups(n);
        if ((smKeys & 0x10) != 0) {
            if (!smTickerTimedClosing && smTickerBoxState == 2) {
                GameEngine.closeTickerbox();
            }
            if (smPlayerCanJump || smPlayerState == 1 || smPlayerState == 2) {
                n8 = smPlayerAngle >> 8;
                n7 = 1;
                smQuickGameAllowNewJump = false;
                smPlayerCanJump = false;
                n6 = 12800;
                if (smPlayerState == 1 || smPlayerState == 2) {
                    smPlayerVelocityX = 0;
                    smPlayerVelocityY = 0;
                    n6 = 20480;
                    if (smPowerupStored != 37 || smQuickGame) {
                        smPlayerCanJump = true;
                    }
                    smPlayerCollectedBananasJump = 0;
                    if (smPlayerState == 1) {
                        n6 += smPlayerAngleVelocityExtra * 4096 / 30720;
                    }
                } else if (smPowerupCollected == 33) {
                    if (smQuickGame) {
                        smShootLevelPlayerCanJumpCounter = 0;
                    }
                    if (smPlayerState != 4) {
                        GameEngine.changePlayerState(4);
                        smPlayerCanJump = true;
                        smPlayerCollectedBananasJump = 0;
                        n7 = 0;
                        smPlayerVelocityX = 0;
                        smPlayerVelocityY = 0;
                    } else {
                        ParticleSystem.addBeansFx(smPlayerX >> 8, smPlayerY >> 8);
                        if (--smPowerupData1 <= 0) {
                            smPowerupCollected = POWERUP_TYPE_NONE;
                            GameEngine.endPowerupHat();
                        }
                        n6 = 25600;
                    }
                } else {
                    smPlayerJumpedOnLastFrame = true;
                    int n15 = smPlayerVelocityX;
                    n2 = smPlayerVelocityY;
                    if (smTargetPeg != null) {
                        n15 = GameEngine.smTargetPeg.mPosX - smPlayerX;
                        n2 = GameEngine.smTargetPeg.mPosY - smPlayerY;
                    }
                    if ((n5 = Util.sqrtApproximate(n15 >> 8, n2 >> 8)) == 0) {
                        n5 = 1;
                    }
                    n4 = (n15 /= n5) * n6 >> 8;
                    n3 = (n2 /= n5) * n6 >> 8;
                    smPlayerVelocityX = n4;
                    smPlayerVelocityY = n3;
                    GameEngine.changePlayerState(0);
                    return;
                }
                if (n7 != 0) {
                    if (smPowerupStored == 37 && !smQuickGame) {
                        n6 = n6 * 15 / 10;
                    }
                    smPlayerJumpedOnLastFrame = true;
                    int n16 = Util.getCos(n8) * n6 >> 12;
                    n2 = Util.getSin(n8) * n6 >> 12;
                    smPlayerVelocityX += n16;
                    smPlayerVelocityY += n2;
                    GameEngine.changePlayerState(0);
                }
            }
            smKeys &= 0xFFFFFFEF;
        }
        if (smPlayerState != 0) {
            smPlayerFanFieldX = 0;
            smPlayerFanFieldY = 0;
        }
        if (smPlayerState == 0) {
            GameEngine.calculateGravityField();
            if (smPowerupCollected != 34) {
                if (smGravityX != 0) {
                    smPlayerVelocityX += smGravityX * n >> 8;
                }
                if (smGravityY != 0) {
                    smPlayerVelocityY += smGravityY * n >> 8;
                }
            }
            smPlayerX += smPlayerVelocityX * n >> 8;
            smPlayerY += smPlayerVelocityY * n >> 8;
        }
        GameEngine.collidePlayerWithLevelBoundaries();
        n8 = Util.sqrtApproximate(smPlayerVelocityX, smPlayerVelocityY);
        if (n8 > 15000) {
            smPlayerVelocityX = smPlayerVelocityX * 240 >> 8;
            smPlayerVelocityY = smPlayerVelocityY * 240 >> 8;
        }
        if (smPlayerCanJump) {
            smTargetPeg = ObjectManager.findNearestRotationPoint(smPlayerX, smPlayerY, smPlayerVelocityX, smPlayerVelocityY, 175);
        }
        if (smPlayerState != 1) {
            smPlayerCollisionX = smPlayerX;
            smPlayerCollisionY = smPlayerY;
        }
    }

    private static void collidePlayerWithLevelBoundaries() {
        int n = smPlayerCollisionX >> 8;
        int n2 = smPlayerCollisionY >> 8;
        if (n - 12 < 0) {
            if (smQuickGame) {
                smPlayerX = smLevelWidth - 12 << 8;
                VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
                VisualEngine.updateCamera(1);
            } else {
                smPlayerX = 3072;
                if (smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(smPlayerX >> 8, smPlayerY >> 8, 256, 0);
                }
                GameEngine.resolveCollisionReflection(256, 256, 0);
            }
        } else if (n > smLevelWidth - 12) {
            if (smQuickGame) {
                smPlayerX = 3072;
                VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
                VisualEngine.updateCamera(1);
            } else {
                smPlayerX = smLevelWidth - 12 << 8;
                if (smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(smPlayerX >> 8, smPlayerY >> 8, -256, 0);
                }
                GameEngine.resolveCollisionReflection(256, -256, 0);
            }
        }
        if (n2 - 12 < 0) {
            if (smQuickGame) {
                smPlayerY = smLevelHeight - 12 << 8;
                VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
                VisualEngine.updateCamera(1);
            } else {
                smPlayerY = 3072;
                if (smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(smPlayerX >> 8, smPlayerY >> 8, 0, 256);
                }
                GameEngine.resolveCollisionReflection(256, 0, 256);
            }
        } else if (n2 > smLevelHeight - 12) {
            if (smQuickGame) {
                smQuickGameAllowNewJump = true;
                smPlayerY = 3072;
                VisualEngine.setCameraPosition((smPlayerX >> 8) * 96 >> 7, (smPlayerY >> 8) * 96 >> 7, VisualEngine.smScreenWidth >> 1, VisualEngine.smScreenHeight >> 1);
                VisualEngine.updateCamera(1);
            } else {
                smPlayerY = smLevelHeight - 12 << 8;
                if (smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(smPlayerX >> 8, smPlayerY >> 8, 0, -256);
                }
                GameEngine.resolveCollisionReflection(256, 0, -256);
            }
        }
    }

    public static void calculateGravityField() {
        smGravityX = 0;
        smGravityY = 0;
        smGravityY += 4352;
        if (smPowerupStored == 37 && !smQuickGame) {
            smGravityY += 7;
        }
        if (smBabyPandasCollected > 0) {
            smGravityY += 768 * smBabyPandasCollected;
        }
        smGravityX += smPlayerFanFieldX;
        smGravityY += smPlayerFanFieldY;
        smPlayerFanFieldX = 0;
        smPlayerFanFieldY = 0;
    }

    public static final void resolveCollisionReflection(int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        smPlayerHasHitWall = true;
        if (smPowerupCollected == 32) {
            smPlayerCollectedBananasJump = 0;
            smPlayerStateTimer = 0;
            GameEngine.changePlayerState(3);
            smPowerupData2 = n2;
            smPowerupData3 = n3;
            smPlayerVelocityX = 0;
            smPlayerVelocityY = 0;
            int n7 = -n2 * 18;
            int n8 = -n3 * 18;
            ParticleSystem.startGlueSurfaceFx(smPlayerX + n7 >> 8, smPlayerY + n8 >> 8);
            return;
        }
        if (smPlayerState == 1) {
            if (smPlayerCirclingCenter.getBoolean(1024)) {
                smPlayerCirclingCenter.setBoolean(8, true);
                smPlayerVelocityY = 10240;
                GameEngine.addSpeedToRigidBodyPiece(0, 0, 100);
                GameEngine.changePlayerState(0);
            }
            if (smPlayerCirclingCenter.getBoolean(32)) {
                GameEngine.smPlayerCirclingCenter.mTypeData = 6300;
                smPlayerCirclingCenter.setBoolean(8, true);
                smPlayerVelocityY = 10240;
                GameEngine.addSpeedToRigidBodyPiece(0, 0, 100);
                GameEngine.changePlayerState(0);
            }
        } else {
            GameEngine.addAchievement(11, 1);
        }
        if ((n6 = Util.sqrtApproximate(n5 = smPlayerVelocityX, n4 = smPlayerVelocityY)) < 5000) {
            if (n6 == 0) {
                n6 = 1;
            }
            n5 = n5 * 5000 / n6;
            n4 = n4 * 5000 / n6;
        }
        int n9 = (n5 * n2 >> 8) + (n4 * n3 >> 8);
        int n10 = n9 * n2 >> 8;
        int n11 = n9 * n3 >> 8;
        smPlayerVelocityX = n5 - ((256 + n) * n10 >> 8);
        smPlayerVelocityY = n4 - ((256 + n) * n11 >> 8);
        if ((smLevelSettings & 4) != 0) {
            if (++smShootLevelPlayerCanJumpCounter > 5) {
                smShootLevelPlayerCanJumpCounter = 0;
                smPlayerCanJump = true;
            }
        } else if (smPowerupStored != 37 || smQuickGame) {
            smPlayerCanJump = true;
        }
    }

    public static final void updatePowerups(int n) {
        if (smPowerupCollected == 34 && (smPowerupData1 -= n) <= 0) {
            ParticleSystem.startHatFx(VisualEngine.smMonkeyHeadX + VisualEngine.smCameraX, VisualEngine.smMonkeyHeadY + VisualEngine.smCameraY, 0);
            smPowerupCollected = POWERUP_TYPE_NONE;
            GameEngine.endPowerupHat();
        }
        if (smPlayerState == 3 && (smKeys & 0x10) != 0) {
            int n2 = GameEngine.getStickyPowerupAngle();
            smPlayerVelocityX = Util.getCos(n2) * 28160 >> 12;
            smPlayerVelocityY = Util.getSin(n2) * 28160 >> 12;
            GameEngine.changePlayerState(0);
            if (--smPowerupData1 <= 0) {
                smPowerupCollected = POWERUP_TYPE_NONE;
                GameEngine.endPowerupHat();
            }
            smPowerupData2 = 0;
            smPowerupData3 = 0;
            smKeys &= 0xFFFFFFEF;
        }
    }

    public static final void attachToRotationPoint(GameObject gameObject) {
        int n = smPlayerY - gameObject.mPosY >> 8;
        int n2 = -n;
        int n3 = smPlayerVelocityX;
        int n4 = smPlayerX - gameObject.mPosX >> 8;
        int n5 = n4;
        int n6 = smPlayerVelocityY;
        smPlayerRotatingCCW = n2 * n3 + n5 * n6 <= 0;
        smPlayerAngle = (smPlayerRotatingCCW ? 256 : -256) + (Util.atan2(smPlayerVelocityY, smPlayerVelocityX) * 1024 >> 16) << 8;
        smCirclingTouchPointX = smPlayerX;
        smCirclingTouchPointY = smPlayerY;
        smPlayerCirclingCenter = gameObject;
        smPlayerCirclingTimer = 0;
        smPlayerLastHoldRotatingDot = gameObject.mUniqueId;
        GameEngine.changePlayerState(1);
        int n7 = 20480;
        int n8 = 30720;
        if (smPowerupStored == 37 && !smQuickGame) {
            n8 = n8 * 15 / 10;
        }
        smPlayerAngleVelocitySpeedUp = n8 * Math.min(Util.sqrtApproximate(smPlayerVelocityX, smPlayerVelocityY), n7) / n7;
        smPlayerVelocityX = 0;
        smPlayerVelocityY = 0;
        if (smPlayerCirclingCenter.getBoolean(4096)) {
            if ((smLevelSettings & 2) != 0 && !GameEngine.getTutorialCompleted(64)) {
                GameEngine.setTickerBoxText(114, false, -1);
                GameEngine.setTutorialCompleted(64);
            }
            if ((smLevelSettings & 1) != 0 && !GameEngine.getTutorialCompleted(128)) {
                GameEngine.setTickerBoxText(115, false, -1);
                GameEngine.setTutorialCompleted(128);
            }
        }
    }

    public static final void playerObjectCollision(GameObject gameObject) {
        byte by = gameObject.mType;
        switch (by) {
            case 1: 
            case 12: 
            case 13: {
                smPlayerBumperBouncesInARow = 0;
                smPlayerBananasInARowNoGravity = 0;
                if (gameObject.mLinkedMover != 0) {
                    byte by2 = gameObject.mLinkedMover;
                    int n = smMoverLinks[by2];
                    int n2 = smMoverData[n + 0] & 0xFF;
                    if (n2 == 0 || n2 == 1) {
                        GameEngine.addObjectTypeToAchievements(1);
                    } else if (n2 == 2) {
                        GameEngine.addObjectTypeToAchievements(8);
                    }
                }
                if (by == 13) {
                    GameEngine.addObjectTypeToAchievements(2);
                    if (!gameObject.getBoolean(256)) {
                        GameEngine.vibrate(250);
                        gameObject.setBoolean(256, true);
                        gameObject.mLifeTimer = 0;
                        smWaterStoppedTimer += 5000;
                    }
                }
                if (by == 12) {
                    GameEngine.addObjectTypeToAchievements(2);
                    if (!gameObject.getBoolean(256)) {
                        GameEngine.vibrate(250);
                        gameObject.setBoolean(256, true);
                        gameObject.mLifeTimer = 0;
                    }
                    if (smWaterTimer == 0 && ObjectManager.areAllValvesSetOn()) {
                        if (!GameEngine.getTutorialCompleted(32768)) {
                            GameEngine.setTickerBoxText(123, true, -1);
                            GameEngine.setTutorialCompleted(32768);
                        }
                        smWaterTimer = 1;
                    }
                }
                if (gameObject.mUniqueId == smPlayerLastHoldRotatingDot || smPlayerState != 0) break;
                GameEngine.attachToRotationPoint(gameObject);
                GameEngine.addAchievement(9, 1);
                if (gameObject.getBoolean(1024) && smHippoTimer == -1) {
                    smHippoTimer = 0;
                }
                if (!gameObject.getBoolean(64)) break;
                GameEngine.addObjectTypeToAchievements(2);
                if (gameObject.getBoolean(256) && !gameObject.getBoolean(512)) break;
                GameEngine.vibrate(250);
                gameObject.setBoolean(256, !gameObject.getBoolean(256));
                ObjectManager.switchToggled(gameObject.mTypeData);
                break;
            }
            case 10: {
                GameEngine.addObjectTypeToAchievements(4);
                smPlayerBumperBouncesInARow = 0;
                smPlayerBananasInARowNoGravity = 0;
                if (gameObject.mUniqueId == smPlayerLastHoldRotatingDot || smPlayerState != 0) break;
                smCirclingTouchPointX = smPlayerX;
                smCirclingTouchPointY = smPlayerY;
                smPlayerCirclingCenter = gameObject;
                smPlayerCirclingTimer = 0;
                smPlayerLastHoldRotatingDot = gameObject.mUniqueId;
                GameEngine.changePlayerState(2);
                smPlayerHoldRopeTimer = 0;
                break;
            }
            case 8: 
            case 9: {
                GameEngine.playerHitLethalBlock();
                break;
            }
            case 35: {
                if (gameObject.mTypeData != 0) break;
                GameObject gameObject2 = ObjectManager.findPeg(gameObject.mPosX >> 8, gameObject.mPosY >> 8, gameObject.mWidth, gameObject.mHeight);
                VisualEngine.smPegCheckpoint.setAnimation(0, 1, false);
                smPlayerStartObject = gameObject2;
                gameObject.mTypeData = 1;
                if (GameEngine.getTutorialCompleted(512)) break;
                GameEngine.setTickerBoxText(117, false, -1);
                GameEngine.setTutorialCompleted(512);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                int n12 = Util.sqrtApproximate(smPlayerVelocityX, smPlayerVelocityY);
                if (n12 > 20480) {
                    if (n12 == 0) {
                        n12 = 1;
                    }
                    smPlayerVelocityX = smPlayerVelocityX * 20480 / n12;
                    smPlayerVelocityY = smPlayerVelocityY * 20480 / n12;
                }
            }
            case 3: 
            case 98: 
            case 99: {
                int n;
                int n3;
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                smPlayerBumperBouncesInARow = 0;
                if (gameObject.mType == 99 || gameObject.mType == 98) {
                    if (!GameEngine.getTutorialCompleted(8)) {
                        GameEngine.setTickerBoxText(111, false, -1);
                        GameEngine.setTutorialCompleted(8);
                    }
                    if (smPlayerState == 0) {
                        gameObject.getBoundingBox();
                        n12 = GameObject.smBoundingBoxX;
                        n11 = GameObject.smBoundingBoxY;
                        n10 = GameObject.smBoundingBoxW;
                        n9 = GameObject.smBoundingBoxH;
                        gameObject.mLifeTimer = 0;
                        gameObject.mTypeData -= 3;
                        ParticleSystem.startBananaBoxShakeFx(n12, n11, n10, n9);
                        if (gameObject.mTypeData <= 0) {
                            gameObject.setBoolean(8, true);
                            ParticleSystem.startBananaBoxBrakeFx(n12, n11, n10, n9);
                            if (gameObject.mType == 99) {
                                for (n8 = 0; n8 < 5; ++n8) {
                                    n7 = n12 + Util.getRandom(n10);
                                    n6 = n11 + Util.getRandom(n9);
                                    GameObject gameObject3 = ObjectManager.addObject((byte)100, n7 - 16, n6 - 16);
                                    gameObject3.mWidth = 32;
                                    gameObject3.mHeight = 32;
                                    gameObject3.mTypeData = 256;
                                    gameObject3.setBoolean(8, true);
                                }
                            }
                            GameEngine.addAchievement(10, 1);
                            GameEngine.vibrate(125);
                        } else {
                            GameEngine.vibrate(75);
                        }
                    }
                }
                if (gameObject.getBoolean(4) && smPlayerOldY >> 8 > GameObject.smBoundingBoxY - 12) break;
                n12 = smPlayerOldCollisionX >> 8;
                n11 = smPlayerOldCollisionY >> 8;
                n10 = smPlayerCollisionX >> 8;
                n9 = smPlayerCollisionY >> 8;
                for (n5 = 0; n5 < 5; ++n5) {
                    n8 = Util.rectangleCollision(n12 + (n10 - n12 >> 1) - 12, n11 + (n9 - n11 >> 1) - 12, 24, 24, GameObject.smBoundingBoxX, GameObject.smBoundingBoxY, GameObject.smBoundingBoxW, GameObject.smBoundingBoxH) ? 1 : 0;
                    if (n8 != 0) {
                        n10 = n12 + (n10 - n12 >> 1);
                        n9 = n11 + (n9 - n11 >> 1);
                        continue;
                    }
                    n12 += n10 - n12 >> 1;
                    n11 += n9 - n11 >> 1;
                }
                smPlayerCollisionX = n12 << 8;
                smPlayerCollisionY = n11 << 8;
                smPlayerX = n12 << 8;
                smPlayerY = n11 << 8;
                n5 = GameObject.smBoundingBoxW >> 1;
                n8 = GameObject.smBoundingBoxH >> 1;
                n7 = (smPlayerX >> 8) - (GameObject.smBoundingBoxX + n5);
                n6 = (smPlayerY >> 8) - (GameObject.smBoundingBoxY + n8);
                boolean bl = Math.abs(n7) < n5;
                boolean bl2 = Math.abs(n6) < n8;
                boolean bl3 = bl & bl2;
                int n13 = n7;
                int n14 = n6;
                if (!bl || bl3) {
                    n13 = n5 * (n7 < 0 ? -1 : 1);
                }
                if (!bl2 || bl3) {
                    n14 = n8 * (n6 < 0 ? -1 : 1);
                }
                if ((n4 = Util.sqrtApproximate(n3 = (smPlayerX >> 8) - (n13 += GameObject.smBoundingBoxX + n5), n = (smPlayerY >> 8) - (n14 += GameObject.smBoundingBoxY + n8))) == 0) {
                    n4 = 1;
                }
                if ((n3 = (n3 << 8) / n4) * smPlayerVelocityX + (n = (n << 8) / n4) * smPlayerVelocityY > 0) break;
                int n15 = gameObject.mElasticity;
                if (by == 3 && smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(n13, n14, n3, n);
                }
                GameEngine.resolveCollisionReflection(n15, n3, n);
                break;
            }
            case 60: 
            case 61: {
                gameObject.mLifeTimer = 0;
                break;
            }
            case 65: 
            case 66: {
                if (by == 66 && smSharkState == 3) {
                    return;
                }
                GameEngine.playerHitLethalBlock();
                break;
            }
            case 68: 
            case 69: {
                GameEngine.playerHitLethalBlock();
                break;
            }
            case 2: {
                int n;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                if (++smPlayerBumperBouncesInARow >= 5) {
                    GameEngine.addAchievement(3, 1);
                }
                if ((n20 = (n19 = smPlayerOldX >> 8) - (n18 = gameObject.mPosX >> 8)) * smPlayerVelocityX + (n17 = (n16 = smPlayerOldY >> 8) - (n = gameObject.mPosY >> 8)) * smPlayerVelocityY > 0) break;
                int n21 = Util.sqrtApproximate(n20, n17);
                if (n21 == 0) {
                    n21 = 1;
                }
                n20 = (n20 << 8) / n21;
                n17 = (n17 << 8) / n21;
                int n22 = gameObject.mRadius + 12 + 2;
                smPlayerX = gameObject.mPosX + n20 * n22;
                smPlayerY = gameObject.mPosY + n17 * n22;
                if (by == 2 && smPlayerState == 0) {
                    ParticleSystem.startCollisionParticleFx(gameObject.mPosX + n20 * gameObject.mRadius >> 8, gameObject.mPosY + n17 * gameObject.mRadius >> 8, n20, n17);
                }
                gameObject.mLifeTimer = 0;
                gameObject.mTypeData = n20 + 256 << 16 | n17 + 256;
                GameEngine.resolveCollisionReflection(gameObject.mElasticity, n20, n17);
                break;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: {
                int n;
                int n23;
                gameObject.setBoolean(8, true);
                GameEngine.vibrate(50);
                if (!smBackgroundIsDrawn) {
                    smPlayerCollectedBananasJump = (byte)(smPlayerCollectedBananasJump + 1);
                }
                int n24 = by - 100;
                if (!smBackgroundIsDrawn) {
                    GameEngine.addAchievement(0 + n24, 1);
                }
                ++smFruitsCollectedNoDelay;
                if (smPowerupCollected == 34 && ++smPlayerBananasInARowNoGravity >= 25) {
                    GameEngine.addAchievement(4, 1);
                }
                int n25 = 16;
                if (!smBackgroundIsDrawn) {
                    n23 = ((gameObject.mPosX >> 8) + n25) * 96 >> 7;
                    n = ((gameObject.mPosY >> 8) + n25) * 96 >> 7;
                    ParticleSystem.startFruitFx(n23 - VisualEngine.smCameraX, n - VisualEngine.smCameraY, n24);
                }
                ParticleSystem.addScalingStarFx((gameObject.mPosX >> 8) + (gameObject.mWidth >> 1), (gameObject.mPosY >> 8) + (gameObject.mHeight >> 1), 1);
                ParticleSystem.startFruitCollectedFx((gameObject.mPosX >> 8) + (gameObject.mWidth >> 1), (gameObject.mPosY >> 8) + (gameObject.mHeight >> 1));
                if (!smBackgroundIsDrawn && (smPlayerCollectedBananasJump & 1) == 0) {
                    ParticleSystem.addComboNumberFx((gameObject.mPosX >> 8) + (gameObject.mWidth >> 1), (gameObject.mPosY >> 8) + (gameObject.mHeight >> 1), smPlayerCollectedBananasJump);
                    if (smHighestCombo < smPlayerCollectedBananasJump) {
                        smHighestCombo = smPlayerCollectedBananasJump;
                    }
                }
                if (smQuickGame) {
                    smQuickGameTimeLeft += GameEngine.getTimeForBanana();
                    smQuickGameTimeLeft = Math.min(smQuickGameTimeLeft, smQuickGameTimeLimit);
                    if (smFruitsCollectedNoDelay + 6 > smQuickGameGoal && smQuickGameFiveToGoTimer == 0) {
                        smQuickGameFiveToGoTimer = 1;
                    }
                }
                if (!smBackgroundIsDrawn) break;
                do {
                    n23 = 40 + Util.getRandom() % (VisualEngine.smScreenWidth - 40 - 40);
                    n = 40 + Util.getRandom() % (VisualEngine.smScreenHeight - 40 - 40);
                    n23 = (n23 << 7) / 96;
                    n = (n << 7) / 96;
                } while (Math.abs(n23 - (gameObject.mPosX >> 8)) < 50 && Math.abs(n - (gameObject.mPosY >> 8)) < 50);
                gameObject.mPosX = n23 << 8;
                gameObject.mPosY = n << 8;
                gameObject.mType = (byte)(100 + smTimer % 5);
                gameObject.setBoolean(8, false);
                break;
            }
            case 11: {
                int n = gameObject.mTypeData;
                if (n == 0) break;
                if (n == 3) {
                    smPlayerFanFieldY += 6400;
                    break;
                }
                if (n == 1) {
                    smPlayerFanFieldY -= 6400;
                    break;
                }
                if (n == 2) {
                    smPlayerFanFieldX += 6400;
                    break;
                }
                if (n != 4) break;
                smPlayerFanFieldX -= 6400;
                break;
            }
            case 36: {
                GameEngine.vibrate(75);
                gameObject.setBoolean(8, true);
                ++smBabyPandasCollected;
                ParticleSystem.startBabyPandaFx((gameObject.mPosX >> 8) + (gameObject.mWidth >> 1), (gameObject.mPosY >> 8) + (gameObject.mHeight >> 1));
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                gameObject.setBoolean(8, true);
                gameObject.mLifeTimer = 0;
                GameEngine.endPowerupHat();
                GameEngine.startPowerupEffect(by);
                int n = (gameObject.mPosX >> 8) + (gameObject.mWidth >> 1);
                int n26 = (gameObject.mPosY >> 8) + (gameObject.mHeight >> 1);
                ParticleSystem.startPowerupCollectedFx(n, n26);
                break;
            }
            case 63: {
                gameObject.setBoolean(8, true);
                if (GameEngine.getTutorialCompleted(256)) break;
                GameEngine.setTickerBoxText(116, true, -1);
                GameEngine.setTutorialCompleted(256);
            }
        }
    }

    public static final void startPowerupEffect(byte by) {
        smPowerupCollected = by;
        smPowerupData1 = 4;
        if (by == 34) {
            smPowerupData1 = 15000;
            if (!GameEngine.getTutorialCompleted(1)) {
                GameEngine.setTickerBoxText(108, false, -1);
                GameEngine.setTutorialCompleted(1);
            }
        }
        if (by == 32 && !GameEngine.getTutorialCompleted(4)) {
            GameEngine.setTickerBoxText(110, false, -1);
            GameEngine.setTutorialCompleted(4);
        }
        if (by == 33 && !GameEngine.getTutorialCompleted(2)) {
            GameEngine.setTickerBoxText(109, false, -1);
            GameEngine.setTutorialCompleted(2);
        }
    }

    public static final void resetTimer() {
        DChocMIDlet.getInstance().resetTimer();
        smPrevTime = System.currentTimeMillis();
    }

    public static final void startQuickGame() {
        smCurrentLevel = 0;
        smQuickGameStage = 1;
        smQuickGameHighscore = 0;
        smQuickGame = true;
        GameEngine.resetKeys();
        smUpdateSoftKeys = true;
        GameEngine.reset();
    }

    public static final void startLevelSelection() {
        GameEngine.resetKeys();
        smUpdateSoftKeys = true;
    }

    public static boolean areaLocked(int n) {
        if (n == 0) {
            return false;
        }
        return !smLevelUnlocked[GameEngine.getCurrentLevel(n - 1, 6)];
    }

    public static int getLastUnlockedLevel() {
        if (smLevelSelectionArea < 5) {
            for (int i = 9; i >= 0; --i) {
                if (!smLevelUnlocked[GameEngine.getCurrentLevel(smLevelSelectionArea, i)]) continue;
                return i;
            }
        }
        return 0;
    }

    public static int getLastUnlockedArea() {
        int n = 0;
        for (int i = 4; i >= 0; --i) {
            if (GameEngine.areaLocked(i)) continue;
            n = i;
            break;
        }
        return n;
    }

    public static final void updateLevelSelectionIcons(int n) {
        VisualEngine.smLevelSelYouAreHere.logicUpdate(n);
        block6: for (int i = 0; i < 4; ++i) {
            switch (i) {
                case 0: {
                    if (GameEngine.areaLocked(i + 1) || smLevelSelectionState == 2 && GameEngine.getLastUnlockedArea() == i + 1) {
                        VisualEngine.smMapArea02Locked.setAnimationFrame(0);
                        continue block6;
                    }
                    VisualEngine.smMapArea02Locked.setAnimationFrame(VisualEngine.smMapArea02Locked.getFrameCount() - 1);
                    continue block6;
                }
                case 1: {
                    if (GameEngine.areaLocked(i + 1) || smLevelSelectionState == 2 && GameEngine.getLastUnlockedArea() == i + 1) {
                        VisualEngine.smMapArea03Locked.setAnimationFrame(0);
                        continue block6;
                    }
                    VisualEngine.smMapArea03Locked.setAnimationFrame(VisualEngine.smMapArea03Locked.getFrameCount() - 1);
                    continue block6;
                }
                case 2: {
                    if (GameEngine.areaLocked(i + 1) || smLevelSelectionState == 2 && GameEngine.getLastUnlockedArea() == i + 1) {
                        VisualEngine.smMapArea04Locked.setAnimationFrame(0);
                        continue block6;
                    }
                    VisualEngine.smMapArea04Locked.setAnimationFrame(VisualEngine.smMapArea04Locked.getFrameCount() - 1);
                    continue block6;
                }
                case 3: {
                    if (GameEngine.areaLocked(i + 1) || smLevelSelectionState == 2 && GameEngine.getLastUnlockedArea() == i + 1) {
                        VisualEngine.smMapArea05Locked.setAnimationFrame(0);
                        continue block6;
                    }
                    VisualEngine.smMapArea05Locked.setAnimationFrame(VisualEngine.smMapArea05Locked.getFrameCount() - 1);
                }
            }
        }
    }

    public static final int updateLevelSelection(int n) {
        int n2;
        smLevelSelectionShakeTime = Math.max(smLevelSelectionShakeTime - n, 0);
        if (smUpdateSoftKeys) {
            Toolkit.removeAllSoftKeys();
            if (smLevelSelectionState == 1) {
                Toolkit.setSoftKey(0, 0);
                Toolkit.setSoftKey(5, 0);
            }
            if (smLevelSelectionState == 0) {
                Toolkit.setSoftKey(0, 0);
                Toolkit.setSoftKey(13, 0);
            }
            smUpdateSoftKeys = false;
        }
        int n3 = -1;
        if (smPressedSK != -1) {
            n3 = smPressedSK;
            GameEngine.resetKeys();
        }
        smTimer += n;
        VisualEngine.smScrollLeftAnimations.logicUpdate(n);
        VisualEngine.smScrollRightAnimations.logicUpdate(n);
        if (VisualEngine.smScrollLeftAnimations.isFinishedAnimation()) {
            VisualEngine.smScrollLeftAnimations.setAnimation(0, -1, true);
        }
        if (VisualEngine.smScrollRightAnimations.isFinishedAnimation()) {
            VisualEngine.smScrollRightAnimations.setAnimation(0, -1, true);
        }
        if (smCheatsEnabled && (smKeysHold & 0x20) != 0 && smLevelSelectionArea < 5) {
            smKeysHold &= 0xFFFFFFDF;
            for (n2 = 0; n2 < smLevelUnlocked.length; ++n2) {
                GameEngine.smLevelUnlocked[n2] = true;
            }
        }
        smLevelSelectionStateTimer += n;
        smLevelSelectionMoveAnimTimer += n;
        if (smLevelSelectionState == 0) {
            GameEngine.updateLevelSelectionIcons(n);
            if ((smKeys & 1) != 0) {
                VisualEngine.smScrollLeftAnimations.setAnimation(1, 1, false);
                smLevelSelectionAreaOld = smLevelSelectionArea--;
                if (smLevelSelectionArea < 0) {
                    smLevelSelectionArea = 5;
                }
                System.out.println("Are selected:" + smLevelSelectionArea);
                smLevelSelectionLevel = GameEngine.getLastUnlockedLevel();
                smLevelSelectionMoveAnimTimer = 0;
                smKeys &= 0xFFFFFFFE;
            }
            if ((smKeys & 2) != 0) {
                VisualEngine.smScrollRightAnimations.setAnimation(1, 1, false);
                smLevelSelectionAreaOld = smLevelSelectionArea++;
                if (smLevelSelectionArea > 5) {
                    smLevelSelectionArea = 0;
                }
                smLevelSelectionLevel = GameEngine.getLastUnlockedLevel();
                smLevelSelectionMoveAnimTimer = 0;
                smKeys &= 0xFFFFFFFD;
            }
            if ((smKeys & 0x10) != 0 || n3 == 0) {
                GameEngine.resetKeys();
                if (smLevelSelectionArea < 5) {
                    smUpdateSoftKeys = true;
                    smLevelSelectionStateTimer = 0;
                    smLevelSelectionState = 1;
                    VisualEngine.smLevelBackground = smLevelSelectionArea;
                } else {
                    return 3;
                }
            }
            if (n3 == 13) {
                return 2;
            }
        } else if (smLevelSelectionState == 1) {
            GameEngine.updateLevelSelectionIcons(n);
            if ((smKeys & 1) != 0) {
                VisualEngine.smScrollLeftAnimations.setAnimation(1, 1, false);
                --smLevelSelectionLevel;
                smKeys &= 0xFFFFFFFE;
            }
            if ((smKeys & 2) != 0) {
                VisualEngine.smScrollRightAnimations.setAnimation(1, 1, false);
                ++smLevelSelectionLevel;
                smKeys &= 0xFFFFFFFD;
            }
            if (smLevelSelectionLevel < 0) {
                smLevelSelectionLevel = 9;
            }
            if (smLevelSelectionLevel > 9) {
                smLevelSelectionLevel = 0;
            }
            if (n3 == 5) {
                smLevelSelectionAreaOld = smLevelSelectionArea;
                smLevelSelectionState = 3;
                smLevelSelectionStateTimer = 0;
                smUpdateSoftKeys = true;
                GameEngine.resetKeys();
            }
            if ((smKeys & 0x10) != 0 || n3 == 0) {
                int n4 = GameEngine.getCurrentLevel(smLevelSelectionArea, smLevelSelectionLevel);
                if (smLevelUnlocked[n4]) {
                    smCurrentLevel = n4;
                    smLevelSelectionState = 4;
                    VisualEngine.smLevelSelPressed.setAnimationFrame(0);
                    GameEngine.resetKeys();
                } else {
                    smLevelSelectionShakeTime = 256;
                    smLevelSelectionShakeId = smLevelSelectionLevel;
                }
                smKeys &= 0xFFFFFFEF;
            }
        }
        if (smLevelSelectionState == 4) {
            GameEngine.updateLevelSelectionIcons(n);
            VisualEngine.smLevelSelPressed.logicUpdate(n);
            if (VisualEngine.smLevelSelPressed.isFinishedAnimation()) {
                smLevelSelectionState = 1;
                GameEngine.resetKeys();
                return 1;
            }
        }
        if (smLevelSelectionState == 3) {
            GameEngine.updateLevelSelectionIcons(n);
            if (smLevelSelectionStateTimer > 500) {
                smUpdateSoftKeys = true;
                smLevelSelectionState = 0;
                smLevelSelectionStateTimer = 0;
                GameEngine.resetKeys();
            }
        }
        if (smLevelSelectionState == 2) {
            if (smLevelSelectionStateTimer > 2000) {
                smLevelSelectionState = 1;
                smLevelSelectionStateTimer = 0;
                smUpdateSoftKeys = true;
                GameEngine.resetKeys();
            } else if (smLevelSelectionStateTimer > 500) {
                n2 = GameEngine.getLastUnlockedArea();
                switch (n2) {
                    case 1: {
                        VisualEngine.smMapArea02Locked.logicUpdate(n);
                        break;
                    }
                    case 2: {
                        VisualEngine.smMapArea03Locked.logicUpdate(n);
                        break;
                    }
                    case 3: {
                        VisualEngine.smMapArea04Locked.logicUpdate(n);
                        break;
                    }
                    case 4: {
                        VisualEngine.smMapArea05Locked.logicUpdate(n);
                    }
                }
            } else {
                GameEngine.updateLevelSelectionIcons(n);
            }
        }
        return 0;
    }

    public static final void drawLevelSelection(Graphics graphics) {
        VisualEngine.drawLevelSelection(graphics);
    }

    public static int getStickyPowerupAngle() {
        int n = (smPlayerStateTimer >> 2) + 1;
        int n2 = Util.atan2(smPowerupData3, smPowerupData2);
        int n3 = n2 * 1024 >> 16;
        return n3 += Util.getSin(n) * 1024 / 4 >> 12;
    }

    public static void updateWater(int n) {
        if (smWaterStoppedTimer >= 1 && (smWaterStoppedTimer -= n) <= 0) {
            ObjectManager.setValvesLifeTimeZero();
            smWaterStoppedTimer = 0;
        }
        Math.max(smWaterStoppedTimer - n, 0);
        if (smWaterStoppedTimer == 0 && smWaterTimer >= 1 || smLevelHasShark) {
            smWaterTimer += n;
            int n2 = smPlayerY >> 8;
            int n3 = GameEngine.getWaterHeight();
            if (n2 > n3) {
                ParticleSystem.startWaterSplashFx(smPlayerX >> 8, n3 + 12);
                GameEngine.playerHitLethalBlock();
            }
        }
    }

    public static final int getWaterHeight() {
        if (smLevelHasShark) {
            int n = 0;
            if (smSharkTimer <= 25000) {
                n = smLevelHeight / 3;
            } else if (smSharkTimer > 25000 && smSharkTimer < 45000) {
                n = smLevelHeight / 3 - (smSharkTimer - 25000) * (smLevelHeight / 3) / 20000;
            } else if (smSharkTimer > 70000 && smSharkTimer < 100000) {
                int n2 = smSharkTimer - 70000;
                int n3 = 30000;
                n = Util.getSin(1024 * n2 / n3 >> 1) * (smLevelHeight / 3) >> 12;
            }
            return smLevelHeight - smLevelHeight * 20 / 100 - n;
        }
        if (smWaterTimer >= 1) {
            int n;
            int n4;
            int n5 = smWaterTimer * 100 / smWaterTimerGoal;
            if (smQuickGame) {
                int n6 = n5;
                int n7 = n5 + 1;
                n4 = smLevelHeight - smLevelHeight * n6 / 100;
                n = smLevelHeight - smLevelHeight * n7 / 100;
            } else {
                int n8 = n5 * n5;
                int n9 = (n5 + 1) * (n5 + 1);
                n4 = smLevelHeight - smLevelHeight * n8 / 10000;
                n = smLevelHeight - smLevelHeight * n9 / 10000;
            }
            int n10 = n5 * smWaterTimerGoal / 100;
            int n11 = (n5 + 1) * smWaterTimerGoal / 100;
            if (smWaterTimer <= n10) {
                return n4;
            }
            if (smWaterTimer >= n11) {
                return n;
            }
            return n4 + (n - n4) * (smWaterTimer - n10) / (n11 - n10);
        }
        return smLevelHeight;
    }

    public static final void resetShark() {
        smSharkState = 0;
        smSharkStateTimer = 15;
        smSharkTimer = 0;
        smSharkStateGoalTime = (1000 + Util.getRandom(1000)) / 33;
        smSharkMovingLeft = true;
        smStoredSharkTime = 0;
        smSharkStateHpLeft = 10;
        for (int i = 0; i < 10; ++i) {
            smSharkTeethsLeft |= 1 << i;
        }
    }

    public static final void updateShark(GameObject gameObject) {
        smSharkTimer += 33;
        ++smSharkStateTimer;
        ++smSharkSwallowedPegTimer;
        gameObject.mOldPosX = gameObject.mPosX;
        gameObject.mOldPosY = gameObject.mPosY;
        int n = GameEngine.getWaterHeight();
        gameObject.mPosY = n + gameObject.mRadius << 8;
        switch (smSharkState) {
            case 0: {
                gameObject.mPosX = gameObject.mPosX + ((smSharkMovingLeft ? -2 : 2) << 8);
                if (gameObject.mPosX >> 8 < 32 || gameObject.mPosX >> 8 > smLevelWidth - 64) {
                    gameObject.mPosX = Math.min(gameObject.mPosX >> 8, smLevelWidth - 64);
                    gameObject.mPosX = Math.max(gameObject.mPosX, 32);
                    gameObject.mPosX <<= 8;
                    smStoredSharkTime = smSharkStateGoalTime - smSharkStateTimer;
                    smSharkState = (byte)5;
                    smSharkStateGoalTime = 22;
                    break;
                }
                if (smSharkStateTimer <= smSharkStateGoalTime) break;
                smSharkStateTimer = 0;
                smSharkState = 1;
                smSharkStateGoalTime = 7;
                for (int i = 0; i < 3; ++i) {
                    ParticleSystem.startWaterSplashFx((gameObject.mPosX >> 8) + (i - 1) * 20, n);
                }
                break;
            }
            case 1: {
                if (smSharkStateTimer <= smSharkStateGoalTime) break;
                smSharkStateTimer = 0;
                smSharkState = (byte)2;
                smSharkStateGoalTime = (9000 + Util.getRandom(3000)) / 33;
                break;
            }
            case 3: {
                smSharkStateTimer += 2;
            }
            case 2: {
                gameObject.mPosY -= Util.getSin(smSharkStateTimer * 512 / smSharkStateGoalTime) * 120 >> 4;
                if (smSharkStateTimer > smSharkStateGoalTime) {
                    smSharkSwallowedPeg = null;
                    smSharkSwallowedPegTimer = 0;
                    smSharkState = 0;
                    smSharkStateTimer = 0;
                    smSharkStateGoalTime = (2000 + Util.getRandom(6000)) / 33;
                }
                if (smSharkSwallowedPeg != null && smSharkSwallowedPeg.getBoolean(32)) {
                    GameEngine.smSharkSwallowedPeg.mPosY += 1320;
                }
                if (smSharkState != 2) break;
                GameObject gameObject2 = null;
                gameObject2 = ObjectManager.collideObjectWithFallingPegs(gameObject, false);
                if (gameObject2 == null) break;
                smSharkSwallowedPeg = gameObject2;
                smSharkState = (byte)3;
                int n2 = 0;
                while (n2 < 2) {
                    int n3 = Util.getRandom() % 10;
                    int n4 = smSharkTeethsLeft & 1 << n3;
                    if (n4 == 0) continue;
                    smSharkTeethsLeft &= ~(1 << n3);
                    ParticleSystem.startSharkTeethFx(VisualEngine.getSharkTeethX(n3), VisualEngine.getSharkTeethY(n3), n3);
                    VisualEngine.startCameraShake(500);
                    GameEngine.vibrate(250);
                    ++n2;
                }
                break;
            }
            case 5: {
                gameObject.mPosY += gameObject.mRadius;
                if (smSharkStateTimer <= smSharkStateGoalTime) break;
                smSharkMovingLeft = !smSharkMovingLeft;
                smSharkStateGoalTime = smStoredSharkTime;
                smSharkState = 0;
                break;
            }
        }
    }

    public static final void resetGorilla() {
        smGorillaMoveTimer = 0;
        smGorillaIdleTimer = -5000;
        smGorillaMovingLeft = true;
        smGorillaSeenPlayer = false;
    }

    public static final void updateGorilla(GameObject gameObject) {
        if ((smGorillaIdleTimer -= 33) > 0) {
            return;
        }
        if ((smGorillaMoveTimer += 33) >= smGorillaMoveLeftRightTime << 1) {
            smGorillaMoveTimer = 0;
        }
        boolean bl = false;
        if (smGorillaMoveTimer >= smGorillaMoveLeftRightTime) {
            bl = true;
        }
        smGorillaMovingLeft = bl;
        int n = smGorillaMoveLeftRightTime;
        int n2 = smGorillaMoveTimer % n;
        if (bl) {
            gameObject.mPosX = smGorillaStartX + (smGorillaEndX - smGorillaStartX) * n2 / n << 8;
            gameObject.mPosY = smGorillaStartY + (smGorillaEndY - smGorillaStartY) * n2 / n << 8;
        } else {
            gameObject.mPosX = smGorillaEndX - (smGorillaEndX - smGorillaStartX) * n2 / n << 8;
            gameObject.mPosY = smGorillaEndY - (smGorillaEndY - smGorillaStartY) * n2 / n << 8;
        }
        if (smGorillaIdleTimer <= -5000 && Util.sqrtApproximate(smPlayerX - gameObject.mPosX >> 8, smPlayerY - gameObject.mPosY >> 8) < 130) {
            smGorillaIdleTimer = 2000;
            smGorillaSeenPlayer = true;
        }
    }

    public static final int getHippoTimeNow() {
        return (smHippoTimer << 12) / 75000;
    }

    public static final int getHippoTimer(int n) {
        if (n <= smHippoStartX) {
            return 0;
        }
        if (n >= smHippoEndX) {
            return 4095;
        }
        return (4096 * n - smHippoStartX) / (smHippoEndX - smHippoStartX);
    }

    public static final int getHippoX(int n) {
        int n2 = smHippoStartX + ((smHippoEndX - smHippoStartX) * n >> 12);
        return n2;
    }

    public static final int getHippoY(int n, int n2) {
        int n3 = smHippoStartY + ((smHippoEndY - smHippoStartY) * n >> 12);
        return n3 += Util.getSin(n2) >> 7;
    }

    public static final void resetHippo() {
        if (smHippoObject != null) {
            smHippoTimer = -1;
            for (int i = 0; i < 4; ++i) {
                if (smHippoPegs[i] == null) continue;
                smHippoPegs[i].setBoolean(8, false);
            }
            GameEngine.updateHippo(smHippoObject);
        }
    }

    public static final void updateHippo(GameObject gameObject) {
        if (smHippoTimer != -1) {
            smHippoTimer += 33;
        }
        int n = GameEngine.getHippoTimeNow();
        int n2 = 0;
        int n3 = 0;
        n2 = GameEngine.getHippoX(n);
        n3 = GameEngine.getHippoY(n, n2);
        gameObject.mPosX = n2 << 8;
        gameObject.mPosY = n3 << 8;
        for (int i = 0; i < 4; ++i) {
            GameEngine.smHippoPegs[i].mPosX = gameObject.mPosX + (Util.getCos((smHippoTimer >> 3) + 1024 * i / 4) * 60 >> 4);
            GameEngine.smHippoPegs[i].mPosY = gameObject.mPosY + (Util.getSin((smHippoTimer >> 3) + 1024 * i / 4) * 60 >> 4);
        }
    }

    public static final void saveGame() {
        if (smCheatsEnabled) {
            return;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            int n;
            dataOutputStream.writeInt(smFruitsStored);
            dataOutputStream.writeInt(smLevelSelectionArea);
            dataOutputStream.writeInt(smLevelSelectionLevel);
            dataOutputStream.writeByte(smPowerupStored);
            dataOutputStream.writeByte(smPowerupOpened);
            dataOutputStream.writeBoolean(smIntroShown);
            dataOutputStream.writeBoolean(smOutroShown);
            dataOutputStream.writeBoolean(smWardrobeIntroShown);
            for (n = 0; n < 5; ++n) {
                dataOutputStream.writeInt(smQuickGameRecordTable[n]);
            }
            for (n = 0; n < smLevelRanks.length; ++n) {
                dataOutputStream.writeByte(smLevelRanks[n]);
            }
            for (n = 0; n < smLevelUnlocked.length; ++n) {
                dataOutputStream.writeBoolean(smLevelUnlocked[n]);
            }
            for (n = 0; n < smAchievementStatistics.length; ++n) {
                dataOutputStream.writeInt(smAchievementStatistics[n]);
            }
            dataOutputStream.writeInt(smAchievementObjectTypes);
            dataOutputStream.writeInt(smTutorialsCompleted);
            for (n = 0; n < smLevelCompleteWithCrown.length; ++n) {
                dataOutputStream.writeBoolean(smLevelCompleteWithCrown[n]);
            }
            dataOutputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Toolkit.writeRecord("ApeRS", byteArrayOutputStream.toByteArray(), 0);
    }

    public static final void loadGame() {
        byte[] byArray = Toolkit.readRecord("ApeRS");
        if (byArray != null) {
            try {
                int n;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                smFruitsStored = dataInputStream.readInt();
                smLevelSelectionArea = dataInputStream.readInt();
                smLevelSelectionLevel = dataInputStream.readInt();
                smPowerupStored = dataInputStream.readByte();
                smPowerupOpened = dataInputStream.readByte();
                smPowerupOpened = (byte)(smPowerupOpened | 1);
                smIntroShown = dataInputStream.readBoolean();
                smOutroShown = dataInputStream.readBoolean();
                smWardrobeIntroShown = dataInputStream.readBoolean();
                for (n = 0; n < 5; ++n) {
                    GameEngine.smQuickGameRecordTable[n] = dataInputStream.readInt();
                }
                for (n = 0; n < smLevelRanks.length; ++n) {
                    GameEngine.smLevelRanks[n] = dataInputStream.readByte();
                }
                for (n = 0; n < smLevelUnlocked.length; ++n) {
                    GameEngine.smLevelUnlocked[n] = dataInputStream.readBoolean();
                }
                for (n = 0; n < smAchievementStatistics.length; ++n) {
                    GameEngine.smAchievementStatistics[n] = dataInputStream.readInt();
                }
                smAchievementObjectTypes = dataInputStream.readInt();
                smTutorialsCompleted = dataInputStream.readInt();
                for (n = 0; n < smLevelCompleteWithCrown.length; ++n) {
                    GameEngine.smLevelCompleteWithCrown[n] = dataInputStream.readBoolean();
                }
            }
            catch (IOException iOException) {}
        } else {
            GameEngine.resetRecords();
            GameEngine.saveGame();
        }
    }

    public static final void resetRecords() {
        int n;
        smLevelSelectionArea = 0;
        smLevelSelectionLevel = 0;
        smFruitsStored = 0;
        smPowerupStored = POWERUP_TYPE_NONE;
        smPowerupOpened = 0;
        smIntroShown = false;
        smOutroShown = false;
        smWardrobeIntroShown = false;
        for (n = 0; n < 5; ++n) {
            GameEngine.smQuickGameRecordTable[n] = 0;
        }
        for (n = 0; n < smLevelRanks.length; ++n) {
            GameEngine.smLevelRanks[n] = 0;
        }
        for (n = 0; n < smLevelUnlocked.length; ++n) {
            GameEngine.smLevelUnlocked[n] = false;
        }
        GameEngine.smLevelUnlocked[0] = true;
        for (n = 0; n < smAchievementStatistics.length; ++n) {
            GameEngine.smAchievementStatistics[n] = 0;
        }
        smAchievementObjectTypes = 0;
        smTutorialsCompleted = 0;
        for (n = 0; n < smLevelCompleteWithCrown.length; ++n) {
            GameEngine.smLevelCompleteWithCrown[n] = false;
        }
        GameEngine.saveGame();
    }

    public static final void resetPandas() {
        smPandaCount = 0;
    }

    public static final void updatePandas() {
        if (smPandaCount <= 0) {
            return;
        }
        int n = smPlayerX >> 8;
        int n2 = smPlayerY >> 8;
        for (int i = 0; i < smPandaCount; ++i) {
            int n3 = i * 4;
            int n4 = smPandaData[n3 + 0];
            int n5 = smPandaData[n3 + 1];
            int n6 = n4 >> 8;
            int n7 = n5 >> 8;
            int n8 = n - n6;
            int n9 = n2 - n7;
            int n10 = n3 + 2;
            smPandaData[n10] = smPandaData[n10] - (n8 << 4);
            int n11 = n3 + 3;
            smPandaData[n11] = smPandaData[n11] - (n9 << 4);
            int n12 = n3 + 0;
            smPandaData[n12] = smPandaData[n12] + ((smPandaData[n3 + 0] - smPandaData[n3 + 2]) * 75 >> 7);
            int n13 = n3 + 1;
            smPandaData[n13] = smPandaData[n13] + ((smPandaData[n3 + 1] - smPandaData[n3 + 3]) * 75 >> 7);
            GameEngine.smPandaData[n3 + 2] = n4;
            GameEngine.smPandaData[n3 + 3] = n5;
            n = smPandaData[n3 + 0] >> 8;
            n2 = smPandaData[n3 + 1] >> 8;
        }
    }

    public static final void loadLevelSelection(int n) {
        if (n >= 0 && n <= 7) {
            VisualEngine.loadLevelSelectionSprites(n);
        } else {
            VisualEngine.loadShopSprites(n - 8);
        }
        smUpdateSoftKeys = true;
    }

    public static final int getCurrentLevel(int n, int n2) {
        return n * 10 + n2;
    }

    public static final int getTimeForBanana() {
        return 1500;
    }

    public static final void vibrate(int n) {
    }

    private static final int getNextPendingAchievement(int n) {
        for (int i = n + 1; i < 20; ++i) {
            if ((smAchievementsPending & 1 << i) == 0) continue;
            return i;
        }
        return -1;
    }

    private static final void updateAchievementTexts() {
        smAchievementAnimTimer = 250;
        int n = smPostGameVisibleAchievement;
        GameEngine.updateAchievementsScreenItems(n, false);
    }

    private static final void updateAchievement(int n) {
        if (smAchievementIconVisibleTimer > 0) {
            smAchievementIconVisibleTimer -= n;
        }
    }

    private static void addObjectTypeToAchievements(int n) {
        if (((smAchievementObjectTypes |= n) & 1) != 0 && (smAchievementObjectTypes & 2) != 0 && (smAchievementObjectTypes & 4) != 0 && (smAchievementObjectTypes & 8) != 0) {
            GameEngine.addAchievement(19, 1);
        }
    }

    public static final void addAchievement(int n, int n2) {
        if (ACHIEVEMENT_GOAL_COUNTS[n] > 0 && smAchievementStatistics[n] < ACHIEVEMENT_GOAL_COUNTS[n]) {
            int n3 = n;
            smAchievementStatistics[n3] = smAchievementStatistics[n3] + n2;
            if (smAchievementStatistics[n] >= ACHIEVEMENT_GOAL_COUNTS[n] && smAchievementStatistics[n] - n2 < ACHIEVEMENT_GOAL_COUNTS[n]) {
                if (n != 8 && n != 6 && n != 5 && n != 7 && n != 15 && n != 16 && n != 17 && n != 18) {
                    smAchievementIconVisibleTimer = 2500;
                    smUnlockedAchievementName = Toolkit.getText(ACHIEVEMENT_TEXT_IDS[n]);
                }
                smAchievementsPending |= 1 << n;
            }
        }
    }

    public static final int updateAchievementsScreen(int n) {
        if (smUpdateSoftKeys) {
            Toolkit.removeAllSoftKeys();
            smCurrentAchievement = 0;
            Toolkit.setSoftKey(5, 0);
            GameEngine.resetKeys();
            smUpdateSoftKeys = false;
        }
        smAchievementTravelTime = Math.max(0, smAchievementTravelTime - n);
        if (smAchievementTitleTicker != null) {
            smAchievementTitleTicker.updateTickerBox(n);
        }
        if (smPressedSK != -1) {
            int n2;
            smLastSoftkeySK = n2 = smPressedSK;
            GameEngine.resetKeys();
            if (smLastSoftkeySK == 5) {
                return 3;
            }
        }
        MenuObject.smScrollLeftAnimations.logicUpdate(n);
        if (MenuObject.smScrollLeftAnimations.isFinishedAnimation()) {
            MenuObject.smScrollLeftAnimations.setAnimation(0, -1, true);
        }
        MenuObject.smScrollRightAnimations.logicUpdate(n);
        if (MenuObject.smScrollRightAnimations.isFinishedAnimation()) {
            MenuObject.smScrollRightAnimations.setAnimation(0, -1, true);
        }
        smStateTime += n;
        smTextBox.logicUpdate(n);
        if ((smKeys & 1) != 0) {
            GameEngine.travelAchievementsScreen(true);
            smKeys &= 0xFFFFFFFE;
        }
        if ((smKeys & 2) != 0) {
            GameEngine.travelAchievementsScreen(false);
            smKeys &= 0xFFFFFFFD;
        }
        return 0;
    }

    public static final void drawAchievementsScreen(Graphics graphics) {
        int n;
        int n2 = Util.getSin(smAchievementTravelTime * 1024 >> 8) * 4 >> 12;
        int n3 = VisualEngine.smAchievementMenuBottomLeft.getHeight();
        int n4 = (VisualEngine.smScreenHeight >> 1) - n3;
        int n5 = smTextboxWidth;
        int n6 = smTextboxHeight;
        int n7 = (VisualEngine.smScreenWidth - n5 >> 1) + n2;
        int n8 = n4 - (n6 >> 1);
        VisualEngine.drawTextBoxBackground(graphics, (VisualEngine.smScreenWidth >> 1) + n2, n8 + (n6 >> 1), smTextboxWidth, n6, VisualEngine.smAchievementTextBox, 0xBFF5FF);
        n5 = smTextboxWidth;
        n7 = VisualEngine.smScreenWidth - n5 >> 1;
        smTextBox.doDraw(graphics, n7 + n2, n8);
        int n9 = (VisualEngine.smScreenHeight >> 1) + (smTextboxHeight >> 1);
        int n10 = VisualEngine.smScreenHeight - Toolkit.getSoftKeyAreaHeight();
        n6 = smTextImageFont.getHeight();
        n4 = n9 + (n10 - n9 >> 1);
        n5 = smTextboxWidth;
        n7 = VisualEngine.smScreenWidth - n5 >> 1;
        n8 = n4 - (n6 >> 1);
        int n11 = (VisualEngine.smScreenWidth >> 1) + n2 - (n5 >> 1);
        int n12 = VisualEngine.smAchievementMenuBottomCenter.getWidth();
        for (n = 0; n < n5; n += n12) {
            VisualEngine.smAchievementMenuBottomCenter.draw(graphics, n11 + n, n8 + (n6 >> 1));
        }
        VisualEngine.smAchievementMenuBottomLeft.draw(graphics, n11, n8 + (n6 >> 1));
        VisualEngine.smAchievementMenuBottomRight.draw(graphics, n11 + n5, n8 + (n6 >> 1));
        n = MenuObject.smScrollLeftAnimations.getWidth() >> 1;
        n4 = VisualEngine.smScreenHeight >> 1;
        int n13 = VisualEngine.smScreenWidth;
        if (smCurrentAchievement > 0) {
            MenuObject.smScrollLeftAnimations.draw(graphics, n, n4);
        }
        if (smCurrentAchievement < 19) {
            MenuObject.smScrollRightAnimations.draw(graphics, n13 - n, n4);
        }
        n = VisualEngine.smAchievementItemDots.getWidth();
        n13 = n * 20;
        int n14 = (VisualEngine.smScreenWidth >> 1) - (n13 >> 1) + n2 + (n >> 1);
        int n15 = n8 + (n6 >> 1);
        for (int i = 0; i < 20; ++i) {
            if (smAchievementStatistics[i] >= ACHIEVEMENT_GOAL_COUNTS[i]) {
                VisualEngine.smAchievementItemDots.setAnimationFrame(1);
            } else {
                VisualEngine.smAchievementItemDots.setAnimationFrame(0);
            }
            VisualEngine.smAchievementItemDots.draw(graphics, n14, n15);
            if (i == smCurrentAchievement) {
                VisualEngine.smAchievementItemDots.setAnimationFrame(2);
                VisualEngine.smAchievementItemDots.draw(graphics, n14, n15);
            }
            n14 += n;
        }
    }

    public static final void loadAchievementScreen(int n) {
        if (n == 0) {
            smAchievementTitleTicker = new Ticker();
            smAchievementTexts = new String[ACHIEVEMENT_TEXT_IDS.length];
            for (int i = 0; i < ACHIEVEMENT_TEXT_IDS.length; ++i) {
                GameEngine.smAchievementTexts[i] = Toolkit.getText(ACHIEVEMENT_TEXT_IDS[i]);
            }
            smAchievementTitleTicker.initTicker();
            smAchievementTitleTicker.setBoundOffset(0);
            smAchievementTitleTicker.setTickerText("");
            VisualEngine.loadAchievementSprites();
            smCurrentAchievement = 0;
            GameEngine.updateAchievementsScreenItems(smCurrentAchievement, true);
        }
    }

    public static final void updateAchievementsScreenItems(int n, boolean bl) {
        smTextBox = new MenuObject();
        smTextBox.setScreen(1, 10, 3);
        smTextBox.setStyle(2);
        int n2 = 0;
        if (bl) {
            smTextBox.setItem(++n2, 1, Toolkit.getText(49), null, -1);
            smTextBox.setItemDvc(++n2, 1, null, VisualEngine.smAchievementLineOrnament1, -1);
        } else {
            smTextBox.setItem(++n2, 1, Toolkit.getText(51), null, -1);
        }
        String string = smAchievementTexts == null ? Toolkit.getText(ACHIEVEMENT_TEXT_IDS[n]) : smAchievementTexts[n];
        smTextBox.setItem(++n2, 1, string, null, -1);
        String[] stringArray = new String[]{"" + ACHIEVEMENT_GOAL_COUNTS[n], "" + Math.min(ACHIEVEMENT_GOAL_COUNTS[n], smAchievementStatistics[n])};
        string = smAchievementTexts == null ? Toolkit.getText(ACHIEVEMENT_TEXT_IDS[20 + n]) : smAchievementTexts[20 + n];
        String string2 = Toolkit.replaceParameters(string, stringArray);
        smTextBox.setItem(++n2, 1, string2, null, -1);
        smTextBox.setImageFonts(smTextImageFont, smTextImageFont, smSelectionImageFont);
        smTextboxWidth = VisualEngine.smScreenWidth - MenuObject.smScrollLeftAnimations.getWidth() * 4;
        smTextboxWidth = Math.min(smTextboxWidth, VisualEngine.smScreenWidth * 80 / 100);
        smTextboxHeight = bl ? VisualEngine.smScreenHeight * 65 / 100 : VisualEngine.smScreenHeight * 75 / 100;
        smTextBox.setSize(smTextboxWidth, smTextboxHeight);
    }

    public static final int getAchievementLoadingStepCount() {
        return 100;
    }

    private static final void travelAchievementsScreen(boolean bl) {
        smAchievementTravelTime = 250;
        if ((smCurrentAchievement += bl ? -1 : 1) < 0) {
            smCurrentAchievement = 19;
        } else if (smCurrentAchievement >= 20) {
            smCurrentAchievement = 0;
        }
        GameEngine.updateAchievementsScreenItems(smCurrentAchievement, true);
        if (bl) {
            MenuObject.smScrollLeftAnimations.setAnimation(1, 1, true);
        } else {
            MenuObject.smScrollRightAnimations.setAnimation(1, 1, true);
        }
    }

    private static final void resetRobot() {
        smRobotHardStateTimer = 0;
        smRobotHardState = 1;
        smLevelHasHardBoss = false;
        smLevelHasEasyBoss = false;
        smHardBossPegLeft = 0;
        smRobotArmLeft = null;
        smRobotArmRight = null;
        smRobotHandState = 0;
        smRobotHandStateTimer = 0;
        smRobotHandStateGoalTime = 0;
        smRobotArmLeftWaypoint = 0;
        smRobotArmRightWaypoint = 0;
        smRobotHandIdleTimer = 2000;
        smRobotShootingTimer = 2500 + Util.getRandom(5000);
        smRobotShotTimes = 0;
        ObjectManager.removeObjectsByType(69);
    }

    private static final void restartRobot() {
        if (smRobotArmLeft != null && smRobotArmRight != null) {
            smRobotHandStateTimer = 0;
            smRobotHandStateGoalTime = 0;
            GameEngine.smRobotArmLeft.mPosX = -VisualEngine.smScreenWidth / 2 << 8;
            GameEngine.smRobotArmRight.mPosX = smLevelWidth + VisualEngine.smScreenWidth / 2 << 8;
            smRobotShotTimes = 0;
            smRobotHandIdleTimer = 1000;
            smRobotHardStateTimer = 0;
            smRobotHardState = 1;
            ObjectManager.removeObjectsByType(69);
        }
    }

    private static final void updateRobot(int n) {
        if (smRobotArmLeft != null) {
            int n2;
            int n3;
            if (smLevelHasHardBoss) {
                smRobotShootingTimer -= n;
                smHardRobotShakeTimer -= n;
                if (smRobotHardState == 0 && (smRobotHardStateTimer += n) > 7500) {
                    smRobotHardStateTimer = 0;
                    smRobotHardState = 1;
                }
            }
            if ((smRobotHandIdleTimer = Math.max(smRobotHandIdleTimer - n, 0)) == 0) {
                smRobotHandStateTimer += n;
            }
            if (smRobotHandStateTimer >= smRobotHandStateGoalTime) {
                GameObject gameObject;
                smRobotHandStateTimer = 0;
                smRobotHandStateGoalTime = smLevelHasHardBoss ? 3000 + Util.getRandom() % 2750 : 5700 + Util.getRandom() % 3000;
                if (++smRobotHandState == 4) {
                    smRobotHandState = 0;
                }
                int n4 = -VisualEngine.smScreenWidth / 2;
                n3 = smLevelWidth + VisualEngine.smScreenWidth / 2;
                if (ROBOT_LEFT_HAND[smRobotHandState]) {
                    if (smLevelHasHardBoss) {
                        gameObject = ObjectManager.getPegNearPoint(smPlayerX >> 8, Math.min(smLevelHeight * 3 / 4, smPlayerY >> 8));
                        if (gameObject != null) {
                            smRobotArmLeftTargetX = gameObject.mPosX >> 8;
                            smRobotArmLeftTargetY = gameObject.mPosY >> 8;
                        }
                    } else {
                        int n5 = Integer.MAX_VALUE;
                        for (n2 = 0; n2 < smRobotWaypointsLeft.length / 2; ++n2) {
                            if (n5 <= Math.abs(smRobotWaypointsLeft[n2 * 2 + 1] - (smPlayerY >> 8))) continue;
                            smRobotArmLeftWaypoint = n2;
                            n5 = Math.abs(smRobotWaypointsLeft[n2 * 2 + 1] - (smPlayerY >> 8));
                        }
                        smRobotArmLeftTargetX = smRobotWaypointsLeft[smRobotArmLeftWaypoint * 2];
                        smRobotArmLeftTargetY = smRobotWaypointsLeft[smRobotArmLeftWaypoint * 2 + 1];
                    }
                    smRobotLeftHandActionDone = false;
                    GameEngine.smRobotArmLeft.mStartPosX = n4;
                    GameEngine.smRobotArmLeft.mStartPosY = smRobotArmLeftTargetY;
                    GameEngine.smRobotArmLeft.mPosY = GameEngine.smRobotArmLeft.mStartPosY << 8;
                }
                if (ROBOT_RIGHT_HAND[smRobotHandState]) {
                    if (smLevelHasHardBoss) {
                        gameObject = ObjectManager.getPegNearPoint(smPlayerX >> 8, Math.min(smLevelHeight * 3 / 4, smPlayerY >> 8));
                        if (gameObject != null) {
                            smRobotArmRightTargetX = gameObject.mPosX >> 8;
                            smRobotArmRightTargetY = gameObject.mPosY >> 8;
                        }
                    } else {
                        int n6 = Integer.MAX_VALUE;
                        for (n2 = 0; n2 < smRobotWaypointsRight.length / 2; ++n2) {
                            if (n6 <= Math.abs(smRobotWaypointsRight[n2 * 2 + 1] - (smPlayerY >> 8))) continue;
                            smRobotArmRightWaypoint = n2;
                            n6 = Math.abs(smRobotWaypointsRight[n2 * 2 + 1] - (smPlayerY >> 8));
                        }
                        smRobotArmRightTargetX = smRobotWaypointsRight[smRobotArmRightWaypoint * 2];
                        smRobotArmRightTargetY = smRobotWaypointsRight[smRobotArmRightWaypoint * 2 + 1];
                    }
                    smRobotRightHandActionDone = false;
                    GameEngine.smRobotArmRight.mStartPosX = n3;
                    GameEngine.smRobotArmRight.mStartPosY = smRobotArmRightTargetY;
                    GameEngine.smRobotArmRight.mPosY = GameEngine.smRobotArmRight.mStartPosY << 8;
                }
            }
            if (smRobotHandStateTimer < 500) {
                int n7;
                n3 = smRobotHandStateTimer;
                int n8 = 500;
                if (ROBOT_LEFT_HAND[smRobotHandState]) {
                    n2 = Math.min(smRobotArmLeftTargetX, (VisualEngine.smCameraX << 7) / 96);
                    n7 = n2 - 50;
                    GameEngine.smRobotArmLeft.mPosX = n7 + (Util.getSin(n3 * 1024 / n8 >> 1) * (n2 - n7) >> 12) << 8;
                    GameEngine.smRobotArmLeft.mPosY = GameEngine.smRobotArmLeft.mStartPosY + (Util.getSin(smTimer * 3) * 7 >> 12) << 8;
                }
                if (ROBOT_RIGHT_HAND[smRobotHandState]) {
                    n2 = Math.max(smRobotArmRightTargetX, (VisualEngine.smCameraX + VisualEngine.smScreenWidth << 7) / 96);
                    n7 = n2 + 50;
                    GameEngine.smRobotArmRight.mPosX = n7 + (Util.getSin(n3 * 1024 / n8 >> 1) * (n2 - n7) >> 12) << 8;
                    GameEngine.smRobotArmRight.mPosY = GameEngine.smRobotArmRight.mStartPosY + (Util.getSin(smTimer * 3) * 7 >> 12) << 8;
                }
            } else {
                GameObject gameObject;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                n3 = smRobotHandStateTimer - 500;
                int n14 = smRobotHandStateGoalTime - 500;
                if (ROBOT_LEFT_HAND[smRobotHandState]) {
                    n2 = smRobotArmLeftTargetX;
                    n13 = GameEngine.smRobotArmLeft.mStartPosX;
                    GameEngine.smRobotArmLeft.mPosX = n13 + (Util.getSin(n3 * 1024 / n14 >> 1) * (n2 - n13) >> 12) << 8;
                    if (smLevelHasHardBoss && !smRobotLeftHandActionDone && n3 > n14 / 2) {
                        smHardRobotShakeTimer = 300;
                        smRobotLeftHandActionDone = true;
                        n12 = (GameEngine.smRobotArmLeft.mPosX >> 8) - 30;
                        n11 = (GameEngine.smRobotArmLeft.mPosY >> 8) - 30;
                        n10 = 60;
                        n9 = 60;
                        gameObject = ObjectManager.findPeg(n12, n11, n10, n9);
                        if (gameObject != null && gameObject.getBoolean(8192) && !gameObject.getBoolean(16384)) {
                            if (smRobotHardState == 0) {
                                ParticleSystem.startRobotPegFx(((gameObject.mPosX >> 8) * 96 >> 96 >> 7) - VisualEngine.smCameraX, ((gameObject.mPosY >> 8) * 96 >> 96 >> 7) - VisualEngine.smCameraY);
                                gameObject.setBoolean(16384, true);
                                smRobotHardStateTimer = 0;
                                smRobotHardState = 1;
                            }
                        } else if (gameObject != null && gameObject.getBoolean(32768)) {
                            smRobotHardState = 0;
                            smRobotHardStateTimer = 0;
                        }
                        if (ObjectManager.areAllBossPegsBroken()) {
                            GameEngine.changeGameState(1);
                        }
                    }
                }
                if (ROBOT_RIGHT_HAND[smRobotHandState]) {
                    n2 = smRobotArmRightTargetX;
                    n13 = GameEngine.smRobotArmRight.mStartPosX;
                    GameEngine.smRobotArmRight.mPosX = n13 + (Util.getSin(n3 * 1024 / n14 >> 1) * (n2 - n13) >> 12) << 8;
                    if (smLevelHasHardBoss && !smRobotRightHandActionDone && n3 > n14 / 2) {
                        smHardRobotShakeTimer = 300;
                        smRobotRightHandActionDone = true;
                        n12 = (GameEngine.smRobotArmRight.mPosX >> 8) - 30;
                        n11 = (GameEngine.smRobotArmRight.mPosY >> 8) - 30;
                        n10 = 60;
                        n9 = 60;
                        gameObject = ObjectManager.findPeg(n12, n11, n10, n9);
                        if (gameObject != null && gameObject.getBoolean(8192) && !gameObject.getBoolean(16384)) {
                            if (smRobotHardState == 0) {
                                ParticleSystem.startRobotPegFx(((gameObject.mPosX >> 8) * 96 >> 96 >> 7) - VisualEngine.smCameraX, ((gameObject.mPosY >> 8) * 96 >> 96 >> 7) - VisualEngine.smCameraY);
                                gameObject.setBoolean(16384, true);
                                smRobotHardStateTimer = 0;
                                smRobotHardState = 1;
                            }
                        } else if (gameObject != null && gameObject.getBoolean(32768)) {
                            smRobotHardState = 0;
                            smRobotHardStateTimer = 0;
                        }
                        if (ObjectManager.areAllBossPegsBroken()) {
                            GameEngine.changeGameState(1);
                        }
                    }
                }
            }
        }
    }

    public static final void robotShoots(int n, int n2, int n3, int n4) {
        n = (n << 7) / 96;
        n2 = (n2 << 7) / 96;
        n3 = (n3 << 7) / 96;
        n4 = (n4 << 7) / 96;
        GameObject gameObject = ObjectManager.addObject((byte)69, n, n2);
        if (gameObject != null) {
            gameObject.mCollisionType = 1;
            gameObject.mRadius = 16;
            gameObject.mStartPosX = gameObject.mPosX + (n3 << 8);
            gameObject.mStartPosY = gameObject.mPosY + (n4 << 8);
        }
    }

    public static final void closeTickerbox() {
        if (smTickerBoxState != 0 && smTickerBoxState != 3) {
            smTickerTextTimer = 0;
            smTickerBoxState = (byte)3;
            smTickerTimedClosing = false;
        }
    }

    public static final void setTickerBoxText(int n, boolean bl, int n2) {
        smTickerText = Toolkit.getText(n);
        smTickerTextTimer = 0;
        smTickerTimedClosing = bl;
        smTickerScrollingOffset = 0;
        smTickerScrollingLeft = false;
        smTickerScrollingTimer = 100;
        smTickerClosingTime = n2 == -1 ? 8500 : n2;
        if (smTickerText != null) {
            smTickerBoxState = 1;
            smTickerTextLength = smTextImageFont.stringWidth(smTickerText);
        } else {
            smTickerBoxState = 0;
        }
        smTutorialTimer = 0;
    }

    public static final void updateTickerBox(int n) {
        if (smTickerBoxState == 0) {
            return;
        }
        if (smTickerTimedClosing && (smTickerTextTimer += n) > smTickerClosingTime) {
            GameEngine.closeTickerbox();
        }
        int n2 = VisualEngine.smScreenWidth - smTickerTextLength - 8;
        if (smTickerTextLength - VisualEngine.smScreenWidth <= 0) {
            smTickerScrollingOffset = VisualEngine.smScreenWidth - smTickerTextLength >> 1;
            smTickerScrollingOffset = Math.max(1, smTickerScrollingOffset);
        } else {
            smTickerScrollingTimer -= n;
            while (smTickerScrollingTimer < 0) {
                if ((smTickerScrollingOffset += (smTickerScrollingLeft ? -1 : 1) * 2) > 8) {
                    smTickerScrollingOffset = 8;
                    smTickerScrollingTimer += 300;
                    smTickerScrollingLeft = true;
                } else if (smTickerScrollingOffset < n2) {
                    smTickerScrollingOffset = n2;
                    smTickerScrollingTimer += 300;
                    smTickerScrollingLeft = false;
                }
                smTickerScrollingTimer += 100;
            }
        }
        switch (smTickerBoxState) {
            case 2: {
                break;
            }
            case 1: {
                if (smTickerTextTimer <= 750) break;
                smTickerTextTimer = 0;
                smTickerBoxState = (byte)2;
                break;
            }
            case 3: {
                if (smTickerTextTimer <= 512) break;
                smTickerTextTimer = 0;
                smTickerBoxState = 0;
                smTickerText = null;
                smTickerTextLength = 0;
            }
        }
    }

    public static final void updateTickerTutorialLogic(int n) {
        if (smCurrentLevel == 0 && smKeyPressTimesLevel == 0 && !smQuickGame && !GameEngine.getTutorialCompleted(16)) {
            GameEngine.setTickerBoxText(112, false, -1);
            GameEngine.setTutorialCompleted(16);
        }
        if (smCurrentLevel == 9 && !smQuickGame && !GameEngine.getTutorialCompleted(4096)) {
            GameEngine.setTickerBoxText(120, true, 8500);
            GameEngine.setTutorialCompleted(4096);
        }
        if (smCurrentLevel == 19 && !smQuickGame && !GameEngine.getTutorialCompleted(1024)) {
            GameEngine.setTickerBoxText(118, true, 8500);
            GameEngine.setTutorialCompleted(1024);
        }
        if (smCurrentLevel == 29 && !smQuickGame && !GameEngine.getTutorialCompleted(2048)) {
            GameEngine.setTickerBoxText(119, true, 8500);
            GameEngine.setTutorialCompleted(2048);
        }
        if (smCurrentLevel == 39 && !smQuickGame && !GameEngine.getTutorialCompleted(16384)) {
            GameEngine.setTickerBoxText(122, true, 8500);
            GameEngine.setTutorialCompleted(16384);
        }
        if (smCurrentLevel == 49 && !smQuickGame && !GameEngine.getTutorialCompleted(8192)) {
            GameEngine.setTickerBoxText(121, true, 8500);
            GameEngine.setTutorialCompleted(8192);
        }
    }

    public static final void setTutorialCompleted(int n) {
        if ((smTutorialsCompleted & n) == 0) {
            smTutorialsCompletedThisLevel |= n;
        }
        smTutorialsCompleted |= n;
    }

    public static final boolean getTutorialCompleted(int n) {
        return (smTutorialsCompleted & n) != 0;
    }

    public static final void setWardrobeSoftkeys() {
        Toolkit.removeAllSoftKeys();
        if (smPowerupStored != Tuner.POWERUPS[smSelectedWardrobePowerup]) {
            if ((smPowerupOpened & 1 << smSelectedWardrobePowerup) != 0) {
                Toolkit.setSoftKey(39, 0);
            } else if (Tuner.POWERUPS[smSelectedWardrobePowerup] != 37) {
                Toolkit.setSoftKey(20, 0);
            }
        }
        Toolkit.setSoftKey(5, 0);
    }

    private static void resetShopScrolling() {
        for (int i = 0; i < VisualEngine.smShopTexts.length; ++i) {
            if (VisualEngine.smShopTexts[i] == null) continue;
            VisualEngine.smShopTexts[i].resetScrolling();
        }
    }

    public static final int updateWardrobe(int n) {
        MenuObject menuObject = VisualEngine.smShopTexts[smSelectedWardrobePowerup];
        menuObject.logicUpdate(n);
        if (smUpdateSoftKeys) {
            GameEngine.setWardrobeSoftkeys();
            smUpdateSoftKeys = false;
        }
        int n2 = -1;
        if (smPressedSK != -1) {
            n2 = smPressedSK;
            GameEngine.resetKeys();
            smLastSoftkeySK = n2;
            if (n2 == 20 || n2 == 39) {
                smKeys |= 0x10;
            }
            if (n2 == 5) {
                smSelectedWardrobePowerup = 0;
                GameEngine.resetShopScrolling();
                return 4;
            }
        }
        if (smCheatsEnabled && (smKeysHold & 0x20) != 0) {
            smFruitsStored += 100;
            smKeysHold &= 0xFFFFFFDF;
        }
        if ((smKeys & 1) != 0) {
            if (--smSelectedWardrobePowerup < 0) {
                smSelectedWardrobePowerup = Tuner.POWERUPS.length - 1;
            }
            smUpdateSoftKeys = true;
            smKeys &= 0xFFFFFFFE;
            VisualEngine.stopShopFlashing();
            GameEngine.resetShopScrolling();
            VisualEngine.smScrollLeftAnimations.setAnimation(1, 1, false);
        }
        VisualEngine.smScrollLeftAnimations.logicUpdate(n);
        if ((smKeys & 2) != 0) {
            if (++smSelectedWardrobePowerup >= Tuner.POWERUPS.length) {
                smSelectedWardrobePowerup = 0;
            }
            smUpdateSoftKeys = true;
            smKeys &= 0xFFFFFFFD;
            VisualEngine.stopShopFlashing();
            GameEngine.resetShopScrolling();
            VisualEngine.smScrollRightAnimations.setAnimation(1, 1, false);
        }
        VisualEngine.smScrollRightAnimations.logicUpdate(n);
        if (VisualEngine.smScrollLeftAnimations.isFinishedAnimation()) {
            VisualEngine.smScrollLeftAnimations.setAnimation(0, -1, true);
        }
        if (VisualEngine.smScrollRightAnimations.isFinishedAnimation()) {
            VisualEngine.smScrollRightAnimations.setAnimation(0, -1, true);
        }
        if ((smKeys & 0x10) != 0) {
            smUpdateSoftKeys = true;
            if ((smPowerupOpened & 1 << smSelectedWardrobePowerup) == 0 && (smSelectedWardrobePowerup != Tuner.POWERUPS.length - 1 || smOutroShown)) {
                if (smFruitsStored >= Tuner.POWERUP_PRICES[smSelectedWardrobePowerup]) {
                    smFruitsStored -= Tuner.POWERUP_PRICES[smSelectedWardrobePowerup];
                    smPowerupOpened = (byte)(smPowerupOpened | 1 << smSelectedWardrobePowerup);
                } else {
                    VisualEngine.startShopFlashing();
                }
            }
            if ((smPowerupOpened & 1 << smSelectedWardrobePowerup) != 0) {
                smPowerupStored = Tuner.POWERUPS[smSelectedWardrobePowerup];
            }
            GameEngine.saveGame();
            smKeys &= 0xFFFFFFEF;
        }
        return 0;
    }

    public static final void collectScoreObject(int n) {
        if (n == 28) {
            --smHardBossPegLeft;
        } else if (n == 14) {
            --smSharkStateHpLeft;
        } else {
            ++smChargeMeterCount;
            ++smFruitsCollected;
            if (smQuickGame) {
                if (++smQuickGameHighscore >= 250) {
                    GameEngine.addAchievement(12, 1);
                }
                if (smQuickGameHighscore >= 500) {
                    GameEngine.addAchievement(13, 1);
                }
                if (smQuickGameHighscore >= 1000) {
                    GameEngine.addAchievement(14, 1);
                }
            }
            if (smPowerupStored != POWERUP_TYPE_NONE && !smQuickGame && smChargeMeterCount >= 5) {
                smUpdateSoftKeys = true;
            }
        }
        VisualEngine.smHudShakeTimer = 512;
    }

    private static final void activateHatPowerup() {
        if (smPowerupCollected == 34) {
            ParticleSystem.startHatFx(VisualEngine.smMonkeyHeadX + VisualEngine.smCameraX, VisualEngine.smMonkeyHeadY + VisualEngine.smCameraY, 0);
        }
        smChargeMeterCount = 0;
        smUpdateSoftKeys = true;
        GameEngine.startPowerupEffect(smPowerupStored);
        int n = 0;
        if (smPowerupStored == 32) {
            n = 1;
        } else if (smPowerupStored == 33) {
            n = 2;
        }
        smPowerupHatWorn = n;
        int n2 = smPlayerX >> 8;
        int n3 = smPlayerY >> 8;
        ParticleSystem.startPowerupCollectedFx(n2, n3);
    }

    private static final void saveQuickGameScore(int n) {
        if (n > smQuickGameRecordTable[4]) {
            for (int i = 0; i < 5; ++i) {
                if (n <= smQuickGameRecordTable[i]) continue;
                for (int j = 4; j > i; --j) {
                    GameEngine.smQuickGameRecordTable[j] = smQuickGameRecordTable[j - 1];
                }
                GameEngine.smQuickGameRecordTable[i] = n;
                return;
            }
        }
    }

    private static final void endPowerupHat() {
        if (smPowerupHatWorn > 0) {
            ParticleSystem.startHatFx(VisualEngine.smMonkeyHeadX + VisualEngine.smCameraX, VisualEngine.smMonkeyHeadY + VisualEngine.smCameraY, smPowerupHatWorn);
        }
        smPowerupHatWorn = -1;
    }

    public static final boolean isPreGameCutScene() {
        return !smQuickGame && Tuner.DATA_CUTSCENE_LEVELS[smCurrentLevel * 2] != null && Tuner.DATA_CUTSCENE_LEVELS[smCurrentLevel * 2].length > 0;
    }

    public static final boolean allowPowerupHatUsage() {
        return smPowerupStored != POWERUP_TYPE_NONE && smPowerupStored != 37 && !smQuickGame && smChargeMeterCount >= 5;
    }

    public static void setImageFonts(ImageFont imageFont, ImageFont imageFont2, ImageFont imageFont3, ImageFont imageFont4) {
        smTitleBarImageFont = imageFont;
        smTextImageFont = imageFont2;
        smSelectionImageFont = imageFont3;
        smSimpleImageFont = imageFont4;
    }

    public void setLicenseManager(ILicenseManager iLicenseManager, boolean bl, int n) {
        this.mLicenseManager = iLicenseManager;
        this.mFreeTrialMode = bl;
        this.mDemoTimeLimit = n;
    }

    static {
        smDrawApeMenuBackground = true;
        smCheatsEnabled = false;
        smPowerupHatWorn = -1;
        smQuickGameRecordTable = new int[5];
        smPressedSK = -1;
        POWERUP_TYPE_NONE = (byte)-1;
        smLevelRanks = new byte[50];
        smLevelCompleteWithCrown = new boolean[50];
        smLevelUnlocked = new boolean[50];
        GameEngine.smLevelUnlocked[0] = true;
        smMoverLinks = new int[32];
        smFruitsStored = 0;
        smPlayerAngleVelocity = 25600;
        smRigidBodyItems = new int[30];
        RIGID_BODY_LOCATIONS = new int[]{0, 7, -4, 6, 4, 6, -3, -4, 3, -4};
        RIGID_BODY_LENGTHS = new int[]{30, 30, 24, 24, 13};
        smGorillaSeenPlayer = false;
        smHippoPegs = new GameObject[4];
        smPandaData = new int[40];
        ACHIEVEMENT_GOAL_COUNTS = new int[]{250, 1, 10, 1, 1, 1, 1, 1, 1, 50, 10, 3000, 1, 1, 1, 1, 1, 1, 1, 1};
        ACHIEVEMENT_TEXT_IDS = new int[]{72, 73, 74, 76, 75, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 71, 70, 69, 67, 68, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52};
        smAchievementStatistics = new int[20];
        smLastSoftkeySK = -1;
        ROBOT_LEFT_HAND = new boolean[]{true, true, true, false};
        ROBOT_RIGHT_HAND = new boolean[]{false, true, false, true};
    }
}

