/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class ParticleSystem {
    private static final int[][] STAR_FACES = new int[][]{{0, -16, 5, 0, -5, 0}, {-15, -6, 0, -6, 0, 6}, {15, -6, 0, -6, 0, 6}, {-10, 13, -3, -6, 6, 0}, {10, 13, 3, -6, -6, 0}};
    public static SpriteObject smComboNumbers;
    private static final int[][] EFFECT_DEFINITIONS;
    private static final int[] EFFECT_SPRITES;
    private static int[] smEffects;
    private static SpriteObject[] smEffectSprites;
    private static int smLastEffectPosition;

    public static final void initParticleSystem() {
        smEffects = new int[1050];
        smLastEffectPosition = 0;
        smComboNumbers = VisualEngine.loadSpriteObject(196681);
        smEffectSprites = new SpriteObject[32];
        for (int i = 0; i < 32; ++i) {
            if (EFFECT_SPRITES[i] == -1) continue;
            ParticleSystem.smEffectSprites[i] = VisualEngine.loadSpriteObject(EFFECT_SPRITES[i]);
            smEffectSprites[i].setAnimation(0, EFFECT_DEFINITIONS[i][1], false);
        }
    }

    public static final void resetEffects() {
        if (smEffects != null) {
            for (int i = 0; i < 1050; i += 7) {
                int n = smEffects[i + 0] & 0xFF;
                if (n == 3 || n == 4 || n == 5 || n == 6 || n == 7 || n == 14 || n == 28) {
                    ParticleSystem.scoreObjectEffectFinished(n);
                }
                for (int j = 0; j < 7; ++j) {
                    ParticleSystem.smEffects[i + j] = 0;
                }
            }
        }
    }

    public static final void updateEffects(int n) {
        boolean bl = false;
        for (int i = 0; i < 1050; i += 7) {
            int n2;
            int n3;
            int n4;
            int n5 = smEffects[i + 0] & 0xFF;
            if (n5 == 0) continue;
            int n6 = i + 5;
            smEffects[n6] = smEffects[n6] + n;
            if (smEffects[i + 5] > EFFECT_DEFINITIONS[n5][0]) {
                if (n5 == 3 || n5 == 4 || n5 == 5 || n5 == 6 || n5 == 7 || n5 == 14 || n5 == 28) {
                    ParticleSystem.scoreObjectEffectFinished(n5);
                }
                for (int j = 0; j < 7; ++j) {
                    ParticleSystem.smEffects[i + j] = 0;
                }
                continue;
            }
            if (n5 == 17 || n5 == 18 || n5 == 19 || n5 == 20 || n5 == 21) {
                int n7 = smEffects[i + 3] >> 16;
                n4 = smEffects[i + 4] >> 16;
                n3 = smEffects[i + 6] >> 16;
                n2 = smEffects[i + 6] & 0xFFFF;
                int n8 = Util.smoothStep(smEffects[i + 5], 0, 900);
                ParticleSystem.smEffects[i + 1] = n7 + ((n3 - n7) * n8 >> 10) << 16;
                ParticleSystem.smEffects[i + 2] = n4 + ((n2 - n4) * n8 >> 10) << 16;
                continue;
            }
            if (n5 == 3 || n5 == 4 || n5 == 5 || n5 == 6 || n5 == 7 || n5 == 14 || n5 == 28) {
                n4 = 10;
                n3 = 10;
                n2 = (smEffects[i + 5] << 12) / 1250;
                Util.smTemp[0] = smEffects[i + 3] + (Util.getSin(i + 1 << 7) >> 4);
                Util.smTemp[1] = smEffects[i + 3];
                Util.smTemp[2] = n4;
                Util.smTemp[3] = n4 - (Util.getSin(i + 213 << 12) >> 4);
                ParticleSystem.smEffects[i + 1] = Util.catmullRomSpline(n2);
                Util.smTemp[0] = smEffects[i + 4] + (Util.getSin(i + 7 << 7) >> 3);
                Util.smTemp[1] = smEffects[i + 4];
                Util.smTemp[2] = n3;
                Util.smTemp[3] = n3 - (Util.getSin(i + 9 << 8) >> 5);
                ParticleSystem.smEffects[i + 2] = Util.catmullRomSpline(n2);
                continue;
            }
            if (n5 == 1 || n5 == 10) {
                int n9 = i + 3;
                smEffects[n9] = smEffects[n9] - (smEffects[i + 3] * n >> 10);
                int n10 = i + 4;
                smEffects[n10] = smEffects[n10] - (smEffects[i + 4] * n >> 10);
            }
            if (n5 == 8) {
                int n11 = i + 2;
                smEffects[n11] = smEffects[n11] + n * 3000;
            }
            if (n5 == 29 || n5 == 30 || n5 == 31) {
                ParticleSystem.smEffects[i + 3] = smEffects[i + 3] * 127 >> 7;
                ParticleSystem.smEffects[i + 4] = smEffects[i + 4] * 127 >> 7;
                int n12 = i + 4;
                smEffects[n12] = smEffects[n12] + n * 3;
            }
            if (n5 == 23) {
                int n13 = i + 4;
                smEffects[n13] = smEffects[n13] + n * 6;
            }
            if (n5 == 15 || n5 == 16 || n5 == 22 || n5 == 25) {
                int n14 = i + 4;
                smEffects[n14] = smEffects[n14] + n * 3;
            }
            if (n5 == 11 || n5 == 24) {
                int n15 = i + 4;
                smEffects[n15] = smEffects[n15] + n * 24;
            }
            int n16 = i + 1;
            smEffects[n16] = smEffects[n16] + smEffects[i + 3] * n;
            int n17 = i + 2;
            smEffects[n17] = smEffects[n17] + smEffects[i + 4] * n;
        }
    }

    public static final void drawEffects(Graphics graphics) {
        int n = VisualEngine.smCameraX;
        int n2 = VisualEngine.smCameraY;
        for (int i = 0; i < 1050; i += 7) {
            int n3;
            int n4 = smEffects[i + 0] & 0xFF;
            if (n4 == 0) continue;
            int n5 = (smEffects[i + 1] >> 16) * 96 >> 7;
            int n6 = (smEffects[i + 2] >> 16) * 96 >> 7;
            n5 -= n;
            n6 -= n2;
            if (n4 == 3 || n4 == 4 || n4 == 5 || n4 == 6 || n4 == 7) {
                n5 = smEffects[i + 1];
                n6 = smEffects[i + 2];
            }
            if (n4 == 14 || n4 == 28) {
                n5 = smEffects[i + 1];
                n6 = smEffects[i + 2];
                smEffectSprites[n4].setAnimationFrame(smEffects[i + 6]);
                smEffectSprites[n4].draw(graphics, n5, n6);
                continue;
            }
            if (n4 == 1) {
                n3 = smEffectSprites[n4].getFrameCount() - 1;
                smEffectSprites[n4].setAnimationFrame(n3 - n3 * smEffects[i + 5] / EFFECT_DEFINITIONS[1][0]);
                smEffectSprites[n4].draw(graphics, n5, n6);
                continue;
            }
            if (n4 == 27) {
                ParticleSystem.drawComboNumbers(graphics, n5, n6, smEffects[i + 5], smEffects[i + 6]);
                continue;
            }
            if (n4 == 26) {
                graphics.setColor(0xFFFF80);
                int n7 = Util.getSin(smEffects[i + 5] * 1024 >> 11) * 255 >> 12;
                int n8 = GameEngine.smTimer;
                for (int j = 0; j < 5; ++j) {
                    VisualEngine.fillTriangle(graphics, n5 + (((Util.getCos(n8) * STAR_FACES[j][0] >> 12) + (Util.getSin(n8) * STAR_FACES[j][1] >> 12)) * n7 >> 8), n6 + ((-(Util.getSin(n8) * STAR_FACES[j][1] >> 12) + (Util.getCos(n8) * STAR_FACES[j][1] >> 12)) * n7 >> 8), n5 + (((Util.getCos(n8) * STAR_FACES[j][2] >> 12) + (Util.getSin(n8) * STAR_FACES[j][3] >> 12)) * n7 >> 8), n6 + ((-(Util.getSin(n8) * STAR_FACES[j][3] >> 12) + (Util.getCos(n8) * STAR_FACES[j][3] >> 12)) * n7 >> 8), n5 + (((Util.getCos(n8) * STAR_FACES[j][4] >> 12) + (Util.getSin(n8) * STAR_FACES[j][5] >> 12)) * n7 >> 8), n6 + ((-(Util.getSin(n8) * STAR_FACES[j][5] >> 12) + (Util.getCos(n8) * STAR_FACES[j][5] >> 12)) * n7 >> 8), 1);
                }
                continue;
            }
            if (n4 == 24) {
                n5 = smEffects[i + 1] >> 16;
                n6 = smEffects[i + 2] >> 16;
                n3 = smEffects[i + 6];
                smEffectSprites[n4].setAnimationFrame(n3);
                smEffectSprites[n4].draw(graphics, n5 -= n, n6 -= n2);
                continue;
            }
            if (n4 == 15 || n4 == 16 || n4 == 23 || n4 == 22 || n4 == 25) {
                if (n4 == 23) {
                    graphics.setColor(Util.lerpColors(1206451, 14086897, smEffects[i + 5] >> 1));
                    n5 = smEffects[i + 1] >> 16;
                    n6 = smEffects[i + 2] >> 16;
                    n3 = 2;
                    if (smEffects[i + 5] > 300) {
                        n3 = 1;
                    }
                    graphics.fillRect(n5, n6, n3, n3);
                } else if (n4 == 16) {
                    graphics.setColor(0xFFFFFF);
                } else if (n4 == 22) {
                    graphics.setColor(0);
                } else if (n4 == 25) {
                    graphics.setColor(11364159);
                } else {
                    graphics.setColor(13257304);
                }
                n3 = 2;
                if (smEffects[i + 5] > 850) {
                    n3 = 1;
                }
                graphics.fillRect(n5, n6, n3, n3);
                continue;
            }
            smEffectSprites[n4].setAnimationFrame(0);
            n3 = smEffects[i + 5];
            if (n4 != 9 && n3 > 0) {
                smEffectSprites[n4].logicUpdate(n3);
            }
            smEffectSprites[n4].draw(graphics, n5, n6);
        }
    }

    public static final int addEffects(int n, int n2, int n3, int n4) {
        int n5 = smEffects[smLastEffectPosition + 0];
        if (n5 == 3 || n5 == 4 || n5 == 5 || n5 == 6 || n5 == 7 || n5 == 14 || n5 == 28) {
            ParticleSystem.scoreObjectEffectFinished(n5);
        }
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 0] = n3;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 1] = n;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 2] = n2;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 3] = 0;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 4] = 0;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 5] = 1;
        ParticleSystem.smEffects[ParticleSystem.smLastEffectPosition + 6] = n4;
        int n6 = smLastEffectPosition;
        if ((smLastEffectPosition += 7) >= 1050) {
            smLastEffectPosition = 0;
        }
        return n6;
    }

    public static final void startCollisionParticleFx(int n, int n2, int n3, int n4) {
        if (GameEngine.smPlayerState == 4) {
            return;
        }
        n <<= 16;
        n2 <<= 16;
        int n5 = 6;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects(n + ((-5 + Util.getRandom(10)) * n3 << 8), n2 + ((-5 + Util.getRandom(10)) * n4 << 8), 1, 0);
            int n7 = Util.getRandom(100);
            int n8 = 15000 + n7 * 350;
            int n9 = n3;
            int n10 = -n4;
            if ((n5 & 1) == 0) {
                n9 = -n3;
                n10 = n4;
            }
            ParticleSystem.smEffects[n6 + 3] = n10 * n8 >> 12;
            ParticleSystem.smEffects[n6 + 4] = n9 * n8 >> 12;
            int n11 = n6 + 5;
            smEffects[n11] = smEffects[n11] + n7 * 3;
        }
    }

    public static final void startGorillaCollisionParticleFx(int n, int n2, int n3, int n4) {
        n <<= 16;
        n2 <<= 16;
        int n5 = 6;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects(n + ((-5 + Util.getRandom(10)) * n3 << 8), n2 + ((-5 + Util.getRandom(10)) * n4 << 8), 1, 0);
            int n7 = Util.getRandom(100);
            int n8 = 2000 + n7 * 500;
            int n9 = n3;
            int n10 = -n4;
            if ((n5 & 1) == 0) {
                n9 = -n3;
                n10 = n4;
            }
            ParticleSystem.smEffects[n6 + 3] = n10 * n8 >> 12;
            ParticleSystem.smEffects[n6 + 4] = n9 * n8 >> 12;
            int n11 = n6 + 5;
            smEffects[n11] = smEffects[n11] + n7 * 3;
        }
    }

    public static final void startCageBrokeFx(int n, int n2, int n3, int n4) {
        int n5 = 40;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects(n + Util.getRandom(n3) << 16, n2 + Util.getRandom(n4) << 16, 2, 0);
            int n7 = n6 + 5;
            smEffects[n7] = smEffects[n7] - Util.getRandom(800);
            int n8 = Util.getRandom(1024);
            int n9 = Util.getRandom(1500);
            ParticleSystem.smEffects[n6 + 3] = Util.getSin(n8) * n9 >> 12;
            ParticleSystem.smEffects[n6 + 4] = Util.getCos(n8) * n9 >> 12;
        }
    }

    public static final void startCageDroppedFx(int n, int n2, int n3, int n4) {
        n <<= 8;
        int n5 = 30;
        int n6 = (n3 << 8) / n5;
        while (--n5 >= 0) {
            int n7 = ParticleSystem.addEffects(n << 8, n2 + Util.getRandom(n4) << 16, 22, 0);
            int n8 = n7 + 5;
            smEffects[n8] = smEffects[n8] - Util.getRandom(800);
            int n9 = Util.getRandom(1024);
            int n10 = Util.getRandom(2500);
            ParticleSystem.smEffects[n7 + 3] = Util.getSin(n9) * n10 >> 12;
            ParticleSystem.smEffects[n7 + 4] = Util.getCos(n9) * n10 >> 12;
            n += n6;
        }
    }

    public static final void startSwitchFx(GameObject gameObject, int n, int n2) {
        int n3 = gameObject.mRadius >> 1;
        int n4 = gameObject.mRadius >> 1;
        int n5 = 10;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects((gameObject.mPosX << 8) + (n - n4 + Util.getRandom(n4 << 1) << 16), (gameObject.mPosY << 8) + (n2 - n3 + Util.getRandom(n3 << 1) << 16), 2, 0);
            int n7 = n6 + 5;
            smEffects[n7] = smEffects[n7] - Util.getRandom(350);
            int n8 = Util.getRandom(1024);
            int n9 = Util.getRandom(1000);
            ParticleSystem.smEffects[n6 + 3] = Util.getSin(n8) * n9 >> 12;
            ParticleSystem.smEffects[n6 + 4] = Util.getCos(n8) * n9 >> 12;
        }
    }

    public static final void startFruitDroppedFx(int n, int n2, int n3, int n4, int n5) {
        int n6 = ParticleSystem.addEffects(n << 8, n2 << 8, 17 + n3, 0);
        ParticleSystem.smEffects[n6 + 3] = smEffects[n6 + 1];
        ParticleSystem.smEffects[n6 + 4] = smEffects[n6 + 2];
        ParticleSystem.smEffects[n6 + 6] = n4 << 16 | n5;
    }

    public static final void startGoalFx(int n, int n2, int n3, int n4) {
        int n5 = n + Util.getRandom() % n3;
        int n6 = n2 + Util.getRandom() % n4;
        n5 <<= 16;
        n6 <<= 16;
        int n7 = 15;
        while (--n7 >= 0) {
            int n8 = ParticleSystem.addEffects(n5 + (Util.getRandom(8) - 4 << 16), n6 + (Util.getRandom(8) - 4 << 16), 29 + Util.getRandom(3), 0);
            ParticleSystem.smEffects[n8 + 3] = Util.getRandom(14000) - 7000;
            ParticleSystem.smEffects[n8 + 4] = Util.getRandom(14000) - 7000;
            int n9 = n8 + 5;
            smEffects[n9] = smEffects[n9] + Util.getRandom(650);
        }
    }

    public static final void startFruitCollectedFx(int n, int n2) {
        n <<= 16;
        n2 <<= 16;
        int n3 = 7;
        while (--n3 >= 0) {
            int n4 = ParticleSystem.addEffects(n + (Util.getRandom(8) - 4 << 16), n2 + (Util.getRandom(8) - 4 << 16), 12, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(5000) - 2500;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(5000) - 2500;
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(1250);
        }
    }

    public static final void startFruitFx(int n, int n2, int n3) {
        int n4 = ParticleSystem.addEffects(n, n2, 3 + n3, 0);
        ParticleSystem.smEffects[n4 + 3] = n;
        ParticleSystem.smEffects[n4 + 4] = n2;
    }

    public static final void startSharkTeethFx(int n, int n2, int n3) {
        int n4 = ParticleSystem.addEffects(n, n2, 14, 0);
        ParticleSystem.smEffects[n4 + 3] = n;
        ParticleSystem.smEffects[n4 + 4] = n2;
        ParticleSystem.smEffects[n4 + 6] = n3;
    }

    public static final void startRobotPegFx(int n, int n2) {
        int n3 = ParticleSystem.addEffects(n, n2, 28, 0);
        ParticleSystem.smEffects[n3 + 3] = n;
        ParticleSystem.smEffects[n3 + 4] = n2;
    }

    public static final void startGlueSurfaceFx(int n, int n2) {
        ParticleSystem.addEffects(n << 16, n2 << 16, 9, 0);
    }

    public static final void addGlueFx(int n, int n2) {
        ParticleSystem.addEffects(n << 16, n2 << 16, 8, 0);
    }

    public static final void addComboNumberFx(int n, int n2, int n3) {
        int n4 = ParticleSystem.addEffects(n << 16, n2 << 16, 27, 0);
        ParticleSystem.smEffects[n4 + 6] = n3;
    }

    public static final void addBeansFx(int n, int n2) {
        n <<= 16;
        n2 <<= 16;
        int n3 = 15;
        while (--n3 >= 0) {
            int n4 = ParticleSystem.addEffects(n + (Util.getRandom(32) - 16 << 16), n2 + (Util.getRandom(32) - 16 << 16), 13, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(2500) - 1250;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(2500) - 1250;
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(500);
        }
    }

    public static final void startPowerupCollectedFx(int n, int n2) {
        int n3;
        int n4;
        n <<= 16;
        n2 <<= 16;
        int n5 = 8;
        int n6 = Util.getRandom(1024);
        int n7 = 1024 / n5;
        while (--n5 >= 0) {
            n4 = ParticleSystem.addEffects(n, n2, 10, 0);
            n3 = 6000;
            ParticleSystem.smEffects[n4 + 3] = Util.getSin(n6) * n3 >> 12;
            ParticleSystem.smEffects[n4 + 4] = Util.getCos(n6) * n3 >> 12;
            int n8 = n4 + 5;
            smEffects[n8] = smEffects[n8] + (100 + Util.getRandom(150));
            n6 += n7;
        }
        n5 = 4;
        n6 += n7 >> 1;
        while (--n5 >= 0) {
            n4 = ParticleSystem.addEffects(n, n2, 10, 0);
            n3 = 2000;
            ParticleSystem.smEffects[n4 + 3] = Util.getSin(n6) * n3 >> 12;
            ParticleSystem.smEffects[n4 + 4] = Util.getCos(n6) * n3 >> 12;
            n6 += n7 << 1;
        }
    }

    public static final void addPowerupActiveFx(int n, int n2, int n3, int n4) {
        n <<= 16;
        n2 <<= 16;
        int n5 = 3;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects(n + (Util.getRandom(15) - 7 << 16), n2 + (Util.getRandom(15) - 7 << 16), 10, 0);
            ParticleSystem.smEffects[n6 + 3] = -n4;
            ParticleSystem.smEffects[n6 + 4] = -n3;
            int n7 = n6 + 5;
            smEffects[n7] = smEffects[n7] + (100 + Util.getRandom(150));
        }
    }

    public static final void startWaterSplashFx(int n, int n2) {
        n <<= 16;
        n2 <<= 16;
        int n3 = 8;
        while (--n3 >= 0) {
            int n4 = ParticleSystem.addEffects(n + (Util.getRandom(15) - 7 << 16), n2 + (Util.getRandom(15) - 7 << 16), 11, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(10000) - 5000;
            ParticleSystem.smEffects[n4 + 4] = -Math.abs(Util.getRandom(10000));
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(350);
        }
    }

    public static final void startFallingPegFx(int n, int n2) {
        n <<= 16;
        n2 <<= 16;
        int n3 = 3;
        while (--n3 >= 0) {
            int n4 = ParticleSystem.addEffects(n + (Util.getRandom(8) - 4 << 16), n2 + (Util.getRandom(8) - 4 << 16), 15, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(5000) - 2500;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(5000) - 2500;
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(400);
        }
    }

    public static final void startBabyPandaFx(int n, int n2) {
        n <<= 16;
        n2 <<= 16;
        int n3 = 12;
        while (--n3 >= 0) {
            int n4 = ParticleSystem.addEffects(n + (Util.getRandom(20) - 10 << 16), n2 + (Util.getRandom(20) - 10 << 16), 16, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(5000) - 2500;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(5000) - 2500;
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(400);
        }
    }

    public static final void addScalingStarFx(int n, int n2, int n3) {
        n <<= 16;
        n2 <<= 16;
        for (int i = 0; i < n3; ++i) {
            int n4 = ParticleSystem.addEffects(n, n2, 26, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(3000) - 1500;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(3000) - 1500;
            int n5 = n4 + 5;
            smEffects[n5] = smEffects[n5] + Util.getRandom(300);
        }
    }

    public static final void addHudFullFx(int n, int n2) {
        int n3 = ParticleSystem.addEffects(n <<= 16, n2 <<= 16, 23, 0);
        ParticleSystem.smEffects[n3 + 3] = Util.getRandom(8000) - 4000;
        ParticleSystem.smEffects[n3 + 4] = Util.getRandom(5000) - 2000;
        int n4 = n3 + 5;
        smEffects[n4] = smEffects[n4] + Util.getRandom(100);
    }

    public static final void startHatFx(int n, int n2, int n3) {
        int n4;
        n <<= 16;
        n2 <<= 16;
        int n5 = 10;
        while (--n5 >= 0) {
            n4 = ParticleSystem.addEffects(n + (Util.getRandom(8) - 4 << 16), n2 + (Util.getRandom(8) - 4 << 16), 15, 0);
            ParticleSystem.smEffects[n4 + 3] = Util.getRandom(5000) - 2500;
            ParticleSystem.smEffects[n4 + 4] = Util.getRandom(5000) - 2500;
            int n6 = n4 + 5;
            smEffects[n6] = smEffects[n6] + Util.getRandom(400);
        }
        n4 = ParticleSystem.addEffects(n, n2, 24, 0);
        ParticleSystem.smEffects[n4 + 3] = Util.getRandom(8000) - 4000;
        ParticleSystem.smEffects[n4 + 4] = -7500;
        ParticleSystem.smEffects[n4 + 6] = n3;
    }

    public static final void startBananaBoxBrakeFx(int n, int n2, int n3, int n4) {
        int n5 = 20;
        while (--n5 >= 0) {
            int n6 = ParticleSystem.addEffects((n << 16) + (Util.getRandom(n3) << 16), (n2 << 16) + (Util.getRandom(n4) << 16), 2, 0);
            int n7 = n6 + 5;
            smEffects[n7] = smEffects[n7] - Util.getRandom(350);
            int n8 = Util.getRandom(1024);
            int n9 = Util.getRandom(1000);
            ParticleSystem.smEffects[n6 + 3] = Util.getSin(n8) * n9 >> 12;
            ParticleSystem.smEffects[n6 + 4] = Util.getCos(n8) * n9 >> 12;
        }
    }

    public static final void startBananaBoxShakeFx(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        n <<= 16;
        n2 <<= 16;
        for (n9 = 0; n9 < n3; n9 += 8) {
            for (n8 = 0; n8 < 2; ++n8) {
                n7 = ParticleSystem.addEffects(n + (n9 << 16), n2 + (n8 == 0 ? n4 << 16 : 0), 25, 0);
                int n10 = n7 + 5;
                smEffects[n10] = smEffects[n10] + (250 + Util.getRandom(800));
                n6 = Util.getRandom(1024);
                n5 = Util.getRandom(2500);
                ParticleSystem.smEffects[n7 + 3] = Util.getSin(n6) * n5 >> 12;
                ParticleSystem.smEffects[n7 + 4] = -Math.abs(Util.getCos(n6) * n5 >> 12);
            }
        }
        for (n9 = 0; n9 < n4; n9 += 8) {
            for (n8 = 0; n8 < 2; ++n8) {
                n7 = ParticleSystem.addEffects(n + (n8 == 0 ? n4 << 16 : 0), n2 + (n9 << 16), 25, 0);
                int n11 = n7 + 5;
                smEffects[n11] = smEffects[n11] + (250 + Util.getRandom(800));
                n6 = Util.getRandom(1024);
                n5 = Util.getRandom(2500);
                ParticleSystem.smEffects[n7 + 3] = Util.getSin(n6) * n5 >> 12;
                ParticleSystem.smEffects[n7 + 4] = -Math.abs(Util.getCos(n6) * n5 >> 12);
            }
        }
    }

    private static final int drawComboNumbers(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = 0;
        SpriteObject spriteObject = smComboNumbers;
        int n8 = 1;
        int n9 = n4;
        while (n9 / n8 > 9) {
            n8 *= 10;
        }
        int n10 = n3;
        int n11 = 1500 - n3;
        int n12 = 0;
        n12 = n11 > 375 ? (n11 > 1125 ? 255 - (n11 - 1125 << 8) / 375 : 255) : (n11 << 8) / 375;
        int n13 = 256 + (n12 * 512 >> 8);
        if (graphics != null) {
            n6 = 185 * n11 + 250 * n10;
            int n14 = 0 * n11 + 162 * n10;
            n5 = 0 * n11 + 0 * n10;
            graphics.setColor(n6 / 1500 << 16 | n14 / 1500 << 8 | n5 / 1500);
            int n15 = ParticleSystem.drawComboNumbers(null, 0, 0, n3, n4);
            n -= n15 >> 1;
            int n16 = spriteObject.getHeight() * n13 >> 8;
            n2 -= n16 >> 1;
        }
        boolean bl = true;
        do {
            int n17 = 0;
            n6 = n9 / n8 % 10;
            if (bl) {
                n6 = 10;
            }
            Animation animation = spriteObject.getCurrentAnimationData();
            n5 = n2 - spriteObject.getPivotY();
            AnimationFrame animationFrame = animation.getFrame(n6);
            int[][] nArray = animationFrame.getRenderables();
            int n18 = nArray.length;
            for (int i = 0; i < n18; ++i) {
                int[] nArray2 = nArray[i];
                int n19 = nArray2[2];
                int n20 = nArray2[3];
                int n21 = (n19 + nArray2[4]) * n13 >> 8;
                int n22 = (n20 + nArray2[5]) * n13 >> 8;
                n19 = n19 * n13 >> 8;
                n17 = Math.max(n17, n21);
                if (graphics == null) continue;
                n20 = n20 * n13 >> 8;
                graphics.fillRect(n + n19, n5 + n20, n21 - n19, n22 - n20);
            }
            if (!bl) {
                n8 /= 10;
            }
            if (bl) {
                bl = false;
                n17 += n13 >> 8;
            }
            n += n17 + 2;
            n7 += n17 + 2;
        } while (n8 > 0);
        return n7;
    }

    private static final void scoreObjectEffectFinished(int n) {
        GameEngine.collectScoreObject(n);
    }

    static {
        EFFECT_DEFINITIONS = new int[][]{{0, -1}, {1000, 1}, {800, 1}, {1250, 1}, {1250, 1}, {1250, 1}, {1250, 1}, {1250, 1}, {400, 1}, {20000, 1}, {800, 1}, {800, 1}, {2700, 1}, {1000, 1}, {1250, 1}, {1200, 1}, {1200, 1}, {900, 1}, {900, 1}, {900, 1}, {900, 1}, {900, 1}, {1200, 1}, {510, 1}, {10000, 1}, {1200, 1}, {1024, 1}, {1500, 1}, {1250, 1}, {2500, 1}, {2500, 1}, {2500, 1}};
        EFFECT_SPRITES = new int[]{-1, 196693, 196770, 196646, 196646, 196646, 196646, 196646, 196702, 196713, 196650, 196658, 196721, 196673, 196727, -1, -1, 196646, -1, -1, -1, -1, -1, -1, 196900, -1, -1, -1, 196690, 196907, 196908, 196906};
    }
}

