/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteObject {
    private Animation[] mAnimations;
    private Animation mCurrentAnimation;
    private int mCurrentFrameIndex;
    private int mElapsedTime;
    private boolean mForceEachFrame;
    private int mLoopCount;
    private int mLoopCounter;
    private boolean mReversed;
    private static int smCurrentColorModification;
    private static int smCurrentRotationAngle;
    private static int smCurrentScaleHorizontal;
    private static int smCurrentScaleVertical;
    private static int smCurrentRenderMode;
    private static Image smCurrentRenderTarget;
    private static int smCurrentBlurBoxWidth;
    private static int smCurrentBlurBoxHeight;
    private static boolean smCurrentBilinearFiltering;

    public SpriteObject(Animation[] animationArray) {
        this.set(animationArray, -2);
    }

    public SpriteObject(Animation animation) {
        this(new Animation[]{animation});
    }

    public SpriteObject(Animation[] animationArray, boolean bl) {
        this.set(animationArray, bl ? -1 : 1);
    }

    public SpriteObject(Animation animation, boolean bl) {
        this(new Animation[]{animation}, bl);
    }

    public SpriteObject() {
    }

    public SpriteObject clone() {
        if (this.mLoopCount == -2) {
            return new SpriteObject(this.mAnimations);
        }
        return new SpriteObject(this.mAnimations, this.mLoopCount == -1);
    }

    private void set(Animation[] animationArray, int n) {
        if (this.mAnimations != null) {
            this.freeResources();
        }
        this.mAnimations = animationArray;
        int n2 = animationArray.length;
        while (--n2 >= 0) {
            DavinciUtilities.modRefCounters(animationArray[n2], 1);
        }
        this.setAnimation(0, n, true);
    }

    public int getFrameCount() {
        return this.mCurrentAnimation.getFrameCount();
    }

    public int getAnimationLength() {
        return this.mCurrentAnimation.getDuration();
    }

    public int getElapsedTime() {
        int n = this.mCurrentAnimation.getFrameStartTime(this.mCurrentFrameIndex) + this.mElapsedTime;
        return n;
    }

    public Animation getCurrentAnimationData() {
        return this.mCurrentAnimation;
    }

    public CollisionBox[] getCollisionBoxes() {
        return this.mCurrentAnimation.getFrame(this.mCurrentFrameIndex).getCollisionBoxes();
    }

    public CollisionBox getCollisionBox(int n) {
        return this.mCurrentAnimation.getFrame(this.mCurrentFrameIndex).getCollisionBox(n);
    }

    public void setElapsedTime(int n) {
        this.setAnimationFrame(0);
        boolean bl = this.mForceEachFrame;
        this.mForceEachFrame = false;
        this.logicUpdate(n);
        this.mForceEachFrame = bl;
    }

    public void logicUpdate(int n) {
        if (!this.mReversed) {
            int n2 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
            this.mElapsedTime += n;
            while (this.mElapsedTime >= n2) {
                this.mElapsedTime -= n2;
                if (this.mForceEachFrame) {
                    this.mElapsedTime = 0;
                }
                int n3 = this.mCurrentAnimation.getFrameCount();
                ++this.mCurrentFrameIndex;
                if (this.mCurrentFrameIndex >= n3) {
                    if (this.mLoopCounter > 0) {
                        --this.mLoopCounter;
                    }
                    this.mCurrentFrameIndex = 0;
                    if (this.mLoopCounter == 0) {
                        this.mCurrentFrameIndex = n3 - 1;
                        this.mElapsedTime = n2 - 1;
                        break;
                    }
                }
                n2 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
            }
        } else {
            this.mElapsedTime -= n;
            while (this.mElapsedTime < 0) {
                int n4;
                --this.mCurrentFrameIndex;
                if (this.mCurrentFrameIndex == -1) {
                    if (this.mLoopCounter > 0) {
                        --this.mLoopCounter;
                    }
                    n4 = this.mCurrentAnimation.getFrameCount();
                    this.mCurrentFrameIndex = n4 - 1;
                    if (this.mLoopCounter == 0) {
                        this.mCurrentFrameIndex = 0;
                        this.mElapsedTime = 0;
                        break;
                    }
                }
                n4 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
                this.mElapsedTime += n4;
                if (!this.mForceEachFrame) continue;
                this.mElapsedTime = n4 - 1;
            }
        }
    }

    private void drawWithEffects(Graphics graphics, int n, int n2) {
        int n3;
        boolean bl;
        int n4 = smCurrentColorModification & 0xFF000000;
        if (n4 == 0) {
            return;
        }
        Animation animation = this.mCurrentAnimation;
        AnimationFrame animationFrame = animation.getFrame(this.mCurrentFrameIndex);
        GraphicsBuffer graphicsBuffer = animationFrame.getGraphicsBuffer();
        boolean bl2 = animationFrame.hasNestedAnimations();
        boolean bl3 = bl = !bl2 && animationFrame.isGraphicsBufferCached();
        if (!bl) {
            int[] nArray;
            int n5;
            n3 = animation.getWithoutTimelineWidth();
            int n6 = animation.getWithoutTimelineHeight();
            int n7 = animation.getWithoutTimelineX();
            int n8 = animation.getWithoutTimelineY();
            Image image = null;
            int n9 = 0;
            int[][] nArray2 = animationFrame.getRenderables();
            int n10 = nArray2.length;
            if (n10 == 1 && (n5 = (nArray = nArray2[0])[0]) == 1) {
                image = DavinciUtilities.getImageFromCache(nArray[3]);
                n9 = nArray[4];
                graphicsBuffer.createBuffer(image, n7 -= nArray[1], n8 -= nArray[2], n9);
            }
            if (image == null) {
                int n11;
                int n12 = smCurrentColorModification;
                n10 = smCurrentRotationAngle;
                int n13 = smCurrentScaleHorizontal;
                n5 = smCurrentScaleVertical;
                int n14 = smCurrentRenderMode;
                int n15 = smCurrentBlurBoxWidth;
                int n16 = smCurrentBlurBoxHeight;
                if (bl2) {
                    n11 = smCurrentBilinearFiltering;
                    SpriteObject.disableAllEffects();
                    smCurrentBilinearFiltering = n11;
                }
                graphicsBuffer.createBuffer(n3, n6, n7, n8);
                n11 = this.getElapsedTime();
                this.mCurrentAnimation.doDraw(graphicsBuffer.getGraphics(), n7, n8, n11);
                if (bl2) {
                    smCurrentColorModification = n12;
                    smCurrentRotationAngle = n10;
                    smCurrentScaleHorizontal = n13;
                    smCurrentScaleVertical = n5;
                    smCurrentRenderMode = n14;
                    smCurrentBlurBoxWidth = n15;
                    smCurrentBlurBoxHeight = n16;
                }
            }
        }
        if (!bl || graphicsBuffer.getColorModification() != smCurrentColorModification) {
            graphicsBuffer.updateBufferARGB(smCurrentColorModification);
        }
        graphicsBuffer.setBilinearFiltering(smCurrentBilinearFiltering);
        graphicsBuffer.setRotation(smCurrentRotationAngle);
        graphicsBuffer.setScale(smCurrentScaleHorizontal, smCurrentScaleVertical);
        graphicsBuffer.setBlur(smCurrentBlurBoxWidth, smCurrentBlurBoxHeight);
        n3 = smCurrentRenderMode;
        if (smCurrentRenderTarget == null) {
            n3 = 0;
        }
        graphicsBuffer.setRenderMode(n3, smCurrentRenderTarget);
        graphicsBuffer.draw(graphics, n, n2);
    }

    public int getCurrentFrameColorModification() {
        int n;
        int n2;
        int n3 = this.mCurrentFrameIndex + 1;
        Animation animation = this.mCurrentAnimation;
        if (n3 == animation.getFrameCount()) {
            n3 = 0;
            if (!this.isLooping()) {
                n3 = this.mCurrentFrameIndex;
            }
        }
        if ((n2 = animation.getFrameColorModification(this.mCurrentFrameIndex)) == (n = animation.getFrameColorModification(n3))) {
            return n2;
        }
        int n4 = animation.getFrameDuration(this.mCurrentFrameIndex);
        return DavinciUtilities.interpolateColor(n2, n, this.mElapsedTime, n4);
    }

    public boolean hasAnimationTimeline() {
        return this.mCurrentAnimation.hasTimeline();
    }

    public int getTimelineX() {
        if (this.hasAnimationTimeline()) {
            return this.mCurrentAnimation.getTimelineValue(1, this.getElapsedTime(), this.isLooping());
        }
        return 0;
    }

    public int getTimelineY() {
        if (this.hasAnimationTimeline()) {
            return this.mCurrentAnimation.getTimelineValue(2, this.getElapsedTime(), this.isLooping());
        }
        return 0;
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = smCurrentColorModification;
        int n7 = smCurrentRotationAngle;
        int n8 = smCurrentScaleHorizontal;
        int n9 = smCurrentScaleVertical;
        int n10 = this.getElapsedTime();
        if (this.hasAnimationTimeline()) {
            n += this.getTimelineX();
            n2 += this.getTimelineY();
            boolean bl = this.isLooping();
            n5 = this.mCurrentAnimation.getTimelineValue(5, n10, bl);
            if (n6 == -8355712) {
                n6 = this.mCurrentAnimation.getTimelineValue(0, n10, bl);
            }
            n4 = this.mCurrentAnimation.getTimelineValue(3, n10, bl);
            n3 = this.mCurrentAnimation.getTimelineValue(4, n10, bl);
            n7 += n5;
            n8 = n4 * smCurrentScaleHorizontal >> 10;
            n9 = n3 * smCurrentScaleVertical >> 10;
        }
        if (n6 == -8355712) {
            n6 = this.getCurrentFrameColorModification();
        }
        if (n6 != -8355712 || n7 != 0 || n8 != 1024 || n9 != 1024 || smCurrentRenderMode != 0 || smCurrentBlurBoxWidth > 1 || smCurrentBlurBoxHeight > 1) {
            int n11 = smCurrentColorModification;
            n5 = smCurrentRotationAngle;
            n4 = smCurrentScaleHorizontal;
            n3 = smCurrentScaleVertical;
            SpriteObject.setColorModification(n6);
            SpriteObject.setRotation(n7);
            SpriteObject.setScale(n8, n9);
            this.drawWithEffects(graphics, n, n2);
            SpriteObject.setColorModification(n11);
            SpriteObject.setRotation(n5);
            SpriteObject.setScale(n3, n4);
            return;
        }
        this.mCurrentAnimation.doDraw(graphics, n, n2, n10);
    }

    public void setAnimation(int n, int n2, boolean bl) {
        this.mCurrentAnimation = this.mAnimations[n];
        this.mLoopCount = n2;
        this.mForceEachFrame = bl;
        this.setAnimationFrame(0);
    }

    public int getCurrentAnimationIndex() {
        int n = 0;
        while (this.mCurrentAnimation != this.mAnimations[n]) {
            ++n;
        }
        return n;
    }

    public int getAnimationCount() {
        return this.mAnimations.length;
    }

    public void setAnimationFrame(int n) {
        this.mCurrentFrameIndex = n;
        this.mLoopCounter = this.mLoopCount;
        if (this.mLoopCount == -2) {
            this.mLoopCounter = 1;
            if (this.mCurrentAnimation.isLoopingPreferenced()) {
                this.mLoopCounter = -1;
            }
        }
        this.mElapsedTime = !this.mReversed ? 0 : this.mCurrentAnimation.getFrameDuration(n) - 1;
    }

    public int getCurrentFrameIndex() {
        return this.mCurrentFrameIndex;
    }

    public boolean isFinishedAnimation() {
        return this.mLoopCounter == 0;
    }

    public int getPivotX() {
        return this.mCurrentAnimation.getX();
    }

    public int getPivotY() {
        return this.mCurrentAnimation.getY();
    }

    public int getWidth() {
        return this.mCurrentAnimation.getWidth();
    }

    public int getHeight() {
        return this.mCurrentAnimation.getHeight();
    }

    public void freeResources() {
        if (this.mAnimations != null) {
            int n = this.mAnimations.length;
            while (--n >= 0) {
                this.mAnimations[n].freeResources();
            }
            DavinciUtilities.releaseUnreferencedImages();
            this.mAnimations = null;
        }
    }

    public static void releaseEffectBuffer() {
    }

    public static void setColorModification(int n) {
        smCurrentColorModification = n;
    }

    public static void setRotation(int n) {
        smCurrentRotationAngle = n;
    }

    public static void setScale(int n, int n2) {
        smCurrentScaleHorizontal = n;
        smCurrentScaleVertical = n2;
    }

    public static void setFiltering(boolean bl) {
        smCurrentBilinearFiltering = bl;
    }

    public static void disableAllEffects() {
        smCurrentColorModification = -8355712;
        smCurrentRotationAngle = 0;
        smCurrentScaleHorizontal = 1024;
        smCurrentScaleVertical = 1024;
        smCurrentRenderMode = 0;
        smCurrentBlurBoxWidth = 0;
        smCurrentBlurBoxHeight = 0;
        smCurrentBilinearFiltering = false;
    }

    public boolean isLooping() {
        return this.mLoopCounter != 0 && (this.mLoopCounter != 1 || this.mCurrentFrameIndex != this.getFrameCount() - 1);
    }

    static {
        SpriteObject.disableAllEffects();
    }
}

