/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.scores;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import ng.games.pacman.io.ResourceManager;
import ng.games.pacman.settings.Settings;

public class ScoresHandler {
    private int yOffset = 0;
    private int imageHeight;
    private int screenHeight;
    private int[] scores = new int[10];
    private String[] players = new String[10];
    private int recordsCount = 0;
    private ResourceManager rm;
    private static ScoresHandler instance = new ScoresHandler();

    private ScoresHandler() {
        this.loadScores();
    }

    public void paint(Graphics graphics, int n) {
        int n2;
        int n3;
        int n4;
        Font font = Settings.DEFAULT_FONT;
        int n5 = 0;
        for (n4 = 0; n4 < this.getRecordsCount(); ++n4) {
            n3 = font.stringWidth(this.getPlayerAt(n4));
            if (n3 <= n5) continue;
            n5 = n3;
        }
        n4 = 15;
        n3 = 25;
        int n6 = 183 - n3;
        graphics.setClip(0, n3, 176, n6);
        int n7 = n3 + n6 - n;
        int n8 = -n7 / n4 - 1;
        if (n8 < 0) {
            n8 = 0;
        }
        if ((n2 = (n6 - n7) / n4 + 3) >= this.getRecordsCount() - 1) {
            n2 = this.getRecordsCount() - 1;
        }
        for (int i = n8; i <= n2; ++i) {
            graphics.drawString(Integer.toString(i + 1) + "." + this.getPlayerAt(i), 10, n7 + i * n4, 20);
            graphics.drawString(Integer.toString(this.getScoreAt(i)), 10 + n5 + 20, n7 + i * n4, 20);
        }
        graphics.setClip(0, 0, 176, 208);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveScores() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"pmscores", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.recordsCount);
            for (int i = 0; i < this.recordsCount; ++i) {
                dataOutputStream.writeInt(this.scores[i]);
                dataOutputStream.writeUTF(this.players[i]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScores() {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)"pmscores", (boolean)true);
            RecordEnumeration recordEnumeration = recordStore.enumerateRecords(null, null, true);
            if (recordEnumeration.hasNextElement()) {
                byte[] byArray = recordEnumeration.nextRecord();
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
                this.recordsCount = dataInputStream.readInt();
                for (int i = 0; i < this.recordsCount; ++i) {
                    this.scores[i] = dataInputStream.readInt();
                    this.players[i] = dataInputStream.readUTF();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                recordStore.closeRecordStore();
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    public int getRecordsCount() {
        return this.recordsCount;
    }

    public boolean checkForHiscore(int n) {
        return this.recordsCount < 10 || n > this.scores[this.scores.length - 1];
    }

    public void addToHiscores(String string, int n) {
        int n2;
        for (n2 = 0; n2 < this.recordsCount && this.scores[n2] > n; ++n2) {
        }
        if (n2 < this.scores.length) {
            for (int i = this.scores.length - 1; i > n2; --i) {
                this.scores[i] = this.scores[i - 1];
                this.players[i] = this.players[i - 1];
            }
            this.scores[n2] = n;
            this.players[n2] = string;
            if (this.recordsCount < this.scores.length) {
                ++this.recordsCount;
            }
        }
    }

    public int getScoreAt(int n) {
        return this.scores[n];
    }

    public String getPlayerAt(int n) {
        return this.players[n];
    }

    private void sortRecords() {
        boolean bl = false;
        while (!bl) {
            bl = true;
            for (int i = 0; i < this.recordsCount - 1; ++i) {
                if (this.scores[i] >= this.scores[i + 1]) continue;
                bl = false;
                int n = this.scores[i];
                this.scores[i] = this.scores[i + 1];
                this.scores[i + 1] = n;
                String string = this.players[i];
                this.players[i] = this.players[i + 1];
                this.players[i + 1] = string;
            }
        }
    }

    public static ScoresHandler getInstance() {
        return instance;
    }

    public String[] getLines() {
        return new String[0];
    }
}

