/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.macs;

import java.util.Hashtable;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.ExtendedDigest;
import org.bouncycastle.crypto.Mac;
import org.bouncycastle.crypto.params.KeyParameter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class HMac
implements Mac {
    private Digest a;
    private int a;
    private int b;
    private byte[] a;
    private byte[] b;
    private static Hashtable a = new Hashtable();

    private static int a(Digest digest) {
        if (digest instanceof ExtendedDigest) {
            return ((ExtendedDigest)digest).getByteLength();
        }
        Integer n2 = (Integer)a.get(digest.getAlgorithmName());
        if (n2 == null) {
            throw new IllegalArgumentException("unknown digest passed: " + digest.getAlgorithmName());
        }
        return n2;
    }

    public HMac(Digest digest) {
        this(digest, HMac.a(digest));
    }

    private HMac(Digest digest, int n2) {
        this.a = digest;
        this.a = digest.getDigestSize();
        this.b = n2;
        this.a = new byte[this.b];
        this.b = new byte[this.b];
    }

    public String getAlgorithmName() {
        return this.a.getAlgorithmName() + "/HMAC";
    }

    public Digest getUnderlyingDigest() {
        return this.a;
    }

    public void init(CipherParameters cipherParameters) {
        int n2;
        this.a.reset();
        byte[] byArray = ((KeyParameter)cipherParameters).getKey();
        if (byArray.length > this.b) {
            this.a.update(byArray, 0, byArray.length);
            this.a.doFinal(this.a, 0);
            for (n2 = this.a; n2 < this.a.length; ++n2) {
                this.a[n2] = 0;
            }
        } else {
            System.arraycopy(byArray, 0, this.a, 0, byArray.length);
            for (n2 = byArray.length; n2 < this.a.length; ++n2) {
                this.a[n2] = 0;
            }
        }
        this.b = new byte[this.a.length];
        System.arraycopy(this.a, 0, this.b, 0, this.a.length);
        n2 = 0;
        while (n2 < this.a.length) {
            int n3 = n2++;
            this.a[n3] = (byte)(this.a[n3] ^ 0x36);
        }
        n2 = 0;
        while (n2 < this.b.length) {
            int n4 = n2++;
            this.b[n4] = (byte)(this.b[n4] ^ 0x5C);
        }
        this.a.update(this.a, 0, this.a.length);
    }

    public int getMacSize() {
        return this.a;
    }

    public void update(byte by2) {
        this.a.update(by2);
    }

    public void update(byte[] byArray, int n2, int n3) {
        this.a.update(byArray, n2, n3);
    }

    public int doFinal(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[this.a];
        this.a.doFinal(byArray2, 0);
        this.a.update(this.b, 0, this.b.length);
        this.a.update(byArray2, 0, byArray2.length);
        int n3 = this.a.doFinal(byArray, n2);
        this.reset();
        return n3;
    }

    public void reset() {
        this.a.reset();
        this.a.update(this.a, 0, this.a.length);
    }

    static {
        a.put("GOST3411", new Integer(32));
        a.put("MD2", new Integer(16));
        a.put("MD4", new Integer(64));
        a.put("MD5", new Integer(64));
        a.put("RIPEMD128", new Integer(64));
        a.put("RIPEMD160", new Integer(64));
        a.put("SHA-1", new Integer(64));
        a.put("SHA-224", new Integer(64));
        a.put("SHA-256", new Integer(64));
        a.put("SHA-384", new Integer(128));
        a.put("SHA-512", new Integer(128));
        a.put("Tiger", new Integer(64));
        a.put("Whirlpool", new Integer(64));
    }
}

