/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

class MenuCanvas
extends GameCanvas
implements Runnable {
    private TruckMIDlet midlet;
    private Image logoImage;
    private int selectedItem = 0;
    private int prevSelectedItem = 0;
    private String title;
    private String[] items;
    private Image[] images;
    private int numberOfItems = 0;
    private Graphics g;
    private volatile Thread animationThread = null;
    private int middleColor = 0xFFFF00;
    private int textColor = 0x440044;
    private int titleHeight;
    private int slower;
    private int slowValue = 6;
    private int offset = 0;
    private int maxOffset = 0;
    private boolean isList = true;
    private boolean firePressed = false;
    private int width;
    private int height;
    private int listScreenHeight;
    private Font titleFont = Font.getFont((int)0, (int)1, (int)0);
    private Font font1 = Font.getFont((int)0, (int)1, (int)0);
    private Font font2 = Font.getFont((int)0, (int)0, (int)0);
    private Font font = Font.getFont((int)0, (int)0, (int)8);
    private int offsetValue = this.font.getHeight();
    private Image scrollImage = TruckMIDlet.createImage("/scroll.png");
    private boolean shown = false;

    MenuCanvas(TruckMIDlet truckMIDlet) {
        super(true);
        this.midlet = truckMIDlet;
        this.g = this.getGraphics();
        this.setFullScreenMode(true);
        this.logoImage = TruckMIDlet.createImage("/wheelback2.png");
        this.items = new String[10];
        this.images = new Image[10];
        this.width = this.getWidth();
        this.height = this.getHeight();
    }

    public void commandAction2() {
        if (this.getString(this.getSelectedIndex()) == "Main menu") {
            this.midlet.showMenuList();
        } else if (this.getString(this.getSelectedIndex()) == "Hit best times") {
            this.prevSelectedItem = this.selectedItem;
            this.midlet.showHitBestTimesMenuList();
        } else if (this.getString(this.getSelectedIndex()) == "Instructions") {
            this.prevSelectedItem = this.selectedItem;
            this.midlet.menuListInstructions();
        } else if (this.getString(this.getSelectedIndex()) == "About") {
            this.prevSelectedItem = this.selectedItem;
            this.midlet.showAbout();
        } else if (this.getString(this.getSelectedIndex()) == "Show best times") {
            this.prevSelectedItem = this.selectedItem;
            this.midlet.showBestTimes();
        } else if (this.getString(this.getSelectedIndex()) == "Options") {
            this.prevSelectedItem = this.selectedItem;
            this.midlet.showOptionsMenu();
        } else if (this.getString(this.getSelectedIndex()) == "Music: off") {
            this.set(this.getSelectedIndex(), "Music: on", TruckMIDlet.createImage("/listitemb4.png"));
            this.midlet.setMusic(true);
        } else if (this.getString(this.getSelectedIndex()) == "Music: on") {
            this.set(this.getSelectedIndex(), "Music: off", TruckMIDlet.createImage("/listitemb4.png"));
            this.midlet.setMusic(false);
        } else if (this.getString(this.getSelectedIndex()) == "Vibration: off") {
            this.set(this.getSelectedIndex(), "Vibration: on", TruckMIDlet.createImage("/listitemb5.png"));
            this.midlet.setVibration(true);
        } else if (this.getString(this.getSelectedIndex()) == "Vibration: on") {
            this.set(this.getSelectedIndex(), "Vibration: off", TruckMIDlet.createImage("/listitemb5.png"));
            this.midlet.setVibration(false);
        } else {
            this.stop();
            if (this.getString(this.getSelectedIndex()) == "Continue game") {
                this.midlet.stopMusic();
                this.prevSelectedItem = this.selectedItem;
                this.midlet.menuListContinueGame();
            } else if (this.getString(this.getSelectedIndex()) == "New game") {
                this.midlet.stopMusic();
                this.prevSelectedItem = this.selectedItem;
                this.midlet.menuListNewGame();
            } else if (this.getString(this.getSelectedIndex()) == "Quit") {
                this.midlet.stopMusic();
                this.midlet.exitFromTheApp();
            } else if (this.getString(this.getSelectedIndex()) == "Resume game") {
                this.midlet.menuListResumeGame();
            } else if (this.getString(this.getSelectedIndex()) == "Restart level") {
                this.midlet.menuListContinueGame();
            } else if (this.getString(this.getSelectedIndex()) == "Start next level") {
                this.midlet.menuListNewGameOnNextLevel();
            } else if (this.title == "Hit best times") {
                this.midlet.hitBestTimes(this.getSelectedIndex() + 1);
                this.midlet.stopMusic();
            }
        }
    }

    public void keyPressed(int n) {
        if (n < 0 && this.shown) {
            if (this.isList) {
                this.commandAction2();
            } else {
                this.midlet.showMenuList();
            }
        }
    }

    private int getSelectedIndex() {
        return this.selectedItem;
    }

    private String getString(int n) {
        return this.items[n];
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Thread thread = Thread.currentThread();
        try {
            while (thread == this.animationThread) {
                long l;
                long l2 = System.currentTimeMillis();
                if (this.isShown()) {
                    this.tick();
                    this.draw();
                    this.flushGraphics();
                    this.shown = true;
                }
                if ((l = System.currentTimeMillis() - l2) < 50L) {
                    MenuCanvas menuCanvas = this;
                    synchronized (menuCanvas) {
                        this.wait(50L - l);
                        continue;
                    }
                }
                thread.yield();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void tick() {
        int n = this.getKeyStates();
        if (this.isList) {
            if ((n & 2) != 0) {
                if (this.slower++ % this.slowValue == 0) {
                    this.selectedItem = --this.selectedItem < 0 ? this.numberOfItems + this.selectedItem : this.selectedItem % this.numberOfItems;
                }
            } else if ((n & 0x40) != 0) {
                if (this.slower++ % this.slowValue == 0) {
                    ++this.selectedItem;
                    this.selectedItem %= this.numberOfItems;
                }
            } else if ((n & 0x100) != 0) {
                if (!this.firePressed) {
                    this.firePressed = true;
                    this.commandAction2();
                }
            } else {
                this.slower = 0;
                this.firePressed = false;
            }
        } else if ((n & 0x40) != 0) {
            if (this.offset < this.maxOffset) {
                this.offset += this.offsetValue;
            }
        } else if ((n & 2) != 0) {
            this.offset -= this.offsetValue;
            if (this.offset < 0) {
                this.offset = 0;
            }
        } else if ((n & 0x100) != 0) {
            if (!this.firePressed) {
                this.firePressed = true;
                this.midlet.showMenuList();
            }
        } else {
            this.firePressed = false;
        }
    }

    public void draw() {
        this.g.setColor(0xBBBBDD);
        this.g.fillRect(0, 0, this.width, this.height);
        this.g.drawImage(this.logoImage, this.width / 2, this.height / 2, 3);
        this.g.setFont(this.titleFont);
        this.g.setColor(this.middleColor);
        this.g.drawString(this.title, 1, 0, 20);
        this.titleHeight = this.titleFont.getHeight();
        this.g.setColor(0x9F9F9F);
        this.g.drawLine(0, this.titleHeight + 1, this.width, this.titleHeight + 1);
        this.g.translate(1, this.titleHeight + 5);
        this.listScreenHeight = this.height - (this.titleHeight + 5);
        if (this.isList) {
            this.drawList();
        } else {
            this.drawInfo();
        }
        this.g.translate(-1, -(this.titleHeight + 5));
        this.g.setClip(0, 0, this.width, this.height);
        if (!this.isList && this.maxOffset != 0) {
            this.g.drawImage(this.scrollImage, this.width - 1, (int)((double)this.titleHeight * 0.5), 10);
        }
    }

    private void drawList() {
        int n = Math.max(this.font1.getHeight(), 16);
        int n2 = (this.selectedItem + 1) * n > this.listScreenHeight ? (int)Math.floor((double)((this.selectedItem + 1) * n - this.listScreenHeight) / (double)n) + 1 : 0;
        this.g.translate(0, -n * n2);
        this.g.setClip(0, n * n2, this.width, this.listScreenHeight);
        for (int i = 0; i < this.numberOfItems; ++i) {
            if (i == this.selectedItem) {
                this.g.setFont(this.font1);
                this.g.setColor(this.middleColor);
            } else {
                this.g.setFont(this.font2);
                this.g.setColor(this.textColor);
            }
            this.g.drawImage(this.images[i], 0, i * n + n / 2, 6);
            this.g.drawString(this.items[i], 18, i * n + n / 2 - this.font1.getHeight() / 2, 20);
        }
        this.g.translate(0, n * n2);
    }

    private void drawInfo() {
        this.g.setColor(this.textColor);
        this.g.setFont(this.font);
        int n = 0;
        String string = "";
        int n2 = 0;
        int n3 = 0;
        this.g.translate(1, -this.offset);
        this.g.setClip(0, this.offset, this.width, this.listScreenHeight);
        for (int i = 1; i <= this.numberOfItems; ++i) {
            int n4;
            n = 0;
            string = "";
            String string2 = this.items[i - 1];
            while ((n4 = string2.indexOf(" ", n)) != -1) {
                String string3 = string2.substring(n, n4);
                if (this.font.stringWidth(string + string2.substring(n, n4 + 1)) > this.width || string3.equals("NL")) {
                    this.g.drawString(string, 0, n2++ * this.font.getHeight() + n3, 20);
                    string = !string3.equals("NL") ? string2.substring(n, n4 + 1) : "";
                    n = n4 + 1;
                    continue;
                }
                string = string + string2.substring(n, n4 + 1);
                n = n4 + 1;
            }
            this.g.drawString(string, 0, n2++ * this.font.getHeight() + n3, 20);
            if (this.images[i - 1] == null) continue;
            this.g.drawImage(this.images[i - 1], this.width / 2, n2 * this.font.getHeight() + n3, 17);
            n3 += this.images[i - 1].getHeight();
        }
        this.g.translate(-1, this.offset);
        this.maxOffset = n2 * this.font.getHeight() + n3 <= this.listScreenHeight ? 0 : n2 * this.font.getHeight() + n3 - this.listScreenHeight;
    }

    public void append(String string, Image image) {
        this.items[this.numberOfItems] = string;
        this.images[this.numberOfItems] = image;
        ++this.numberOfItems;
    }

    public void set(int n, String string, Image image) {
        this.items[n] = string;
        this.images[n] = image;
    }

    public void insert(int n, String string, Image image) {
        for (int i = this.numberOfItems; i >= n; --i) {
            this.items[i + 1] = this.items[i];
            this.images[i + 1] = this.images[i];
        }
        this.items[n] = string;
        this.images[n] = image;
        ++this.numberOfItems;
    }

    public void delete(int n) {
        --this.numberOfItems;
        for (int i = n; i < this.numberOfItems; ++i) {
            this.items[i] = this.items[i + 1];
            this.images[i] = this.images[i + 1];
        }
    }

    public void init(String string) {
        this.title = string;
        this.numberOfItems = 0;
    }

    public void initMainMenuWithContinue(String string) {
        this.title = string;
        this.middleColor = 0xFFFF00;
        this.numberOfItems = 0;
        this.selectedItem = this.prevSelectedItem;
        this.isList = true;
        this.append("Continue game", TruckMIDlet.createImage("/listitem2.png"));
        this.append("New game", TruckMIDlet.createImage("/listitem1.png"));
        this.append("Show best times", TruckMIDlet.createImage("/listitem5.png"));
        this.append("Hit best times", TruckMIDlet.createImage("/listitem4.png"));
        this.append("Options", TruckMIDlet.createImage("/listitem8.png"));
        this.append("Instructions", TruckMIDlet.createImage("/listitem6.png"));
        this.append("About", TruckMIDlet.createImage("/listitem7.png"));
        this.append("Quit", TruckMIDlet.createImage("/listitem3.png"));
    }

    public void initMainMenuWithoutContinue(String string) {
        this.title = string;
        this.middleColor = 0xFFFF00;
        this.numberOfItems = 0;
        this.selectedItem = this.prevSelectedItem;
        this.isList = true;
        this.append("New game", TruckMIDlet.createImage("/listitem1.png"));
        this.append("Show best times", TruckMIDlet.createImage("/listitem5.png"));
        this.append("Hit best times", TruckMIDlet.createImage("/listitem4.png"));
        this.append("Options", TruckMIDlet.createImage("/listitem8.png"));
        this.append("Instructions", TruckMIDlet.createImage("/listitem6.png"));
        this.append("About", TruckMIDlet.createImage("/listitem7.png"));
        this.append("Quit", TruckMIDlet.createImage("/listitem3.png"));
    }

    public void initGameMenuWithResume(String string) {
        this.title = string;
        this.middleColor = 0xAAFFAA;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        this.append("Resume game", TruckMIDlet.createImage("/listitema2.png"));
        this.append("Restart level", TruckMIDlet.createImage("/listitema1.png"));
        this.append("Main menu", TruckMIDlet.createImage("/listitema3.png"));
    }

    public void initGameMenuWithoutResume(String string) {
        this.title = string;
        this.middleColor = 0xAAFFAA;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        this.append("Restart level", TruckMIDlet.createImage("/listitema1.png"));
        this.append("Main menu", TruckMIDlet.createImage("/listitema3.png"));
    }

    public void initNextLevelMenu(String string) {
        this.title = string;
        this.middleColor = 0xAAFFAA;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        this.append("Start next level", TruckMIDlet.createImage("/listitema1.png"));
        this.append("Main menu", TruckMIDlet.createImage("/listitema3.png"));
    }

    public void initAllLevelsDoneMenu(String string) {
        this.title = string;
        this.middleColor = 0xAAFFAA;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        this.append("Main menu", TruckMIDlet.createImage("/listitema3.png"));
    }

    public void initHitBestTimesMenu(String string, int n) {
        this.title = string;
        this.middleColor = 0xFFFFFF;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        if (n > 0) {
            for (int i = 1; i <= n; ++i) {
                this.append("Level" + Integer.toString(i), TruckMIDlet.createImage("/listitemb1.png"));
            }
        }
        this.append("Main menu", TruckMIDlet.createImage("/listitemb3.png"));
    }

    public void initOptionsMenu(String string, boolean bl, boolean bl2) {
        this.title = string;
        this.middleColor = 0xFFFFFF;
        this.numberOfItems = 0;
        this.selectedItem = 0;
        this.isList = true;
        if (bl) {
            this.append("Music: on", TruckMIDlet.createImage("/listitemb4.png"));
        } else {
            this.append("Music: off", TruckMIDlet.createImage("/listitemb4.png"));
        }
        if (bl2) {
            this.append("Vibration: on", TruckMIDlet.createImage("/listitemb5.png"));
        } else {
            this.append("Vibration: off", TruckMIDlet.createImage("/listitemb5.png"));
        }
        this.append("Main menu", TruckMIDlet.createImage("/listitemb3.png"));
    }

    public void initBestTimesScreen(String string, int n, long[] lArray) {
        this.title = string;
        this.middleColor = 0xFFFFFF;
        this.numberOfItems = 0;
        this.offset = 0;
        this.isList = false;
        if (n == 0) {
            this.append("Still not available EOS", null);
        } else {
            for (int i = 1; i <= n; ++i) {
                this.append("Level " + Integer.toString(i) + ": " + Long.toString(lArray[i - 1]) + " sec EOS", null);
            }
        }
    }

    public void initInstructionsScreen(String string) {
        this.title = string;
        this.middleColor = 0xFFFFFF;
        this.numberOfItems = 0;
        this.offset = 0;
        this.isList = false;
        this.append("You are a truck driver with the following task: NL -Take a turn into the depot: EOS", TruckMIDlet.createImage("/help1.png"));
        this.append("-drive with the back of the trailer close to the pick-up door (yellow dotted area) and stop for loading: EOS", TruckMIDlet.createImage("/help2.png"));
        this.append("-wait till the stuff is picked up, NL -leave the yard before your time is gone. (You must pass through the mark on the road entirely.) EOS", TruckMIDlet.createImage("/help3.png"));
        this.append("NL Controls: NL UP or 2: speed up NL (backward: speed down) NL DOWN or 8: speed down NL (backward: speed up) NL LEFT or 4: steer left NL RIGHT or 6: steer right NL FIRE or 5: brake NL NL The position of the steering wheel and the speed can be seen at the foot of the screen (just above the damage and time markers). NL EOS", null);
        this.append("*: change to scroll mode NL #: change to game mode NL NL The scroll mode may be useful if your phone's display is small. In this case your viewpoint can be displaced from the truck to any position near the vehicle. Use UP (2), DOWN (8), LEFT (4), RIGHT (6) keys for this purpose. FIRE (5) will reset the default position. The current viewpoint is marked with a little eye symbol. EOS", TruckMIDlet.createImage("/eye2.png"));
    }

    public void initAboutScreen(String string) {
        this.title = string;
        this.middleColor = 0xFFFFFF;
        this.numberOfItems = 0;
        this.offset = 0;
        this.isList = false;
        this.append("(c) Bal\u00e1zs Tukora EOS", null);
        this.append("Music: Zolt\u00e1n S\u00e1ri NL NL All rights reserved EOS", null);
    }
}

