/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class TruckMIDlet
extends MIDlet {
    private Command selectcommand;
    private TruckCanvas truckCanvas = new TruckCanvas(this);
    private MenuCanvas menuCanvas = new MenuCanvas(this);
    private static final String RS_NAME = "BESTTIMES";
    public long[] bestTimes = new long[5];
    public int currentLevel = 1;
    public static final int numberOfLevels = 5;
    public boolean againstBestTime = false;
    public int hitBestTimeLevel = 1;
    public boolean musicOn = true;
    public boolean vibrationOn = true;
    public Player player;

    public TruckMIDlet() {
        this.readRecordStore();
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/music.mid");
            this.player = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
        }
        catch (IOException iOException) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void startApp() {
        Displayable displayable = Display.getDisplay((MIDlet)this).getCurrent();
        if (displayable == null) {
            this.startMusic();
            this.showLogo();
        } else {
            if (displayable == this.truckCanvas) {
                this.truckCanvas.start();
            }
            if (displayable == this.menuCanvas) {
                this.startMusic();
                this.menuCanvas.start();
            }
            Display.getDisplay((MIDlet)this).setCurrent(displayable);
        }
    }

    public void pauseApp() {
        Displayable displayable = Display.getDisplay((MIDlet)this).getCurrent();
        if (displayable == this.truckCanvas) {
            this.truckCanvas.stop();
        }
        if (displayable == this.menuCanvas) {
            this.menuCanvas.stop();
        }
        this.stopMusic();
    }

    public void destroyApp(boolean bl) {
        if (this.truckCanvas != null) {
            this.truckCanvas.stop();
        }
        if (this.menuCanvas != null) {
            this.menuCanvas.stop();
        }
    }

    void showLogo() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)new LogoCanvas(this));
    }

    void backFromLogo() {
        this.showMenuList();
    }

    void showMenuCanvas() {
        if (Display.getDisplay((MIDlet)this).getCurrent() != this.menuCanvas) {
            Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.menuCanvas);
            this.menuCanvas.start();
        }
    }

    void showMenuList() {
        this.startMusic();
        this.againstBestTime = false;
        if (this.currentLevel > 1) {
            this.menuCanvas.initMainMenuWithContinue("Main menu");
        } else {
            this.menuCanvas.initMainMenuWithoutContinue("Main menu");
        }
        this.showMenuCanvas();
    }

    void showGameMenuListWithResume() {
        this.menuCanvas.initGameMenuWithResume("Game menu");
        this.showMenuCanvas();
    }

    void showGameMenuListWithoutResume() {
        this.menuCanvas.initGameMenuWithoutResume("Game menu");
        this.showMenuCanvas();
    }

    void showNextLevelMenuList() {
        if (++this.currentLevel > 5) {
            this.menuCanvas.initAllLevelsDoneMenu("All levels done!");
            this.currentLevel = 1;
        } else {
            this.menuCanvas.initNextLevelMenu("Next Level");
        }
        this.showMenuCanvas();
    }

    void menuListNewGameOnNextLevel() {
        this.truckCanvas.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.truckCanvas);
        this.truckCanvas.start();
    }

    void menuListNewGame() {
        this.currentLevel = 1;
        this.truckCanvas.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.truckCanvas);
        this.truckCanvas.start();
    }

    void menuListContinueGame() {
        this.truckCanvas.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.truckCanvas);
        this.truckCanvas.start();
    }

    void menuListResumeGame() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.truckCanvas);
        this.truckCanvas.start();
    }

    void showBestTimes() {
        int n = 5;
        for (int i = 5; i > 0; --i) {
            if (this.bestTimes[i - 1] != 0L) continue;
            n = i - 1;
        }
        this.menuCanvas.initBestTimesScreen("Best times", n, this.bestTimes);
    }

    void showHitBestTimesMenuList() {
        int n = 5;
        for (int i = 5; i > 0; --i) {
            if (this.bestTimes[i - 1] != 0L) continue;
            n = i - 1;
        }
        this.menuCanvas.initHitBestTimesMenu(n == 0 ? "Still not available" : "Hit best times", n);
        this.showMenuCanvas();
    }

    void hitBestTimes(int n) {
        this.againstBestTime = true;
        this.hitBestTimeLevel = n;
        this.truckCanvas.init();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.truckCanvas);
        this.truckCanvas.start();
    }

    void menuListInstructions() {
        this.menuCanvas.initInstructionsScreen("Instructions");
        this.showMenuCanvas();
    }

    void showAbout() {
        this.menuCanvas.initAboutScreen("About");
        this.showMenuCanvas();
    }

    void showOptionsMenu() {
        this.menuCanvas.initOptionsMenu("Options", this.musicOn, this.vibrationOn);
        this.showMenuCanvas();
    }

    void vibrate(int n) {
        Display.getDisplay((MIDlet)this).vibrate(n);
    }

    void setMusic(boolean bl) {
        this.musicOn = bl;
        if (bl) {
            this.startMusic();
        } else {
            this.stopMusic();
        }
    }

    void startMusic() {
        try {
            if (this.player.getState() != 400 && this.musicOn) {
                this.player.setLoopCount(-1);
                this.player.start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void stopMusic() {
        try {
            if (this.player.getState() == 400) {
                this.player.stop();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void setVibration(boolean bl) {
        this.vibrationOn = bl;
    }

    void setBestTimes(int n, long l) {
        if (this.bestTimes[n - 1] > l || this.bestTimes[n - 1] == 0L) {
            this.bestTimes[n - 1] = l;
        }
    }

    void exitFromTheApp() {
        this.writeRecordStore();
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    static Image createImage(String string) {
        Image image = null;
        try {
            image = Image.createImage((String)string);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readRecordStore() {
        RecordStore recordStore = null;
        ByteArrayInputStream byteArrayInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                this.currentLevel = 1;
                for (int i = 1; i <= 5; ++i) {
                    this.bestTimes[i - 1] = 0L;
                }
            } else {
                byte[] byArray = recordStore.getRecord(1);
                byteArrayInputStream = new ByteArrayInputStream(byArray);
                filterInputStream = new DataInputStream(byteArrayInputStream);
                this.currentLevel = ((DataInputStream)filterInputStream).readInt();
                this.musicOn = ((DataInputStream)filterInputStream).readBoolean();
                this.vibrationOn = ((DataInputStream)filterInputStream).readBoolean();
                for (int i = 1; i <= 5; ++i) {
                    this.bestTimes[i - 1] = ((DataInputStream)filterInputStream).readLong();
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRecordStore() {
        RecordStore recordStore = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        FilterOutputStream filterOutputStream = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RS_NAME, (boolean)true);
            byteArrayOutputStream = new ByteArrayOutputStream();
            filterOutputStream = new DataOutputStream(byteArrayOutputStream);
            ((DataOutputStream)filterOutputStream).writeInt(this.currentLevel);
            ((DataOutputStream)filterOutputStream).writeBoolean(this.musicOn);
            ((DataOutputStream)filterOutputStream).writeBoolean(this.vibrationOn);
            for (int i = 1; i <= 5; ++i) {
                ((DataOutputStream)filterOutputStream).writeLong(this.bestTimes[i - 1]);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(byArray, 0, byArray.length);
            } else {
                recordStore.setRecord(1, byArray, 0, byArray.length);
            }
        }
        catch (IOException iOException) {
        }
        catch (RecordStoreException recordStoreException) {
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (RecordStoreException recordStoreException) {}
            }
        }
    }
}

