/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Bitmap;
import game.GameBoard;
import game.Keyboard;
import game.MultiOutPut;
import game.Sound;
import game.Storage;
import game.game;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

class GameScreen
extends GameCanvas
implements Runnable {
    public static final byte IMG_GAME_BEBE = 11;
    public static final byte IMG_GAME_BLACK_MASSE = 12;
    public static final byte IMG_GAME_CLOCK = 13;
    public static final byte IMG_GAME_COLORS = 12;
    public static final byte IMG_GAME_COLORS_BIG = 13;
    public static final byte IMG_GAME_COLOR_BAR = 11;
    public static final byte IMG_GAME_FAMILLE = 14;
    public static final byte IMG_GAME_KLIING = 0;
    public static final byte IMG_GAME_MASSE = 1;
    public static final byte IMG_GAME_MOINS_10 = 17;
    public static final byte IMG_GAME_MOINS_100 = 9;
    public static final byte IMG_GAME_MOINS_200 = 15;
    public static final byte IMG_GAME_PLUS_100 = 10;
    public static final byte IMG_GAME_PLUS_200 = 16;
    public static final byte IMG_GAME_SCREEN = 2;
    public static final byte IMG_GAME_SCREEN_BAR = 3;
    public static final byte IMG_GAME_SCREEN_CACHE1 = 4;
    public static final byte IMG_GAME_SCREEN_CACHE2 = 5;
    public static final byte IMG_GAME_SCREEN_CACHE3 = 6;
    public static final byte IMG_GAME_SPLASH = 7;
    public static final byte IMG_GAME_SPLASH_BIG = 8;
    public static final byte IMG_INTRO_MEDIAPLAZZA = 0;
    public static final byte IMG_INTRO_SCREEN = 0;
    public static final byte IMG_LOADING_FLAG = 0;
    public static final byte IMG_MENU_CUP = 0;
    public static final byte IMG_MENU_CURSEUR = 1;
    public static final byte IMG_MENU_SCREEN = 2;
    public static final byte IMG_MENU_SPARKLE1 = 3;
    public static final byte MAX_SOUND = 8;
    public static final byte MU_BACK = 18;
    public static final byte MU_BEBE = 36;
    public static final byte MU_BEBE_WIDTH = 1;
    public static final byte MU_CREDITS = 21;
    public static final byte MU_CREDITS_WIDTH = 10;
    public static final byte MU_HELP = 31;
    public static final byte MU_HELP_CELEBRITE = 39;
    public static final byte MU_HELP_CELEBRITE_WIDTH = 9;
    public static final byte MU_HELP_COLORS = 48;
    public static final byte MU_HELP_COLORS_WIDTH = 9;
    public static final byte MU_HELP_CONTROLES = 57;
    public static final byte MU_HELP_CONTROLES_WIDTH = 6;
    public static final byte MU_HELP_WIDTH = 3;
    public static final byte MU_LOADING = 0;
    public static final byte MU_MAIN = 1;
    public static final byte MU_MAIN_WIDTH = 5;
    public static final byte MU_NIV = 34;
    public static final byte MU_NIV_WIDTH = 1;
    public static final byte MU_OK = 37;
    public static final byte MU_OPTIONS = 14;
    public static final byte MU_OPTIONS_WIDTH = 5;
    public static final byte MU_PAUSE = 9;
    public static final byte MU_PAUSE_WIDTH = 2;
    public static final byte MU_PLAY = 6;
    public static final byte MU_PLAYING = 11;
    public static final byte MU_PLAYING_WIDTH = 3;
    public static final byte MU_PLAY_WIDTH = 3;
    public static final byte MU_SON_OUI = 19;
    public static final byte MU_TIME_OUT = 38;
    public static final byte MU_ULTIME = 35;
    public static final byte MU_ULTIME_WIDTH = 1;
    public static final byte MU_VIBREUR_OUI = 20;
    public static final int NB_COLORS = 5;
    public static final byte NB_LETTERS = 26;
    public static final int NB_TETE_MAXI = 4;
    public static final int REPAINT = 30;
    public static final int SCR_H = 320;
    public static final int SCR_W = 240;
    public static final byte SM_HELP = 30;
    public static final byte SM_HELP_CELEBRITE = 100;
    public static final byte SM_HELP_COLORS = 110;
    public static final byte SM_HELP_CONTROLES = 120;
    public static final byte SM_LOADING = 90;
    public static final byte SM_LVL_UP = 50;
    public static final byte SM_MAIN = 0;
    public static final byte SM_NEW_RECORD = 70;
    public static final byte SM_OPTIONS = 20;
    public static final byte SM_OPTIONS_CREDITS = 21;
    public static final byte SM_OPTIONS_LANGUAGE = 22;
    public static final byte SM_PAUSE = 60;
    public static final byte SM_PLAY = 10;
    public static final byte SM_RECORD_NAME = 80;
    public static final byte SM_SCORES = 40;
    public static final byte SM_TIME_0UT = 121;
    public static final byte SND_BABY = 5;
    public static final byte SND_BIP = 7;
    public static final byte SND_BOOM_BAD = 3;
    public static final byte SND_BOOM_GOOD = 2;
    public static final byte SND_BOOM_ULTIME = 6;
    public static final byte SND_KLING = 4;
    public static final byte SND_LVL_UP = 1;
    public static final byte SND_MENU = 0;
    public static final byte S_EXIT = 0;
    public static final byte S_GAME = 5;
    public static final byte S_INTRO = 1;
    public static final byte S_INTRO_SCREEN = 3;
    public static final byte S_LOADING = 2;
    public static final byte S_MENU = 4;
    public static final int TPS_ATTENTE = 1000;
    public static final int TPS_HANDICAP = 3000;
    public static final int VITESSE = 20;
    private boolean _bBack;
    private boolean _bOk;
    private boolean _back;
    private byte _cpt;
    private int _cur_char;
    private String _cur_name;
    private boolean _curs;
    private int _curs_frame;
    private int _curs_x;
    private int _curs_y;
    private boolean _handicap;
    private long _lastpaint;
    private int _length_x;
    private int _length_y;
    private byte _nb_char;
    private boolean _ok;
    private boolean _paint;
    private byte _rank;
    private byte _state;
    private byte _stateLoaded;
    private byte _stateM;
    private byte _stateScore;
    private long _time;
    private long _time_handicap;
    private byte curMusic;
    private int firstPlayCeleb;
    private int firstPlayColor;
    private GameBoard gameboard = null;
    private Bitmap[] img_game;
    private Bitmap[] img_intro;
    private Bitmap[] img_intro_screen;
    private Bitmap[] img_loading;
    private Bitmap[] img_menu;
    public int isSound;
    private int isVibro;
    private int lang;
    private int lvl_celebrites;
    private int lvl_colors;
    private game midlet;
    public static MultiOutPut mu;
    private int[] score_celeb;
    private String[] score_celeb_name;
    private int[] score_colors;
    private String[] score_colors_name;
    public static Sound snd;
    public static Storage stor;

    static {
        stor = new Storage();
        mu = null;
        snd = null;
    }

    public GameScreen(game game2) {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = game2;
        this.gameInit();
        new Thread(this).start();
    }

    private int calcMenuAlign(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = mu.calcSize(n + n4);
            if (n5 > n3) {
                n3 = n5;
            }
            n4 = (byte)(n4 + 1);
        }
        return n3;
    }

    /*
     * Unable to fully structure code
     */
    public void drawGame(Graphics var1_1) {
        var1_1.setClip(0, 0, 240, 320);
        this.img_game[2].draw(var1_1, 0, 0, 4);
        var1_1.setClip(0, 0, this.img_game[3].getWidth(), this.img_game[3].getHeight());
        this.img_game[3].draw(var1_1, 0, 0, 4);
        GameScreen.mu.print(var1_1, 45, 10, new Integer(this.gameboard.getNbTapeRestant()).toString(), 0);
        GameScreen.mu.print(var1_1, 113, 25, new Integer(this.gameboard.getScore()).toString(), 0);
        GameScreen.mu.print(var1_1, 190, 10, new Integer(this.gameboard.getTimer()).toString(), 0);
        this.gameboard.draw(var1_1, this.img_game);
        if (this.gameboard.bebeTouche()) ** GOTO lbl-1000
        if (this.gameboard.getType() == 2 && this.gameboard.getTimer() % 2 == 0) {
            GameScreen.mu.print(var1_1, 120 - GameScreen.mu.calcSize(35) / 2, 320 - GameScreen.mu.iCharSizeY * 3 / 2, 35, 1);
        } else if (this.gameboard.bebeTouche()) {
            GameScreen.mu.print(var1_1, 120 - GameScreen.mu.calcSize(36) / 2, 320 - GameScreen.mu.iCharSizeY * 3 / 2, 36, 1);
        }
        if (this.gameboard.getNbTapeRestant() < 1) {
            if (this._handicap) {
                if (this.isVibro == 1) {
                    Display.getDisplay((MIDlet)this.midlet).vibrate(500);
                }
                this._time_handicap = System.currentTimeMillis();
                this._handicap = false;
            } else if (System.currentTimeMillis() - this._time_handicap > 3000L) {
                this.gameboard.resetMasse();
                this._handicap = true;
            } else {
                var1_1.setClip(0, 0, 240, 320);
                this.img_game[0].draw(var1_1, 0, 0, 4);
            }
        }
    }

    public void drawMenu(Graphics graphics) {
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(0, 0, 0);
        graphics.fillRect(0, 0, 240, 320);
        this.img_menu[2].draw(graphics, 120, 0, 4 + 1);
        switch (this._stateM) {
            case 50: {
                this.drawMenu(graphics, 11, this._length_y);
                int n = GameBoard.rand.nextInt() % 240;
                int n2 = GameBoard.rand.nextInt() % 320;
                this.img_menu[3].draw(graphics, n, n2, 2 + 1);
                break;
            }
            case 0: {
                this.drawMenu(graphics, 1, this._length_y);
                break;
            }
            case 10: {
                this._length_y = 3;
                int n = this.calcMenuAlign(6, this._length_y);
                int n3 = 160 - GameScreen.mu.iCharSizeY * this._length_y / 2;
                if (this._curs_y == 0) {
                    mu.print(graphics, 120 - n / 2, n3, 6, 1);
                } else {
                    mu.print(graphics, 120 - n / 2, n3, 6, 0);
                }
                mu.print(graphics, 120 - n / 2, n3 += GameScreen.mu.iCharSizeY, 34, 0);
                if (this._curs_y == 0 && this._curs_x > this.lvl_celebrites - 1) {
                    this._curs_x = 0;
                }
                int n4 = 0;
                while (n4 < this.lvl_celebrites) {
                    if (this._curs_x == n4 && this._curs_y == 0) {
                        mu.print(graphics, 120 + 2 * n4 * GameScreen.mu.iCharSizeX, n3, new Integer(n4 + 1).toString(), 1);
                    } else {
                        mu.print(graphics, 120 + 2 * n4 * GameScreen.mu.iCharSizeX, n3, new Integer(n4 + 1).toString(), 0);
                    }
                    n4 = (byte)(n4 + 1);
                }
                n = this.calcMenuAlign(6, this._length_y);
                n3 += 2 * GameScreen.mu.iCharSizeY;
                if (this._curs_y == 1) {
                    mu.print(graphics, 120 - n / 2, n3, 7, 1);
                } else {
                    mu.print(graphics, 120 - n / 2, n3, 7, 0);
                }
                mu.print(graphics, 120 - n / 2, n3 += GameScreen.mu.iCharSizeY, 34, 0);
                if (this._curs_y == 1 && this._curs_x > this.lvl_colors - 1) {
                    this._curs_x = 0;
                }
                int n5 = 0;
                while (n5 < this.lvl_colors) {
                    if (this._curs_x == n5 && this._curs_y == 1) {
                        mu.print(graphics, 120 + 2 * n5 * GameScreen.mu.iCharSizeX, n3, new Integer(n5 + 1).toString(), 1);
                    } else {
                        mu.print(graphics, 120 + 2 * n5 * GameScreen.mu.iCharSizeX, n3, new Integer(n5 + 1).toString(), 0);
                    }
                    n5 = (byte)(n5 + 1);
                }
                n3 += 2 * GameScreen.mu.iCharSizeY;
                if (this._curs_y == 2) {
                    mu.print(graphics, 120 - n / 2, n3, 8, 1);
                } else {
                    mu.print(graphics, 120 - n / 2, n3, 8, 0);
                }
                int n6 = 120 - n / 2 - this.img_menu[1].getWidth() / 2;
                int n7 = 160 - GameScreen.mu.iCharSizeY * this._length_y / 2 + GameScreen.mu.iCharSizeY * this._curs_y * 3;
                this.img_menu[1].drawFrame(graphics, n6, n7, this._curs_frame, 8);
                break;
            }
            case 20: {
                this.drawOptions(graphics);
                break;
            }
            case 21: {
                this.drawMenu(graphics, 21, this._length_y);
                break;
            }
            case 22: {
                graphics.setClip(0, 0, 240, 320);
                graphics.setColor(0, 0, 0);
                graphics.fillRect(0, 0, 240, 320);
                int n = 1;
                while (n < 7) {
                    int n8 = 120 + ((n - 1) / 3 * 2 - 1) * this.img_loading[0].getWidth() * 3 / 2;
                    int n9 = 160 + ((n - 1) % 3 - 1) * this.img_loading[0].getHeight() * 3 / 2;
                    if (this.lang == n) {
                        this.img_loading[0].drawFrame(graphics, n8, n9, (n - 1) * 2, 1 + 2);
                    } else {
                        this.img_loading[0].drawFrame(graphics, n8, n9, (n - 1) * 2 + 1, 1 + 2);
                    }
                    n = (byte)(n + 1);
                }
                break;
            }
            case 30: {
                this.drawMenu(graphics, 31, this._length_y);
                break;
            }
            case 40: {
                if (this._stateScore == 3) {
                    this.drawScore(graphics, 6, this.score_colors_name, this.score_colors);
                    break;
                }
                this.drawScore(graphics, 6, this.score_celeb_name, this.score_celeb);
                break;
            }
            case 60: {
                this.drawMenu(graphics, 9, this._length_y);
                break;
            }
            case 70: {
                graphics.setClip(0, 0, 240, 320);
                graphics.setColor(0, 0, 0);
                graphics.fillRect(0, 0, 240, 320);
                this.img_menu[0].draw(graphics, 120, 160, 2 + 1);
                int n = GameBoard.rand.nextInt() % 240;
                int n10 = GameBoard.rand.nextInt() % 320;
                this.img_menu[3].draw(graphics, n, n10, 2 + 1);
                break;
            }
            case 80: {
                char c = 'A';
                int n = 0;
                while (n <= 26) {
                    int n11 = 24 + n % 6 * 36;
                    int n12 = 80 + n / 6 * 36;
                    if (n == 26) {
                        c = '<';
                    }
                    if (c == this._cur_char) {
                        mu.printChar(graphics, n11, n12, c, 1);
                    } else {
                        mu.printChar(graphics, n11, n12, c, 0);
                    }
                    c = (char)(c + '\u0001');
                    n = (byte)(n + 1);
                }
                mu.print(graphics, 120 - mu.calcSize(this._cur_name) / 2, 320 - 3 * GameScreen.mu.iCharSizeY, this._cur_name, 1);
                break;
            }
            case 90: {
                mu.print(graphics, 120 - mu.calcSize(0) / 2, 160, 0, 1);
                break;
            }
            case 121: {
                mu.print(graphics, 120 - mu.calcSize(38) / 2, 160, 38, 1);
                break;
            }
            case 100: {
                this.drawMenu(graphics, 39, 9);
                break;
            }
            case 110: {
                this.drawMenu(graphics, 48, this._length_y);
                break;
            }
            case 120: {
                this.drawMenu(graphics, 57, this._length_y);
            }
        }
        if (this._bBack) {
            mu.print(graphics, 240 - mu.calcSize(18), 320 - GameScreen.mu.iCharSizeY, 18, 0);
        }
        if (this._bOk) {
            mu.print(graphics, 0, 320 - GameScreen.mu.iCharSizeY, 37, 0);
        }
    }

    private void drawMenu(Graphics graphics, int n, int n2) {
        int n3 = this.calcMenuAlign(n, n2);
        int n4 = 160 - GameScreen.mu.iCharSizeY * n2 / 2;
        if (n == 21) {
            int n5 = 0;
            while (n5 < n2) {
                if (n5 == 0 || n5 == 2 || n5 == 5 || n5 == 7) {
                    mu.print(graphics, 120 - n3 / 2, n4, n + n5, 1);
                } else {
                    mu.print(graphics, 120 - n3 / 2, n4, n + n5, 0);
                }
                n4 += GameScreen.mu.iCharSizeY;
                n5 = (byte)(n5 + 1);
            }
        } else {
            int n6 = 0;
            while (n6 < n2) {
                if (this._curs && this._curs_y == n6) {
                    mu.print(graphics, 120 - n3 / 2, n4, n + n6, 1);
                } else {
                    mu.print(graphics, 120 - n3 / 2, n4, n + n6, 0);
                }
                n4 += GameScreen.mu.iCharSizeY;
                n6 = (byte)(n6 + 1);
            }
        }
        if (this._curs) {
            int n7 = 120 - n3 / 2 - this.img_menu[1].getWidth() / 2;
            int n8 = 160 - GameScreen.mu.iCharSizeY * n2 / 2 + GameScreen.mu.iCharSizeY * this._curs_y;
            this.img_menu[1].drawFrame(graphics, n7, n8, this._curs_frame, 8);
        }
    }

    public void drawOptions(Graphics graphics) {
        int n = this.calcMenuAlign(14, 5);
        int n2 = 160 - GameScreen.mu.iCharSizeY * 5 / 2;
        int n3 = 0;
        while (n3 < 5) {
            int n4 = n3 == this._curs_y ? 1 : 0;
            if (n3 == 1 && this.isSound == 1) {
                mu.print(graphics, 120 - n / 2, n2, 19, n4);
            } else if (n3 == 2 && this.isVibro == 1) {
                mu.print(graphics, 120 - n / 2, n2, 20, n4);
            } else {
                mu.print(graphics, 120 - n / 2, n2, 14 + n3, n4);
            }
            n2 += GameScreen.mu.iCharSizeY;
            n3 = (byte)(n3 + 1);
        }
        int n5 = 120 - n / 2 - this.img_menu[1].getWidth() / 2;
        int n6 = 160 - GameScreen.mu.iCharSizeY * 5 / 2 + GameScreen.mu.iCharSizeY * this._curs_y;
        this.img_menu[1].drawFrame(graphics, n5, n6, this._curs_frame, 8);
    }

    private void drawScore(Graphics graphics, int n, String[] stringArray, int[] nArray) {
        int n2 = 160 - GameScreen.mu.iCharSizeY * n / 2 - GameScreen.mu.iCharSizeY;
        int n3 = 30;
        if (this._stateScore == 1) {
            mu.print(graphics, 120 - mu.calcSize(6) / 2, n2, 6, 1);
        } else {
            mu.print(graphics, 120 - mu.calcSize(7) / 2, n2, 7, 1);
        }
        n2 = 160 - GameScreen.mu.iCharSizeY * n / 2;
        int n4 = 1;
        while (n4 < 6) {
            mu.print(graphics, n3, n2 += GameScreen.mu.iCharSizeY, stringArray[n4 - 1], 1);
            mu.print(graphics, 240 - GameScreen.mu.iCharSizeY * 4, n2, new Integer(nArray[n4 - 1]).toString(), 1);
            n4 = (byte)(n4 + 1);
        }
        mu.print(graphics, 240 - mu.calcSize(18), 320 - GameScreen.mu.iCharSizeY, 18, 1);
    }

    public static void free(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                objectArray[n] = null;
                n = (byte)(n + 1);
            }
            objectArray = null;
            System.gc();
        }
    }

    public void gameExit() {
        this.saveRecords();
        if (this.gameboard != null) {
            this.gameboard.free();
            this.gameboard = null;
        }
        GameScreen.free(this.img_intro);
        GameScreen.free(this.img_loading);
        GameScreen.free(this.img_intro_screen);
        GameScreen.free(this.img_menu);
        GameScreen.free(this.img_game);
        mu = null;
        if (snd != null) {
            snd.Stop_Music();
            snd = null;
        }
        System.gc();
        this.midlet.destroyApp(false);
    }

    void gameInit() {
        this.loadRecords();
        mu = new MultiOutPut(240, 320);
        snd = new Sound(this);
        this.loadSound();
        this.setState((byte)1);
        this._handicap = true;
        this._stateLoaded = (byte)-1;
    }

    protected void hideNotify() {
        this.gameExit();
        this.midlet.destroyApp(false);
    }

    public void keyPressed(int n) {
        Keyboard.keyPressed(n);
    }

    public void keyReleased(int n) {
        Keyboard.keyReleased(n);
    }

    public void loadImg(byte by) {
        if (by != this._stateLoaded) {
            this._stateLoaded = by;
            switch (by) {
                case 1: {
                    GameScreen.free(this.img_loading);
                    GameScreen.free(this.img_intro_screen);
                    GameScreen.free(this.img_menu);
                    GameScreen.free(this.img_game);
                    this.img_intro = new Bitmap[1];
                    this.img_intro[0] = new Bitmap(240, 320, "/gfx/intro_mediaplazza.png", 1, 1);
                    break;
                }
                case 3: {
                    GameScreen.free(this.img_intro);
                    GameScreen.free(this.img_loading);
                    GameScreen.free(this.img_menu);
                    GameScreen.free(this.img_game);
                    this.img_intro_screen = new Bitmap[1];
                    this.img_intro_screen[0] = new Bitmap(240, 320, "/gfx/intro_screen.png", 1, 1);
                    break;
                }
                case 4: {
                    GameScreen.free(this.img_intro);
                    GameScreen.free(this.img_intro_screen);
                    GameScreen.free(this.img_game);
                    this.img_loading = new Bitmap[1];
                    this.img_loading[0] = new Bitmap(240, 320, "/gfx/loading_flags.png", 2, 6);
                    this.img_menu = new Bitmap[4];
                    this.img_menu[0] = new Bitmap(240, 320, "/gfx/menu_cup.png", 1, 1);
                    this.img_menu[1] = new Bitmap(240, 320, "/gfx/menu_curseur.png", 4, 1);
                    this.img_menu[2] = new Bitmap(240, 320, "/gfx/menu_screen.png", 1, 1);
                    this.img_menu[3] = new Bitmap(240, 320, "/gfx/menu_sparkle1.png", 1, 1);
                    break;
                }
                case 5: {
                    GameScreen.free(this.img_intro);
                    GameScreen.free(this.img_loading);
                    GameScreen.free(this.img_intro_screen);
                    GameScreen.free(this.img_menu);
                    if (this.gameboard.getType() == 3) {
                        this.img_game = new Bitmap[14];
                        this.img_game[11] = new Bitmap(240, 320, "/gfx/game_color_bar.png", 1, 1);
                        this.img_game[12] = new Bitmap(240, 320, "/gfx/game_colors.png", 5, 1);
                        this.img_game[13] = new Bitmap(240, 320, "/gfx/game_colors_big.png", 5, 1);
                    } else {
                        this.img_game = new Bitmap[18];
                        this.img_game[11] = new Bitmap(240, 320, "/gfx/game_bebe.png", 1, 1);
                        this.img_game[12] = new Bitmap(240, 320, "/gfx/game_black_masse.png", 3, 1);
                        this.img_game[13] = new Bitmap(240, 320, "/gfx/game_clock.png", 1, 1);
                        this.img_game[14] = new Bitmap(240, 320, "/gfx/game_famille.png", 12, 3);
                        this.img_game[15] = new Bitmap(240, 320, "/gfx/game_-200.png", 1, 1);
                        this.img_game[16] = new Bitmap(240, 320, "/gfx/game_+200.png", 1, 1);
                        this.img_game[17] = new Bitmap(240, 320, "/gfx/game_-10s.png", 1, 1);
                    }
                    this.img_game[2] = new Bitmap(240, 320, "/gfx/game_screen.png", 1, 1);
                    this.img_game[3] = new Bitmap(240, 320, "/gfx/game_screen_bar.png", 1, 1);
                    this.img_game[4] = new Bitmap(240, 320, "/gfx/game_screen_cache1.png", 1, 1);
                    this.img_game[5] = new Bitmap(240, 320, "/gfx/game_screen_cache2.png", 1, 1);
                    this.img_game[6] = new Bitmap(240, 320, "/gfx/game_screen_cache3.png", 1, 1);
                    this.img_game[7] = new Bitmap(240, 320, "/gfx/game_splash.png", 1, 1);
                    this.img_game[8] = new Bitmap(240, 320, "/gfx/game_splash_big.png", 1, 1);
                    this.img_game[10] = new Bitmap(240, 320, "/gfx/game_+100.png", 1, 1);
                    this.img_game[9] = new Bitmap(240, 320, "/gfx/game_-100.png", 1, 1);
                    this.img_game[0] = new Bitmap(240, 320, "/gfx/game_kliing.png", 1, 1);
                    this.img_game[1] = new Bitmap(240, 320, "/gfx/game_masse.png", 3, 1);
                }
            }
            System.gc();
        }
    }

    void loadRecords() {
        try {
            this.lang = Integer.parseInt(stor.sGet(0));
            this.isSound = Integer.parseInt(stor.sGet(1));
            this.isVibro = Integer.parseInt(stor.sGet(2));
            this.lvl_celebrites = Integer.parseInt(stor.sGet(3));
            if (this.lvl_celebrites == 0) {
                this.lvl_celebrites = 1;
            }
            this.lvl_colors = Integer.parseInt(stor.sGet(4));
            if (this.lvl_colors == 0) {
                this.lvl_colors = 1;
            }
            this.score_celeb = new int[5];
            this.score_colors = new int[5];
            this.score_celeb_name = new String[5];
            this.score_colors_name = new String[5];
            if (stor.sGet(15) == null || stor.sGet(15) == "0") {
                this.resetScore();
            } else {
                int n = 0;
                while (n < 5) {
                    this.score_celeb[n] = Integer.parseInt(stor.sGet(5 + n));
                    this.score_colors[n] = Integer.parseInt(stor.sGet(10 + n));
                    this.score_celeb_name[n] = stor.sGet(15 + n);
                    this.score_colors_name[n] = stor.sGet(20 + n);
                    n = (byte)(n + 1);
                }
            }
            this.firstPlayCeleb = Integer.parseInt(stor.sGet(25));
            this.firstPlayColor = Integer.parseInt(stor.sGet(26));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    private void loadSound() {
        snd.Load("/level/menu.mid", true, true, 0);
        snd.Load("/level/lvl_up.mid", true, false, 1);
        snd.Load("/level/boom_good.wav", false, false, 2);
        snd.Load("/level/boom_bad.wav", false, false, 3);
        snd.Load("/level/kling.wav", false, false, 4);
        snd.Load("/level/baby.wav", false, false, 5);
        snd.Load("/level/boom_ultime.wav", false, false, 6);
        snd.Load("/level/bip.wav", false, false, 7);
    }

    public void paint(Graphics graphics) {
        if (this._paint) {
            return;
        }
        this._paint = true;
        this.loadImg(this._state);
        switch (this._state) {
            case 1: {
                graphics.setClip(0, 0, 240, 320);
                graphics.setColor(255, 255, 255);
                graphics.fillRect(0, 0, 240, 320);
                this.img_intro[0].draw(graphics, 120, 160, 2 + 1);
                break;
            }
            case 3: {
                graphics.setClip(0, 0, 240, 320);
                graphics.setColor(0, 0, 0);
                graphics.fillRect(0, 0, 240, 320);
                this.img_intro_screen[0].draw(graphics, 120, 0, 4 + 1);
                break;
            }
            case 4: {
                this.drawMenu(graphics);
                break;
            }
            case 5: {
                this.drawGame(graphics);
            }
        }
        if (System.currentTimeMillis() - this._lastpaint < 30L) {
            try {
                Thread.sleep(30L - (System.currentTimeMillis() - this._lastpaint));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._paint = false;
    }

    void resetScore() {
        this.lvl_celebrites = 1;
        this.lvl_colors = 1;
        int n = 0;
        while (n < 5) {
            this.score_celeb[n] = 0;
            this.score_colors[n] = 0;
            this.score_celeb_name[n] = "AAA";
            this.score_colors_name[n] = "AAA";
            n = (byte)(n + 1);
        }
        this.saveRecords();
    }

    public void run() {
        while (this._state != 0) {
            this._lastpaint = System.currentTimeMillis();
            this.repaint();
            this.update();
            this.serviceRepaints();
        }
        this.gameExit();
    }

    void saveRecords() {
        try {
            stor.set(0, this.lang);
            stor.set(1, this.isSound);
            stor.set(2, this.isVibro);
            stor.set(3, this.lvl_celebrites);
            stor.set(4, this.lvl_colors);
            int n = 0;
            while (n < 5) {
                stor.set(5 + n, this.score_celeb[n]);
                stor.set(10 + n, this.score_colors[n]);
                stor.set(15 + n, this.score_celeb_name[n]);
                stor.set(20 + n, this.score_colors_name[n]);
                n = (byte)(n + 1);
            }
            stor.set(25, this.firstPlayCeleb);
            stor.set(26, this.firstPlayColor);
            stor.save();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void setGameState() {
        snd.Stop_Music();
        this.setState((byte)5);
        this._time = System.currentTimeMillis();
    }

    public void setMenuState(byte by) {
        this.curMusic = by == 50 ? (byte)1 : 0;
        if (this._state != 4 || by == 50) {
            if (this._state != 3) {
                snd.Stop_Music();
            }
            snd.Start_Music(this.curMusic);
        }
        this.setState((byte)4);
        this._stateM = by;
        this._curs = false;
        this._cur_char = 65;
        this._nb_char = 0;
        this._cur_name = "";
        this._bBack = false;
        this._bOk = false;
        if (by != 60) {
            this._time = System.currentTimeMillis();
        }
    }

    public void setRecordName(String string) {
        if (this._stateScore == 3) {
            this.score_colors_name[this._rank + 1] = string;
        } else {
            this.score_celeb_name[this._rank + 1] = string;
        }
        this.saveRecords();
    }

    public void setState(byte by) {
        this._state = by;
        this._cpt = 0;
        this._curs_y = 0;
        this._curs_x = 0;
        this._curs_frame = 0;
        this._length_x = 0;
        this._length_y = 0;
    }

    public static void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void update() {
        switch (this._state) {
            case 1: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this._time <= 2000L) break;
                this.setState((byte)2);
                break;
            }
            case 2: {
                if (this.lang == 0) {
                    this.lang = 1;
                    mu.setLanguage(0);
                    this.resetScore();
                    this.setMenuState((byte)22);
                    break;
                }
                mu.setLanguage(this.lang - 1);
                this.setState((byte)3);
                break;
            }
            case 3: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this._time <= 1000L) break;
                this.setMenuState((byte)0);
                break;
            }
            case 4: {
                this.updateMenu();
                break;
            }
            case 5: {
                this.updateGame();
            }
        }
    }

    public void updateGame() {
        this.gameboard.update();
        if (this.gameboard.getTimer() < 1) {
            this.setMenuState((byte)121);
            return;
        }
        if (Keyboard.pressed && (Keyboard.menuLeft || Keyboard.menuRight)) {
            Keyboard.resetKeys();
            this.setMenuState((byte)60);
        }
        if (this.gameboard.getNbTapeRestant() < 1) {
            return;
        }
        if (this.gameboard.isAllDead() && this.gameboard.masseEnBas()) {
            if (this.gameboard.getLvl() == 4) {
                this.updateScore();
            } else {
                this.setMenuState((byte)50);
                if ((this.gameboard.getType() == 1 || this.gameboard.getType() == 2) && this.gameboard.getLvl() + 1 > this.lvl_celebrites) {
                    ++this.lvl_celebrites;
                    this.saveRecords();
                } else if (this.gameboard.getType() == 3 && this.gameboard.getLvl() + 1 > this.lvl_colors) {
                    ++this.lvl_colors;
                    this.saveRecords();
                }
                this.gameboard.reset(false);
                this.gameboard.initialiser(this.gameboard.getType(), this.gameboard.getLvl() + 1, 4, 20, 1000);
            }
        }
        if (Keyboard.pressed) {
            if (Keyboard.nbrPress > 0 && Keyboard.nbrPress < 10) {
                this.gameboard.taper(Keyboard.nbrPress - 1);
            }
            Keyboard.resetKeys();
        }
    }

    public void updateMenu() {
        this._back = false;
        this._ok = false;
        if (Keyboard.pressed) {
            if (Keyboard.menuRight) {
                this._back = true;
                Keyboard.resetKeys();
            } else if (Keyboard.nbrPress == 5 || Keyboard.middle || Keyboard.menuLeft) {
                this._ok = true;
                Keyboard.resetKeys();
            }
        }
        switch (this._stateM) {
            case 50: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                    this._length_y = 3;
                }
                if (!this._ok && System.currentTimeMillis() - this._time <= 2000L) break;
                this.setGameState();
                break;
            }
            case 40: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 5;
                }
                if (this._back || this._ok) {
                    this.setMenuState((byte)0);
                    break;
                }
                if (!Keyboard.pressed) break;
                if (Keyboard.right || Keyboard.nbrPress == 6 || Keyboard.left || Keyboard.nbrPress == 4) {
                    this._stateScore = this._stateScore == 1 ? (byte)3 : (byte)1;
                }
                Keyboard.resetKeys();
                break;
            }
            case 0: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 5;
                    this._curs = true;
                }
                if (!this._ok) break;
                switch (this._curs_y) {
                    case 0: {
                        this.setMenuState((byte)10);
                        break;
                    }
                    case 1: {
                        this.setMenuState((byte)20);
                        break;
                    }
                    case 2: {
                        this.setMenuState((byte)30);
                        break;
                    }
                    case 3: {
                        this._stateScore = 1;
                        this.setMenuState((byte)40);
                        break;
                    }
                    case 4: {
                        this.setState((byte)0);
                    }
                }
                break;
            }
            case 10: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 3;
                    this._length_x = 4;
                    this._curs = true;
                }
                if (this._ok) {
                    switch (this._curs_y) {
                        case 0: {
                            if (this.gameboard != null) {
                                this.gameboard.free();
                                this.gameboard = null;
                                System.gc();
                            }
                            this.gameboard = new GameBoard();
                            this.gameboard.reset(true);
                            this.gameboard.initialiser((byte)1, this._curs_x + 1, 4, 20, 1000);
                            if (this.firstPlayCeleb > 0) {
                                this.setMenuState((byte)90);
                                break;
                            }
                            this.setMenuState((byte)100);
                            break;
                        }
                        case 1: {
                            if (this.gameboard != null) {
                                this.gameboard.free();
                                this.gameboard = null;
                                System.gc();
                            }
                            this.gameboard = new GameBoard();
                            this.gameboard.reset(true);
                            this.gameboard.initialiser((byte)3, this._curs_x + 1, 5, 20, 1000);
                            if (this.firstPlayColor > 0) {
                                this.setMenuState((byte)90);
                                break;
                            }
                            this.setMenuState((byte)110);
                            break;
                        }
                        case 2: {
                            this.setMenuState((byte)0);
                        }
                    }
                    break;
                }
                if (this._back) {
                    this.setMenuState((byte)0);
                    break;
                }
                if (!Keyboard.pressed) break;
                if (Keyboard.nbrPress == 4 || Keyboard.left) {
                    --this._curs_x;
                    if (this._curs_y == 0 && this._curs_x < 0) {
                        this._curs_x = this.lvl_celebrites - 1;
                    } else if (this._curs_y == 1 && this._curs_x < 0) {
                        this._curs_x = this.lvl_colors - 1;
                    }
                    Keyboard.resetKeys();
                    break;
                }
                if (Keyboard.nbrPress != 6 && !Keyboard.right) break;
                ++this._curs_x;
                if (this._curs_y == 0 && this._curs_x >= this.lvl_celebrites) {
                    this._curs_x = 0;
                } else if (this._curs_y == 1 && this._curs_x >= this.lvl_colors) {
                    this._curs_x = 0;
                }
                Keyboard.resetKeys();
                break;
            }
            case 20: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 5;
                    this._bBack = true;
                    this._bOk = true;
                    this._curs = true;
                }
                if (this._ok) {
                    switch (this._curs_y) {
                        case 0: {
                            this.setMenuState((byte)21);
                            break;
                        }
                        case 1: {
                            this.isSound = (this.isSound + 1) % 2;
                            if (this.isSound == 0) {
                                snd.Stop_Music();
                                break;
                            }
                            snd.Start_Music(0);
                            break;
                        }
                        case 2: {
                            this.isVibro = (this.isVibro + 1) % 2;
                            break;
                        }
                        case 3: {
                            this.setMenuState((byte)22);
                            break;
                        }
                        case 4: {
                            this.setMenuState((byte)0);
                        }
                    }
                    break;
                }
                if (!this._back) break;
                this.setMenuState((byte)0);
                break;
            }
            case 21: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 10;
                    this._bBack = true;
                }
                if (!this._ok && !this._back) break;
                this.setMenuState((byte)20);
                break;
            }
            case 22: {
                if (this._ok) {
                    this.saveRecords();
                    mu.setLanguage(this.lang - 1);
                    this.firstPlayCeleb = 0;
                    this.firstPlayColor = 0;
                    this.setState((byte)3);
                    break;
                }
                if (this._back) {
                    this.setMenuState((byte)20);
                    break;
                }
                if (!Keyboard.pressed) break;
                if (Keyboard.up || Keyboard.nbrPress == 2) {
                    --this.lang;
                    if (this.lang < 1) {
                        this.lang = 6;
                    }
                } else if (Keyboard.down || Keyboard.nbrPress == 8) {
                    ++this.lang;
                    if (this.lang > 6) {
                        this.lang = 1;
                    }
                } else if (Keyboard.right || Keyboard.nbrPress == 6) {
                    this.lang += 3;
                    if (this.lang > 6) {
                        this.lang -= 6;
                    }
                } else if (Keyboard.left || Keyboard.nbrPress == 4) {
                    this.lang -= 3;
                    if (this.lang < 1) {
                        this.lang += 6;
                    }
                }
                Keyboard.resetKeys();
                break;
            }
            case 30: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 3;
                    this._bOk = true;
                    this._bBack = true;
                    this._curs = true;
                }
                if (this._back) {
                    this.setMenuState((byte)0);
                    break;
                }
                if (!this._ok) break;
                switch (this._curs_y) {
                    case 0: {
                        this.setMenuState((byte)120);
                        break;
                    }
                    case 1: {
                        this.setMenuState((byte)100);
                        break;
                    }
                    case 2: {
                        this.setMenuState((byte)110);
                    }
                }
                break;
            }
            case 60: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 2;
                    this._curs = true;
                }
                if (this._back) {
                    this.setGameState();
                    break;
                }
                if (!this._ok) break;
                switch (this._curs_y) {
                    case 0: {
                        this.setGameState();
                        break;
                    }
                    case 1: {
                        if (this.gameboard != null) {
                            this.gameboard.free();
                            this.gameboard = null;
                            System.gc();
                        }
                        this.setMenuState((byte)0);
                    }
                }
                break;
            }
            case 70: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                    return;
                }
                if (System.currentTimeMillis() - this._time < 2000L) {
                    return;
                }
                this.setMenuState((byte)80);
                break;
            }
            case 80: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_x = 6;
                    this._length_y = 5;
                    this._bOk = true;
                    this._bBack = true;
                }
                if (this._back && this._nb_char > 0) {
                    this._nb_char = (byte)(this._nb_char - 1);
                    this._cur_name = this._cur_name.substring(0, this._nb_char);
                    break;
                }
                if (!this._ok) break;
                if (this._nb_char == 3) {
                    this.setRecordName(this._cur_name);
                    this.setMenuState((byte)40);
                    break;
                }
                if (this._cur_char == 60 && this._nb_char > 0) {
                    this._nb_char = (byte)(this._nb_char - 1);
                    this._cur_name = this._cur_name.substring(0, this._nb_char);
                    break;
                }
                this._cur_name = this._cur_name + "" + (char)this._cur_char;
                this._nb_char = (byte)(this._nb_char + 1);
                break;
            }
            case 90: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                    this._length_y = 1;
                }
                if (!this._ok && !this._back && System.currentTimeMillis() - this._time <= 1000L) break;
                this.setGameState();
                break;
            }
            case 121: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._time = System.currentTimeMillis();
                    this._length_y = 1;
                }
                if (!this._ok && !this._back && System.currentTimeMillis() - this._time <= 1000L) break;
                this.updateScore();
                break;
            }
            case 100: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 9;
                }
                if (!this._ok && !this._back) break;
                if (this.firstPlayCeleb == 0 && this.gameboard != null) {
                    ++this.firstPlayCeleb;
                    this.setGameState();
                    break;
                }
                this.setMenuState((byte)30);
                break;
            }
            case 110: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 9;
                }
                if (!this._ok && !this._back) break;
                if (this.firstPlayColor == 0 && this.gameboard != null) {
                    ++this.firstPlayColor;
                    this.setGameState();
                    break;
                }
                this.setMenuState((byte)30);
                break;
            }
            case 120: {
                if (this._cpt == 0) {
                    this._cpt = (byte)(this._cpt + 1);
                    this._length_y = 6;
                }
                if (!this._ok && !this._back) break;
                this.setMenuState((byte)30);
            }
        }
        if (Keyboard.pressed) {
            if (Keyboard.nbrPress == 2 || Keyboard.up) {
                if (this._stateM != 80) {
                    this._curs_x = 0;
                }
                --this._curs_y;
                if (this._curs_y < 0) {
                    this._curs_y = this._stateM == 80 && this._curs_x >= 3 ? this._length_y - 2 : this._length_y - 1;
                }
            } else if (Keyboard.nbrPress == 8 || Keyboard.down) {
                if (this._stateM != 80) {
                    this._curs_x = 0;
                }
                ++this._curs_y;
                if (this._curs_y >= this._length_y || this._stateM == 80 && this._curs_y >= this._length_y - 1 && this._curs_x >= 3) {
                    this._curs_y = 0;
                }
            } else if (Keyboard.nbrPress == 4 || Keyboard.left) {
                --this._curs_x;
                if (this._curs_x < 0) {
                    this._curs_x = this._stateM == 80 && this._curs_y == this._length_y - 1 ? 2 : this._length_x - 1;
                }
            } else if (Keyboard.nbrPress == 6 || Keyboard.right) {
                ++this._curs_x;
                if (this._curs_x >= this._length_x || this._stateM == 80 && this._curs_y == this._length_y - 1 && this._curs_x == 3) {
                    this._curs_x = 0;
                }
            }
            this._cur_char = 65 + this._length_x * this._curs_y + this._curs_x;
            if (this._cur_char == 91) {
                this._cur_char = 60;
            }
            Keyboard.resetKeys();
        }
        if (this._curs && System.currentTimeMillis() - this._time > 100L) {
            this._time = System.currentTimeMillis();
            this._curs_frame = (this._curs_frame + 1) % 4;
        }
    }

    public void updateScore() {
        this._rank = (byte)4;
        switch (this.gameboard.getType()) {
            case 1: 
            case 2: {
                while (this._rank >= 0 && this.gameboard.getScore() > this.score_celeb[this._rank]) {
                    this._rank = (byte)(this._rank - 1);
                }
                if (this._rank == 4) {
                    this.setMenuState((byte)0);
                    return;
                }
                int n = 4;
                while (n > this._rank + 1) {
                    this.score_celeb[n] = this.score_celeb[n - 1];
                    this.score_celeb_name[n] = this.score_celeb_name[n - 1];
                    n = (byte)(n - 1);
                }
                this.score_celeb[this._rank + 1] = this.gameboard.getScore();
                this.score_celeb_name[this._rank + 1] = "AAA";
                this._stateScore = 1;
                this.setMenuState((byte)70);
                break;
            }
            case 3: {
                while (this._rank >= 0 && this.gameboard.getScore() > this.score_colors[this._rank]) {
                    this._rank = (byte)(this._rank - 1);
                }
                if (this._rank == 4) {
                    this.setMenuState((byte)0);
                    return;
                }
                int n = 4;
                while (n > this._rank + 1) {
                    this.score_colors[n] = this.score_colors[n - 1];
                    this.score_colors_name[n] = this.score_colors_name[n - 1];
                    n = (byte)(n - 1);
                }
                this.score_colors[this._rank + 1] = this.gameboard.getScore();
                this.score_colors_name[this._rank + 1] = "AAA";
                this._stateScore = (byte)3;
                this.setMenuState((byte)70);
            }
        }
        if (this.gameboard != null) {
            this.gameboard.free();
            this.gameboard = null;
            System.gc();
        }
    }
}

