/*
 * Decompiled with CFR 0.152.
 */
package game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Bitmap {
    private String _URL;
    private int _height;
    private Image _image;
    private int _nbrFrames;
    private int _nbrFramesX;
    private int _nbrFramesY;
    private int _screenHeight;
    private int _screenWidth;
    private int _width;

    public Bitmap(int n, int n2, String string, int n3, int n4) {
        this._screenWidth = n;
        this._screenHeight = n2;
        this._URL = string;
        this._nbrFramesX = n3;
        if (n3 < 1) {
            this._nbrFramesX = 1;
        }
        this._nbrFramesY = n4;
        if (n4 < 1) {
            this._nbrFramesY = 1;
        }
        this._nbrFrames = n3 * n4;
        this.load();
    }

    void deload() {
        this._image = null;
        this._width = 0;
        this._height = 0;
        System.gc();
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        if (this._image == null) {
            return;
        }
        if ((n3 & 8) != 0) {
            n -= this._width;
        }
        if ((n3 & 0x20) != 0) {
            n2 -= this._height;
        }
        if ((n3 & 1) != 0) {
            n -= this._width >> 1;
        }
        if ((n3 & 2) != 0) {
            n2 -= this._height >> 1;
        }
        graphics.drawImage(this._image, n, n2, 16 + 4);
    }

    void drawFrame(Graphics graphics, int n, int n2, int n3, int n4) {
        if (this._image == null) {
            return;
        }
        int n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        if (n3 >= this._nbrFrames || n3 < 0) {
            System.out.println("Error invalid frameID for " + this._URL + " FRAME:" + n3);
            return;
        }
        if ((n4 & 8) != 0) {
            n -= this._width;
        }
        if ((n4 & 0x20) != 0) {
            n2 -= this._height;
        }
        if ((n4 & 1) != 0) {
            n -= this._width >> 1;
        }
        if ((n4 & 2) != 0) {
            n2 -= this._height >> 1;
        }
        graphics.drawRegion(this._image, n3 % this._nbrFramesX * this._width, n3 / this._nbrFramesX * this._height, this._width, this._height, 0, n, n2, 4 + 16);
    }

    public int getHeight() {
        return this._height;
    }

    public String getImageURL() {
        return this._URL;
    }

    public int getNbFramesX() {
        return this._nbrFramesX;
    }

    public int getNbFramesY() {
        return this._nbrFramesY;
    }

    public int getWidth() {
        return this._width;
    }

    void load() {
        try {
            this._image = Image.createImage((String)this._URL);
            this._width = this._image.getWidth() / this._nbrFramesX;
            this._height = this._image.getHeight() / this._nbrFramesY;
        }
        catch (Exception exception) {
            System.out.println("Error Bitmap Loading : " + this._URL);
        }
    }
}

