/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.JumpUpMidlet;
import cc.jmap.games.Platform;
import cc.jmap.games.SoundPlayer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Actor
extends GameObject {
    private static final int IMG_HOLD = 0;
    private static final int IMG_UP = 1;
    private static final int IMG_TOP = 2;
    private static final int IMG_DOWN = 3;
    private static final int IMG_FALL = 4;
    private static final int IMG_HIT = 5;
    private static final int IMG_UP_ROCKET_1 = 6;
    private static final int IMG_UP_ROCKET_2 = 7;
    public static final int STATE_PLAY = 0;
    public static final int STATE_HIT = 1;
    public static final int STATE_FALL = 2;
    private int state = 0;
    public int velocityX = 0;
    public int velocityH = 0;
    private int lastX = 0;
    private int lastH = 0;
    private int holdCount = 0;
    private int rocketCount = 0;

    public Actor() {
        this.type = 1;
        this.reset();
    }

    public void reset() {
        this.velocityX = 0;
        this.velocityH = 0;
        this.lastX = 0;
        this.lastH = 0;
        this.posX = 180;
        this.posH = 150;
        this.holdCount = 0;
        this.state = 0;
    }

    public int getState() {
        return this.state;
    }

    public void setVelocityX(double value) {
        if (this.state == 0) {
            this.velocityX = (int)(-1.0 * value / 3.0);
            if (this.velocityX > 100) {
                this.velocityX = 100;
            } else if (this.velocityX < -100) {
                this.velocityX = -100;
            }
        }
    }

    public void step() {
        this.lastX = this.posX;
        this.lastH = this.posH;
        this.posX += this.velocityX;
        if (this.posX > 360 && this.velocityX > 0) {
            this.posX -= 360;
        } else if (this.posX < 0 && this.velocityX < 0) {
            this.posX += 360;
        }
        this.velocityH -= 4;
        this.posH = this.state == 0 && this.velocityH > 50 ? (this.posH += 50) : (this.velocityH < -88 ? (this.posH -= 88) : (this.posH += this.velocityH));
    }

    public boolean checkFall() {
        boolean flag = false;
        if (this.posH - GameLogic.height < -60 && this.state == 0) {
            this.state = 2;
            this.velocityH = 80;
            this.velocityX = 0;
            GameLogic.setGameOverScore();
            SoundPlayer.playFile(6);
            flag = true;
        } else if (this.velocityH < -80 && this.state == 1) {
            this.state = 2;
            flag = true;
        }
        return flag;
    }

    public boolean checkBounce(Platform p) {
        if (this.lastH >= this.posH && this.lastH >= p.posH && p.posH >= this.posH && this.posX > p.posX - 45 && this.posX < p.posX + 45) {
            if (p.ptype == 1) {
                p.stepOn();
                this.fly(p.posH);
                SoundPlayer.playFile(5);
                JumpUpMidlet.vibrate();
            } else if (p.ptype == 0 || p.ptype == 2 || p.ptype == 3) {
                p.stepOn();
                this.jump(p.posH);
                SoundPlayer.playFile(1);
            } else if (p.ptype == 4) {
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean checkHit(Platform p) {
        if (p == null) {
            return false;
        }
        int phalfx = 30;
        int h = 50;
        if (p.enemy == 1 || p.enemy == 2) {
            phalfx = 23;
            h = 62;
        }
        int px1 = p.posX - phalfx;
        int py1 = p.posH + h;
        int px2 = p.posX + phalfx;
        int py2 = p.posH;
        int ax1 = this.posX - 23;
        int ay1 = this.posH + 53;
        int ax2 = this.posX + 23;
        int ay2 = this.posH + 5;
        int ax3 = this.posX + 23;
        int ay3 = this.posH + 53;
        int ax4 = this.posX - 23;
        int ay4 = this.posH + 5;
        boolean flag = false;
        if (px1 < ax1 && ax1 < px2 && py1 > ay1 && ay1 > py2) {
            flag = true;
        } else if (px1 < ax2 && ax2 < px2 && py1 > ay2 && ay2 > py2) {
            flag = true;
        } else if (px1 < ax3 && ax3 < px2 && py1 > ay3 && ay3 > py2) {
            flag = true;
        } else if (px1 < ax4 && ax4 < px2 && py1 > ay4 && ay4 > py2) {
            flag = true;
        }
        if (flag) {
            this.hitted();
            return true;
        }
        return false;
    }

    public void hitted() {
        SoundPlayer.playFile(2);
        this.state = 1;
        this.velocityH = 60;
        this.velocityX = 0;
        GameLogic.setGameOverScore();
        JumpUpMidlet.vibrate();
    }

    public boolean checkEat(Platform p) {
        if (p == null) {
            return false;
        }
        int phalfx = 30;
        int h = 50;
        int px1 = p.posX - phalfx;
        int py1 = p.posH + h;
        int px2 = p.posX + phalfx;
        int py2 = p.posH;
        int ax1 = this.posX - 23;
        int ay1 = this.posH + 53;
        int ax2 = this.posX + 23;
        int ay2 = this.posH + 5;
        int ax3 = this.posX + 23;
        int ay3 = this.posH + 53;
        int ax4 = this.posX - 23;
        int ay4 = this.posH + 5;
        boolean flag = false;
        if (px1 < ax1 && ax1 < px2 && py1 > ay1 && ay1 > py2) {
            flag = true;
        } else if (px1 < ax2 && ax2 < px2 && py1 > ay2 && ay2 > py2) {
            flag = true;
        } else if (px1 < ax3 && ax3 < px2 && py1 > ay3 && ay3 > py2) {
            flag = true;
        } else if (px1 < ax4 && ax4 < px2 && py1 > ay4 && ay4 > py2) {
            flag = true;
        }
        if (flag) {
            this.ate(p);
            return true;
        }
        return false;
    }

    public void ate(Platform p) {
        if (p.bonusScoreIndex == 0) {
            SoundPlayer.playFile(3);
            JumpUpMidlet.vibrate();
            p.eatBonus();
        }
    }

    public void jump(int posH) {
        this.velocityH = 44;
        this.posH = posH;
        this.holdCount = 2;
    }

    public void fly(int posH) {
        this.velocityH = 132;
        this.posH = posH;
        this.holdCount = 2;
    }

    public boolean isDown() {
        return this.velocityH < -2;
    }

    public void draw(Graphics g, GameCanvas canvas) {
        if (this.state == 1) {
            Image aimg = GameObject.actorImgs[5];
            g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
        } else if (this.state == 2) {
            Image aimg = GameObject.actorImgs[4];
            g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
        } else {
            if (this.holdCount > 0) {
                Image aimg = GameObject.actorImgs[0];
                g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
                --this.holdCount;
                return;
            }
            if (this.velocityH >= -16 && this.velocityH <= 16) {
                Image aimg = GameObject.actorImgs[2];
                g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
            } else if (this.velocityH > 12) {
                Image aimg = null;
                if (this.velocityH > 44) {
                    ++this.rocketCount;
                    aimg = GameObject.actorImgs[this.rocketCount % 2 + 6];
                    g.drawImage(aimg, this.posX - 22, 640 - (this.posH - GameLogic.height) - 45, 20);
                }
                aimg = GameObject.actorImgs[1];
                g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
            } else if (this.velocityH < -12) {
                Image aimg = GameObject.actorImgs[3];
                g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
            } else {
                Image aimg = GameObject.actorImgs[1];
                g.drawImage(aimg, this.posX - 32, 640 - (this.posH - GameLogic.height) - 64, 20);
            }
        }
    }
}

