/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Flying;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.GameSync;
import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.net.GameCommand;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Actor
extends GameObject {
    public static final int STATE_HIT = 30;
    public static final int STATE_FALL = 32;
    public static final int STATE_C = 2;
    public static final int STATE_C_NO = 2;
    public static final int STATE_L = 4;
    public static final int STATE_L_NO = 3;
    public static final int STATE_R = 8;
    public static final int STATE_R_NO = 2;
    private int moveState = 2;
    public static final int HIT_NONE = 10;
    public static final int HIT_FEATHER = 11;
    public static final int HIT_UFO = 12;
    private int hitState = 10;
    private static final int SPEED_NO = 20;
    private static final int SPEED_SLOW = 21;
    private static final int SPEED_FAST = 22;
    private int speedType = 20;
    private int targetHeight = 400;
    private int height = 400;
    private double posX = 180.0;
    private int speed = 0;
    private double vH = 0.0;
    private int renderCount = 0;
    private boolean milu = true;
    private static final float X_SLOW = 0.8f;
    private static final float X_FAST = 1.9f;
    private int lastFlyingHitID = -1;
    public static final int CRATE_NONE = 0;
    public static final int CRATE_FLASH = 1;
    public static final int CRATE_FEATHER = 2;
    private int crate = 0;
    public static String crateStatus = "";
    public boolean winnerFlag = false;

    public Actor(boolean isMilu) {
        this.milu = isMilu;
    }

    public boolean isActiveSide() {
        if (GameSync.masterFlag && this.milu) {
            return true;
        }
        return !GameSync.masterFlag && !this.milu;
    }

    public int getHitState() {
        return this.hitState;
    }

    public boolean addCrate(int item) {
        if (this.crate == 0) {
            this.crate = item;
            return true;
        }
        return false;
    }

    public void useCrate() {
        if (this.crate == 2) {
            this.useFeatherCrate();
            this.crate = 0;
        } else if (this.crate == 1) {
            this.useFlashCrate();
            this.crate = 0;
        }
    }

    public void reset() {
        this.crate = 0;
        this.hitState = 10;
        this.moveState = 2;
        this.targetHeight = 400;
        this.renderCount = 0;
        this.speed = 0;
        this.posX = 180.0;
        this.vH = 0.0;
        this.height = GameLogic.getHFromPosY(100L);
        this.posY = GameLogic.getPosYFromH(this.height);
    }

    public double getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    void syncFeatherHit(int gameH, int pos10X, int h, int stat, int hitStat, int flyingID, int targetH) {
        System.out.println("syncFeatherHit #1 state:" + this.hitState + "/th:" + targetH);
        if (!GameSync.masterFlag) {
            GameLogic.height = gameH;
        }
        if (flyingID != 200) {
            Flying.flyings[flyingID].disable();
        }
        this.posX = pos10X / 10;
        this.height = h;
        this.moveState = stat;
        this.targetHeight = targetH;
        this.hitState = 11;
        SoundPlayer.playFile(3);
        System.out.println("syncFeatherHit #N state:" + this.hitState + "/th:" + targetH);
    }

    public void setFeatherHit(int flyingID) {
        this.lastFlyingHitID = flyingID;
        int min_height = GameLogic.getHFromPosY(100L);
        this.hitState = 11;
        this.moveState = 2;
        this.targetHeight = GameLogic.getHFromPosY(this.height) > 400 ? this.height - 1100 : this.height - 850;
        if (this.targetHeight < min_height) {
            this.targetHeight = min_height;
        }
        this.checkBoundary();
        SoundPlayer.playFile(3);
        if (GameLogic.score < 5000) {
            GameLogic.itemScore += 50;
        } else if (GameLogic.score < 20000) {
            GameLogic.itemScore += 200;
        } else if (GameLogic.score < 50000) {
            GameLogic.itemScore += 500;
        } else if (GameLogic.score < 100000) {
            GameLogic.itemScore += 1000;
        }
        this.sendStepState(5);
    }

    public void useFeatherCrate() {
        this.setFeatherHit(200);
    }

    void syncUfoHit(int gameH, int pos10X, int h, int stat, int hitStat, int flyingID, int targetH) {
        if (!GameSync.masterFlag) {
            GameLogic.height = gameH;
        }
        if (flyingID != 200) {
            Flying.flyings[flyingID].disable();
        }
        this.posX = pos10X / 10;
        this.height = h;
        this.speedType = 20;
        this.targetHeight = targetH;
        this.hitState = 12;
        this.moveState = 30;
        this.vH = -160.0;
        SoundPlayer.playFile(4);
        System.out.println("syncUfoHit #N state:" + this.hitState + "/vH:" + this.vH);
    }

    public void setUfoHit(int flyingID) {
        this.lastFlyingHitID = flyingID;
        this.hitState = 12;
        this.moveState = 30;
        this.vH = -160.0;
        this.targetHeight = this.height + 1100;
        int max_height = GameLogic.getHFromPosY(640L);
        if (this.targetHeight > max_height) {
            this.targetHeight = max_height;
        }
        this.checkBoundary();
        SoundPlayer.playFile(4);
        ParatrooperMidlet.vibrate();
        this.sendStepState(4);
    }

    public void syncUseCrateFlash() {
        this.setUfoHit(200);
        crateStatus = "syncUseCrateFlash(200)";
    }

    public void useFlashCrate() {
        crateStatus = "useFlashCrate()";
        this.sendStepState(7);
    }

    void syncCrateHit(int gameH, int pos10X, int h, int stat, int hitStat, int flyingID, int targetH) {
        crateStatus = "syncCrateHit:" + String.valueOf(flyingID);
        System.out.println("syncCrateHit #1 state:" + this.hitState + "/vH:" + this.vH);
        Flying.flyings[flyingID].disable();
        this.posX = pos10X / 10;
        this.height = h;
        this.speedType = 20;
        this.targetHeight = targetH;
        SoundPlayer.playFile(3);
    }

    public boolean setCrateHit(int flyingID) {
        int item = GameLogic.ran.nextInt(100) % 2 == 0 ? 2 : 1;
        boolean ret = this.addCrate(item);
        if (!ret) {
            return false;
        }
        crateStatus = "setCrateHit:" + String.valueOf(flyingID);
        this.lastFlyingHitID = flyingID;
        this.checkBoundary();
        SoundPlayer.playFile(3);
        ParatrooperMidlet.vibrate();
        this.sendStepState(6);
        return true;
    }

    public void checkBoundary() {
        if (GameLogic.instance.getState() == 5) {
            return;
        }
        if (this.posX < 35.0) {
            this.posX = 35.0;
        } else if (this.posX > 326.0) {
            this.posX = 326.0;
        }
        if (this.posY < 50) {
            this.posY = 50;
            this.height = GameLogic.getHFromPosY(this.posY);
        } else if (this.posY > 606) {
            if (GameLogic.instance.getState() == 1 && this.isActiveSide()) {
                this.sendStepState(8);
            }
            if (this.isActiveSide()) {
                GameLogic.instance.endingGame();
            }
        }
    }

    void syncStep(int gameH, int pos10X, int h, int stat, int hitStat, int speedTy, int targetH) {
        if (!GameSync.masterFlag) {
            GameLogic.height = gameH;
        }
        this.hitState = hitStat;
        if (this.hitState != 10) {
            System.out.println("onion sync step:" + this.hitState + " x:" + this.posX + "/h:" + this.height + "/th:" + this.targetHeight + "/vH:" + this.vH);
        }
        if (this.hitState == 10) {
            this.posX = pos10X / 10;
            this.height = h;
            this.moveState = stat;
            this.speedType = speedTy;
        } else {
            this.posX = pos10X / 10;
        }
    }

    void step() {
        int B = 8;
        int B2 = 25;
        int h_inc = 2;
        if (this.hitState == 10) {
            if (this.isActiveSide()) {
                if (GameLogic.sensorValue >= -8 && GameLogic.sensorValue <= 8) {
                    this.moveState = 2;
                    this.speedType = 20;
                } else if (GameLogic.sensorValue < -25) {
                    this.moveState = 8;
                    this.speedType = 22;
                } else if (GameLogic.sensorValue < -8) {
                    this.moveState = 8;
                    this.speedType = 21;
                } else if (GameLogic.sensorValue > 25) {
                    this.moveState = 4;
                    this.speedType = 22;
                } else if (GameLogic.sensorValue > 8) {
                    this.moveState = 4;
                    this.speedType = 21;
                }
            }
            if (this.moveState == 2) {
                this.speed = 0;
            } else if (this.moveState == 8) {
                if (this.speedType == 22) {
                    this.posX += (double)1.9f;
                    this.speed = 2;
                    h_inc = 7;
                } else if (this.speedType == 21) {
                    this.posX += (double)0.8f;
                    this.speed = 1;
                    h_inc = 3;
                }
            } else if (this.moveState == 4) {
                if (this.speedType == 22) {
                    this.posX -= (double)1.9f;
                    this.speed = 2;
                    h_inc = 7;
                } else if (this.speedType == 21) {
                    this.posX -= (double)0.8f;
                    this.speed = 1;
                    h_inc = 3;
                }
            }
            this.height += h_inc;
            this.sendStepState(3);
        } else if (this.hitState == 11) {
            if (this.targetHeight < this.height) {
                int diff = (this.height - this.targetHeight) / 20 + 10;
                this.height -= diff;
            } else {
                this.hitState = 10;
            }
        } else if (this.hitState == 12) {
            this.vH += 16.0;
            this.height = (int)((double)this.height + this.vH);
            if (this.vH > -10.0) {
                this.moveState = 32;
            }
            if (this.targetHeight < this.height) {
                this.hitState = 10;
            }
        }
        this.posY = GameLogic.getPosYFromH(this.height);
        this.checkBoundary();
    }

    void drawCrate(Graphics g, GameCanvas canvas) {
        Image img = null;
        img = (Image)GameObject.itemImgVec.elementAt(2);
        g.drawImage(img, 13, 560, 20);
        if (this.crate == 2) {
            img = (Image)GameObject.flyingImgVec.elementAt(1);
            g.drawImage(img, 11, 569, 20);
        } else if (this.crate == 1) {
            img = (Image)GameObject.flyingImgVec.elementAt(12);
            g.drawImage(img, 20, 568, 20);
        }
    }

    void render(Graphics g, GameCanvas canvas) {
        int img_index = 0;
        ++this.renderCount;
        int cc = 0;
        int offset = 0;
        offset = this.milu ? 0 : 10;
        cc = this.speed == 1 ? this.renderCount / 5 : this.renderCount;
        if (this.moveState == 2) {
            img_index = offset + this.moveState + cc % 2;
        } else if (this.moveState == 4) {
            img_index = offset + this.moveState + cc % 3;
        } else if (this.moveState == 8) {
            img_index = offset + this.moveState + cc % 2;
        } else if (this.moveState == 30) {
            img_index = offset + 1;
        } else if (this.moveState == 32) {
            img_index = offset + 0;
        }
        if (GameLogic.instance.getState() == 5) {
            img_index = offset + 0;
        }
        Image img = (Image)GameObject.actorImgVec.elementAt(img_index);
        if (this.milu) {
            g.drawImage(img, (int)this.posX - 50, this.posY - 45, 20);
        } else if (GameLogic.playerMode != 0) {
            g.drawImage(img, (int)this.posX - 39, this.posY - 47, 20);
        }
        if (this.crate != 0) {
            this.drawCrate(g, canvas);
        }
    }

    private void sendStepState(int cmdType) {
        if (this.isActiveSide()) {
            GameCommand cmd = GameCommand.newInstance();
            if (cmdType == 4 || cmdType == 5 || cmdType == 6 || cmdType == 7) {
                cmd.setActorState(cmdType, GameLogic.height, (int)(this.posX * 10.0), this.height, this.moveState, this.hitState, this.lastFlyingHitID, this.targetHeight);
            } else if (cmdType == 3) {
                if (this.renderCount % 3 != 0 && this.hitState == 10) {
                    return;
                }
                cmd.setActorState(cmdType, GameLogic.height, (int)(this.posX * 10.0), this.height, this.moveState, this.hitState, this.speedType, this.targetHeight);
            }
            GameLogic.instance.sync.sendGameCommand(cmd);
        }
    }
}

