/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Flying;
import cc.jmap.games.GameLogic;
import cc.jmap.games.PageCanvas;
import cc.jmap.games.net.GameCommand;
import cc.jmap.games.net.MatchService;

public class GameSync {
    public MatchService service = null;
    public static boolean masterFlag = true;
    private int[] vs = new int[15];

    public GameSync() {
        this.service = new MatchService();
    }

    public void startMaster() {
        masterFlag = true;
        this.service.openAsServer();
    }

    public void startSlave(String serverURL) {
        masterFlag = false;
        this.service.searchServers(serverURL);
    }

    public void stopAndReset() {
        this.service.stopAndReset();
        this.service.reset();
    }

    public void recvGameState() {
        GameCommand cmd = this.service.recvGameCommand();
        while (cmd != null) {
            this.vs = cmd.getValues();
            if (cmd.getCid() == 3) {
                GameLogic.instance.getIdleActor().syncStep(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6]);
            } else if (cmd.getCid() == 4) {
                GameLogic.instance.getIdleActor().syncUfoHit(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6]);
            } else if (cmd.getCid() == 5) {
                GameLogic.instance.getIdleActor().syncFeatherHit(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6]);
            } else if (cmd.getCid() == 6) {
                GameLogic.instance.getIdleActor().syncCrateHit(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6]);
            } else if (cmd.getCid() == 7) {
                GameLogic.instance.getActiveActor().syncUseCrateFlash();
            } else if (cmd.getCid() != 8) {
                if (cmd.getCid() == 9) {
                    Flying.syncReset(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6], this.vs[7], this.vs[8], this.vs[9]);
                } else if (cmd.getCid() == 10) {
                    Flying.syncStep(this.vs[0], this.vs[1], this.vs[2], this.vs[3], this.vs[4], this.vs[5], this.vs[6], this.vs[7], this.vs[8], this.vs[9]);
                } else if (cmd.getCid() == 2) {
                    if (this.vs[0] == 101) {
                        PageCanvas.clientStartToPlay();
                    } else if (this.vs[0] == 105) {
                        GameLogic.instance.syncEndingGame();
                    } else if (this.vs[0] == 102) {
                        GameLogic.instance.syncReplayGame();
                    } else if (this.vs[0] == 103) {
                        GameLogic.instance.syncPauseGame();
                    } else if (this.vs[0] == 104) {
                        GameLogic.instance.syncResumeGame();
                    } else if (this.vs[0] == 106) {
                        PageCanvas.btstatus = "recv SYS_GAME_ABORT";
                        GameLogic.instance.syncAbortGame();
                    }
                }
            }
            cmd = this.service.recvGameCommand();
        }
    }

    public void sendGameCommand(GameCommand cmd) {
        this.service.sendGameCommand(cmd);
    }
}

