/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games.net;

import cc.jmap.games.GameLogic;
import cc.jmap.games.PageCanvas;
import cc.jmap.games.ParatrooperMidlet;
import cc.jmap.games.net.GameCommand;
import cc.jmap.games.net.MatchService;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import javax.bluetooth.LocalDevice;
import javax.bluetooth.ServiceRecord;
import javax.bluetooth.UUID;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;
import javax.microedition.io.StreamConnectionNotifier;

public class BTServer
implements Runnable {
    private static final UUID SERVER_UUID = new UUID("F0E0D0C0B0A000908070605040302222", false);
    private LocalDevice localDevice;
    private StreamConnectionNotifier notifier;
    private ServiceRecord record;
    private ParatrooperMidlet parent;
    private boolean isClosed;
    private StreamConnection conn;
    private InputStream in = null;
    private OutputStream out = null;
    private Thread btServerThread;
    private MatchService service = null;
    private MyTimerTask task = null;
    private Timer timer = null;
    private static long lastRecvTimestamp = 0L;
    private final int STATE_ERROR;
    private final int STATE_UNINIT;
    private final int STATE_OPENED;
    private final int STATE_CONNECTED;
    private final int STATE_CLOSED;
    private int state = 0;
    public static final int TIMEOUT = 10000;

    BTServer(ParatrooperMidlet parent, MatchService service) {
        this.STATE_ERROR = -1;
        this.STATE_UNINIT = 0;
        this.STATE_OPENED = 1;
        this.STATE_CONNECTED = 2;
        this.STATE_CLOSED = 3;
        this.parent = parent;
        this.service = service;
        this.state = 0;
        this.btServerThread = new Thread(this);
        this.btServerThread.start();
    }

    public static void resetTimer() {
        lastRecvTimestamp = System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean isBTReady = false;
        try {
            this.localDevice = LocalDevice.getLocalDevice();
            try {
                this.localDevice.setDiscoverable(10390323);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer url = new StringBuffer("btspp://localhost:");
            url.append(SERVER_UUID.toString());
            url.append(";name=BTGame");
            url.append(";authorize=false");
            System.out.println("bt server url: " + url);
            this.notifier = (StreamConnectionNotifier)Connector.open((String)url.toString());
            this.record = this.localDevice.getRecord((Connection)this.notifier);
            isBTReady = true;
            if (!isBTReady) {
                return;
            }
            while (true) {
                if (this.isClosed) {
                    return;
                }
                this.conn = null;
                try {
                    this.task = new MyTimerTask();
                    this.timer = new Timer();
                    this.timer.schedule((TimerTask)this.task, 120000L);
                }
                catch (Exception e) {
                    PageCanvas.setBTStatus("e8:" + e.toString());
                }
                this.state = 1;
                this.conn = this.notifier.acceptAndOpen();
                this.state = 2;
                PageCanvas.serverReadyToStart();
                PageCanvas.setBTStatus("serverReadyToPlay()");
                this.handleMessageLoop(this.conn);
            }
        }
        catch (IllegalArgumentException e) {
            PageCanvas.setBTStatus("run() IllegalArgumentException");
            this.isClosed = true;
            PageCanvas.goError("e1." + e.getMessage());
            return;
        }
        catch (IOException e) {
            PageCanvas.setBTStatus("run() IOException");
            this.isClosed = true;
            PageCanvas.goError("e2." + e.getMessage());
            return;
        }
        catch (SecurityException e) {
            PageCanvas.setBTStatus("run() SecurityException");
            this.isClosed = true;
            PageCanvas.goError("e3." + e.getMessage());
            return;
        }
        catch (Exception e) {
            PageCanvas.setBTStatus("run() Exception");
            this.isClosed = true;
            PageCanvas.goError("e4." + e.getMessage());
        }
    }

    void expireCheck() {
        if (this.state == 1) {
            try {
                if (this.timer != null) {
                    this.timer.cancel();
                }
                if (GameLogic.state != 1) {
                    PageCanvas.goError("e5.no services");
                    this.isClosed = true;
                    this.state = -1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void handleMessageLoop(StreamConnection conn) {
        int BUF_SIZE = 1000;
        byte[] data = new byte[1000];
        GameCommand cmd = null;
        int dataLen = 0;
        int avail = 0;
        int startOffset = 0;
        int lastSeq = 0;
        long now = 0L;
        try {
            try {
                this.out = conn.openOutputStream();
                this.in = conn.openInputStream();
                while (!this.isClosed) {
                    now = System.currentTimeMillis();
                    if (lastRecvTimestamp + 10000L < now && GameLogic.state == 1) {
                        GameLogic.instance.onBTError("timeout");
                    }
                    if ((avail = this.in.available()) > 1000) {
                        avail = 1000;
                    }
                    if (avail > 0) {
                        dataLen = this.in.read(data, 0, avail);
                        lastRecvTimestamp = now;
                        startOffset = 0;
                        try {
                            while (startOffset < dataLen) {
                                int offset = GameCommand.dividBytes(data, dataLen, startOffset);
                                if (offset >= 0) {
                                    byte l = data[offset + 1];
                                    startOffset = offset + l;
                                    cmd = this.service.enqueueRecvCommand(data, dataLen, offset);
                                    if (cmd == null) continue;
                                    if (lastSeq != cmd.getSeq() - 1) {
                                        GameLogic.btGap = lastSeq;
                                    }
                                    GameLogic.rvalue1 = cmd.getSeq();
                                    lastSeq = cmd.getSeq();
                                    continue;
                                }
                                startOffset = dataLen;
                            }
                        }
                        catch (Exception e) {
                            PageCanvas.setBTStatus("bt e1:" + e.getMessage());
                        }
                    }
                    cmd = this.service.dequeueSendCommand();
                    while (cmd != null) {
                        GameLogic.svalue1 = cmd.getSeq();
                        dataLen = cmd.length();
                        System.arraycopy(cmd.getBytes(), 0, data, 0, dataLen);
                        try {
                            this.out.write(data, 0, dataLen);
                            this.out.flush();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        cmd = this.service.dequeueSendCommand();
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Exception e) {
                        PageCanvas.setBTStatus("bt e2:" + e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                GameLogic.instance.onBTError("ioe");
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (this.in != null) {
                    this.in.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    void destroy() {
        this.isClosed = true;
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this.notifier != null) {
                this.notifier.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.timer != null) {
            try {
                this.timer.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.state = 0;
    }

    private class MyTimerTask
    extends TimerTask {
        private MyTimerTask() {
        }

        public void run() {
            BTServer.this.expireCheck();
        }
    }
}

