/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games.net;

public class GameCommand {
    private static final int DATA_LEN = 100;
    byte[] byteData = new byte[100];
    public static final byte CMD_UNINIT = -1;
    public static final byte CMD_SYS_EVENT = 2;
    public static final byte CMD_ACTOR_STEP = 3;
    public static final byte CMD_ACTOR_HITUFO = 4;
    public static final byte CMD_ACTOR_HITFEATHER = 5;
    public static final byte CMD_ACTOR_HITCRATE = 6;
    public static final byte CMD_ACTOR_USE_FLASH = 7;
    public static final byte CMD_ACTOR_LOSE = 8;
    public static final byte CMD_OBJECT_RENEW = 9;
    public static final byte CMD_OBJECT_STEP = 10;
    public static final byte CMD_START = 2;
    public static final byte CMD_END = 10;
    public static final byte SYS_SERVER_READY = 100;
    public static final byte SYS_GAME_START = 101;
    public static final byte SYS_GAME_REPLAY = 102;
    public static final byte SYS_GAME_PAUSE = 103;
    public static final byte SYS_GAME_RESUME = 104;
    public static final byte SYS_GAME_END = 105;
    public static final byte SYS_GAME_ABORT = 106;
    private static int seqCount = 0;
    private byte cid = (byte)-1;
    private byte len = 0;
    private int seq = 0;
    private int[] intValues = new int[15];

    public byte getCid() {
        return this.cid;
    }

    public int getSeq() {
        return this.seq;
    }

    public static GameCommand newInstance() {
        return new GameCommand(seqCount++);
    }

    private GameCommand(int s) {
        this.cid = (byte)-1;
        this.seq = s;
    }

    public void setActorState(int cmdType, int gameH, int posX, int height, int state, int hitState, int speedType, int targetHeight) {
        this.cid = (byte)cmdType;
        this.len = (byte)(6 + 4 * GameCommand.vno(this.cid));
        this.intValues[0] = gameH;
        this.intValues[1] = posX;
        this.intValues[2] = height;
        this.intValues[3] = state;
        this.intValues[4] = hitState;
        this.intValues[5] = speedType;
        this.intValues[6] = targetHeight;
        this.getBytes();
    }

    public void setFlyingReset(int cmdType, int flyingID, int posX, int height, int motion, int mSpeed1, int mSpeed2, int motionV1, int motionV2, int motionV3, int motionV4) {
        this.cid = (byte)cmdType;
        this.len = (byte)(6 + 4 * GameCommand.vno(this.cid));
        this.intValues[0] = flyingID;
        this.intValues[1] = posX;
        this.intValues[2] = height;
        this.intValues[3] = motion;
        this.intValues[4] = mSpeed1;
        this.intValues[5] = mSpeed2;
        this.intValues[6] = motionV1;
        this.intValues[7] = motionV2;
        this.intValues[8] = motionV3;
        this.intValues[9] = motionV4;
        this.getBytes();
    }

    public void setFlyingStep(int cmdType, int flyingID, int posX, int height, int motion, int mSpeed1, int mSpeed2, int motionV1, int motionV2, int motionV3, int motionV4) {
        this.cid = (byte)cmdType;
        this.len = (byte)(6 + 4 * GameCommand.vno(this.cid));
        this.intValues[0] = flyingID;
        this.intValues[1] = posX;
        this.intValues[2] = height;
        this.intValues[3] = motion;
        this.intValues[4] = mSpeed1;
        this.intValues[5] = mSpeed2;
        this.intValues[6] = motionV1;
        this.intValues[7] = motionV2;
        this.intValues[8] = motionV3;
        this.intValues[9] = motionV4;
        this.getBytes();
    }

    public void setCrateReset(int cmdType, int flyingID, int posX, int height, int motion, int mSpeed1, int mSpeed2, int motionV1, int motionV2, int motionV3, int motionV4) {
        this.cid = (byte)cmdType;
        this.len = (byte)(6 + 4 * GameCommand.vno(this.cid));
        this.intValues[0] = flyingID;
        this.intValues[1] = posX;
        this.intValues[2] = height;
        this.intValues[3] = motion;
        this.intValues[4] = mSpeed1;
        this.intValues[5] = mSpeed2;
        this.intValues[6] = motionV1;
        this.intValues[7] = motionV2;
        this.intValues[8] = motionV3;
        this.intValues[9] = motionV4;
        this.getBytes();
    }

    public void setSystemState(int cmdType, int sysStatus) {
        this.cid = (byte)cmdType;
        this.len = (byte)(6 + 4 * GameCommand.vno(this.cid));
        this.intValues[0] = sysStatus;
    }

    private static int vno(int c) {
        if (c == 3) {
            return 7;
        }
        if (c == 7) {
            return 7;
        }
        if (c == 4 || c == 5 || c == 6) {
            return 10;
        }
        if (c == 9 || c == 10) {
            return 10;
        }
        if (c == 2) {
            return 1;
        }
        return 10;
    }

    public int[] getValues() {
        return this.intValues;
    }

    public void setValue(GameCommand cmd) {
        this.cid = cmd.cid;
        this.len = cmd.len;
        this.seq = cmd.seq;
        int i = 0;
        while (i < GameCommand.vno(this.cid)) {
            this.intValues[i] = cmd.intValues[i];
            ++i;
        }
        this.getBytes();
    }

    public void setFromBytes(byte[] bytesIn, int len, int offset) {
        this.cid = bytesIn[0 + offset];
        this.len = bytesIn[1 + offset];
        this.seq = GameCommand.byteArrayToInt(bytesIn, 2 + offset);
        int i = 0;
        while (i < GameCommand.vno(this.cid)) {
            this.intValues[i] = GameCommand.byteArrayToInt(bytesIn, 6 + i * 4 + offset);
            ++i;
        }
    }

    public byte[] getBytes() {
        this.byteData[0] = this.cid;
        this.byteData[1] = this.len;
        GameCommand.intToByteArray(this.seq, this.byteData, 2);
        int i = 0;
        while (i < GameCommand.vno(this.cid)) {
            GameCommand.intToByteArray(this.intValues[i], this.byteData, 6 + 4 * i);
            ++i;
        }
        return this.byteData;
    }

    public int length() {
        return this.len;
    }

    public static void intToByteArray(int value, byte[] array, int offset) {
        array[offset] = (byte)(value >>> 24);
        array[offset + 1] = (byte)(value >> 16 & 0xFF);
        array[offset + 2] = (byte)(value >> 8 & 0xFF);
        array[offset + 3] = (byte)(value & 0xFF);
    }

    public static final int byteArrayToInt(byte[] array, int offset) {
        return (array[offset] << 24) + ((array[offset + 1] & 0xFF) << 16) + ((array[offset + 2] & 0xFF) << 8) + (array[offset + 3] & 0xFF);
    }

    public static final int dividBytes(byte[] data, int len, int startOffset) {
        boolean hit = false;
        byte b = 0;
        byte b2 = 0;
        int i = startOffset;
        while (i < len) {
            b = data[i];
            b2 = data[i + 1];
            if (b >= 2 && b <= 10 && b2 == 6 + GameCommand.vno(b) * 4 && i + b2 <= len) {
                hit = true;
            }
            if (hit) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

