/*
 * Decompiled with CFR 0.152.
 */
package cc.jmap.games;

import cc.jmap.games.Flying;
import cc.jmap.games.GameLogic;
import cc.jmap.games.GameObject;
import cc.jmap.games.SoundPlayer;
import cc.jmap.games.TastyDreamMidlet;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Actor
extends GameObject {
    private static final int[] CENTER_X;
    private static final int[] CENTER_Y;
    private static final int R = 30;
    public double vX = 0.0;
    public double vY = 0.0;
    public double aY = 0.0;
    private int startY = 0;
    private long startTime = 0L;
    private static final int STATE_READY = 1;
    private static final int STATE_JUMP_UP = 2;
    private static final int STATE_JUMP_DOWN = 3;
    private int state = 1;
    private static boolean hitted;
    public static final int TYPE_A = 0;
    public static final int TYPE_B = 1;
    public static final int TYPE_C = 2;
    public static final int TYPE_D = 3;
    public static final int TYPE_E = 4;
    public static final int TYPE_F = 5;
    public static final int TYPE_G = 6;
    public static final int TYPE_H = 7;
    private int jumpType = 0;

    static {
        int[] nArray = new int[9];
        nArray[1] = 39;
        nArray[2] = 46;
        nArray[3] = 41;
        nArray[4] = 40;
        nArray[5] = 43;
        nArray[6] = 44;
        nArray[7] = 42;
        nArray[8] = 38;
        CENTER_X = nArray;
        int[] nArray2 = new int[9];
        nArray2[1] = 30;
        nArray2[2] = 36;
        nArray2[3] = 28;
        nArray2[4] = 31;
        nArray2[5] = 32;
        nArray2[6] = 37;
        nArray2[7] = 36;
        nArray2[8] = 33;
        CENTER_Y = nArray2;
        hitted = false;
    }

    public Actor() {
        this.type = 1;
        this.reset();
    }

    public void reset() {
        this.posX = 480;
        this.vX = 0.0;
        this.vY = 0.0;
        this.aY = 0.0;
        this.startY = 0;
        this.startTime = 0L;
        this.ramdomPlatformY();
    }

    private void ramdomPlatformY() {
        int r = GameLogic.ran.nextInt(600) % 5;
        this.posX = 0;
        this.posY = 150 + 75 * r;
        this.state = 1;
        this.startY = this.posY;
    }

    public int getCenterX() {
        return this.posX + CENTER_X[this.jumpType];
    }

    public int getCenterY() {
        return this.posY + CENTER_Y[this.jumpType];
    }

    public int getR() {
        return 30;
    }

    public void setHit() {
        hitted = true;
    }

    public void step() {
        this.vY += this.aY / 10.0;
        this.posX = (int)((double)this.posX + this.vX);
        this.posY = (int)((double)this.posY + this.vY);
        if ((this.state == 2 || this.state == 3) && this.posX > 380) {
            this.posX = 0;
            this.ramdomPlatformY();
            this.vX = 0.0;
            this.vY = 0.0;
            this.aY = 0.0;
            this.jumpType = 0;
            this.state = 1;
            hitted = false;
        }
    }

    public void jumpUp() {
        if (this.state == 1) {
            this.startTime = System.currentTimeMillis();
            Flying.foodCount = 0;
            SoundPlayer.playFile(3);
            this.jumpType = GameLogic.ran.nextInt(6) + 2;
            this.vX = 15.0;
            this.vY = -19.0;
            this.aY = 14.0;
            this.state = 2;
            Flying.hitCount = 0;
            Flying.scoreForOneFoodNow = Flying.scoreForOneFoodBase;
            TastyDreamMidlet.vibrate();
        }
    }

    public void jumpDown() {
        if (this.state == 1) {
            this.startTime = System.currentTimeMillis();
            SoundPlayer.playFile(3);
            Flying.foodCount = 0;
            this.jumpType = GameLogic.ran.nextInt(6) + 2;
            this.vX = 13.0;
            this.vY = -5.0;
            this.aY = 9.0;
            this.state = 3;
            Flying.hitCount = 0;
            Flying.scoreForOneFoodNow = Flying.scoreForOneFoodBase;
            TastyDreamMidlet.vibrate();
        }
    }

    public void render(Graphics g, GameCanvas canvas) {
        if (GameLogic.state != 1) {
            return;
        }
        long diff = System.currentTimeMillis() - this.startTime;
        Image aImg = null;
        if (this.posX == 0) {
            aImg = GameObject.actorImgs[0];
            g.drawImage(aImg, this.posX, this.startY, 20);
            aImg = GameObject.actorImgs[10];
            g.drawImage(aImg, 0, this.startY + 83 - 7, 20);
        } else {
            aImg = !hitted ? GameObject.actorImgs[1] : GameObject.actorImgs[this.jumpType];
            g.drawImage(aImg, this.posX, this.posY, 20);
            int index = 0;
            int offset = 83;
            if (diff > 0L && diff < 960L) {
                int u = (int)(diff / 60L) % 6;
                if (u == 0 || u == 5) {
                    index = 9;
                    offset -= 23;
                } else if (u == 1 || u == 4) {
                    index = 10;
                    offset -= 7;
                } else if (u == 2 || u == 3) {
                    index = 11;
                }
                aImg = GameObject.actorImgs[index];
                g.drawImage(aImg, 0, this.startY + offset, 20);
            }
        }
    }
}

