/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class DavinciUtilities {
    public static final int LOOP_FOREVER = -1;
    private static int[] smCrcTable;
    public static final boolean USE_TEXTURES = false;
    private static final int TEXTURE_PACK_BIT = 16;
    private static int[] smTextureRID;
    private static DChocImage[] smTextureImage;
    private static short[][][] smTextureCoordinate;
    public static final boolean USE_IMAGE_CACHING = false;
    public static final boolean USE_ANIMATION_CACHING = false;
    private static final boolean BREW_TRANSPARENCY = false;
    public static final int SCALE_ACCURACY = 10;
    public static final int NO_SCALING = 1024;
    private static Hashtable smImageCache;
    private static Hashtable smAnimationCache;
    private static final int INITIAL_SIZE = 629;
    private static final int IMAGE_HANDLE_SIZE = 5;
    private static int[] smImageHandles;
    private static int smImageHandlesSize;
    public static int smCurrentLoadingStep;
    private static Vector smImages;
    private static short[] smImageReferences;
    private static int[] smImageIDs;
    private static byte[] smPaletteIndices;
    private static short[] smImageTransformation;
    private static int[][] smPalettes;
    public static final int PIXELS_24BIT = 254;
    public static final int PIXELS_32BIT = 255;
    private static final int PIXELS_RAW_FORMAT = 253;
    public static final int PIXELS_INDEXED = -1;
    public static final boolean USE_NOKIAUI_TRANSFORMATIONS = false;
    public static final boolean USE_MIDP2_TRANSFORMATIONS = false;
    public static final boolean USE_REALTIME_TRANSFORMATIONS = false;
    private static final boolean USE_REALTIME_TRANSFORMATIONS_FOR_ALPHA_IMAGES = false;
    private static final int SCALING_BIT = 8;
    public static final int TRANSFORMATION_NONE = 0;
    public static final int TRANSFORMATION_FLIP_HORIZONTAL = 1;
    public static final int TRANSFORMATION_FLIP_VERTICAL = 2;
    public static final int RENDERABLE_TYPE_IMAGE = 1;
    public static final int RENDERABLE_TYPE_FILLEDRECT = 2;
    public static final int RENDERABLE_TYPE_RECT = 3;
    public static final int RENDERABLE_TYPE_LINE = 4;
    public static final int RENDERABLE_TYPE_FILLEDCIRCLE = 5;
    public static final int RENDERABLE_TYPE_POLYGON = 6;
    public static final int RENDERABLE_TYPE_CLIP_RECT = 7;
    public static final int RENDERABLE_TYPE_BEZIER = 8;
    public static final int RENDERABLE_TYPE_NESTED_ANIMATION = 9;
    public static final boolean USE_MIDP2_EFFECTS = false;
    public static final boolean ENABLE_FILLED_POLYGONS = true;
    public static final boolean ENABLE_FILLED_CIRCLES = false;
    public static final boolean ENABLE_CLIP_RECTS = true;
    public static final boolean ENABLE_NESTED_ANIMATIONS = true;
    public static final boolean ENABLE_LINES = false;
    public static final boolean ENABLE_FILLED_RECTS = true;
    public static final boolean ENABLE_COLLISION_BOXES = true;
    public static final boolean ENABLE_RECTS = false;
    public static final int SIN_ACCURACY = 15;
    public static final int ANGLE_ACCURACY = 8;
    private static Vector smSpriteObjectCache;
    private static short[] smSpriteObjectReference;
    private static int[] smSpriteObjectID;
    public static final int BILINEAR_ACCURACY = 8;
    private static int[] smTemp;

    private static void allocateTempMemory(int n) {
        if (smTemp == null || smTemp.length < n) {
            smTemp = new int[n];
        }
    }

    public static void initialize() {
        byte[] byArray = Toolkit.getResourceBytes(0x990000);
        int n = byArray.length >> 2;
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        smPalettes = new int[n][];
        for (int i = 0; i < n; ++i) {
            try {
                int n2 = dataInputStream.readInt();
                byte[] byArray2 = Toolkit.getResourceBytes(n2);
                int n3 = byArray2.length / 3;
                DavinciUtilities.smPalettes[i] = new int[n3];
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
                for (int j = 0; j < n3; ++j) {
                    int n4 = byteArrayInputStream.read();
                    int n5 = byteArrayInputStream.read();
                    int n6 = byteArrayInputStream.read();
                    DavinciUtilities.smPalettes[i][j] = n4 << 16 | n5 << 8 | n6 | 0xFF000000;
                }
                DavinciUtilities.smPalettes[i][0] = 0;
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void textureInit() throws IOException {
        DataInputStream dataInputStream = Toolkit.getResourceStream(-1);
        int n = dataInputStream.readShort();
        smTextureRID = new int[n];
        smTextureImage = new DChocImage[n];
        smTextureCoordinate = new short[n][][];
        for (int i = 0; i < n; ++i) {
            dataInputStream.read();
            int n2 = dataInputStream.readInt();
            dataInputStream.read();
            DavinciUtilities.smTextureRID[i] = n2;
            int n3 = dataInputStream.readShort();
            DavinciUtilities.smTextureCoordinate[i] = new short[n3][4];
            for (int j = 0; j < n3; ++j) {
                for (int k = 0; k < 4; ++k) {
                    DavinciUtilities.smTextureCoordinate[i][j][k] = dataInputStream.readShort();
                }
            }
        }
        dataInputStream.close();
    }

    public static void resetLoading() {
        smCurrentLoadingStep = 0;
    }

    public static Animation loadAnimation(int n, boolean bl) {
        if (!bl) {
            DavinciUtilities.resetLoading();
        }
        Animation animation = null;
        try {
            animation = new Animation(n, bl);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return animation;
    }

    public static Animation loadAnimation(int n) {
        return DavinciUtilities.loadAnimation(n, false);
    }

    public static Animation[] loadAnimations(int[] nArray, boolean bl) {
        Animation[] animationArray = new Animation[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            animationArray[i] = DavinciUtilities.loadAnimation(nArray[i], bl);
        }
        return animationArray;
    }

    public static Animation[] loadAnimations(int[] nArray) {
        return DavinciUtilities.loadAnimations(nArray, false);
    }

    public static Image getImage(int n) {
        return DavinciUtilities.getDChocImage(n).getImage();
    }

    public static DChocImage getDChocImage(int n) {
        return DavinciUtilities.getDChocImage(n, 0, 1024);
    }

    private static DChocImage getImageFromCache(int n, int n2, int n3, int n4, int n5) {
        return null;
    }

    private static void putImageToCache(DChocImage dChocImage, int n, int n2, int n3, int n4, int n5) {
        if (smImageCache == null) {
            smImageCache = new Hashtable();
        }
        String string = "" + n2 + "." + n3 + "." + n4 + "." + n;
        smImageCache.put(string, dChocImage);
    }

    public static Image getImage(int n, int n2, int n3) {
        return DavinciUtilities.getDChocImage(n, n2, n3).getImage();
    }

    public static DChocImage getDChocImage(int n, int n2, int n3) {
        DChocImage dChocImage = null;
        if (n != -1) {
            dChocImage = DavinciUtilities.getImageFromCache(n, n2, n3, n3, 0);
            if (dChocImage != null) {
                return dChocImage;
            }
            DataInputStream dataInputStream = Toolkit.getResourceStream(n);
            try {
                int n4 = (dataInputStream.read() >> 4) + 1;
                int n5 = dataInputStream.readInt();
                int n6 = dataInputStream.read();
                dataInputStream.close();
                dChocImage = DavinciUtilities.getImage(n5, n6, n2, n3 * n4);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            DavinciUtilities.putImageToCache(dChocImage, n, n2, n3, n3, 0);
        }
        return dChocImage;
    }

    public static void freeImageResources() {
        smImages.removeAllElements();
        smImageIDs = new int[629];
        smPaletteIndices = new byte[629];
        smImageTransformation = new short[629];
        smImageReferences = new short[629];
        DavinciUtilities.clearImageLoadingList();
    }

    private static void addImageToLoadList(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (smImageHandles == null) {
            smImageHandles = new int[3145];
        }
        if ((n6 = smImageHandlesSize * 5) == smImageHandles.length) {
            int[] nArray = new int[smImageHandles.length << 1];
            System.arraycopy(smImageHandles, 0, nArray, 0, n6);
            smImageHandles = nArray;
        }
        DavinciUtilities.smImageHandles[n6] = n;
        DavinciUtilities.smImageHandles[n6 + 1] = n2;
        DavinciUtilities.smImageHandles[n6 + 2] = n3;
        DavinciUtilities.smImageHandles[n6 + 3] = n4;
        DavinciUtilities.smImageHandles[n6 + 4] = n5;
        ++smImageHandlesSize;
        while (n6 > 0 && smImageHandles[n6 + 1] < smImageHandles[n6 + 1 - 5]) {
            DavinciUtilities.swap(smImageHandles, n6, n6 - 5, 5);
            n6 -= 5;
        }
    }

    public static void loadImageIntoCache(int n, int n2, int n3, int n4, boolean bl, int[] nArray) {
        Object object;
        boolean bl2 = false;
        int n5 = 0;
        nArray[1] = 0;
        if (n2 != 253) {
            n5 = n3;
        }
        int n6 = n4 - 1 << 8 | n5;
        int n7 = DavinciUtilities.findIndex(n, n2, n6);
        if (n7 == -1) {
            n7 = DavinciUtilities.findIndex(-1, 0, 0);
            if (n7 == -1) {
                n7 = smImages.size();
                if (n7 == smImageIDs.length) {
                    object = new int[n7 << 1];
                    byte[] byArray = new byte[n7 << 1];
                    short[] sArray = new short[n7 << 1];
                    short[] sArray2 = new short[n7 << 1];
                    System.arraycopy(smImageIDs, 0, object, 0, n7);
                    System.arraycopy(smPaletteIndices, 0, byArray, 0, n7);
                    System.arraycopy(smImageReferences, 0, sArray, 0, n7);
                    System.arraycopy(smImageTransformation, 0, sArray2, 0, n7);
                    smImageIDs = object;
                    smPaletteIndices = byArray;
                    smImageReferences = sArray;
                    smImageTransformation = sArray2;
                }
                DavinciUtilities.smImageReferences[n7] = 0;
            }
        } else {
            nArray[0] = n7;
            return;
        }
        DavinciUtilities.smImageIDs[n7] = n;
        DavinciUtilities.smPaletteIndices[n7] = (byte)n2;
        DavinciUtilities.smImageTransformation[n7] = (short)n6;
        if (n7 == smImages.size()) {
            smImages.addElement(null);
        }
        if (bl) {
            object = DavinciUtilities.getImage(n, n2, n5, n4 << 10);
            smImages.setElementAt(object, n7);
        } else {
            DavinciUtilities.addImageToLoadList(n7, n, n2, n5, n4);
        }
        nArray[0] = n7;
    }

    public static int getAdditionalLoadingCount() {
        return smImageHandlesSize;
    }

    private static DChocImage loadTextureImage(int n, int n2, int n3, int n4) {
        int n5 = n >> 16;
        if (smTextureImage[n5] == null) {
            DavinciUtilities.smTextureImage[n5] = DavinciUtilities.getImage(smTextureRID[n5], n2, n3, n4);
        }
        DChocImage dChocImage = new DChocImage(smTextureImage[n5]);
        short[] sArray = smTextureCoordinate[n5][n & 0xFFFF];
        dChocImage.setRegion(sArray[0], sArray[1], sArray[2], sArray[3]);
        return dChocImage;
    }

    public static void loadNext() {
        int n;
        int n2 = smCurrentLoadingStep * 5;
        if (DavinciUtilities.getImageFromCache(n = smImageHandles[n2++]) == null) {
            int n3 = smImageHandles[n2++];
            int n4 = smImageHandles[n2++];
            int n5 = smImageHandles[n2++];
            int n6 = smImageHandles[n2];
            DChocImage dChocImage = DavinciUtilities.getImage(n3, n4, n5, n6 << 10);
            smImages.setElementAt(dChocImage, n);
        }
        if (++smCurrentLoadingStep == smImageHandlesSize) {
            DavinciUtilities.clearImageLoadingList();
        }
    }

    private static void clearImageLoadingList() {
        smImageHandles = null;
        smCurrentLoadingStep = 0;
        smImageHandlesSize = 0;
    }

    public static void swap(int[] nArray, int n, int n2, int n3) {
        while (--n3 >= 0) {
            int n4 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n4;
            ++n;
            ++n2;
        }
    }

    private static DChocImage getImage(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n2 == 253) {
            return new DChocImage(n);
        }
        byte[] byArray = Toolkit.getResourceBytes(n);
        int n8 = byArray[0] << 8 | byArray[1] & 0xFF;
        int[] nArray = null;
        if (n2 == 254 || n2 == 255) {
            n7 = n2;
            n6 = 2;
            n5 = (byArray.length - n6) / n8;
            n5 = n2 == 254 ? (n5 /= 3) : (n5 >>= 2);
        } else {
            n6 = 10;
            n5 = (byArray.length - n6) / n8;
            nArray = smPalettes[n2];
            n7 = -1;
        }
        byte[] byArray2 = DavinciUtilities.createPng(nArray, byArray, n8, n5, n7, n6, n3, n4);
        return new DChocImage(Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length));
    }

    private static int getScaledValue(int n, int n2) {
        return (n = n * n2 >> 10) > 0 ? n : 1;
    }

    private static int[] getImagePixels(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 4;
        if (n3 == -1) {
            n7 = 1;
        } else if (n3 == 254) {
            n7 = 3;
        }
        int n8 = n;
        n = DavinciUtilities.getScaledValue(n, n6);
        n2 = DavinciUtilities.getScaledValue(n2, n6);
        int[] nArray2 = new int[n * n2];
        int n9 = 0;
        for (int i = 0; i < n2; ++i) {
            int n10;
            int n11;
            int n12 = i;
            if (n6 != 1024) {
                n12 = (n12 << 10) / n6;
            }
            n12 *= n8 * n7;
            n12 += n4;
            if (n3 == -1 && n6 == 1024) {
                n11 = n12;
                n10 = n;
                while (--n10 >= 0) {
                    nArray2[n9++] = nArray[byArray[n11++] & 0xFF];
                }
                continue;
            }
            for (n11 = 0; n11 < n; ++n11) {
                n10 = n11;
                if (n6 != 1024) {
                    n10 = (n10 << 10) / n6;
                }
                int n13 = n12 + n10 * n7;
                if (n3 == -1) {
                    nArray2[n9++] = nArray[byArray[n13] & 0xFF];
                    continue;
                }
                int n14 = (byArray[n13] & 0xFF) << 16;
                int n15 = (byArray[++n13] & 0xFF) << 8;
                int n16 = byArray[++n13] & 0xFF;
                if (n3 == 255) {
                    int n17 = (byArray[++n13] & 0xFF) << 24;
                    nArray2[n9++] = n17 | n14 | n15 | n16;
                    continue;
                }
                nArray2[n9++] = 0xFF000000 | n14 | n15 | n16;
            }
        }
        DavinciUtilities.transformBuffer(nArray2, n, n2, n5);
        return nArray2;
    }

    public static DChocImage createMIDP2Image(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray2 = DavinciUtilities.getImagePixels(nArray, byArray, n, n2, n3, n4, n5, n6);
        n = DavinciUtilities.getScaledValue(n, n6);
        n2 = DavinciUtilities.getScaledValue(n2, n6);
        return new DChocImage(Image.createRGBImage((int[])nArray2, (int)n, (int)n2, (n3 != 254 ? 1 : 0) != 0));
    }

    public static void transformBuffer(int[] nArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if ((n3 & 3) == 3) {
            int n4 = 0;
            int n5 = n * n2;
            int n6 = n5 >> 1;
            int n7 = n5 - 1;
            while (n7 >= n6) {
                int n8 = nArray[n7];
                nArray[n7--] = nArray[n4];
                nArray[n4++] = n8;
            }
        } else if ((n3 & 1) != 0) {
            int n9 = n >> 1;
            int n10 = 0;
            int n11 = n2;
            while (--n11 >= 0) {
                int n12 = n10 + n - 1;
                int n13 = n10 + n9;
                while (n10 < n13) {
                    int n14 = nArray[n10];
                    nArray[n10++] = nArray[n12];
                    nArray[n12--] = n14;
                }
                n10 += n - n9;
            }
        } else {
            int n15 = (n2 - 1) * n;
            int n16 = (n2 >> 1) * n;
            int n17 = n;
            while (--n17 >= 0) {
                int n18 = n17;
                int n19 = n15 + n17;
                int n20 = n18 + n16;
                while (n18 < n20) {
                    int n21 = nArray[n18];
                    nArray[n18] = nArray[n19];
                    nArray[n19] = n21;
                    n18 += n;
                    n19 -= n;
                }
            }
        }
    }

    public static void modRefCounters(Animation animation, int n) {
        if (animation != null) {
            int n2 = animation.getFrameCount();
            while (--n2 >= 0) {
                if (animation.isFrameReference(n2)) continue;
                AnimationFrame animationFrame = animation.getFrame(n2);
                int[][] nArray = animationFrame.getRenderables();
                int n3 = nArray.length;
                while (--n3 >= 0) {
                    int n4;
                    int[] nArray2 = nArray[n3];
                    int n5 = nArray2[0];
                    if (n5 == 1) {
                        n4 = nArray2[3];
                        int n6 = smImageReferences[n4] + n;
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        DavinciUtilities.smImageReferences[n4] = (short)n6;
                        continue;
                    }
                    if (n5 != 9) continue;
                    int n7 = n4 = nArray2[4];
                    smSpriteObjectReference[n7] = (short)(smSpriteObjectReference[n7] + n);
                    if (smSpriteObjectReference[n4] > 0) continue;
                    DavinciUtilities.smSpriteObjectReference[n4] = 0;
                    SpriteObject spriteObject = DavinciUtilities.getSpriteObjectFromCache(n4);
                    if (spriteObject == null) continue;
                    spriteObject.freeResources();
                    smSpriteObjectCache.setElementAt(null, n4);
                }
            }
        }
    }

    public static boolean hasNestedAnimations(Animation animation, int n) {
        return animation.hasNestedAnimations(n);
    }

    private static int findIndex(int n, int n2, int n3) {
        int n4 = smImages.size();
        while (--n4 >= 0) {
            if (smImageIDs[n4] != n || n != -1 && (n2 != (smPaletteIndices[n4] & 0xFF) || n3 != smImageTransformation[n4])) continue;
            return n4;
        }
        return -1;
    }

    public static void fillEllipse(Graphics graphics, int n, int n2, int n3, int n4) {
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.setGraphicsContext(graphics);
        iRenderingPlatform.fillEllipse(n, n2, n3, n4);
    }

    public static byte[] createPng(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        boolean bl = (n5 & 1) != 0;
        boolean bl2 = (n5 & 2) != 0;
        boolean bl3 = n3 == -1 && n4 != 0;
        int n9 = 4;
        int n10 = 4;
        int n11 = 0;
        if (n3 == -1) {
            n9 = 1;
            n10 = 1;
            n11 = 3 * nArray.length + 4 + 4 + 4 + 1 + 4 + 4 + 4;
        } else if (n3 == 254) {
            n10 = 3;
        }
        int n12 = n;
        n = n * n6 >> 10;
        n = n > 0 ? n : 1;
        n2 = n2 * n6 >> 10;
        n2 = n2 > 0 ? n2 : 1;
        int n13 = 65531;
        n13 -= n13 % (n * n9 + 1);
        int n14 = n * n2 * n9 + n2;
        int n15 = (n14 - 1) / n13 + 1;
        int n16 = 6 + n14 + n15 * 5;
        byte[] byArray2 = new byte[57 + n16 + n11];
        byArray2[0] = -119;
        byArray2[1] = 80;
        byArray2[2] = 78;
        byArray2[3] = 71;
        byArray2[4] = 13;
        byArray2[5] = 10;
        byArray2[6] = 26;
        byArray2[7] = 10;
        byArray2[11] = 13;
        byArray2[12] = 73;
        byArray2[13] = 72;
        byArray2[14] = 68;
        byArray2[15] = 82;
        byArray2[18] = (byte)(n >> 8);
        byArray2[19] = (byte)n;
        byArray2[22] = (byte)(n2 >> 8);
        byArray2[23] = (byte)n2;
        byArray2[24] = 8;
        byArray2[25] = (byte)(n3 == -1 ? 3 : 6);
        int n17 = DavinciUtilities.crc32(byArray2, 12, 17);
        byArray2[29] = (byte)(n17 >> 24);
        byArray2[30] = (byte)(n17 >> 16);
        byArray2[31] = (byte)(n17 >> 8);
        byArray2[32] = (byte)n17;
        int n18 = 33;
        if (n3 == -1) {
            n8 = nArray.length * 3;
            byArray2[35] = (byte)(n8 >> 8);
            byArray2[36] = (byte)n8;
            byArray2[37] = 80;
            byArray2[38] = 76;
            byArray2[39] = 84;
            byArray2[40] = 69;
            n18 = 41;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                byArray2[n18++] = (byte)(nArray[n7] >> 16);
                byArray2[n18++] = (byte)(nArray[n7] >> 8);
                byArray2[n18++] = (byte)nArray[n7];
            }
            n17 = DavinciUtilities.crc32(byArray2, n18 - n8 - 4, n8 + 4);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
            n18 += 3;
            byArray2[n18++] = 1;
            byArray2[n18++] = 116;
            byArray2[n18++] = 82;
            byArray2[n18++] = 78;
            byArray2[n18++] = 83;
            n17 = DavinciUtilities.crc32(byArray2, ++n18 - 5, 5);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
        }
        byArray2[n18++] = (byte)(n16 >> 24);
        byArray2[n18++] = (byte)(n16 >> 16);
        byArray2[n18++] = (byte)(n16 >> 8);
        byArray2[n18++] = (byte)n16;
        n8 = n18;
        byArray2[n18++] = 73;
        byArray2[n18++] = 68;
        byArray2[n18++] = 65;
        byArray2[n18++] = 84;
        byArray2[n18++] = 120;
        byArray2[n18++] = 1;
        n7 = 1;
        int n19 = n13;
        int n20 = 0;
        boolean bl4 = n6 == 1024 && n5 == 0 && bl3;
        n9 *= n;
        for (int i = 0; i < n15; ++i) {
            if (i == n15 - 1) {
                byArray2[n18] = 1;
                n19 = (n14 - 1) % n13 + 1;
            }
            int n21 = ++n18;
            byArray2[n21] = (byte)n19;
            int n22 = ++n18;
            byArray2[n22] = (byte)(n19 >> 8);
            int n23 = n19 ^ 0xFFFF;
            int n24 = ++n18;
            byArray2[n24] = (byte)n23;
            int n25 = ++n18;
            ++n18;
            byArray2[n25] = (byte)(n23 >> 8);
            for (int j = 0; n20 < n2 && j < n19; j += n9, ++n20) {
                int n26;
                int n27;
                int n28;
                ++j;
                ++n18;
                int n29 = n28 = bl2 ? n2 - n20 - 1 : n20;
                if (n6 != 1024) {
                    n28 = (n28 << 10) / n6;
                }
                n28 *= n12 * n10;
                n28 += n4;
                if (n3 == -1 && n6 == 1024) {
                    if (bl) {
                        n27 = n28 + n - 1;
                        n26 = n;
                        while (--n26 >= 0) {
                            byArray2[n18++] = byArray[n27--];
                        }
                        continue;
                    }
                    n27 = n28;
                    n26 = n;
                    while (--n26 >= 0) {
                        byArray2[n18++] = byArray[n27++];
                    }
                    continue;
                }
                for (n27 = 0; n27 < n; ++n27) {
                    int n30 = n26 = bl ? n - n27 - 1 : n27;
                    if (n6 != 1024) {
                        n26 = (n26 << 10) / n6;
                    }
                    int n31 = n28 + n26 * n10;
                    byArray2[n18++] = byArray[n31];
                    if (n3 == -1) continue;
                    byArray2[n18++] = byArray[++n31];
                    byArray2[n18++] = byArray[++n31];
                    byArray2[n18++] = n3 == 255 ? byArray[++n31] : -1;
                }
            }
            if (bl4) continue;
            n7 = DavinciUtilities.adler32(byArray2, n18 - n19, n19, n7);
        }
        if (bl4) {
            byArray2[n18++] = byArray[2];
            byArray2[n18++] = byArray[3];
            byArray2[n18++] = byArray[4];
            byArray2[n18++] = byArray[5];
            byArray2[n18++] = byArray[6];
            byArray2[n18++] = byArray[7];
            byArray2[n18++] = byArray[8];
            byArray2[n18] = byArray[9];
        } else {
            byArray2[n18++] = (byte)(n7 >>> 24);
            byArray2[n18++] = (byte)(n7 >>> 16);
            byArray2[n18++] = (byte)(n7 >>> 8);
            byArray2[n18++] = (byte)n7;
            n17 = DavinciUtilities.crc32(byArray2, n8, n18 - n8);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18] = (byte)n17;
        }
        n18 += 5;
        byArray2[n18++] = 73;
        byArray2[n18++] = 69;
        byArray2[n18++] = 78;
        byArray2[n18++] = 68;
        byArray2[n18++] = -82;
        byArray2[n18++] = 66;
        byArray2[n18++] = 96;
        byArray2[n18] = -126;
        return byArray2;
    }

    private static int adler32(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 >>> 16;
        int n5 = n3 & 0xFFFF;
        n2 += n;
        while (n < n2) {
            n5 = (n5 + (byArray[n] & 0xFF)) % 65521;
            n4 = (n4 + n5) % 65521;
            ++n;
        }
        return (n4 << 16) + n5;
    }

    private static int crc32(byte[] byArray, int n, int n2) {
        int n3;
        if (smCrcTable == null) {
            smCrcTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                n3 = i;
                for (int j = 0; j < 8; ++j) {
                    n3 = (n3 & 1) != 0 ? 0xEDB88320 ^ n3 >>> 1 : (n3 >>>= 1);
                    DavinciUtilities.smCrcTable[i] = n3;
                }
            }
        }
        n3 = -1;
        n2 += n;
        while (n < n2) {
            n3 = smCrcTable[(n3 ^ byArray[n]) & 0xFF] ^ n3 >>> 8;
            ++n;
        }
        return ~n3;
    }

    public static void freeCRCTable() {
        smCrcTable = null;
    }

    public static void releaseUnreferencedImages() {
        int n = smImages.size();
        while (--n >= 0) {
            if (smImageReferences[n] != 0 || DavinciUtilities.getImageFromCache(n) == null) continue;
            smImages.setElementAt(null, n);
            DavinciUtilities.smImageIDs[n] = -1;
        }
    }

    private static boolean isTextureReferenced(int n) {
        int n2 = smImages.size();
        while (--n2 >= 0) {
            if (smImageReferences[n2] <= 0 || smImageIDs[n2] >> 16 != n) continue;
            return true;
        }
        return false;
    }

    public static final int getRange(int n, int n2) {
        n2 = Math.abs(n2);
        if ((n = Math.abs(n)) > n2) {
            return n + (n2 * 106 >> 8);
        }
        return n2 + (n * 106 >> 8);
    }

    public static void fillApproximateBezier(Graphics graphics, int n, int n2, short[] sArray, int n3, int n4) {
        int n5 = n4 * 6;
        DavinciUtilities.allocateTempMemory(n5);
        for (int i = 0; i < n5; ++i) {
            DavinciUtilities.smTemp[i] = sArray[n3++];
        }
        DavinciUtilities.fillApproximateBezier(graphics, n, n2, smTemp, 0, n4);
    }

    public static void fillApproximateBezier(Graphics graphics, int n, int n2, int[] nArray, int n3, int n4) {
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.setGraphicsContext(graphics);
        iRenderingPlatform.setPivot(n, n2);
        iRenderingPlatform.fillBezier(nArray, n3, n4);
    }

    public static void fillTriangle(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        DavinciUtilities.allocateTempMemory(6);
        DavinciUtilities.smTemp[0] = n;
        DavinciUtilities.smTemp[1] = n2;
        DavinciUtilities.smTemp[2] = n3;
        DavinciUtilities.smTemp[3] = n4;
        DavinciUtilities.smTemp[4] = n5;
        DavinciUtilities.smTemp[5] = n6;
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.setGraphicsContext(graphics);
        iRenderingPlatform.setColor(graphics.getColor());
        iRenderingPlatform.fillPolygon(smTemp, 0, 3);
    }

    public static void fillPolygon(Graphics graphics, int n, int n2, short[] sArray, int n3, int n4) {
        int n5 = n4 * 2;
        DavinciUtilities.allocateTempMemory(n5);
        for (int i = 0; i < n5; ++i) {
            DavinciUtilities.smTemp[i] = sArray[n3++];
        }
        DavinciUtilities.fillPolygon(graphics, n, n2, smTemp, 0, n4);
    }

    public static void fillPolygon(Graphics graphics, int n, int n2, int[] nArray, int n3, int n4) {
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.setGraphicsContext(graphics);
        iRenderingPlatform.setPivot(n, n2);
        iRenderingPlatform.fillPolygon(nArray, n3, n4);
    }

    public static final int sin(int n) {
        return MathUtils.sin(n);
    }

    public static final int cos(int n) {
        return MathUtils.cos(n);
    }

    public static int getMovementX(byte[] byArray, int n) {
        if (n != -1) {
            int n2 = n << 1;
            n2 = byArray[n2] << 8 | byArray[n2 + 1] & 0xFF;
            if (byArray[n2++] == 0) {
                return (short)(byArray[n2++] << 8 | byArray[n2] & 0xFF);
            }
        }
        return 0;
    }

    public static int getMovementY(byte[] byArray, int n) {
        if (n != -1) {
            int n2 = n << 1;
            n2 = byArray[n2] << 8 | byArray[n2 + 1] & 0xFF;
            if (byArray[n2++] == 0) {
                n2 += 2;
                return (short)(byArray[n2++] << 8 | byArray[n2] & 0xFF);
            }
        }
        return 0;
    }

    public static int loadAnimationIntoCache(int n, boolean bl) {
        int n2;
        if (smSpriteObjectID == null) {
            smSpriteObjectID = new int[629];
            smSpriteObjectReference = new short[629];
            smSpriteObjectCache = new Vector(629);
        }
        int n3 = smSpriteObjectCache.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (n != smSpriteObjectID[n2] || DavinciUtilities.getSpriteObjectFromCache(n2) == null) continue;
            return n2;
        }
        for (n2 = 0; n2 < n3 && DavinciUtilities.getSpriteObjectFromCache(n2) != null; ++n2) {
        }
        if (n2 >= smSpriteObjectID.length) {
            int n4 = smSpriteObjectID.length;
            int n5 = n4 << 1;
            short[] sArray = new short[n5];
            int[] nArray = new int[n5];
            System.arraycopy(smSpriteObjectReference, 0, sArray, 0, n4);
            System.arraycopy(smSpriteObjectID, 0, nArray, 0, n4);
            smSpriteObjectReference = sArray;
            smSpriteObjectID = nArray;
        }
        if (n2 == n3) {
            smSpriteObjectCache.addElement(null);
        }
        smSpriteObjectCache.setElementAt(new SpriteObject(), n2);
        DavinciUtilities.smSpriteObjectID[n2] = n;
        Animation animation = DavinciUtilities.loadAnimation(n, bl);
        smSpriteObjectCache.setElementAt(new SpriteObject(animation), n2);
        return n2;
    }

    public static void drawAntiAliasedLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.pushParameters();
        iRenderingPlatform.setGraphicsContext(graphics);
        iRenderingPlatform.setColorARGB(n5);
        iRenderingPlatform.drawLine(n, n2, n3, n4);
        iRenderingPlatform.popParameters();
    }

    public static DChocImage getImageFromCache(int n) {
        return (DChocImage)smImages.elementAt(n);
    }

    public static SpriteObject getSpriteObjectFromCache(int n) {
        return (SpriteObject)smSpriteObjectCache.elementAt(n);
    }

    public static int interpolateColor(int n, int n2, int n3, int n4) {
        int n5 = DavinciUtilities.interpolateValue(n >>> 24, n2 >>> 24, n3, n4);
        int n6 = DavinciUtilities.interpolateValue(n >> 16 & 0xFF, n2 >> 16 & 0xFF, n3, n4);
        int n7 = DavinciUtilities.interpolateValue(n & 0xFF00, n2 & 0xFF00, n3, n4);
        int n8 = DavinciUtilities.interpolateValue(n & 0xFF, n2 & 0xFF, n3, n4);
        return n5 << 24 | n6 << 16 | n7 & 0xFF00 | n8;
    }

    public static int interpolateValue(int n, int n2, int n3, int n4) {
        return n + (n2 - n) * n3 / n4;
    }

    public static final int bilinearFilter(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n >> 8;
        int n10 = n2 >> 8;
        int n11 = n10 * n3 + n9;
        if (n9 != -1 && n10 != -1) {
            n8 = nArray[n11];
            n7 = n9 < n3 - 1 ? nArray[n11 + 1] : n8 & 0xFFFFFF;
            n6 = n7 & 0xFFFFFF;
            n5 = n8 & 0xFFFFFF;
            if (n10 < n4 - 1) {
                n11 += n3;
                if (n9 < n3 - 1) {
                    n6 = nArray[n11 + 1];
                }
                n5 = nArray[n11];
            }
        } else if (n9 == -1) {
            ++n11;
            if (n10 == -1) {
                n6 = nArray[n11 + n3];
                n7 = n5 = n6 & 0xFFFFFF;
                n8 = n5;
            } else {
                n7 = nArray[n11];
                n8 = n6 = n7 & 0xFFFFFF;
                if (n10 < n4 - 1) {
                    n6 = nArray[n11 + n3];
                }
                n5 = n6 & 0xFFFFFF;
            }
        } else {
            n5 = nArray[n11 += n3];
            n8 = n6 = n5 & 0xFFFFFF;
            if (n9 < n3 - 1) {
                n6 = nArray[n11 + 1];
            }
            n7 = n6 & 0xFFFFFF;
        }
        n10 = n2 & 0xFF;
        n9 = n & 0xFF;
        int n12 = n8 >>> 24;
        int n13 = n12 + (((n5 >>> 24) - n12) * n10 >> 8);
        n12 = n7 >>> 24;
        int n14 = n12 + (((n6 >>> 24) - n12) * n10 >> 8);
        int n15 = n13 + ((n14 - n13) * n9 >> 8) << 24;
        n12 = n8 & 0xFF00FF;
        n13 = n12 + (((n5 & 0xFF00FF) - n12) * n10 >> 8) & 0xFF00FF;
        n12 = n7 & 0xFF00FF;
        n14 = n12 + (((n6 & 0xFF00FF) - n12) * n10 >> 8) & 0xFF00FF;
        n15 |= n13 + ((n14 - n13) * n9 >> 8) & 0xFF00FF;
        n12 = n8 & 0xFF00;
        n13 = n12 + (((n5 & 0xFF00) - n12) * n10 >> 8);
        n12 = n7 & 0xFF00;
        n14 = n12 + (((n6 & 0xFF00) - n12) * n10 >> 8);
        return n15 |= n13 + ((n14 - n13) * n9 >> 8) & 0xFF00;
    }

    static {
        smImages = new Vector(629, 629);
        smImageReferences = new short[629];
        smImageIDs = new int[629];
        smPaletteIndices = new byte[629];
        smImageTransformation = new short[629];
    }
}

