/*
 * Decompiled with CFR 0.152.
 */
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FlowProcessor {
    public static final int NO_LOADING = -1;
    private static final boolean DEBUG_FLOW = true;
    private static final int NO_STATE_CHANGE = -1;
    private FlowHandler mFlowHandler;
    private byte[] mFlowBinary;
    private short[] mEventTargets;
    private int mWildEventCount;
    private short[] mStateOffsets;
    private byte[] mStateGroups;
    private int mCurrentState = -1;
    private int mNextState = -1;
    private MenuObject mCurrentMenu;
    private short[] mCurrentGameScreen;
    private short[] mCurrentBranch;
    private MenuObject[] mLoadedMenus;
    private short[][] mMenuSoftkeyEvents;
    private short[][] mLoadedGameScreens;
    private short[][] mLoadedBranches;
    private int mMenuScreenCount;
    private int mGameScreenStartIndex;
    private int mGameScreenCount;
    private int mBranchStartIndex;
    private int mBranchCount;
    private boolean mGoingForward;
    private boolean mStoreStateToHistory;
    private short[] mStateHistory;
    private int mStateHistoryPointer;
    private int mMaxLoadingCount;
    private int mLoadingCounter;
    private int mStateGroupLoadingCount;
    private int mStateLoadingCount;
    private int mDavinciLoadingPercentage;
    private boolean mDavinciLoading;
    private short[] mMenusToLoad;
    private byte[] mMenuSelectedItems;
    private boolean[] mStateGroupInMemory;
    private boolean mInFinalLoadingStep;
    private long mFinalLoadingStepStartTime;
    private static final boolean USE_MENU_ITEM_GRAPHICS = true;
    private static Hashtable smMenuResourceHashtable;
    private int mCurrentTransition;
    private int mTransitionTime;
    private int mTransitionDuration;
    private int mFlowTransitionState;
    private int mTransitionStateA;
    private int mTransitionStateB;
    private static final int TRANSITION_NONE = 0;
    private static final int TRANSITION_STATE_OUT = 1;
    private static final int TRANSITION_LOADING_IN = 2;
    private static final int TRANSITION_LOADING = 3;
    private static final int TRANSITION_LOADING_OUT = 4;
    private static final int TRANSITION_STATE_IN = 5;
    private boolean mReloadStateGroup;

    public FlowProcessor(int n, FlowHandler flowHandler) {
        this.initializeFlow(n, flowHandler);
    }

    public void logicUpdate(int n) {
        if (this.mFlowTransitionState != 0) {
            DChocMIDlet.skipTimer();
            if (this.mFlowTransitionState == 3) {
                this.updateLoading();
                return;
            }
        } else if (this.mNextState != -1) {
            DChocMIDlet.skipTimer();
            this.changeState();
            return;
        }
        int n2 = this.mFlowHandler.logicUpdate(this.mCurrentState, n);
        this.processEvent(n2);
        if (this.mCurrentMenu != null) {
            int[] nArray = this.mCurrentMenu.logicUpdate(n);
            this.mMenuSelectedItems[this.mCurrentState] = (byte)this.mCurrentMenu.getSelectedItem();
            if (nArray != null) {
                if (nArray[0] == 1) {
                    this.processEvent(nArray[1]);
                } else if (nArray[0] == 0) {
                    boolean bl = false;
                    short[] sArray = this.mMenuSoftkeyEvents[this.mCurrentState];
                    if (sArray != null) {
                        int n3 = 0;
                        while (n3 < sArray.length) {
                            short s = sArray[n3++];
                            short s2 = sArray[n3++];
                            if (s != nArray[1]) continue;
                            this.processEvent(s2);
                            bl = true;
                        }
                    }
                    if (!bl) {
                        this.processSoftkeyEvent(nArray[1]);
                    }
                }
            }
        }
    }

    public void doPostDraw(Graphics graphics) {
    }

    public void doDraw(Graphics graphics) {
        if (this.inLoadingScreen()) {
            this.mFlowHandler.drawLoadingScreen(graphics, this.getLoadingPercentage());
            return;
        }
        if (HeapReaderAndApplicationPauser.isPaused()) {
            // empty if block
        }
        this.mFlowHandler.doDraw(this.mCurrentState, graphics);
        if (this.mCurrentMenu != null) {
            this.mFlowHandler.drawMenu(this.mCurrentState, graphics, this.mCurrentMenu);
        }
    }

    private boolean ignoreControlEvents() {
        return this.mFlowTransitionState != 0 && this.mFlowTransitionState != 5;
    }

    public void keyEventOccurred(int n, int n2) {
        if (this.ignoreControlEvents()) {
            return;
        }
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.keyEventOccurred(n, n2);
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.keyEventOccurred(this.mCurrentState, n, n2);
        }
    }

    public void controllerEventOccurred(int n, int n2, int n3, int n4, int n5) {
        if (this.ignoreControlEvents()) {
            return;
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.controllerEventOccurred(n, n2, n3, n4, n5);
        }
    }

    public void pointerEventOccurred(int n, int n2, int n3) {
        if (this.ignoreControlEvents()) {
            return;
        }
        if (this.mCurrentMenu != null) {
            this.mCurrentMenu.pointerEventOccurred(n, n2, n3);
        }
        if (this.mFlowHandler != null) {
            this.mFlowHandler.pointerEventOccurred(this.mCurrentState, n, n2, n3);
        }
    }

    private void clearCache() {
        this.mReloadStateGroup = true;
        if (this.mNextState == -1) {
            this.mNextState = this.mCurrentState;
        }
        if (this.mFlowTransitionState != 0) {
            this.mFlowTransitionState = 1;
            this.changeState();
        }
    }

    public void languageChanged() {
        this.clearCache();
    }

    private boolean inLoadingScreen() {
        return this.mFlowTransitionState >= 2 && this.mFlowTransitionState <= 4;
    }

    public void pause() {
        if (!this.inLoadingScreen()) {
            if (this.mCurrentMenu != null) {
                this.mCurrentMenu.stopScrolling();
            }
            this.mFlowHandler.pauseGame();
        }
    }

    public void screenSizeChanged() {
        if (this.mCurrentState != 35 && this.mCurrentState != 43) {
            this.clearCache();
        }
        this.mFlowHandler.screenSizeChanged();
    }

    public void licenseManagerActivated() {
        this.mFlowHandler.licenseManagerActivated();
    }

    public void controllerActivated() {
        this.mFlowHandler.controllerActivated();
    }

    private void initializeFlow(int n, FlowHandler flowHandler) {
        int n2;
        int n3;
        this.mFlowHandler = flowHandler;
        byte[] byArray = Toolkit.getResourceBytes(n);
        this.mFlowBinary = byArray;
        int n4 = byArray[0] & 0xFF;
        this.mWildEventCount = byArray[1] & 0xFF;
        int n5 = 2;
        this.mEventTargets = new short[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            this.mEventTargets[n3] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
        }
        n3 = byArray[n5++] & 0xFF;
        this.mStateGroupInMemory = new boolean[n3];
        this.mGameScreenStartIndex = this.mMenuScreenCount = byArray[n5++] & 0xFF;
        this.mGameScreenCount = byArray[n5++] & 0xFF;
        this.mBranchStartIndex = this.mGameScreenStartIndex + this.mGameScreenCount;
        int n6 = byArray[n5++] & 0xFF;
        int n7 = this.mMenuScreenCount + this.mGameScreenCount + n6;
        this.mStateGroups = new byte[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            this.mStateGroups[n2] = byArray[n5++];
        }
        this.mStateOffsets = new short[n7];
        for (n2 = 0; n2 < n7; ++n2) {
            this.mStateOffsets[n2] = (short)((byArray[n5++] & 0xFF) << 8 | byArray[n5++] & 0xFF);
        }
        this.mNextState = byArray[n5] & 0xFF;
        this.mLoadedMenus = new MenuObject[this.mMenuScreenCount];
        this.mMenuSoftkeyEvents = new short[this.mMenuScreenCount][];
        this.mLoadedGameScreens = new short[this.mGameScreenCount][];
        this.mLoadedBranches = new short[n6][];
        this.mMenuSelectedItems = new byte[this.mMenuScreenCount];
        n2 = this.mMenuScreenCount;
        int n8 = 0;
        while (n8 < this.mGameScreenCount) {
            this.loadGameScreen(n2);
            ++n8;
            ++n2;
        }
        n8 = 0;
        while (n8 < n6) {
            this.loadBranch(n2);
            ++n8;
            ++n2;
        }
        this.mBranchCount = n6;
        this.mStateHistory = new short[this.mMenuScreenCount + n6 + this.mGameScreenCount];
        this.mStateHistoryPointer = 0;
        this.mStoreStateToHistory = false;
    }

    private void createLoadingLists() {
        this.mStateGroupLoadingCount = 0;
        byte by = this.mStateGroups[this.mNextState];
        byte by2 = -1;
        if (!this.mReloadStateGroup && this.mCurrentState != -1) {
            by2 = this.mStateGroups[this.mCurrentState];
        }
        if (by != -1 && by != by2) {
            int n;
            if (!this.mFlowHandler.isChildGroup(by, by2)) {
                this.mStateGroupLoadingCount = this.mFlowHandler.getStateGroupLoadingCount(by);
            }
            Vector<Short> vector = new Vector<Short>();
            for (n = 0; n < this.mStateGroups.length; ++n) {
                if (this.mStateGroups[n] != by || !this.isMenuState(n) || this.mLoadedMenus[n] != null && !this.mReloadStateGroup || !this.mFlowHandler.isMenuNeeded(n)) continue;
                vector.addElement(new Short((short)n));
            }
            n = vector.size();
            this.mMenusToLoad = new short[n];
            for (int i = 0; i < n; ++i) {
                this.mMenusToLoad[i] = (Short)vector.elementAt(i);
            }
        } else {
            int n = this.mNextState;
            this.mMenusToLoad = this.isMenuState(n) && this.mLoadedMenus[n] == null ? new short[]{(short)n} : new short[0];
        }
        this.mStateLoadingCount = this.mFlowHandler.getStateLoadingCount(this.mNextState);
        this.mMaxLoadingCount = this.mStateGroupLoadingCount + this.mStateLoadingCount + this.mMenusToLoad.length;
        this.mDavinciLoadingPercentage = this.mFlowHandler.getDavinciLoadingPercentage(this.mNextState);
    }

    private void releaseCurrentState() {
        int n;
        int n2;
        if (this.mReloadStateGroup) {
            this.mReloadStateGroup = false;
            n2 = this.mMenuScreenCount;
            while (--n2 >= 0) {
                this.removeFromMenuCache(n2);
            }
            smMenuResourceHashtable = null;
            this.mCurrentMenu = null;
        }
        n2 = this.mStateGroups[this.mNextState];
        int n3 = n = this.mCurrentState != -1 ? this.mStateGroups[this.mCurrentState] : -1;
        if (n != -1) {
            if (n != n2 && !this.mFlowHandler.isChildGroup(n, n2)) {
                int n4 = this.mStateGroupInMemory.length;
                while (--n4 >= 0) {
                    if (!this.mStateGroupInMemory[n4] || n4 == n2) continue;
                    this.mFlowHandler.unloadStateGroup(n4, n2);
                    int n5 = this.mStateGroups.length;
                    while (--n5 >= 0) {
                        if (this.mStateGroups[n5] != n4 || !this.isMenuState(n5)) continue;
                        if (this.mLoadedMenus[n5] != null) {
                            // empty if block
                        }
                        this.removeFromMenuCache(n5);
                    }
                    this.mStateGroupInMemory[n4] = false;
                }
            }
        } else if (this.isMenuState(this.mCurrentState)) {
            if (this.mLoadedMenus[this.mCurrentState] != null) {
                // empty if block
            }
            this.removeFromMenuCache(this.mCurrentState);
        }
        this.mFlowHandler.unloadState(this.mCurrentState, this.mNextState);
        this.deactivateState();
    }

    private void setFlowTransitionState(int n) {
        this.mTransitionTime = 0;
        this.mFlowTransitionState = n;
    }

    private boolean isTransitionNeeded(int n, int n2, int n3) {
        if (n == 3) {
            return this.loadingScreenNeeded();
        }
        return false;
    }

    private boolean loadingScreenNeeded() {
        return this.mMaxLoadingCount > 0;
    }

    private void activateNextTransitionState() {
        int n = this.mFlowTransitionState;
        do {
            switch (n) {
                case 5: {
                    this.setFlowTransitionState(0);
                    return;
                }
                case 1: {
                    if (this.mCurrentState == -1) break;
                    this.releaseCurrentState();
                    break;
                }
                case 4: {
                    this.activateNextState();
                }
            }
        } while (!this.isTransitionNeeded(++n, this.mTransitionStateA, this.mTransitionStateB));
        switch (n) {
            case 1: 
            case 5: {
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                this.mFlowHandler.setLoading(this.mNextState, true);
                this.mLoadingCounter = 0;
                this.mDavinciLoading = false;
                Toolkit.removeAllSoftKeys();
            }
        }
        this.setFlowTransitionState(n);
    }

    private void updateLoading() {
        int n;
        if (this.mLoadingCounter < this.mMaxLoadingCount) {
            int n2;
            long l = System.currentTimeMillis();
            do {
                if (this.mDavinciLoading) {
                    DavinciUtilities.loadNext();
                } else {
                    short s;
                    int n3 = this.mLoadingCounter;
                    if (n3 < this.mStateGroupLoadingCount) {
                        s = this.mStateGroups[this.mNextState];
                        this.mFlowHandler.loadStateGroup(s, n3);
                    } else if ((n3 -= this.mStateGroupLoadingCount) < this.mStateLoadingCount) {
                        this.mFlowHandler.loadState(this.mNextState, n3);
                    } else {
                        s = this.mMenusToLoad[n3 -= this.mStateLoadingCount];
                        this.loadMenu(s);
                    }
                }
                ++this.mLoadingCounter;
                n2 = (int)(System.currentTimeMillis() - l);
            } while (this.mLoadingCounter < this.mMaxLoadingCount && n2 < 50);
            return;
        }
        if (!this.mDavinciLoading && (n = DavinciUtilities.getAdditionalLoadingCount()) > 0) {
            this.mLoadingCounter = 0;
            this.mMaxLoadingCount = n;
            this.mDavinciLoading = true;
            return;
        }
        if (!this.isFinalLoadingStepDelayDone()) {
            return;
        }
        this.activateNextTransitionState();
    }

    private void activateNextState() {
        byte by = this.mStateGroups[this.mNextState];
        if (by != -1) {
            this.mStateGroupInMemory[by] = true;
        }
        smMenuResourceHashtable = null;
        this.mFlowHandler.setLoading(this.mNextState, false);
        int n = this.mCurrentState;
        this.mCurrentState = this.mNextState;
        this.mNextState = -1;
        int n2 = this.mStateHistoryPointer;
        while (--n2 >= 0) {
            if (this.mStateHistory[n2] != this.mCurrentState) continue;
            this.mStateHistoryPointer = n2;
            break;
        }
        this.activateState(this.mCurrentState);
        this.mFlowHandler.switchState(n, this.mCurrentState, this.mCurrentMenu);
    }

    private void changeState() {
        this.mTransitionStateA = this.mCurrentState;
        while (this.isBranchState(this.mNextState)) {
            this.mCurrentState = this.mNextState;
            this.activateBranch(this.mNextState);
            this.processBranch(this.mNextState);
        }
        this.mCurrentState = this.mTransitionStateA;
        this.mTransitionStateB = this.mNextState;
        this.createLoadingLists();
        this.activateNextTransitionState();
    }

    private void deactivateState() {
        this.mCurrentMenu = null;
        this.mCurrentGameScreen = null;
        this.mCurrentBranch = null;
        Toolkit.removeAllSoftKeys();
    }

    private void activateState(int n) {
        if (this.isMenuState(n)) {
            this.activateMenuScreen(n);
        } else if (this.isGameState(n)) {
            this.activateGameScreen(n);
        } else {
            this.activateBranch(n);
        }
    }

    private boolean isBranchState(int n) {
        int n2 = this.mGameScreenStartIndex + this.mGameScreenCount;
        return n >= n2 && n < n2 + this.mBranchCount;
    }

    private boolean isMenuState(int n) {
        return n < this.mMenuScreenCount;
    }

    private boolean isGameState(int n) {
        return n >= this.mGameScreenStartIndex && n < this.mGameScreenStartIndex + this.mGameScreenCount;
    }

    private void activateMenuScreen(int n) {
        this.mCurrentMenu = this.mLoadedMenus[n];
        if (this.mGoingForward) {
            this.mCurrentMenu.setSelectedItem(0);
        } else {
            this.mCurrentMenu.setSelectedItem(this.mMenuSelectedItems[this.mCurrentState] & 0xFF);
        }
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 2);
        this.mCurrentMenu.setVisible();
        this.mFlowHandler.processMenu(n, this.mCurrentMenu, 3);
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateGameScreen(int n) {
        if (this.mLoadedGameScreens[n - this.mGameScreenStartIndex] == null) {
            this.loadGameScreen(n);
        }
        this.mCurrentGameScreen = this.mLoadedGameScreens[n - this.mGameScreenStartIndex];
        this.mStoreStateToHistory = this.mFlowHandler.shouldStoreStateToHistory(n);
    }

    private void activateBranch(int n) {
        this.mCurrentBranch = this.mLoadedBranches[n - this.mBranchStartIndex];
        this.mStoreStateToHistory = false;
    }

    private void processBranch(int n) {
        if (this.mFlowHandler.evaluateBranchCondition(n)) {
            this.processEvent(this.mCurrentBranch[0]);
        } else {
            this.processEvent(this.mCurrentBranch[1]);
        }
    }

    private void loadMenu(int n) {
        int n2;
        int n3;
        if (smMenuResourceHashtable == null) {
            smMenuResourceHashtable = new Hashtable();
        }
        byte[] byArray = this.mFlowBinary;
        int n4 = this.mStateOffsets[n];
        int n5 = byArray[n4++];
        Vector<Integer> vector = new Vector<Integer>();
        Image[][] imageArrayArray = new Image[1][];
        SpriteObject[] spriteObjectArray = new SpriteObject[1];
        byte by = byArray[n4++];
        byte by2 = byArray[n4++];
        MenuObject menuObject = new MenuObject();
        this.mFlowHandler.processMenu(n, menuObject, 0);
        this.mFlowHandler.menuSetScreen(n, menuObject, by, n5, by2);
        byte by3 = byArray[n4++];
        this.mFlowHandler.menuSetStyle(n, menuObject, by3);
        int n6 = FlowProcessor.loadResourceID(byArray, n4);
        n4 += 4;
        String string = this.mFlowHandler.processText(n, n6, -1);
        n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray);
        Image image = imageArrayArray[0] == null ? null : imageArrayArray[0][0];
        SpriteObject spriteObject = spriteObjectArray[0];
        by2 = byArray[n4++];
        if (string != null || spriteObject != null || image != null) {
            if (spriteObject != null) {
                this.mFlowHandler.menuSetTitleBarDvc(n, menuObject, string, spriteObject, by2);
            } else {
                this.mFlowHandler.menuSetTitleBar(n, menuObject, string, image, by2);
            }
        }
        byte by4 = byArray[n4++];
        if ((n3 = byArray[n4++] & 0xFF) != 255) {
            vector.addElement(new Integer(by4));
            vector.addElement(new Integer(n3));
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, by4, 0);
        byte by5 = byArray[n4++];
        int n7 = byArray[n4++] & 0xFF;
        if (n7 != 255) {
            vector.addElement(new Integer(by5));
            vector.addElement(new Integer(n7));
        }
        this.mFlowHandler.menuSetSoftkey(n, menuObject, by5, 1);
        block7: for (int i = 0; i < n5; ++i) {
            n2 = byArray[n4++];
            switch (n2) {
                case 0: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetItem(n, menuObject, i, n2, string, spriteObject, imageArray, s);
                    continue block7;
                }
                case 1: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    int n8 = byArray[n4++];
                    String[] stringArray = new String[n8];
                    for (int j = 0; j < n8; ++j) {
                        n6 = FlowProcessor.loadResourceID(byArray, n4);
                        n4 += 4;
                        stringArray[j] = this.mFlowHandler.processText(n, n6, i);
                    }
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, n8, imageArrayArray, spriteObjectArray);
                    Image[] imageArray2 = imageArrayArray[0];
                    SpriteObject spriteObject2 = spriteObjectArray[0];
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetSwitchItem(n, menuObject, i, string, spriteObject, imageArray, stringArray, spriteObject2, imageArray2, s);
                    continue block7;
                }
                case 2: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 4, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    int n9 = byArray[n4++] & 0xFF;
                    int n10 = byArray[n4++] & 0xFF;
                    short s = FlowProcessor.loadEvent(byArray[n4++]);
                    this.mFlowHandler.menuSetSliderItem(n, menuObject, i, string, spriteObject, imageArray, n9, n10, s);
                    continue block7;
                }
                case 3: {
                    n4 += 9;
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 3, imageArrayArray, spriteObjectArray);
                    n4 += 2;
                    continue block7;
                }
                case 4: {
                    n6 = FlowProcessor.loadResourceID(byArray, n4);
                    n4 += 4;
                    string = this.mFlowHandler.processText(n, n6, i);
                    n4 = FlowProcessor.loadImagesOrAnimations(byArray, n4, 1, imageArrayArray, spriteObjectArray);
                    Image[] imageArray = imageArrayArray[0];
                    spriteObject = spriteObjectArray[0];
                    this.mFlowHandler.menuSetItem(n, menuObject, i, 1, string, spriteObject, imageArray, -1);
                }
            }
        }
        this.mFlowHandler.processMenu(n, menuObject, 1);
        this.mFlowHandler.menuSetSize(n, menuObject);
        menuObject.setSelectedItem(0);
        this.mLoadedMenus[n] = menuObject;
        if (vector.size() > 0) {
            short[] sArray = new short[vector.size()];
            for (n2 = 0; n2 < vector.size(); ++n2) {
                sArray[n2] = (short)((Integer)vector.elementAt(n2)).intValue();
            }
            this.mMenuSoftkeyEvents[n] = sArray;
        }
    }

    private static int loadImagesOrAnimations(byte[] byArray, int n, int n2, Image[][] imageArray, SpriteObject[] spriteObjectArray) {
        int n3;
        imageArray[0] = null;
        spriteObjectArray[0] = null;
        int[] nArray = new int[n2];
        byte[] byArray2 = new byte[n2];
        boolean bl = false;
        boolean bl2 = false;
        for (n3 = 0; n3 < n2; ++n3) {
            nArray[n3] = FlowProcessor.loadResourceID(byArray, n);
            n += 4;
            bl2 = bl2 || nArray[n3] != -1;
            byArray2[n3] = byArray[n++];
            bl = bl || byArray2[n3] == 2 || byArray2[n3] == 3;
        }
        if (bl2) {
            if (bl) {
                Animation[] animationArray = new Animation[n2];
                for (int i = 0; i < n2; ++i) {
                    int n4 = nArray[i];
                    Integer n5 = new Integer(n4);
                    Animation animation = (Animation)smMenuResourceHashtable.get(n5);
                    if (animation == null) {
                        animation = DavinciUtilities.loadAnimation(n4);
                        smMenuResourceHashtable.put(n5, animation);
                    }
                    animationArray[i] = animation;
                }
                spriteObjectArray[0] = new SpriteObject(animationArray, true);
            } else {
                imageArray[0] = new Image[n2];
                for (n3 = 0; n3 < n2; ++n3) {
                    int n6 = nArray[n3];
                    Integer n7 = new Integer(n6);
                    Image image = (Image)smMenuResourceHashtable.get(n7);
                    if (image == null) {
                        if (byArray2[n3] == 0) {
                            image = Toolkit.getImage(n6);
                        } else if (byArray2[n3] == 1) {
                            image = DavinciUtilities.getImage(n6);
                        }
                        if (image != null) {
                            smMenuResourceHashtable.put(n7, image);
                        }
                    }
                    imageArray[0][n3] = image;
                }
            }
        }
        return n;
    }

    private void loadGameScreen(int n) {
        byte[] byArray = this.mFlowBinary;
        int n2 = this.mStateOffsets[this.mMenuScreenCount + (n - this.mGameScreenStartIndex)];
        int n3 = byArray[n2++] & 0xFF;
        short[] sArray = new short[n3];
        for (int i = 0; i < n3; ++i) {
            sArray[i] = FlowProcessor.loadEvent(byArray[n2++]);
        }
        this.mLoadedGameScreens[n - this.mGameScreenStartIndex] = sArray;
    }

    private static short loadEvent(byte by) {
        short s = (short)(by & 0xFF);
        return s == 255 ? (short)-1 : (short)s;
    }

    public static int loadResourceID(byte[] byArray, int n) {
        return byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF;
    }

    private void loadBranch(int n) {
        byte[] byArray = this.mFlowBinary;
        int n2 = this.mStateOffsets[this.mMenuScreenCount + this.mGameScreenCount + (n - this.mBranchStartIndex)];
        short[] sArray = new short[]{FlowProcessor.loadEvent(byArray[n2++]), FlowProcessor.loadEvent(byArray[n2])};
        this.mLoadedBranches[n - this.mBranchStartIndex] = sArray;
    }

    private void processEvent(int n) {
        int n2 = -1;
        if (this.mStateHistoryPointer > 0) {
            n2 = this.mStateHistory[this.mStateHistoryPointer - 1];
        }
        if (n != -1) {
            if (n == -2) {
                if (this.mCurrentGameScreen != null && this.mCurrentGameScreen.length > 0) {
                    this.processEvent(this.mCurrentGameScreen[0]);
                }
            } else if (n == -3) {
                this.mGoingForward = false;
                this.mNextState = n2;
                --this.mStateHistoryPointer;
            } else if (n >= 0) {
                int n3 = this.mEventTargets[n];
                if (n3 != -1) {
                    this.mGoingForward = true;
                    this.mNextState = n3;
                    if (this.isMenuState(this.mCurrentState)) {
                        this.mMenuSelectedItems[this.mCurrentState] = (byte)this.mCurrentMenu.getSelectedItem();
                    }
                    if (n2 == n3) {
                        this.mGoingForward = false;
                        --this.mStateHistoryPointer;
                    } else if (this.mStoreStateToHistory) {
                        this.mStateHistory[this.mStateHistoryPointer++] = (short)this.mCurrentState;
                    }
                }
                this.mFlowHandler.eventOccurred(this.mCurrentState, n);
            }
        }
    }

    private void processSoftkeyEvent(int n) {
        if (n != -1 && Toolkit.getSoftKeyType(n) == 2) {
            this.processEvent(-3);
        }
    }

    private void removeFromMenuCache(int n) {
        if (this.mLoadedMenus[n] != null) {
            this.mLoadedMenus[n].releaseScreen();
            this.mLoadedMenus[n] = null;
        }
    }

    public int getLoadingPercentage() {
        int n = -1;
        if (this.mFlowTransitionState == 3) {
            if (this.mInFinalLoadingStep) {
                return 100;
            }
            int n2 = 100 - this.mDavinciLoadingPercentage;
            n = this.mDavinciLoading ? n2 + this.mLoadingCounter * this.mDavinciLoadingPercentage / this.mMaxLoadingCount : this.mLoadingCounter * n2 / this.mMaxLoadingCount;
        }
        return n;
    }

    private boolean isFinalLoadingStepDelayDone() {
        int n;
        long l = System.currentTimeMillis();
        if (!this.mInFinalLoadingStep) {
            this.mInFinalLoadingStep = true;
            this.mFinalLoadingStepStartTime = l;
        }
        if ((n = (int)(l - this.mFinalLoadingStepStartTime)) < 150) {
            return false;
        }
        this.mInFinalLoadingStep = false;
        return true;
    }
}

