/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class MenuCountry {
    private static final int COLUM_MAX = 4;
    private static final int FILE_MAX = 4;
    private static final int TOTAL = 16;
    private static int smPosX;
    private static int smPosY;
    private static int smFilePos;
    private static String smHeaderStr;
    private static String[] smCountryStr;
    private static SpriteObject[] smSelectorSpr;
    private static SpriteObject[] smImageSpr;
    private static SpriteObject[] smArrowSpr;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int UP = 2;
    private static final int DOWN = 3;
    private static int mPressedSK;
    private static int mBoxSelectedX;
    private static int mBoxSelectedY;
    private static int[] mPointerBoxX;
    private static int[] mPointerBoxY;
    public static int smSelected;
    public static final int[] SPRITE_IDS;
    private static Vector smSpriteObjectCache;

    public static int getLoadingCount() {
        return 16;
    }

    public static void load(int n) {
        if (n == 0) {
            smImageSpr = new SpriteObject[16];
        } else if (n == 1) {
            smSelectorSpr = new SpriteObject[4];
            MenuCountry.smSelectorSpr[0] = MenuCountry.loadSpriteObject(458869, true);
            MenuCountry.smSelectorSpr[1] = MenuCountry.loadSpriteObject(458868, true);
            MenuCountry.smSelectorSpr[2] = MenuCountry.loadSpriteObject(458867, true);
            MenuCountry.smSelectorSpr[3] = MenuCountry.loadSpriteObject(458870, true);
        } else if (n == 2) {
            smArrowSpr = new SpriteObject[4];
            MenuCountry.smArrowSpr[0] = MenuCountry.loadSpriteObject(458791, true);
            MenuCountry.smArrowSpr[1] = MenuCountry.loadSpriteObject(458792, true);
            MenuCountry.smArrowSpr[2] = MenuCountry.loadSpriteObject(458871, true);
            MenuCountry.smArrowSpr[3] = MenuCountry.loadSpriteObject(458872, true);
        }
        MenuCountry.smImageSpr[n] = MenuCountry.loadSpriteObject(SPRITE_IDS[n], true);
    }

    public static void freeResources() {
        MenuCountry.freeSpriteObjects();
        smSelectorSpr = null;
        smArrowSpr = null;
        smImageSpr = null;
    }

    public static void keyEventOccurred(int n, int n2) {
        if (n2 == 3) {
            mPressedSK = n;
        }
        if (n2 == 0) {
            int n3 = Toolkit.getToolkitGameAction(n);
            switch (n3) {
                case 52: {
                    if (smPosX <= 0) break;
                    --smPosX;
                    break;
                }
                case 54: {
                    if (smPosX >= 3) break;
                    ++smPosX;
                    break;
                }
                case 50: {
                    if (smPosY <= 0) break;
                    --smPosY;
                    break;
                }
                case 56: {
                    if (smPosY >= 3) break;
                    ++smPosY;
                    break;
                }
                case 53: {
                    mPressedSK = 0;
                }
            }
        }
    }

    public static void pointerEventOccurred(int n, int n2, int n3) {
        if (n3 == 0) {
            int n4 = smImageSpr[0].getWidth();
            int n5 = smImageSpr[0].getHeight();
            if (MenuCountry.checkColision(n, n2, smArrowSpr[0], mBoxSelectedX - (n4 >> 1) - (smArrowSpr[0].getWidth() >> 1), mBoxSelectedY)) {
                if (smPosX > 0) {
                    --smPosX;
                }
            } else if (MenuCountry.checkColision(n, n2, smArrowSpr[1], mBoxSelectedX + (n4 >> 1) + (smArrowSpr[1].getWidth() >> 1), mBoxSelectedY)) {
                if (smPosX < 3) {
                    ++smPosX;
                }
            } else if (MenuCountry.checkColision(n, n2, smArrowSpr[2], mBoxSelectedX, mBoxSelectedY - (n5 >> 1) - (smArrowSpr[2].getHeight() >> 1))) {
                if (smPosY > 0) {
                    --smPosY;
                }
            } else if (MenuCountry.checkColision(n, n2, smArrowSpr[3], mBoxSelectedX, mBoxSelectedY + (n5 >> 1) + (smArrowSpr[3].getHeight() >> 1))) {
                if (smPosY < 3) {
                    ++smPosY;
                }
            } else if (Util.colision(n, n2, 1, 1, mBoxSelectedX - (n4 >> 1), mBoxSelectedY - (n5 >> 1), n4, n5)) {
                mPressedSK = 0;
            } else {
                for (int i = 0; i < 16; ++i) {
                    if (!MenuCountry.checkColision(n, n2, smImageSpr[i], mPointerBoxX[i], mPointerBoxY[i])) continue;
                    smPosX = i % 4;
                    smPosY = i / 4;
                }
            }
            mBoxSelectedX = 0;
            mBoxSelectedY = 0;
        }
    }

    public static void init(boolean bl) {
        smHeaderStr = Toolkit.getText(181);
        smCountryStr = new String[Game.COUNTRIES_IDS.length];
        for (int i = 0; i < smCountryStr.length; ++i) {
            MenuCountry.smCountryStr[i] = Toolkit.getText(Game.COUNTRIES_IDS[i]);
        }
        if (bl) {
            smPosX = 0;
            smPosY = 0;
            smFilePos = 0;
        }
        Toolkit.removeAllSoftKeys();
        Toolkit.setSoftKey(0, 0);
        Toolkit.setSoftKey(5, 0);
        mPressedSK = -1;
    }

    public static int logicUpdate(int n) {
        if (mPressedSK != -1) {
            int n2 = mPressedSK;
            mPressedSK = -1;
            if (n2 == 0) {
                Game.smCountrySelected = smSelected = smPosY * 4 + smPosX;
                return -2;
            }
            if (n2 == 5) {
                return 21;
            }
        }
        smSelectorSpr[0].logicUpdate(n);
        smSelectorSpr[1].logicUpdate(n);
        smSelectorSpr[2].logicUpdate(n);
        smSelectorSpr[3].logicUpdate(n);
        smArrowSpr[0].logicUpdate(n);
        smArrowSpr[1].logicUpdate(n);
        smArrowSpr[2].logicUpdate(n);
        smArrowSpr[3].logicUpdate(n);
        return -1;
    }

    public static void doDraw(Graphics graphics) {
        smSelected = smPosY * 4 + smPosX;
        graphics.setColor(0);
        graphics.fillRect(0, 0, Toolkit.getScreenWidth(), Toolkit.getScreenHeight());
        Game.drawCommonBackground(graphics);
        TextField.draw(graphics, smHeaderStr, GameEngine.smFontTitle, Toolkit.getScreenWidth() >> 1, 0, 17);
        TextField.draw(graphics, smCountryStr[smPosY * 4 + smPosX], GameEngine.smFontOutline, Toolkit.getScreenWidth() >> 1, GameEngine.smFontTitle.getHeight() + GameEngine.smFontOutline.getHeight(), 3);
        int n = smImageSpr[0].getWidth();
        int n2 = smImageSpr[0].getHeight();
        int n3 = (n + n / 3) * 4;
        int n4 = Toolkit.getScreenWidth() - n3 >> 1;
        int n5 = GameEngine.smFontTitle.getHeight() + (GameEngine.smFontOutline.getHeight() << 1);
        int n6 = Toolkit.getScreenHeight() - Toolkit.getSoftKeyAreaHeight() - n5;
        int[] nArray = Util.calculateDistributionBoxes(4, n3);
        int n7 = 0;
        n7 = nArray[1] - nArray[0];
        n7 = Util.regla3(90, 100, n7);
        int n8 = n6 / n7;
        int n9 = n6;
        n6 = n8 * n7;
        n5 += n9 - n6 >> 1;
        int n10 = n7 >> 1;
        if (smFilePos > smPosY) {
            smFilePos = smPosY;
        } else if (smFilePos <= smPosY - n8) {
            smFilePos = smPosY - n8 + 1;
        }
        int n11 = 0;
        for (int i = 0; i < 4; ++i) {
            if (i < smFilePos || i >= smFilePos + n8) continue;
            for (int j = 0; j < 4; ++j) {
                int n12 = i * 4 + j;
                smImageSpr[n12].draw(graphics, n4 + nArray[j], n5 + n10 + n11 * n7);
                MenuCountry.mPointerBoxX[n12] = n4 + nArray[j];
                MenuCountry.mPointerBoxY[n12] = n5 + n10 + n11 * n7;
            }
            ++n11;
        }
        mBoxSelectedX = n4 + nArray[smPosX];
        mBoxSelectedY = n5 + n10 + (smPosY - smFilePos) * n7;
        smSelectorSpr[0].draw(graphics, mBoxSelectedX - (n >> 1), mBoxSelectedY - (n2 >> 1));
        smSelectorSpr[1].draw(graphics, mBoxSelectedX + (n >> 1), mBoxSelectedY - (n2 >> 1));
        smSelectorSpr[2].draw(graphics, mBoxSelectedX - (n >> 1), mBoxSelectedY + (n2 >> 1));
        smSelectorSpr[3].draw(graphics, mBoxSelectedX + (n >> 1), mBoxSelectedY + (n2 >> 1));
        if (smPosX > 0) {
            smArrowSpr[0].draw(graphics, mBoxSelectedX - (n >> 1), mBoxSelectedY);
        }
        if (smPosX < 3) {
            smArrowSpr[1].draw(graphics, mBoxSelectedX + (n >> 1), mBoxSelectedY);
        }
        if (smPosY > 0) {
            smArrowSpr[2].draw(graphics, mBoxSelectedX, mBoxSelectedY - (n2 >> 1));
        }
        if (smPosY < 3) {
            smArrowSpr[3].draw(graphics, mBoxSelectedX, mBoxSelectedY + (n2 >> 1));
        }
    }

    private static boolean checkColision(int n, int n2, SpriteObject spriteObject, int n3, int n4) {
        return Util.colision(n, n2, 1, 1, n3 - (spriteObject.getWidth() >> 1) - 10, n4 - (spriteObject.getHeight() >> 1) - 10, spriteObject.getWidth() + 10, spriteObject.getHeight() + 10);
    }

    protected static SpriteObject loadSpriteObject(int[] nArray, boolean bl) {
        SpriteObject spriteObject = new SpriteObject(DavinciUtilities.loadAnimations(nArray), bl);
        if (smSpriteObjectCache == null) {
            smSpriteObjectCache = new Vector();
        }
        smSpriteObjectCache.addElement(spriteObject);
        return spriteObject;
    }

    protected static SpriteObject loadSpriteObject(int n, boolean bl) {
        return MenuCountry.loadSpriteObject(new int[]{n}, bl);
    }

    public static void freeSpriteObjects() {
        if (smSpriteObjectCache != null) {
            for (int i = 0; i < smSpriteObjectCache.size(); ++i) {
                SpriteObject spriteObject = (SpriteObject)smSpriteObjectCache.elementAt(i);
                spriteObject.freeResources();
            }
            smSpriteObjectCache = null;
        }
    }

    static {
        mPressedSK = -1;
        mPointerBoxX = new int[16];
        mPointerBoxY = new int[16];
        SPRITE_IDS = Game.COUNTRY_FLAG_IDS;
    }
}

