/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsBuffer {
    public static final int NEUTRAL_COLOR = -8355712;
    private Image mBufferImage;
    private Graphics mBufferGraphics;
    private boolean mImageSource;
    private static final int BUFFER_COLOR = 0;
    private static final int BUFFER_MODIFIED = 1;
    private static final int BUFFER_TARGET = 2;
    private static final int BUFFER_BLUR_RESULT = 3;
    private static final int BUFFER_BLUR_RED = 4;
    private static final int BUFFER_BLUR_GREEN = 5;
    private static final int BUFFER_BLUR_BLUE = 6;
    private static final int BUFFER_BLUR_ALPHA = 7;
    private static final int BUFFER_ORIGINAL = 8;
    private int[][] mBuffer = new int[9][];
    private int mFramePivotX;
    private int mFramePivotY;
    private int mFrameWidth;
    private int mFrameHeight;
    private static final int PARAM_COLOR_MODIFICATION = 0;
    private static final int PARAM_BILINEAR_FILTERING = 1;
    private static final int PARAM_ANGLE = 2;
    private static final int PARAM_SCALE_WIDTH = 3;
    private static final int PARAM_SCALE_HEIGHT = 4;
    private static final int PARAM_REPAINTED = 5;
    private static final int PARAM_COUNT = 6;
    private int[] mEffectParam = new int[6];
    private int[] mLastEffectParam;
    public static final int SCALE_ACCURACY = 10;
    public static final int NO_SCALING = 1024;
    private int mRotatedWidth;
    private int mRotatedHeight;
    private int[] mRotatedX;
    private int[] mRotatedY;
    private int mBlurBoxWidth;
    private int mBlurBoxHeight;
    public static final int RENDER_MODE_NORMAL = 0;
    public static final int RENDER_MODE_ADD = 1;
    public static final int RENDER_MODE_SUB = 2;
    private int mRenderMode;
    private Image mRenderTarget;
    private static final int TRANSPARENT_COLOR = -65281;
    private static int[] smTransparentColor;
    private static final int BUFFER_EXTRA = 120;

    public void prepareFrame(Image image, int n, int n2) {
        this.createBuffer(image, n, n2, 0);
    }

    private boolean allocateBuffer(int n, int n2, boolean bl) {
        if (this.mBuffer[n] == null || n2 > this.mBuffer[n].length) {
            if (bl) {
                n2 = n2 * 120 / 100;
            }
            this.mBuffer[n] = new int[n2];
            return true;
        }
        return false;
    }

    public void createBuffer(Image image, int n, int n2, int n3) {
        this.mImageSource = true;
        this.mFramePivotX = n;
        this.mFramePivotY = n2;
        this.mFrameWidth = image.getWidth();
        this.mFrameHeight = image.getHeight();
        int n4 = this.mFrameWidth * this.mFrameHeight;
        this.allocateBuffer(8, n4, false);
        image.getRGB(this.mBuffer[8], 0, this.mFrameWidth, 0, 0, this.mFrameWidth, this.mFrameHeight);
        this.transformBuffer(n3);
        this.mEffectParam[5] = this.mEffectParam[5] + 1;
    }

    public void createBuffer(int n, int n2, int n3, int n4) {
        this.mImageSource = false;
        this.mFramePivotX = n3;
        this.mFramePivotY = n4;
        this.mFrameWidth = n;
        this.mFrameHeight = n2;
        int n5 = 0;
        int n6 = 0;
        if (this.mBufferImage != null) {
            n5 = this.mBufferImage.getWidth();
            n6 = this.mBufferImage.getHeight();
        }
        if (n > n5 || n2 > n6) {
            this.mBufferImage = Image.createImage((int)n, (int)n2);
            this.mBufferGraphics = this.mBufferImage.getGraphics();
            this.mBufferGraphics.setClip(0, 0, n, n2);
        }
        int n7 = n * n2;
        this.allocateBuffer(8, n7, false);
        if (smTransparentColor == null) {
            smTransparentColor = new int[]{-65281};
            Image image = Image.createRGBImage((int[])smTransparentColor, (int)1, (int)1, (boolean)false);
            image.getRGB(smTransparentColor, 0, 1, 0, 0, 1, 1);
        }
        this.mBufferGraphics.setColor(smTransparentColor[0]);
        this.mBufferGraphics.fillRect(0, 0, n, n2);
        this.mEffectParam[5] = this.mEffectParam[5] + 1;
    }

    public void prepareFrame(int n, int n2, int n3, int n4, boolean bl) {
        this.createBuffer(n, n2, n3, n4);
    }

    private void fixTransparentPixels(int[] nArray, int n, int n2) {
        int n3 = smTransparentColor[0];
        int n4 = n * n2;
        while (--n4 >= 0) {
            if (nArray[n4] != n3) continue;
            nArray[n4] = 0;
        }
    }

    private boolean readPixelsAgain() {
        return this.mLastEffectParam == null || this.mEffectParam[5] != this.mLastEffectParam[5];
    }

    public void updateBufferARGB(int n) {
        this.mEffectParam[0] = n;
        int[] nArray = this.mBuffer[8];
        if (!this.mImageSource && this.readPixelsAgain()) {
            this.mBufferImage.getRGB(nArray, 0, this.mFrameWidth, 0, 0, this.mFrameWidth, this.mFrameHeight);
            this.fixTransparentPixels(nArray, this.mFrameWidth, this.mFrameHeight);
        }
        if (n != -8355712) {
            int n2;
            int n3;
            this.allocateBuffer(0, this.mFrameWidth * this.mFrameHeight, false);
            int[] nArray2 = this.mBuffer[0];
            int n4 = n & 0xFF000000;
            int n5 = (n & 0xFF0000) - 0x800000 << 1;
            if (n5 == 0xFE0000) {
                n5 = 0xFF0000;
            }
            if ((n3 = (n & 0xFF00) - 32768 << 1) == 65024) {
                n3 = 65280;
            }
            if ((n2 = (n & 0xFF) - 128 << 1) == 254) {
                n2 = 255;
            }
            if (!this.mImageSource) {
                int n6 = this.mFrameWidth * this.mFrameHeight;
                while (--n6 >= 0) {
                    int n7 = nArray[n6];
                    if ((n7 & 0xFF000000) == 0) {
                        nArray2[n6] = 0;
                        continue;
                    }
                    int n8 = (n7 & 0xFF0000) + n5;
                    if (n8 > 0xFF0000) {
                        n8 = 0xFF0000;
                    } else if (n8 < 0) {
                        n8 = 0;
                    }
                    int n9 = (n7 & 0xFF00) + n3;
                    if (n9 > 65280) {
                        n9 = 65280;
                    } else if (n9 < 0) {
                        n9 = 0;
                    }
                    int n10 = (n7 & 0xFF) + n2;
                    if (n10 > 255) {
                        n10 = 255;
                    } else if (n10 < 0) {
                        n10 = 0;
                    }
                    nArray2[n6] = n4 | n8 | n9 | n10;
                }
            } else {
                if ((n4 >>>= 24) == 255) {
                    n4 = 256;
                }
                n4 <<= 16;
                int n11 = this.mFrameWidth * this.mFrameHeight;
                while (--n11 >= 0) {
                    int n12 = nArray[n11];
                    int n13 = (n12 & 0xFF0000) + n5;
                    if (n13 > 0xFF0000) {
                        n13 = 0xFF0000;
                    } else if (n13 < 0) {
                        n13 = 0;
                    }
                    int n14 = (n12 & 0xFF00) + n3;
                    if (n14 > 65280) {
                        n14 = 65280;
                    } else if (n14 < 0) {
                        n14 = 0;
                    }
                    int n15 = (n12 & 0xFF) + n2;
                    if (n15 > 255) {
                        n15 = 255;
                    } else if (n15 < 0) {
                        n15 = 0;
                    }
                    nArray2[n11] = (n12 >>> 24) * n4 & 0xFF000000 | n13 | n14 | n15;
                }
            }
        }
        this.mEffectParam[5] = this.mEffectParam[5] + 1;
    }

    public void setRotation(int n) {
        this.mEffectParam[2] = n;
    }

    private int[] getPixelBuffer() {
        if (this.mEffectParam[0] != -8355712) {
            return this.mBuffer[0];
        }
        return this.mBuffer[8];
    }

    private void doRotation(int n, int n2, int n3) {
        int n4 = this.mFrameWidth * n2 >> 10;
        if (this.mFrameHeight > this.mFrameWidth) {
            n4 = this.mFrameHeight * n3 >> 10;
        }
        n4 = n4 * 362 >> 8;
        n4 += 2;
        n4 *= n4;
        this.allocateBuffer(1, n4, true);
        if (this.mRotatedY == null) {
            this.mRotatedX = new int[4];
            this.mRotatedY = new int[4];
        }
        int[] nArray = this.getPixelBuffer();
        int[] nArray2 = this.mBuffer[1];
        int n5 = DavinciUtilities.sin(n);
        int n6 = DavinciUtilities.cos(n);
        int n7 = this.mFrameWidth;
        int n8 = this.mFrameHeight;
        int n9 = -n7 * n2 >> 10;
        int n10 = n9 + ((n7 << 1) * n2 >> 10);
        int n11 = -n8 * n3 >> 10;
        int n12 = n11 + ((n8 << 1) * n3 >> 10);
        this.mRotatedX[0] = n9 * n6 - n11 * n5;
        this.mRotatedY[0] = n11 * n6 + n9 * n5;
        this.mRotatedX[1] = n10 * n6 - n11 * n5;
        this.mRotatedY[1] = n11 * n6 + n10 * n5;
        this.mRotatedX[2] = n10 * n6 - n12 * n5;
        this.mRotatedY[2] = n12 * n6 + n10 * n5;
        this.mRotatedX[3] = n9 * n6 - n12 * n5;
        this.mRotatedY[3] = n12 * n6 + n9 * n5;
        int n13 = Integer.MAX_VALUE;
        int n14 = Integer.MIN_VALUE;
        int n15 = Integer.MAX_VALUE;
        int n16 = Integer.MIN_VALUE;
        int n17 = 4;
        while (--n17 >= 0) {
            if (this.mRotatedX[n17] > n14) {
                n14 = this.mRotatedX[n17];
            }
            if (this.mRotatedX[n17] < n13) {
                n13 = this.mRotatedX[n17];
            }
            if (this.mRotatedY[n17] > n16) {
                n16 = this.mRotatedY[n17];
            }
            if (this.mRotatedY[n17] >= n15) continue;
            n15 = this.mRotatedY[n17];
        }
        n15 >>= 16;
        n14 >>= 16;
        n16 >>= 16;
        ++n16;
        this.mRotatedWidth = ++n14 - (n13 >>= 16);
        if (this.mRotatedWidth == 0) {
            this.mRotatedWidth = 1;
        }
        this.mRotatedHeight = n16 - n15;
        if (this.mRotatedHeight == 0) {
            this.mRotatedHeight = 1;
        }
        n17 = this.mRotatedWidth;
        n5 = DavinciUtilities.sin(-n);
        n6 = DavinciUtilities.cos(-n);
        int n18 = (n5 << 10) / n2;
        int n19 = (n5 << 10) / n3;
        int n20 = (n6 << 10) / n2;
        int n21 = (n6 << 10) / n3;
        int n22 = n13 * n20 - n15 * n18 + (n7 << 14);
        int n23 = n15 * n21 + n13 * n19 + (n8 << 14);
        boolean bl = this.mEffectParam[1] == 1;
        int n24 = bl ? Short.MIN_VALUE : 0;
        boolean bl2 = false;
        int n25 = 0;
        int n26 = this.mRotatedHeight;
        while (--n26 >= 0) {
            int n27;
            int n28 = n22;
            int n29 = n23;
            n22 -= n18;
            n23 += n21;
            int n30 = 0;
            int n31 = 0;
            for (n27 = 0; n27 < 2; ++n27) {
                int n32 = 0;
                int n33 = 0;
                int n34 = n28;
                int n35 = n20;
                int n36 = n7;
                if (n27 == 1) {
                    n34 = n29;
                    n35 = n19;
                    n36 = n8;
                }
                n36 <<= 15;
                if (n34 < n24) {
                    n32 = n17;
                    if (n35 > 0 && n34 + (n32 = -(n34 - n24) / n35) * n35 < n24) {
                        ++n32;
                    }
                } else if (n34 >= n36) {
                    n32 = n17;
                    if (n35 < 0 && n34 + (n32 = (n34 - n36) / -n35) * n35 >= n36) {
                        ++n32;
                    }
                }
                if ((n34 += n17 * n35 - n35) < n24) {
                    n33 = n17;
                    if (n35 < 0 && n34 - (n33 = (n34 - n24) / n35) * n35 < n24) {
                        ++n33;
                    }
                } else if (n34 >= n36) {
                    n33 = n17;
                    if (n35 > 0 && n34 - (n33 = (n34 - n36) / n35) * n35 >= n36) {
                        ++n33;
                    }
                }
                if (n33 > n31 && (n31 = n33) >= n17) {
                    n31 = n17;
                    break;
                }
                if (n32 <= n30 || (n30 = n32) < n17) continue;
                n30 = n17;
                break;
            }
            if (n30 + n31 >= n17) {
                if (!bl2) {
                    --this.mRotatedHeight;
                    continue;
                }
                this.mRotatedHeight -= n26 + 1;
                return;
            }
            if (n30 != 0) {
                n28 += n30 * n20;
                n29 += n30 * n19;
            }
            bl2 = true;
            n27 = n25 + n17;
            n30 += n25;
            n31 = n27 - n31;
            while (n25 < n30) {
                nArray2[n25++] = 0;
            }
            if (!bl) {
                while (n25 < n31) {
                    nArray2[n25++] = nArray[(n28 >> 15) + (n29 >> 15) * n7];
                    n28 += n20;
                    n29 += n19;
                }
            } else {
                while (n25 < n31) {
                    nArray2[n25++] = DavinciUtilities.bilinearFilter(nArray, n28 >> 7, n29 >> 7, n7, n8);
                    n28 += n20;
                    n29 += n19;
                }
            }
            while (n25 < n27) {
                nArray2[n25++] = 0;
            }
        }
    }

    public void setBlur(int n, int n2) {
        if (n != this.mBlurBoxWidth || n2 != this.mBlurBoxHeight) {
            this.mBlurBoxWidth = n;
            this.mBlurBoxHeight = n2;
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        boolean bl = true;
        if (this.mLastEffectParam != null) {
            n8 = 0;
            n7 = 6;
            while (--n7 >= 0) {
                if (this.mLastEffectParam[n7] == this.mEffectParam[n7]) continue;
                n8 = 1;
                break;
            }
            if (n8 == 0) {
                bl = false;
            }
        } else {
            this.mLastEffectParam = new int[6];
        }
        if ((n6 = (n8 = this.mFrameWidth) * (n7 = this.mEffectParam[3]) >> 10) <= 0) {
            n6 = 1;
        }
        if ((n5 = (n4 = this.mFrameHeight) * (n3 = this.mEffectParam[4]) >> 10) <= 0) {
            n5 = 1;
        }
        int n9 = this.mFramePivotX;
        int n10 = this.mFramePivotY;
        int[] nArray = this.getPixelBuffer();
        int n11 = this.mEffectParam[2];
        if (n11 != 0) {
            if (bl) {
                this.doRotation(n11, n7, n3);
            }
            int n12 = DavinciUtilities.sin(n11);
            int n13 = DavinciUtilities.cos(n11);
            int n14 = (this.mFramePivotX << 1) - this.mFrameWidth;
            int n15 = (this.mFramePivotY << 1) - this.mFrameHeight;
            n14 = n14 * n7 >> 10;
            n15 = n15 * n3 >> 10;
            n8 = this.mRotatedWidth;
            n4 = this.mRotatedHeight;
            n9 = n14 * n13 - n15 * n12 + (n8 << 15) >> 16;
            n10 = n15 * n13 + n14 * n12 + (n4 << 15) >> 16;
            nArray = this.mBuffer[1];
        } else if (n7 != 1024 || n3 != 1024) {
            int n16 = n6 * n5;
            this.allocateBuffer(1, n16, true);
            int[] nArray2 = this.mBuffer[1];
            if (bl) {
                int n17 = (n8 << 10) / n6;
                int n18 = (n4 << 10) / n5;
                int n19 = 0;
                int n20 = 0;
                if (this.mEffectParam[1] == 0) {
                    int n21 = n5;
                    while (--n21 >= 0) {
                        int n22 = (n19 >> 10) * n8 << 10;
                        int n23 = n6;
                        while (--n23 >= 0) {
                            nArray2[n20++] = nArray[n22 >> 10];
                            n22 += n17;
                            if (n23 <= 8) continue;
                            nArray2[n20++] = nArray[n22 >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            nArray2[n20++] = nArray[(n22 += n17) >> 10];
                            n22 += n17;
                            n23 -= 8;
                        }
                        n19 += n18;
                    }
                } else {
                    int n24 = n5;
                    while (--n24 >= 0) {
                        int n25 = (n19 >> 10) * n8 << 10;
                        n25 = 0;
                        int n26 = n19 >> 2;
                        int n27 = n6;
                        while (--n27 >= 0) {
                            nArray2[n20++] = DavinciUtilities.bilinearFilter(nArray, n25 >> 2, n26, n8, n4);
                            n25 += n17;
                        }
                        n19 += n18;
                    }
                }
            }
            nArray = nArray2;
            n8 = n6;
            n4 = n5;
            n9 = n9 * n7 >> 10;
            n10 = n10 * n3 >> 10;
        }
        if (bl && (this.mBlurBoxWidth > 1 || this.mBlurBoxHeight > 1)) {
            nArray = this.doBlur(nArray, n8, n4, this.mBlurBoxWidth, this.mBlurBoxHeight);
        }
        this.drawBuffer(graphics, nArray, n - n9, n2 - n10, n8, n4);
        this.copyEffectParams();
    }

    private void copyEffectParams() {
        int n = 6;
        while (--n >= 0) {
            this.mLastEffectParam[n] = this.mEffectParam[n];
        }
    }

    public int[] doBlur(int[] nArray, int n, int n2, int n3, int n4) {
        if (n3 < 1) {
            n3 = 1;
        }
        if (n4 < 1) {
            n4 = 1;
        }
        this.doBlurPreComputation(nArray, n, n2);
        int[] nArray2 = this.mBuffer[3];
        int n5 = 65536 / (((n3 << 1) + 1) * ((n4 << 1) + 1));
        int[] nArray3 = this.mBuffer[7];
        int[] nArray4 = this.mBuffer[4];
        int[] nArray5 = this.mBuffer[5];
        int[] nArray6 = this.mBuffer[6];
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            int n8 = i - n4;
            if (n8 < 0) {
                n8 = 0;
            }
            if ((n7 = i + n4) >= n2) {
                n7 = n2 - 1;
            }
            n8 *= n;
            n7 *= n;
            for (int j = 0; j < n; ++j) {
                int n9;
                int n10 = j - n3;
                if (n10 < 0) {
                    n10 = 0;
                }
                if ((n9 = j + n3) >= n) {
                    n9 = n - 1;
                }
                int n11 = n9 + n7;
                int n12 = n10 + n8;
                int n13 = nArray3[n11] + nArray3[n12] - nArray3[n10 += n7] - nArray3[n9 += n8];
                nArray2[n6] = n13 * n5 >> 16 << 24;
                n13 = nArray4[n11] + nArray4[n12] - nArray4[n10] - nArray4[n9];
                int n14 = n6;
                nArray2[n14] = nArray2[n14] | n13 * n5 & 0xFF0000;
                n13 = nArray5[n11] + nArray5[n12] - nArray5[n10] - nArray5[n9];
                int n15 = n6;
                nArray2[n15] = nArray2[n15] | n13 * n5 >> 16 << 8;
                n13 = nArray6[n11] + nArray6[n12] - nArray6[n10] - nArray6[n9];
                int n16 = n6++;
                nArray2[n16] = nArray2[n16] | n13 * n5 >> 16;
            }
        }
        return nArray2;
    }

    private void doBlurPreComputation(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5 = n * n2;
        this.allocateBuffer(3, n5, true);
        this.allocateBuffer(7, n5, true);
        this.allocateBuffer(4, n5, true);
        this.allocateBuffer(5, n5, true);
        this.allocateBuffer(6, n5, true);
        int[] nArray2 = this.mBuffer[7];
        nArray2[0] = nArray[0] >>> 24;
        int n6 = n4 + n - 1;
        for (n4 = 1; n4 < n6; ++n4) {
            nArray2[n4] = (nArray[n4] >>> 24) + nArray2[n4 - 1];
        }
        n6 = n2;
        while (--n6 >= 1) {
            nArray2[n4++] = (nArray[n4] >>> 24) + nArray2[n4 - n];
            n3 = n4 + n - 1;
            while (n4 < n3) {
                nArray2[n4] = (nArray[n4] >>> 24) + nArray2[n4 - 1] - nArray2[n4 - n - 1] + nArray2[n4 - n];
                ++n4;
            }
        }
        for (n6 = 1; n6 <= 2; ++n6) {
            n3 = n6 << 3;
            nArray2 = this.mBuffer[4];
            if (n6 == 2) {
                nArray2 = this.mBuffer[5];
            }
            nArray2[0] = nArray[0] >>> n3 & 0xFF;
            int n7 = n4 + n - 1;
            for (n4 = 1; n4 < n7; ++n4) {
                nArray2[n4] = (nArray[n4] >>> n3 & 0xFF) + nArray2[n4 - 1];
            }
            n7 = n2;
            while (--n7 >= 1) {
                nArray2[n4++] = (nArray[n4] >>> n3 & 0xFF) + nArray2[n4 - n];
                int n8 = n4 + n - 1;
                while (n4 < n8) {
                    nArray2[n4] = (nArray[n4] >>> n3 & 0xFF) + nArray2[n4 - 1] - nArray2[n4 - n - 1] + nArray2[n4 - n];
                    ++n4;
                }
            }
        }
        nArray2 = this.mBuffer[6];
        nArray2[0] = nArray[0] & 0xFF;
        n6 = n4 + n - 1;
        for (n4 = 1; n4 < n6; ++n4) {
            nArray2[n4] = (nArray[n4] & 0xFF) + nArray2[n4 - 1];
        }
        n6 = n2;
        while (--n6 >= 1) {
            nArray2[n4++] = (nArray[n4] & 0xFF) + nArray2[n4 - n];
            n3 = n4 + n - 1;
            while (n4 < n3) {
                nArray2[n4] = (nArray[n4] & 0xFF) + nArray2[n4 - 1] - nArray2[n4 - n - 1] + nArray2[n4 - n];
                ++n4;
            }
        }
    }

    private void drawBuffer(Graphics graphics, int[] nArray, int n, int n2, int n3, int n4) {
        int n5 = graphics.getClipX();
        int n6 = n5 + graphics.getClipWidth();
        if (n6 <= 0) {
            return;
        }
        int n7 = graphics.getClipY();
        int n8 = n7 + graphics.getClipHeight();
        if (n8 <= 0) {
            return;
        }
        if (n7 < 0) {
            n7 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n >= n6 || n2 >= n8 || n + n3 <= n5 || n2 + n4 <= n7) {
            return;
        }
        int n9 = n;
        int n10 = n2;
        int n11 = 0;
        int n12 = 0;
        int n13 = n3;
        int n14 = n4;
        if (n9 + n3 > n6) {
            n13 -= n9 + n3 - n6;
        }
        if (n10 + n4 > n8) {
            n14 -= n10 + n4 - n8;
        }
        if (n9 < n5) {
            n11 -= n9 - n5;
            n13 += n9 - n5;
            n9 = n5;
        }
        if (n10 < n7) {
            n12 -= n10 - n7;
            n14 += n10 - n7;
            n10 = n7;
        }
        if (this.mRenderMode == 0) {
            graphics.drawRGB(nArray, n12 * n3 + n11, n3, n9, n10, n13, n14, true);
        } else {
            int n15 = n3 * n4;
            this.allocateBuffer(2, n15, true);
            int[] nArray2 = this.mBuffer[2];
            this.mRenderTarget.getRGB(nArray2, n12 * n3 + n11, n3, n9, n10, n13, n14);
            if (this.mRenderMode == 1) {
                int n16 = n3 * n4;
                while (--n16 >= 0) {
                    int n17;
                    int n18;
                    int n19 = nArray2[n16];
                    int n20 = nArray[n16];
                    int n21 = n20 >>> 24;
                    int n22 = (n20 & 0xFF00FF) * n21 >> 8;
                    int n23 = (n19 & 0xFF0000) + (n22 & 0xFF0000);
                    if (n23 > 0xFF0000) {
                        n23 = 0xFF0000;
                    }
                    if ((n18 = (n19 & 0xFF00) + ((n20 & 0xFF00) * n21 >> 8 & 0xFF00)) > 65280) {
                        n18 = 65280;
                    }
                    if ((n17 = (n19 & 0xFF) + (n22 & 0xFF)) > 255) {
                        n17 = 255;
                    }
                    nArray2[n16] = n23 | n18 | n17;
                }
            } else {
                int n24 = n3 * n4;
                while (--n24 >= 0) {
                    int n25;
                    int n26;
                    int n27 = nArray2[n24];
                    int n28 = nArray[n24];
                    int n29 = n28 >>> 24;
                    int n30 = (n28 & 0xFF00FF) * n29 >> 8;
                    int n31 = (n27 & 0xFF0000) - (n30 & 0xFF0000);
                    if (n31 < 0) {
                        n31 = 0;
                    }
                    if ((n26 = (n27 & 0xFF00) - ((n28 & 0xFF00) * n29 >> 8 & 0xFF00)) < 0) {
                        n26 = 0;
                    }
                    if ((n25 = (n27 & 0xFF) - (n30 & 0xFF)) < 0) {
                        n25 = 0;
                    }
                    nArray2[n24] = n31 | n26 | n25;
                }
            }
            graphics.drawRGB(nArray2, n12 * n3 + n11, n3, n9, n10, n13, n14, false);
        }
    }

    public Graphics getGraphics() {
        return this.mBufferGraphics;
    }

    public int getRotationAngle() {
        return this.mEffectParam[2];
    }

    public int getColorModification() {
        return this.mEffectParam[0];
    }

    public int getScaleWidth() {
        return this.mEffectParam[3];
    }

    public int getScaleHeight() {
        return this.mEffectParam[4];
    }

    public void setScale(int n) {
        this.setScale(n, n);
    }

    public void setScale(int n, int n2) {
        this.mEffectParam[3] = n;
        this.mEffectParam[4] = n2;
    }

    public void setBilinearFiltering(boolean bl) {
        this.mEffectParam[1] = bl ? 1 : 0;
    }

    public void setRenderMode(int n, Image image) {
        this.mRenderMode = n;
        this.mRenderTarget = image;
    }

    public void transformBuffer(int n) {
        DavinciUtilities.transformBuffer(this.mBuffer[8], this.mFrameWidth, this.mFrameHeight, n);
    }

    public void freeResources() {
        int n = this.mBuffer.length;
        while (--n >= 0) {
            this.mBuffer[n] = null;
        }
        this.mLastEffectParam = null;
        this.freeImageBuffer();
    }

    public void freeImageBuffer() {
        this.mBufferImage = null;
        this.mBufferGraphics = null;
    }

    public int[] getPreviousEffectParams() {
        return this.mLastEffectParam;
    }

    public void draw(Graphics graphics, Image image, int n, int n2, int n3) {
        int n4 = this.mRenderMode;
        Image image2 = this.mRenderTarget;
        this.setRenderMode(n, image);
        this.draw(graphics, n2, n3);
        this.setRenderMode(n4, image2);
    }
}

