/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class SpriteObject {
    private Animation[] mAnimations;
    private Animation mCurrentAnimation;
    private int mCurrentFrameIndex;
    private int mElapsedTime;
    private boolean mForceEachFrame;
    private int mLoopCount;
    private int mLoopCounter;
    public static final int LOOP_FOREVER = -1;
    public static final int LOOP_ANIMATION_PREFERENCE = -2;
    private boolean mReversed;
    public static final boolean CACHE_GRAPHICS_BUFFERS = true;
    private static boolean smFrameBufferCaching = true;
    private static Vector smFrameCacheUsed;
    private static Vector smFrameCacheFree;

    public SpriteObject(Animation[] animationArray) {
        this.set(animationArray, -2);
    }

    public SpriteObject(Animation animation) {
        this(new Animation[]{animation});
    }

    public SpriteObject(Animation[] animationArray, boolean bl) {
        this.set(animationArray, bl ? -1 : 1);
    }

    public SpriteObject(Object[] objectArray, boolean bl) {
        Animation[] animationArray = new Animation[objectArray.length];
        int n = objectArray.length;
        while (--n >= 0) {
            animationArray[n] = (Animation)objectArray[n];
        }
        this.set(animationArray, bl ? -1 : 1);
    }

    public SpriteObject(Animation animation, boolean bl) {
        this(new Animation[]{animation}, bl);
    }

    public SpriteObject() {
    }

    public SpriteObject clone() {
        if (this.mLoopCount == -2) {
            return new SpriteObject(this.mAnimations);
        }
        return new SpriteObject(this.mAnimations, this.mLoopCount == -1);
    }

    private void set(Animation[] animationArray, int n) {
        if (this.mAnimations != null) {
            this.freeResources();
        }
        this.mAnimations = animationArray;
        int n2 = animationArray.length;
        while (--n2 >= 0) {
            DavinciUtilities.modRefCounters(animationArray[n2], 1);
        }
        this.setAnimation(0, n, true);
    }

    public void copyTo(SpriteObject spriteObject) {
        spriteObject.set(this.mAnimations, this.mLoopCount);
    }

    public int getFrameCount() {
        return this.mCurrentAnimation.getFrameCount();
    }

    public int getAnimationLength() {
        return this.mCurrentAnimation.getDuration();
    }

    public int getElapsedTime() {
        int n = this.mCurrentAnimation.getFrameStartTime(this.mCurrentFrameIndex) + this.mElapsedTime;
        return n;
    }

    public Animation getCurrentAnimationData() {
        return this.mCurrentAnimation;
    }

    public CollisionBox[] getCollisionBoxes() {
        return this.mCurrentAnimation.getFrame(this.mCurrentFrameIndex).getCollisionBoxes();
    }

    public CollisionBox getCollisionBox(int n) {
        return this.mCurrentAnimation.getFrame(this.mCurrentFrameIndex).getCollisionBox(n);
    }

    public void setElapsedTime(int n) {
        this.setAnimationFrame(0);
        boolean bl = this.mForceEachFrame;
        this.mForceEachFrame = false;
        this.logicUpdate(n);
        this.mForceEachFrame = bl;
    }

    public void logicUpdate(int n) {
        if (!this.mReversed) {
            int n2 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
            this.mElapsedTime += n;
            while (this.mElapsedTime >= n2) {
                this.mElapsedTime -= n2;
                if (this.mForceEachFrame) {
                    this.mElapsedTime = 0;
                }
                int n3 = this.mCurrentAnimation.getFrameCount();
                ++this.mCurrentFrameIndex;
                if (this.mCurrentFrameIndex >= n3) {
                    if (this.mLoopCounter > 0) {
                        --this.mLoopCounter;
                    }
                    this.mCurrentFrameIndex = 0;
                    if (this.mLoopCounter == 0) {
                        this.mCurrentFrameIndex = n3 - 1;
                        this.mElapsedTime = n2 - 1;
                        break;
                    }
                }
                n2 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
            }
        } else {
            this.mElapsedTime -= n;
            while (this.mElapsedTime < 0) {
                int n4;
                --this.mCurrentFrameIndex;
                if (this.mCurrentFrameIndex == -1) {
                    if (this.mLoopCounter > 0) {
                        --this.mLoopCounter;
                    }
                    n4 = this.mCurrentAnimation.getFrameCount();
                    this.mCurrentFrameIndex = n4 - 1;
                    if (this.mLoopCounter == 0) {
                        this.mCurrentFrameIndex = 0;
                        this.mElapsedTime = 0;
                        break;
                    }
                }
                n4 = this.mCurrentAnimation.getFrameDuration(this.mCurrentFrameIndex);
                this.mElapsedTime += n4;
                if (!this.mForceEachFrame) continue;
                this.mElapsedTime = n4 - 1;
            }
        }
    }

    public void drawAlpha(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, null, 0, n, n2, n3 << 24 | 0x808080, 0, 1024, 1024);
    }

    public void drawRotated(Graphics graphics, int n, int n2, int n3) {
        this.draw(graphics, null, 0, n, n2, this.getCurrentFrameColorModification(), n3, 1024, 1024);
    }

    public void draw(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.draw(graphics, null, 0, n, n2, n3, n4, n5, n5);
    }

    public void draw(Graphics graphics, DChocImage dChocImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(graphics, dChocImage, n, n2, n3, n4, n5, n6, n6);
    }

    public void draw(Graphics graphics, DChocImage dChocImage, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        iRenderingPlatform.pushParameters();
        if (dChocImage != null) {
            iRenderingPlatform.setGraphicsContext(dChocImage);
        } else {
            iRenderingPlatform.setGraphicsContext(graphics);
        }
        iRenderingPlatform.setColorModification(n4);
        iRenderingPlatform.setRotation(n5);
        iRenderingPlatform.setScale(n6, n7);
        iRenderingPlatform.setRenderMode(n);
        this.draw(n2, n3);
        iRenderingPlatform.popParameters();
    }

    public int getCurrentFrameAlpha() {
        return this.getCurrentFrameColorModification() >>> 24;
    }

    public int getCurrentFrameColorModification() {
        if (this.hasAnimationTimeline()) {
            int n = this.getElapsedTime();
            boolean bl = this.isLooping();
            return this.mCurrentAnimation.getTimelineValue(0, n, bl);
        }
        return -8355712;
    }

    public void draw(Graphics graphics, Image image, int n, int n2) {
        this.draw(graphics, image, n, n2);
    }

    public boolean hasAnimationTimeline() {
        return this.mCurrentAnimation.hasTimeline();
    }

    public int getTimelineX() {
        if (this.hasAnimationTimeline()) {
            return this.mCurrentAnimation.getTimelineValue(1, this.getElapsedTime(), this.isLooping());
        }
        return 0;
    }

    public int getTimelineY() {
        if (this.hasAnimationTimeline()) {
            return this.mCurrentAnimation.getTimelineValue(2, this.getElapsedTime(), this.isLooping());
        }
        return 0;
    }

    public void drawAligned(int n, int n2, int n3, int n4) {
        int n5 = this.mCurrentAnimation.getAlignment();
        if ((n5 & 8) != 0) {
            n2 += n4;
        } else if ((n5 & 4) != 0) {
            n2 += n4 >> 1;
        }
        if ((n5 & 0x20) != 0) {
            n += n3;
        } else if ((n5 & 0x10) != 0) {
            n += n3 >> 1;
        }
        this.draw(n, n2);
    }

    public void draw(int n, int n2) {
        boolean bl;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl2;
        IRenderingPlatform iRenderingPlatform = Toolkit.getRenderingPlatform();
        int n7 = iRenderingPlatform.getColorModification();
        int n8 = iRenderingPlatform.getRotation();
        int n9 = iRenderingPlatform.getScaleWidth();
        int n10 = iRenderingPlatform.getScaleHeight();
        int n11 = this.getElapsedTime();
        Animation animation = this.mCurrentAnimation;
        boolean bl3 = this.hasAnimationTimeline();
        if (bl3) {
            n += this.getTimelineX();
            n2 += this.getTimelineY();
            bl2 = this.isLooping();
            int n12 = animation.getTimelineValue(5, n11, bl2);
            if (n7 == -8355712) {
                n7 = animation.getTimelineValue(0, n11, bl2);
            }
            n6 = animation.getTimelineValue(3, n11, bl2);
            n5 = animation.getTimelineValue(4, n11, bl2);
            n8 += n12;
            n9 = n6 * n9 >> 10;
            n10 = n5 * n10 >> 10;
        }
        if (!(bl2 = n7 & 0xFF000000)) {
            return;
        }
        if (bl3) {
            iRenderingPlatform.pushParameters();
            iRenderingPlatform.setColorModification(n7);
            iRenderingPlatform.setRotation(n8);
            iRenderingPlatform.setScale(n9, n10);
        }
        AnimationFrame animationFrame = animation.getFrame(this.mCurrentFrameIndex);
        n6 = animation.getWithoutTimelineX();
        n5 = animation.getWithoutTimelineY();
        boolean bl4 = false;
        int n13 = 0;
        boolean bl5 = false;
        DChocImage dChocImage = null;
        if (iRenderingPlatform.getColorModification() != -8355712 || iRenderingPlatform.getScaleWidth() != 1024 || iRenderingPlatform.getScaleHeight() != 1024 || iRenderingPlatform.getRotation() != 0 || iRenderingPlatform.getRenderMode() != 0 || iRenderingPlatform.getBlurWidth() > 1 || iRenderingPlatform.getBlurHeight() > 1) {
            int[][] nArray = animationFrame.getRenderables();
            n4 = nArray.length;
            if (iRenderingPlatform.getBlurWidth() > 1 || iRenderingPlatform.getBlurHeight() > 1) {
                bl5 = true;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                int[] nArray2 = nArray[n3];
                switch (nArray2[0]) {
                    case 1: 
                    case 5: {
                        if (n4 == 1) {
                            bl4 = true;
                            n6 = -nArray2[1];
                            n5 = -nArray2[2];
                            dChocImage = DavinciUtilities.getImageFromCache(nArray2[3]);
                        }
                    }
                    case 7: 
                    case 9: {
                        bl5 = true;
                        n3 = n4;
                    }
                }
            }
        }
        if (n7 != -8355712) {
            bl5 = true;
        }
        if (!bl5) {
            animation.doDraw(n, n2, n11);
            if (bl3) {
                iRenderingPlatform.popParameters();
            }
            return;
        }
        boolean bl6 = bl = SpriteObject.isFrameBufferCachingEnabled() && animation.isFrameBufferCachingEnabled();
        if (!bl4) {
            n4 = animation.getWithoutTimelineWidth();
            n3 = animation.getWithoutTimelineHeight();
            dChocImage = bl ? animationFrame.getGraphicsBuffer() : SpriteObject.getFrameBufferFromCache(n4, n3);
            boolean bl7 = false;
            if (!animationFrame.hasNestedAnimations()) {
                bl7 = iRenderingPlatform.isFrameUpToDate(dChocImage);
            }
            if (!bl7) {
                iRenderingPlatform.pushParameters();
                int n14 = iRenderingPlatform.getFilters();
                iRenderingPlatform.disableAllEffects();
                iRenderingPlatform.setFilters(n14);
                iRenderingPlatform.makeImageTransparent(dChocImage, n4, n3);
                iRenderingPlatform.setPivot(0, 0);
                iRenderingPlatform.setGraphicsContext(dChocImage);
                animation.doDraw(n6, n5, n11);
                iRenderingPlatform.popParameters();
            }
        }
        n4 = iRenderingPlatform.getPivotX();
        n3 = iRenderingPlatform.getPivotY();
        iRenderingPlatform.setPivot(n, n2);
        iRenderingPlatform.drawImage(dChocImage, -n6, -n5, n13, 20);
        iRenderingPlatform.setPivot(n4, n3);
        if (!bl && !bl4) {
            smFrameCacheUsed.removeElement(dChocImage);
            smFrameCacheFree.addElement(dChocImage);
        }
        if (bl3) {
            iRenderingPlatform.popParameters();
        }
    }

    private static DChocImage getFrameBufferFromCache(int n, int n2) {
        if (smFrameCacheUsed == null) {
            smFrameCacheUsed = new Vector();
            smFrameCacheFree = new Vector();
        }
        boolean bl = false;
        DChocImage dChocImage = null;
        int n3 = smFrameCacheFree.size();
        while (--n3 >= 0) {
            dChocImage = (DChocImage)smFrameCacheFree.elementAt(n3);
            dChocImage.clearRegion();
            if (n > dChocImage.getWidth() || n2 > dChocImage.getHeight()) continue;
            smFrameCacheFree.removeElementAt(n3);
            bl = true;
            break;
        }
        if (!bl) {
            dChocImage = new DChocImage(n * 12 / 10, n2 * 12 / 10);
        }
        if (n != dChocImage.getImage().getWidth() || n2 != dChocImage.getHeight()) {
            dChocImage.setRegion(0, 0, n, n2);
        }
        smFrameCacheUsed.addElement(dChocImage);
        return dChocImage;
    }

    public void draw(Graphics graphics, int n, int n2) {
        Toolkit.getRenderingPlatform().setGraphicsContext(graphics);
        this.draw(n, n2);
    }

    public void setAnimation(int n, int n2, boolean bl) {
        this.mCurrentAnimation = this.mAnimations[n];
        this.mLoopCount = n2;
        this.mForceEachFrame = bl;
        this.setAnimationFrame(0);
    }

    public int getCurrentAnimationIndex() {
        int n = 0;
        while (this.mCurrentAnimation != this.mAnimations[n]) {
            ++n;
        }
        return n;
    }

    public int getAnimationCount() {
        return this.mAnimations.length;
    }

    public void setAnimationFrame(int n) {
        this.mCurrentFrameIndex = n;
        this.mLoopCounter = this.mLoopCount;
        if (this.mLoopCount == -2) {
            this.mLoopCounter = 1;
            if (this.mCurrentAnimation.isLoopingPreferenced()) {
                this.mLoopCounter = -1;
            }
        }
        this.mElapsedTime = !this.mReversed ? 0 : this.mCurrentAnimation.getFrameDuration(n) - 1;
    }

    public int getCurrentFrameIndex() {
        return this.mCurrentFrameIndex;
    }

    public boolean isFinishedAnimation() {
        return this.mLoopCounter == 0;
    }

    public int getPivotX() {
        return this.mCurrentAnimation.getX();
    }

    public int getPivotY() {
        return this.mCurrentAnimation.getY();
    }

    public int getWidth() {
        return this.mCurrentAnimation.getWidth();
    }

    public int getHeight() {
        return this.mCurrentAnimation.getHeight();
    }

    public int getFrameWidth(int n) {
        return this.mCurrentAnimation.getFrame(n).getWidth();
    }

    public int getFrameHeight(int n) {
        return this.mCurrentAnimation.getFrame(n).getHeight();
    }

    public int getFrameWidth() {
        return this.getFrameWidth(this.mCurrentFrameIndex);
    }

    public int getFrameHeight() {
        return this.getFrameHeight(this.mCurrentFrameIndex);
    }

    public boolean getLoopPreference() {
        return this.mCurrentAnimation.isLoopingPreferenced();
    }

    public void freeResources() {
        if (this.mAnimations != null) {
            int n = this.mAnimations.length;
            while (--n >= 0) {
                this.mAnimations[n].freeResources();
            }
            DavinciUtilities.releaseUnreferencedImages();
            this.mAnimations = null;
        }
    }

    public void freeFrameCacheBuffers() {
        if (this.mCurrentAnimation != null) {
            for (int i = 0; i < this.mCurrentAnimation.getFrameCount(); ++i) {
                AnimationFrame animationFrame = this.mCurrentAnimation.getFrame(i);
                animationFrame.freeFrameBufferResources();
            }
        }
    }

    public static void releaseEffectBuffer() {
    }

    public static void setColorModification(int n) {
        Toolkit.getRenderingPlatform().setColorModification(n);
    }

    public static void setRotation(int n) {
        Toolkit.getRenderingPlatform().setRotation(n);
    }

    public static void setScale(int n, int n2) {
        Toolkit.getRenderingPlatform().setScale(n, n2);
    }

    public static void setRenderMode(int n) {
        SpriteObject.setRenderMode(n, null);
    }

    public static void setRenderMode(int n, DChocImage dChocImage) {
        Toolkit.getRenderingPlatform().setGraphicsContext(dChocImage);
        Toolkit.getRenderingPlatform().setRenderMode(n);
    }

    public static void setBlur(int n, int n2) {
        Toolkit.getRenderingPlatform().setBlur(n, n2);
    }

    public static void setFiltering(boolean bl) {
        Toolkit.getRenderingPlatform().setFiltering(3, bl);
    }

    public static boolean isFilteringEnabled() {
        return Toolkit.getRenderingPlatform().isFilterEnabled(3);
    }

    public static void disableAllEffects() {
        Toolkit.getRenderingPlatform().disableAllEffects();
    }

    public void setReversedPlayback(boolean bl) {
        this.mReversed = bl;
    }

    public boolean isLooping() {
        return this.mLoopCounter != 0 && (this.mLoopCounter != 1 || this.mCurrentFrameIndex != this.getFrameCount() - 1);
    }

    public static void setFrameBufferCaching(boolean bl) {
        smFrameBufferCaching = bl;
    }

    public static boolean isFrameBufferCachingEnabled() {
        return smFrameBufferCaching;
    }
}

