/*
 * Decompiled with CFR 0.152.
 */
public final class Trigonometry {
    public static final int PRECISSION = 10;
    private static short[] sintable;
    private static short[] costable;
    private static short[] tantable;

    public static void init() {
        byte[] byArray = Toolkit.getResourceBytes(65537);
        sintable = new short[64];
        costable = new short[64];
        tantable = new short[64];
        for (int i = 0; i < 64; ++i) {
            Trigonometry.sintable[i] = (short)((byArray[i * 2] & 0xFF) << 8 | byArray[i * 2 + 1] & 0xFF);
            Trigonometry.costable[i] = (short)((byArray[128 + i * 2] & 0xFF) << 8 | byArray[i * 2 + 129] & 0xFF);
            Trigonometry.tantable[i] = (short)((byArray[i * 2 + 256] & 0xFF) << 8 | byArray[i * 2 + 257] & 0xFF);
        }
    }

    public static int sin(int n) {
        short s = ((n &= 0xFF) & 0x40) == 0 ? sintable[n & 0x3F] : sintable[63 - (n & 0x3F)];
        if (n >= 128) {
            s = -s;
        }
        return s;
    }

    public static int sinAccurate(int n) {
        int n2 = n >> 10;
        return Trigonometry.sin(n2) * (1024 - (n &= 0x3FF)) + Trigonometry.sin(n2 + 1) * n >> 10;
    }

    public static int cos(int n) {
        short s = ((n &= 0xFF) & 0x40) == 0 ? costable[n & 0x3F] : costable[63 - (n & 0x3F)];
        if (n >= 64 && n < 192) {
            s = -s;
        }
        return s;
    }

    public static int cosAccurate(int n) {
        int n2 = n >> 10;
        return Trigonometry.cos(n2) * (1024 - (n &= 0x3FF)) + Trigonometry.cos(n2 + 1) * n >> 10;
    }

    /*
     * WARNING - void declaration
     */
    public static int trigon_atan(int n, int n2) {
        void var2_4;
        int n3;
        int s = 99999;
        if (n2 != 0) {
            n3 = (n << 10) / n2;
        }
        if (n3 < 0) {
            var2_4 = -n3;
        }
        int n4 = 0;
        int n5 = 32;
        int n6 = 63;
        while (n4 < n6 - 1) {
            if (var2_4 > tantable[n5]) {
                n4 = n5;
            } else {
                if (var2_4 >= tantable[n5]) break;
                n6 = n5;
            }
            n5 = n4 + n6 >> 1;
        }
        if (n >= 0) {
            if (n2 >= 0) {
                return n5;
            }
            return 128 - n5;
        }
        if (n2 < 0) {
            return 128 + n5;
        }
        return 256 - n5 & 0xFF;
    }
}

