/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class Weather {
    private static final int EFFECTS_RAIN_FLOOR_TICKS_MAX = 8;
    private static final int EFFECTS_RAIN_REFERENCE_COLOR = 0xFFFFFF;
    private static final int EFFECTS_RAIN_COLOR = 0xFFFFFF;
    private static final int EFFECTS_RAIN_DROP_COLOR = 0xC0C0C0;
    private static final int EFFECTS_RAIN_DROP_DARKING_STEP_COLOR = 0x333333;
    private static final int EFFECTS_RAIN_DROP_TOTAL_TICKS = 6;
    private static final int EFFECTS_RAIN_DROP_DARKING_TICKS = 1;
    private int[][][] effects_rainData;
    private int mRainFloorSlope = 1;
    private int effects_rainLayerNum;
    private int effects_rainLayerCurrentID;
    private int[] effects_rainLayerX;
    private int[] effects_rainLayerY;
    private int[] effects_rainLayerWidth;
    private int[] effects_rainLayerHeight;
    private int[] effects_rainLayerColor;
    private int effects_rainFloorUpperB;
    public boolean effects_rainOnBool = false;
    private int effects_rainScreenVelYPPT;
    private int effects_rainFarLengthYPixls;
    private int effects_rainNearLengthYPixls;
    public static final int EFFECTS_CLEAN = 0;
    public static final int EFFECTS_RAIN = 1;
    public static final int EFFECTS_SNOW = 0;
    public static final int EFFECTS_DUST = 3;
    private static final int EFFECTS_LAYER_NUM = 2;
    private static final int EFFECTS_SPAWN_HEIGHT = 20;
    private static final int EFFECTS_FLOOR_TICKS_MAX = 8;
    private static final int EFFECTS_DROP_COLOR = 0x333333;
    private static final int EFFECTS_DROP_TOTAL_TICKS = 8;
    private int[][][] effects_data;
    private int[] effects_layerX;
    private int[] effects_layerY;
    private int[] effects_layerWidth;
    private int[] effects_height;
    private int[] effects_layerColor;
    private int effects_type = 0;
    public boolean effects_onBool = false;
    private int effects_screenVelYPPT;
    private int effects_farLengthYPixls;
    private int effects_nearLengthYPixls;
    private int canvasWidth;
    private int canvasHeight;
    final boolean FAST_RANDOM;
    private int rnd = 0;
    private int RND_Cont = (int)(System.currentTimeMillis() >> 8 & 0xFL);
    private static final int[] RND_Data = new int[]{440777937, 1385877358, -210086711, 541049956, 838251821};
    private Random rand;

    public Weather() {
        this.FAST_RANDOM = false;
    }

    public void effects_init(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.effects_onBool = true;
        this.canvasWidth = n3;
        this.canvasHeight = n5;
        this.effects_rainFloorUpperB = n6;
        if (this.effects_layerX == null) {
            this.effects_layerX = new int[2];
            this.effects_layerY = new int[2];
            this.effects_layerWidth = new int[2];
            this.effects_height = new int[2];
            this.effects_layerColor = new int[2];
        }
        this.effects_data = new int[2][][];
        this.effects_type = n;
        if (n == 1) {
            this.effects_rainInit(1);
            int n8 = 3;
            this.effects_rainInitLayer(n2, n4, this.canvasWidth, n7, 13552856, n8);
        } else {
            this.effects_screenVelYPPT = 1;
            this.effects_farLengthYPixls = 2;
            this.effects_nearLengthYPixls = 3;
        }
        this.effects_tick();
    }

    public void effects_initLayer(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.effects_layerX[n] = n2;
        this.effects_layerY[n] = n3;
        this.effects_layerWidth[n] = n4;
        this.effects_height[n] = n5;
        this.effects_layerColor[n] = n6;
        int n8 = n4 / n7 / 2;
        this.effects_data[n] = new int[n8][4];
        for (int i = 0; i < this.effects_data[n].length; ++i) {
            this.effects_data[n][i][0] = this.effects_layerX[n] + this.rnd(this.effects_data[n].length * 3) * n7;
            this.effects_data[n][i][1] = this.effects_layerY[n] + this.rnd(this.effects_height[n]);
            this.effects_data[n][i][2] = this.effects_type == 1 ? this.rnd(8) : this.rnd(64) + this.rnd(64);
            if (this.effects_type != 3) continue;
            this.effects_data[n][i][3] = this.rnd(512);
            if (this.rnd(20) >= 10) continue;
            this.effects_data[n][i][3] = ~this.effects_data[n][i][3];
        }
    }

    public void effects_destroy() {
        this.effects_layerX = null;
        this.effects_layerY = null;
        this.effects_layerWidth = null;
        this.effects_height = null;
        this.effects_layerColor = null;
        this.effects_data = null;
        this.effects_onBool = false;
        this.effects_rainDestroy();
    }

    public void effects_tick() {
        if (this.effects_type == 1) {
            this.effects_rainTick();
        } else if (this.effects_onBool) {
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < this.effects_data[i].length; ++j) {
                    if (this.effects_data[i][j][2] >= 0) {
                        int[] nArray = this.effects_data[i][j];
                        nArray[0] = nArray[0] + (this.rnd(1) - this.rnd(2));
                        int[] nArray2 = this.effects_data[i][j];
                        nArray2[1] = nArray2[1] + this.effects_screenVelYPPT;
                    }
                    if (this.effects_data[i][j][0] < this.effects_layerX[i] || this.effects_data[i][j][1] > this.effects_layerY[i] + this.effects_height[i] || this.effects_data[i][j][2] == -8) {
                        this.effects_data[i][j][0] = this.effects_layerX[i] + this.rnd(this.effects_data[i].length * 3 >> 1) * (this.effects_layerWidth[i] / this.effects_data[i].length);
                        this.effects_data[i][j][1] = this.effects_layerY[i] - this.rnd(20);
                        if (this.effects_type == 1) {
                            this.effects_data[i][j][2] = this.rnd(8);
                            continue;
                        }
                        this.effects_data[i][j][2] = this.rnd(64) + this.rnd(64);
                        continue;
                    }
                    if (this.effects_data[i][j][2] >= 0) {
                        if (i == 0) {
                            if (this.effects_data[i][j][0] >= 0) continue;
                            int[] nArray = this.effects_data[i][j];
                            nArray[2] = nArray[2] - 1;
                            continue;
                        }
                        if (this.effects_data[i][j][0] > 0 || this.effects_data[i][j][1] < this.canvasHeight >> 1) continue;
                        int[] nArray = this.effects_data[i][j];
                        nArray[2] = nArray[2] - 1;
                        continue;
                    }
                    int[] nArray = this.effects_data[i][j];
                    nArray[2] = nArray[2] - 1;
                }
            }
        }
    }

    public void effects_draw(Graphics graphics, int n, int n2) {
        if (this.effects_onBool) {
            if (this.effects_type == 1) {
                this.effects_rainDraw(graphics, n, n2);
            } else {
                graphics.setClip(0, 0, this.canvasWidth, this.canvasHeight);
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < this.effects_data[i].length; ++j) {
                        int n3;
                        int n4 = this.effects_data[i][j][0];
                        int n5 = this.effects_data[i][j][1];
                        if (n4 < 0) {
                            n4 += this.canvasWidth;
                        } else if (n4 >= this.canvasWidth) {
                            n4 -= this.canvasWidth;
                        }
                        if (n5 < 0) {
                            n5 += this.canvasHeight;
                        } else if (n5 >= this.canvasHeight) {
                            n5 -= this.canvasHeight;
                        }
                        if (this.effects_data[i][j][2] < 0) {
                            graphics.setColor(0x333333);
                            graphics.fillRect(this.effects_data[i][j][0], this.effects_data[i][j][1], 1, 1);
                            continue;
                        }
                        if (this.effects_type == 3) {
                            boolean bl;
                            n3 = this.effects_data[i][j][3];
                            boolean bl2 = bl = n3 < 0;
                            if (bl) {
                                n3 ^= 0xFFFFFFFF;
                            }
                            graphics.setColor(this.fadeColor(0, bl ? 16722432 : 16757760, n3 <= 256 ? n3 : 512 - n3));
                            if ((n3 += 8) > 512) {
                                n3 = 0;
                            }
                            if (bl) {
                                n3 ^= 0xFFFFFFFF;
                            }
                            this.effects_data[i][j][3] = n3;
                        } else {
                            graphics.setColor(this.effects_layerColor[i]);
                        }
                        n3 = this.effects_farLengthYPixls;
                        if (i == 1) {
                            n3 = this.effects_data[i][j][2] < 5 ? this.effects_farLengthYPixls : this.effects_nearLengthYPixls;
                        }
                        n3 += this.rnd(n3 >> 1);
                        if (this.effects_type == 1) continue;
                        graphics.fillRect(n4, n5, n3, n3);
                    }
                }
            }
        }
    }

    public void setRainFloorSlope(int n) {
        this.mRainFloorSlope = n == 0 ? 1 : n;
    }

    public void effects_rainInit(int n) {
        this.effects_rainLayerNum = n;
        this.effects_rainLayerCurrentID = -1;
        if (this.effects_rainData == null) {
            this.effects_rainData = new int[this.effects_rainLayerNum][][];
            this.effects_rainLayerX = new int[this.effects_rainLayerNum];
            this.effects_rainLayerY = new int[this.effects_rainLayerNum];
            this.effects_rainLayerWidth = new int[this.effects_rainLayerNum];
            this.effects_rainLayerHeight = new int[this.effects_rainLayerNum];
            this.effects_rainLayerColor = new int[this.effects_rainLayerNum];
        }
        this.effects_rainScreenVelYPPT = this.canvasHeight / 20;
        this.effects_rainFarLengthYPixls = this.canvasHeight / 55;
        this.effects_rainNearLengthYPixls = this.canvasHeight / 40;
        this.effects_rainOnBool = true;
    }

    public void effects_rainInitLayer(int n, int n2, int n3, int n4, int n5, int n6) {
        ++this.effects_rainLayerCurrentID;
        this.effects_rainLayerX[this.effects_rainLayerCurrentID] = n;
        this.effects_rainLayerY[this.effects_rainLayerCurrentID] = n2;
        this.effects_rainLayerWidth[this.effects_rainLayerCurrentID] = n3;
        this.effects_rainLayerHeight[this.effects_rainLayerCurrentID] = n4;
        this.effects_rainLayerColor[this.effects_rainLayerCurrentID] = n5;
        int n7 = n3 / n6;
        this.effects_rainData[this.effects_rainLayerCurrentID] = new int[n7][3];
        for (int i = 0; i < this.effects_rainData[this.effects_rainLayerCurrentID].length; ++i) {
            this.effects_rainData[this.effects_rainLayerCurrentID][i][0] = Math.abs(this.rnd(this.effects_rainLayerWidth[this.effects_rainLayerCurrentID] * 2));
            this.effects_rainData[this.effects_rainLayerCurrentID][i][1] = this.effects_rainLayerY[this.effects_rainLayerCurrentID] + this.rnd(this.effects_rainLayerHeight[this.effects_rainLayerCurrentID]);
            this.effects_rainData[this.effects_rainLayerCurrentID][i][2] = this.rnd(8);
        }
    }

    public void effects_rainDestroy() {
        this.effects_rainData = null;
        this.effects_rainLayerX = null;
        this.effects_rainLayerY = null;
        this.effects_rainLayerWidth = null;
        this.effects_rainLayerHeight = null;
        this.effects_rainLayerColor = null;
        this.effects_rainOnBool = false;
    }

    public void effects_rainTick() {
        if (this.effects_rainOnBool) {
            for (int i = 0; i < this.effects_rainLayerNum; ++i) {
                for (int j = 0; j < this.effects_rainData[i].length; ++j) {
                    if (this.effects_rainData[i][j][2] >= 0) {
                        int[] nArray = this.effects_rainData[i][j];
                        nArray[1] = nArray[1] + this.effects_rainScreenVelYPPT;
                    }
                    if (this.effects_rainData[i][j][0] < this.effects_rainLayerX[i] || this.effects_rainData[i][j][1] > this.effects_rainLayerY[i] + this.effects_rainLayerHeight[i] || this.effects_rainData[i][j][2] == -6) {
                        this.effects_rainData[i][j][0] = this.effects_rainLayerX[this.effects_rainLayerCurrentID] + Math.abs(this.rnd(this.effects_rainLayerWidth[this.effects_rainLayerCurrentID] * 2));
                        this.effects_rainData[i][j][1] = this.effects_rainLayerY[i] + this.rnd(this.effects_rainLayerHeight[i]);
                        this.effects_rainData[i][j][2] = this.rnd(8);
                        continue;
                    }
                    if (this.effects_rainData[i][j][2] < 0) {
                        int[] nArray = this.effects_rainData[i][j];
                        nArray[2] = nArray[2] - 1;
                        continue;
                    }
                    int n = this.effects_rainData[i][j][1] - (this.effects_rainData[i][j][0] * this.mRainFloorSlope >> 8);
                    if (this.effects_rainFloorUpperB > n) continue;
                    int[] nArray = this.effects_rainData[i][j];
                    nArray[2] = nArray[2] - 1;
                }
            }
        }
    }

    public void effects_rainDraw(Graphics graphics, int n, int n2) {
        if (this.effects_rainOnBool) {
            for (int i = 0; i < this.effects_rainLayerNum; ++i) {
                for (int j = 0; j < this.effects_rainData[i].length; ++j) {
                    int n3 = this.effects_rainData[i][j][0] + n;
                    int n4 = this.effects_rainData[i][j][1] + n2;
                    if (this.effects_rainData[i][j][2] < 0) {
                        graphics.setColor(0xC0C0C0);
                        graphics.fillRect(n3, n4, 1, 1);
                        graphics.setColor(0xFFFFFF);
                        switch (this.effects_rainData[i][j][2]) {
                            case -2: {
                                graphics.fillRect(n3 + 2, n4 - 2, 1, 1);
                                break;
                            }
                            case -3: {
                                graphics.fillRect(n3 + 3, n4, 1, 1);
                                graphics.fillRect(n3, n4 - 3, 1, 1);
                                break;
                            }
                            case -4: {
                                graphics.fillRect(n3 + 2, n4 + 2, 1, 1);
                                graphics.fillRect(n3 - 2, n4 - 2, 1, 1);
                                break;
                            }
                        }
                        continue;
                    }
                    graphics.setColor(this.effects_rainLayerColor[i]);
                    int n5 = this.effects_rainFarLengthYPixls;
                    if (i == 1) {
                        n5 = this.effects_rainData[i][j][2] < 5 ? this.effects_rainFarLengthYPixls : this.effects_rainNearLengthYPixls;
                    }
                    n5 += this.rnd(n5 >> 1);
                    graphics.drawLine(n3, n4, n3, n4 - n5);
                }
            }
        }
    }

    private int rnd(int n) {
        if (this.rand == null) {
            this.rand = new Random(System.currentTimeMillis());
        }
        return this.rand.nextInt(n);
    }

    private int fadeColor(int n, int n2, int n3) {
        int n4 = ((n2 & 0xFF0000) - (n & 0xFF0000) >> 16) * n3 >> 8;
        int n5 = ((n2 & 0xFF00) - (n & 0xFF00) >> 8) * n3 >> 8;
        int n6 = ((n2 & 0xFF) - (n & 0xFF)) * n3 >> 8;
        return (n4 << 16) + (n5 << 8) + n6 + n;
    }
}

