/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.game.obstacles;

import com.ximad.pvn.audio.SoundSystem;
import com.ximad.pvn.game.Box2d;
import com.ximad.pvn.game.Fireworks;
import com.ximad.pvn.game.GameParameters;
import com.ximad.pvn.game.LevelCompleteStat;
import com.ximad.pvn.game.MyWorld;
import com.ximad.pvn.game.PhysicalGameObject;
import com.ximad.pvn.game.Point;
import com.ximad.pvn.game.obstacles.Obstacle;
import com.ximad.pvn.utils.ArrayList;

public class ObstacleBox
extends Obstacle {
    private static final int DENSITY = 15;
    public float collisionForce = 0.0f;
    static /* synthetic */ Class class$com$ximad$pvn$game$pandas$PandaMini;

    public ObstacleBox() {
        this.isPlayerPenetratable = true;
        this.score = 5000;
        this.durability = 1;
        this.type = 5008;
    }

    public void OnCollision(PhysicalGameObject obj, float force) {
        if (obj.typeDinamicalObjects == 101) {
            this.collisionForce = force;
            if (this.collisionForce > 8.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 103) {
            this.collisionForce = force;
            if (this.collisionForce > 7.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 104) {
            this.collisionForce = force;
            if (this.collisionForce > 7.0f) {
                --this.durability;
            }
        }
        if (obj.typeDinamicalObjects == 102 && obj.getClass() != (class$com$ximad$pvn$game$pandas$PandaMini == null ? (class$com$ximad$pvn$game$pandas$PandaMini = ObstacleBox.class$("com.ximad.pvn.game.pandas.PandaMini")) : class$com$ximad$pvn$game$pandas$PandaMini)) {
            this.collisionForce = force;
            if (this.collisionForce > 21.0f) {
                this.durability = this.durability == 2 ? (this.durability -= 2) : --this.durability;
            } else if (this.collisionForce > 8.0f) {
                --this.durability;
            }
        }
    }

    public void update(long dt) {
        super.update(dt);
        if (this.durability <= 0) {
            this.onDestroy = true;
        }
        if (this.onDestroy) {
            int centerX = Box2d.getCenterX(this.box2dId) * 100;
            SoundSystem.SOUND_ON_GIFTBOX_HIT.play();
            Fireworks.createParticleExplosion(centerX - 100, 60, 5);
            Fireworks.createParticleExplosion(centerX, 60, 5);
            Fireworks.createParticleExplosion(centerX + 100, 60, 5);
            super.crushObstacle(this);
            this.destroyObstacle();
            ++((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).obstacles;
            ((LevelCompleteStat)GameParameters.currentScenario.level.get((int)MyWorld.currentLevelInt)).score += (long)this.score;
        } else {
            if (MyWorld.onPlay) {
                this.defaultFrame = this.nFrames - this.durability;
            }
            if (MyWorld.onLost) {
                // empty if block
            }
        }
    }

    public static void createObstacle(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, String imageName, int angle) {
        ObstacleBox obj = new ObstacleBox();
        ArrayList shape = new ArrayList();
        obj.restitution = 1;
        obj.friction = 90;
        obj.isCrushable = true;
        obj.density = 15;
        obj.angle = angle;
        obj.isStatic = sstatic;
        obj.imageName = imageName;
        shape.add(new Point(x1, y1));
        shape.add(new Point(x2, y2));
        shape.add(new Point(x3, y3));
        shape.add(new Point(x4, y4));
        obj.loadImage(imageName, shape);
        obj.setShape(shape, false, false);
        MyWorld.physicalGameObjects.add(obj);
        obj.mass = Box2d.getMass(obj.box2dId);
        obj.damage = obj.durability = obj.nFrames;
        obj.box2dId.setParent(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

