/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.pvn.screens;

import com.ximad.pvn.engine.Application;
import com.ximad.pvn.engine.CustomButton;
import com.ximad.pvn.engine.CustomLabelField;
import com.ximad.pvn.engine.UiScreen;
import com.ximad.pvn.game.DataManager;
import com.ximad.pvn.game.Textures;
import com.ximad.pvn.screens.HomeScreen;
import javax.microedition.lcdui.Graphics;

public class OptionsScreen
extends UiScreen {
    private static OptionsScreen instance;
    private CustomButton btBack = new CustomButton(Textures.back, 0, 1){

        protected void touchAction() {
            Application.setScreen(HomeScreen.getInstance());
        }
    };
    private CustomButton btClear = new CustomButton(Textures.optionsClearOff, Textures.optionsClearOff, null){

        protected void touchAction() {
            Application.dataManager.clearAllLevels();
            Application.setScreen(HomeScreen.getInstance());
        }
    };
    private CustomButton btMusicMinus = new CustomButton(Textures.optionsMinusOff, Textures.optionsMinusOff, null){

        protected void touchAction() {
            if (DataManager.getCurrentMusicLvl() > 0) {
                DataManager.setCurrentMusicLvl(DataManager.getCurrentMusicLvl() - 10);
            }
        }
    };
    private CustomButton btMusicPlus = new CustomButton(Textures.optionsPlusOff, Textures.optionsPlusOff, null){

        protected void touchAction() {
            if (DataManager.getCurrentMusicLvl() < 100) {
                DataManager.setCurrentMusicLvl(DataManager.getCurrentMusicLvl() + 10);
            }
        }
    };
    private CustomButton btEffectsMinus = new CustomButton(Textures.optionsMinusOff, Textures.optionsMinusOff, null){

        protected void touchAction() {
            if (DataManager.getCurrentEffectsLvl() > 0) {
                DataManager.setCurrentEffectsLvl(DataManager.getCurrentEffectsLvl() - 10);
            }
        }
    };
    private CustomButton btEffectsPlus = new CustomButton(Textures.optionsPlusOff, Textures.optionsPlusOff, null){

        protected void touchAction() {
            if (DataManager.getCurrentEffectsLvl() < 100) {
                DataManager.setCurrentEffectsLvl(DataManager.getCurrentEffectsLvl() + 10);
            }
        }
    };
    private CustomLabelField lbMusicVolumeNumber;
    private CustomLabelField lbEffectsVolumeNumber = new CustomLabelField(Double.toString(DataManager.getCurrentEffectsLvl() / 100), 24, 5646607);

    public OptionsScreen() {
        this.lbMusicVolumeNumber = new CustomLabelField(Double.toString(DataManager.getCurrentMusicLvl() / 100), 24, 5646607);
        this.add(this.btBack, 257, 310);
        this.add(this.lbMusicVolumeNumber, 450, 195);
        this.add(this.lbEffectsVolumeNumber, 450, 270);
        this.add(this.btClear, 436, 112);
        this.add(this.btMusicMinus, 392, 186);
        this.add(this.btMusicPlus, 501, 186);
        this.add(this.btEffectsMinus, 392, 262);
        this.add(this.btEffectsPlus, 501, 262);
    }

    public void onPaint(Graphics g) {
        Textures.mainMenuBackground.draw(g, 0, 0);
        Textures.optionsMainBackground.draw(g, 25, 0);
        super.onPaint(g);
    }

    public void onVolumeChange() {
        this.lbMusicVolumeNumber.setText(Double.toString((double)DataManager.getCurrentMusicLvl() * 1.0 / 100.0));
        this.lbEffectsVolumeNumber.setText(Double.toString((double)DataManager.getCurrentEffectsLvl() * 1.0 / 100.0));
        OptionsScreen.repaint();
    }

    public static OptionsScreen getInstance() {
        if (instance == null) {
            instance = new OptionsScreen();
        }
        return instance;
    }
}

