/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.audio;

import com.ximad.bubble_birds_2.audio.SoundManager;
import com.ximad.bubble_birds_2.game.DataManager;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Sound {
    private static final boolean DEBUG = false;
    private Player player;
    private boolean isPaused = false;
    private boolean isLoop;
    private String soundPath;

    public boolean isPaused() {
        return this.isPaused;
    }

    public Sound(SoundManager soundManager, String soundPath) {
        this.soundPath = soundPath;
        this.isLoop = false;
        this.create(soundPath);
        soundManager.add(this);
    }

    private void create(String fileName) {
        try {
            InputStream is = this.getClass().getResourceAsStream(fileName);
            if (is == null) {
                return;
            }
            this.player = Manager.createPlayer((InputStream)is, (String)"audio/mp3");
            this.player.setLoopCount(this.isLoop ? -1 : 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playInLoop() {
        this.setLooping(true);
        this.play();
    }

    public void play() {
        if (this.player == null) {
            return;
        }
        if (!DataManager.getSoundState()) {
            return;
        }
        try {
            if (this.player.getState() != 300) {
                this.player.prefetch();
            }
            this.player.start();
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
        this.isPaused = false;
    }

    public void pause() {
        if (this.player == null && this.player.getState() == 400) {
            return;
        }
        try {
            this.player.stop();
            this.isPaused = true;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void resume() {
        if (this.player == null && !this.isPaused) {
            return;
        }
        try {
            this.player.start();
            this.isPaused = false;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stop() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.isPaused = false;
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void setLooping(boolean isLoop) {
        try {
            this.player.setLoopCount(isLoop ? -1 : 1);
            this.isLoop = isLoop;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        if (this.player == null) {
            return;
        }
        try {
            this.player.stop();
            this.player.deallocate();
            this.player.close();
            this.player = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

