/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.screen;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.component.Animatable;
import com.ximad.bubble_birds_2.component.BitmapField;
import com.ximad.bubble_birds_2.component.CustomIntField;
import com.ximad.bubble_birds_2.engine.Application;
import com.ximad.bubble_birds_2.engine.Bitmap;
import com.ximad.bubble_birds_2.engine.CustomButton;
import com.ximad.bubble_birds_2.engine.CustomLabelField;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.engine.UiScreen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.res.ImagesResources;
import com.ximad.bubble_birds_2.screen.EnterNameScreen;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.HomeScreen;
import com.ximad.bubble_birds_2.screen.ScoresScreen;
import com.ximad.bubble_birds_2.screen.SettingsScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import javax.microedition.lcdui.Graphics;

public class GamePopupScreen
extends UiScreen {
    public static final int WIN_LVL = 0;
    public static final int ENTER = 1;
    public static final int LOSE = 2;
    public static final int WIN_ALL = 3;
    public static final int LOSE_ALL = 4;
    public static final int NEW = 5;
    public static final int CLEAR = 6;
    public static final int BUY_LEVEL = 7;
    public static final int BUY_LIFE = 8;
    public static final int RATE = 9;
    public static final int POPUPS_COUNT = 10;
    private static GamePopupScreen[] instances = new GamePopupScreen[10];
    public static String playerName;
    public static CustomButton name_button;
    public static CustomLabelField name_text;
    private Bitmap background;
    private BitmapField popup_body;
    CustomButton popup_no_btn;
    CustomButton popup_yes_btn;
    public static Animatable bird_1;
    public static Animatable bird_2;
    public static final AnimationThread animationThread;
    private CustomIntField level_field;
    private CustomIntField score_field;
    private CustomIntField coins_field;
    private CustomIntField total_field;
    private CustomIntField lives_field;
    private int selected_lvl = 1;
    private int price = 0;
    private boolean isPopupNeeded = false;
    private int[] shadowRGB;
    private int pop_type;

    public GamePopupScreen(int type) {
        this.pop_type = type;
        this.init();
    }

    private void init() {
        if (this.pop_type == 0 || this.pop_type == 1 || this.pop_type == 2) {
            this.isPopupNeeded = false;
            int gms_number = DataManager.playedGamesNumber;
            if ((gms_number % 2 == 0 || gms_number == 1) && DataManager.isAdPopupNeeded) {
                this.isPopupNeeded = true;
            }
        }
        int width = 360;
        int height = 640;
        this.background = ImagesResources.popupBg;
        if (this.pop_type == 2) {
            this.lives_field = new CustomIntField(DataManager.levelData.getLivesNmb(), 230, 263, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupLose);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupYesOff, ImagesResources.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(ShopScreen.getInstance());
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupNoOff, ImagesResources.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    if (DataManager.levelData.getAllScore() == 0 || DataManager.getPlayerPosition(DataManager.levelData.getAllScore()) == -1) {
                        DataManager.removeLevelData();
                        Application.setScreen(HomeScreen.getInstance());
                    } else {
                        Application.setScreen(GamePopupScreen.getInstance(1));
                    }
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.lives_field, 0, 0);
            this.add(this.popup_yes_btn, 103, 408);
            this.add(this.popup_no_btn, 239, 408);
        } else if (this.pop_type == 0) {
            this.level_field = new CustomIntField(DataManager.levelData.getCurrLvl(), 213, 225, ImagesResources.font_popup);
            this.score_field = new CustomIntField(DataManager.levelData.getCurrScore(), 241, 276, ImagesResources.font_popup);
            this.coins_field = new CustomIntField(DataManager.levelData.getCurrMoney(), 193, 308, ImagesResources.font_popup);
            this.total_field = new CustomIntField(DataManager.levelData.getAllScore(), 183, 365, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupWinLvl);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupOkOff, ImagesResources.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(ShopScreen.getInstance());
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.level_field, 0, 0);
            this.add(this.score_field, 0, 0);
            this.add(this.coins_field, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 172, 408);
            DataManager.levelData.setCurrLvl(DataManager.levelData.getCurrLvl() + 1);
        } else if (this.pop_type == 3) {
            DataManager.levelData.setAllScore(DataManager.levelData.getAllScore() + DataManager.levelData.getCurrScore());
            this.total_field = new CustomIntField(DataManager.levelData.getAllScore(), 183, 369, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupWinGame);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupOkOff, ImagesResources.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    DataManager.levelData.setAllScore(DataManager.levelData.getAllScore() + DataManager.levelData.getCurrScore());
                    if (DataManager.levelData.getAllScore() == 0 || DataManager.getPlayerPosition(DataManager.levelData.getAllScore()) == -1) {
                        Application.setScreen(HomeScreen.getInstance());
                    } else {
                        Application.setScreen(GamePopupScreen.getInstance(1));
                    }
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 172, 408);
        } else if (this.pop_type == 4) {
            this.total_field = new CustomIntField(DataManager.levelData.getAllScore(), 181, 314, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupLoseAll);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupOkOff, ImagesResources.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    if (DataManager.levelData.getAllScore() == 0 || DataManager.getPlayerPosition(DataManager.levelData.getAllScore()) == -1) {
                        DataManager.removeLevelData();
                        Application.setScreen(HomeScreen.getInstance());
                    } else {
                        Application.setScreen(GamePopupScreen.getInstance(1));
                    }
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.total_field, 0, 0);
            this.add(this.popup_yes_btn, 172, 408);
        } else if (this.pop_type == 5) {
            this.popup_body = new BitmapField(ImagesResources.popupUnfinish);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupYesOff, ImagesResources.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    DataManager.removeLevelData();
                    Application.setScreen(GameScreen.getInstance(1));
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupNoOff, ImagesResources.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.returnToMenu();
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.popup_yes_btn, 103, 408);
            this.add(this.popup_no_btn, 239, 408);
        } else if (this.pop_type == 6) {
            this.popup_body = new BitmapField(ImagesResources.popupClear);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupYesOff, ImagesResources.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    DataManager.clearScores();
                    DataManager.removeLevelData();
                    GamePopupScreen.this.returnToMenu();
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupNoOff, ImagesResources.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.playButtonSound();
                    GamePopupScreen.this.returnToMenu();
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.popup_yes_btn, 103, 408);
            this.add(this.popup_no_btn, 239, 408);
        } else if (this.pop_type == 7) {
            this.lives_field = new CustomIntField(this.selected_lvl, 181, 260, ImagesResources.font_popup);
            this.coins_field = new CustomIntField(this.price, 181, 325, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupBuyLvl);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupYesOff, ImagesResources.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    SoundSystem.SOUND_COINS.play();
                    DataManager.levelData.setPassedLvl(GamePopupScreen.this.selected_lvl);
                    DataManager.levelData.setCurrLvl(GamePopupScreen.this.selected_lvl);
                    DataManager.levelData.setAllMoney(DataManager.levelData.getAllMoney() - GamePopupScreen.this.price);
                    Application.setScreen(GameScreen.getInstance(GamePopupScreen.this.selected_lvl));
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupNoOff, ImagesResources.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(ShopScreen.getInstance());
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.lives_field, 0, 0);
            this.add(this.coins_field, 0, 0);
            this.add(this.popup_yes_btn, 103, 408);
            this.add(this.popup_no_btn, 239, 408);
        } else if (this.pop_type == 8) {
            this.coins_field = new CustomIntField(this.price, 180, 312, ImagesResources.font_popup);
            this.popup_body = new BitmapField(ImagesResources.popupBuyLife);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupYesOff, ImagesResources.popupYesOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    SoundSystem.SOUND_COINS.play();
                    DataManager.levelData.setLivesNmb(DataManager.levelData.getLivesNmb() + 1);
                    DataManager.levelData.setAllMoney(DataManager.levelData.getAllMoney() - GamePopupScreen.this.price);
                    Application.setScreen(ShopScreen.getInstance());
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupNoOff, ImagesResources.popupNoOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(ShopScreen.getInstance());
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.coins_field, 0, 0);
            this.add(this.popup_yes_btn, 103, 408);
            this.add(this.popup_no_btn, 239, 408);
        } else if (this.pop_type == 1) {
            this.popup_body = new BitmapField(ImagesResources.popupEnter);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupOkOff, ImagesResources.popupOkOn, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.set_name();
                }
            };
            name_button = new CustomButton(147, 26){

                protected void touchAction() {
                    Application.setScreen(EnterNameScreen.getInstance());
                }
            };
            name_text = new CustomLabelField("Champion", 19, 0);
            this.add(this.popup_body, 77, 213);
            this.add(name_text, 119, 237);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(name_button, 101, 224);
            this.add(this.popup_yes_btn, 172, 383);
        } else if (this.pop_type == 9) {
            this.popup_body = new BitmapField(ImagesResources.popupRate);
            this.popup_yes_btn = new CustomButton(ImagesResources.popupBtnRate, ImagesResources.popupBtnRatePress, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.isRating = true;
                    try {
                        Application.getInstance().platformRequest("http://appworld.blackberry.com/webstore/content/64260");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Application.setScreen(HomeScreen.getInstance());
                }
            };
            this.popup_no_btn = new CustomButton(ImagesResources.popupBtnCancel, ImagesResources.popupBtnCancelPress, null, null){

                protected void touchAction() {
                    GamePopupScreen.this.removeAdsFromScreen();
                    GamePopupScreen.this.playButtonSound();
                    Application.setScreen(HomeScreen.getInstance());
                }
            };
            this.add(this.popup_body, 77, 213);
            this.add(bird_1, 0, 0);
            this.add(bird_2, 0, 0);
            this.add(this.popup_yes_btn, 91, 459);
            this.add(this.popup_no_btn, 208, 459);
        }
        if (this.pop_type == 0 || this.pop_type == 3) {
            SoundSystem.SOUND_LEVEL_END.play();
        } else if (this.pop_type == 2 || this.pop_type == 4) {
            SoundSystem.SOUND_GAME_LOSE.play();
        }
    }

    public void onShow() {
        animationThread.resumeAnimation();
    }

    public void onHide() {
        animationThread.pauseAnimation();
    }

    private void initExisting() {
        int width = 360;
        int height = 640;
        this.background = ImagesResources.popupBg;
        if (this.pop_type == 2) {
            this.lives_field.set_int(DataManager.levelData.getLivesNmb());
            this.popup_body.setBitmap(ImagesResources.popupLose);
        } else if (this.pop_type == 0) {
            this.level_field.set_int(DataManager.levelData.getCurrLvl());
            this.score_field.set_int(DataManager.levelData.getCurrScore());
            this.coins_field.set_int(DataManager.levelData.getCurrMoney());
            this.total_field.set_int(DataManager.levelData.getAllScore());
            this.popup_body.setBitmap(ImagesResources.popupWinLvl);
            DataManager.levelData.setCurrLvl(DataManager.levelData.getCurrLvl() + 1);
        } else if (this.pop_type == 3) {
            DataManager.levelData.setAllScore(DataManager.levelData.getAllScore() + DataManager.levelData.getCurrScore());
            this.total_field.set_int(DataManager.levelData.getAllScore());
            this.popup_body.setBitmap(ImagesResources.popupWinGame);
        } else if (this.pop_type == 4) {
            this.total_field.set_int(DataManager.levelData.getAllScore());
            this.popup_body.setBitmap(ImagesResources.popupLoseAll);
        } else if (this.pop_type == 5) {
            this.popup_body.setBitmap(ImagesResources.popupUnfinish);
        } else if (this.pop_type == 6) {
            this.popup_body.setBitmap(ImagesResources.popupClear);
        } else if (this.pop_type == 7) {
            this.lives_field.set_int(this.selected_lvl);
            this.coins_field.set_int(this.price);
            this.popup_body.setBitmap(ImagesResources.popupBuyLvl);
        } else if (this.pop_type == 8) {
            this.coins_field.set_int(this.price);
            this.popup_body.setBitmap(ImagesResources.popupBuyLife);
        } else if (this.pop_type == 1) {
            this.popup_body.setBitmap(ImagesResources.popupEnter);
        }
    }

    public void onPaint(Graphics g) {
        this.background.draw(g, 0, 0);
        super.onPaint(g);
    }

    private void returnToMenu() {
        this.processClose();
    }

    public void set_name() {
        this.removeAdsFromScreen();
        this.playButtonSound();
        DataManager.addResultToScoreboard(name_text.getText(), DataManager.levelData.getAllScore());
        DataManager.removeLevelData();
        Application.setScreen(ScoresScreen.getInstance());
    }

    public void close() {
        this.processClose();
    }

    private void processClose() {
        this.removeAdsFromScreen();
        if (this.pop_type == 1) {
            this.playButtonSound();
            this.set_name();
        } else if (this.pop_type == 8 || this.pop_type == 7 || this.pop_type == 0) {
            this.playButtonSound();
            Application.setScreen(ShopScreen.getInstance());
        } else if (this.pop_type == 6) {
            this.playButtonSound();
            Application.setScreen(SettingsScreen.getInstance());
        } else if (this.pop_type == 3 || this.pop_type == 2 || this.pop_type == 4) {
            this.playButtonSound();
            if (DataManager.levelData.getAllScore() == 0 || DataManager.getPlayerPosition(DataManager.levelData.getAllScore()) == -1) {
                Application.setScreen(HomeScreen.getInstance());
            } else {
                Application.setScreen(GamePopupScreen.getInstance(1));
            }
        } else {
            this.playButtonSound();
            Application.setScreen(HomeScreen.getInstance());
        }
    }

    private void playButtonSound() {
        try {
            SoundSystem.SOUND_BUTTON.play();
        }
        catch (Error error) {
            // empty catch block
        }
    }

    public void removeAdsFromScreen() {
    }

    public static GamePopupScreen getInstance(int popupType) {
        try {
            if (instances[popupType] == null) {
                GamePopupScreen.instances[popupType] = new GamePopupScreen(popupType);
            } else {
                instances[popupType].initExisting();
            }
            return instances[popupType];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return null;
        }
    }

    public static GamePopupScreen getInstance(int type, int lvl, int new_price) {
        GamePopupScreen _inst = null;
        try {
            _inst = instances[type];
            if (_inst == null) {
                _inst = GamePopupScreen.instances[type] = new GamePopupScreen(type);
                _inst.selected_lvl = lvl;
                _inst.price = new_price;
            }
            _inst.initExisting();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        return _inst;
    }

    public static void setPlayerName(String name) {
        playerName = name;
        GamePopupScreen.getInstance(1);
        name_text.setText(name);
    }

    static {
        animationThread = new AnimationThread();
        animationThread.pauseAnimation();
        animationThread.start();
    }

    public static class AnimationThread
    extends Thread {
        private boolean paused = false;

        public AnimationThread() {
            if (bird_1 == null) {
                bird_1 = new Animatable(ImagesResources.popupBird_1[0], 43, 40);
                bird_1.animate(ImagesResources.popupBird_1, 140, Animatable.TYPE_LINEAR, true);
                bird_1.startAnimation(Animatable.TYPE_FRAME);
            }
            if (bird_2 == null) {
                bird_2 = new Animatable(ImagesResources.popupBird_2[0], 200, 40);
                bird_2.animate(ImagesResources.popupBird_2, 140, Animatable.TYPE_LINEAR, true);
                bird_2.startAnimation(Animatable.TYPE_FRAME);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int sleepTime = 50;
                while (true) {
                    if (this.paused) {
                        AnimationThread animationThread = this;
                        synchronized (animationThread) {
                            this.wait();
                        }
                    }
                    sleepTime = bird_1.frameAnimationStep();
                    bird_2.frameAnimationStep();
                    Screen.repaint();
                    AnimationThread.sleep(sleepTime);
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void pauseAnimation() {
            this.paused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resumeAnimation() {
            this.paused = false;
            AnimationThread animationThread = this;
            synchronized (animationThread) {
                this.notifyAll();
            }
        }
    }
}

