/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.bubble_birds_2.engine;

import com.ximad.bubble_birds_2.audio.SoundSystem;
import com.ximad.bubble_birds_2.engine.MainCanvas;
import com.ximad.bubble_birds_2.engine.Screen;
import com.ximad.bubble_birds_2.game.DataManager;
import com.ximad.bubble_birds_2.screen.EnterNameScreen;
import com.ximad.bubble_birds_2.screen.GamePopupScreen;
import com.ximad.bubble_birds_2.screen.GameScreen;
import com.ximad.bubble_birds_2.screen.ShopScreen;
import com.ximad.bubble_birds_2.screen.SplashScreen;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;

public class Application
extends MIDlet {
    public static boolean isRating = false;
    private static long deactTime = 0L;
    public static MainCanvas canvas;
    private static Application instance;
    public static int screenWidth;
    public static int screenHeight;
    public static DataManager dataManager;
    public static boolean isForeground;
    public static Screen screen;
    private static Command quitCommand;

    public Application() {
        instance = this;
        canvas = new MainCanvas();
        canvas.setFullScreenMode(true);
    }

    public void startApp() {
        canvas.setFullScreenMode(true);
        canvas.start();
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)canvas);
        Screen.sleep(50L);
        screenWidth = canvas.getWidth();
        screenHeight = canvas.getHeight();
        if (screenHeight < screenWidth) {
            screenWidth = canvas.getHeight();
            screenHeight = canvas.getWidth();
        }
        Application.setScreen(SplashScreen.getInstance());
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (dataManager != null) {
            dataManager.saveSettings();
        }
        if (SoundSystem.isInited) {
            SoundSystem.release();
        }
        canvas.stop();
    }

    public static void setScreen(Screen screen) {
        if (Application.screen != null) {
            Application.screen.onHide();
        }
        if (!(screen instanceof SplashScreen || screen instanceof GameScreen || screen instanceof ShopScreen || screen instanceof EnterNameScreen || screen instanceof GamePopupScreen)) {
            SoundSystem.SOUND_MAIN_THEME.playInLoop();
        } else if (SoundSystem.SOUND_MAIN_THEME != null) {
            SoundSystem.SOUND_MAIN_THEME.stop();
        }
        Application.screen = screen;
        if (screen != null) {
            screen.onShow();
        }
    }

    public static Screen getScreen() {
        return screen;
    }

    public static void activate() {
        if (isRating && System.currentTimeMillis() - deactTime >= 40000L) {
            DataManager.isRated = true;
        }
        isRating = false;
        isForeground = true;
        if (!(screen instanceof SplashScreen || screen instanceof GameScreen || screen instanceof ShopScreen || screen instanceof EnterNameScreen || screen instanceof GamePopupScreen || SoundSystem.SOUND_MAIN_THEME == null)) {
            SoundSystem.SOUND_MAIN_THEME.playInLoop();
        }
        canvas.start();
        if (screen instanceof GameScreen) {
            ((GameScreen)screen).onShow();
        }
    }

    public static void deactivate() {
        if (isRating) {
            deactTime = System.currentTimeMillis();
        }
        if (SoundSystem.SOUND_MAIN_THEME != null && !SoundSystem.SOUND_MAIN_THEME.isPaused()) {
            SoundSystem.SOUND_MAIN_THEME.stop();
        }
        if (screen instanceof GameScreen) {
            screen.onHide();
        }
        canvas.stop();
        isForeground = false;
    }

    public static void quit() {
        DataManager.saveSettings();
        instance.destroyApp(true);
        instance.notifyDestroyed();
    }

    public static MIDlet getInstance() {
        return instance;
    }

    static {
        isForeground = false;
    }
}

