/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.skeleton.Defines;

public class GameState {
    public static final int CUTSCENE_INTRO_OFFSET = 1;
    public static final int CUTSCENE_WORLD1_OFFSET = 2;
    public static final int CUTSCENE_WORLD2_OFFSET = 4;
    public static final int CUTSCENE_WORLD3_OFFSET = 8;
    public static final int CUTSCENE_WORLD4_OFFSET = 16;
    public static final int CUTSCENE_WORLD5_OFFSET = 32;
    public static final long W1L1_PLAYED_OFFSET = 1L;
    public static final long W2L1_PLAYED_OFFSET = 2L;
    public static final long W3L1_PLAYED_OFFSET = 4L;
    public static final long W4L1_PLAYED_OFFSET = 8L;
    public static final long W5L1_PLAYED_OFFSET = 16L;
    public static final long CHEST_OPENED_OFFSET = 32L;
    public static final long CHECKPOINT_PASSED_OFFSET = 64L;
    public static final long FIRST_LEVEL_COMPLETED_OFFSET = 128L;
    public static final long SLIPPERY_ENCOUNTERED_OFFSET = 256L;
    public static final long FIRST_LEVEL_AFTER_TOTEM1_OFFSET = 512L;
    public static final long ALL_LEVELS_COMPLETE_OFFSET = 1024L;
    public static final long SIGN_JUMP_PLAYED_OFFSET = 2048L;
    public static final long SIGN_MONSTER_PLAYED_OFFSET = 4096L;
    public static final long SIGN_HEALTH_PLAYED_OFFSET = 8192L;
    public static final long SIGN_SILVER_COIN_PLAYED_OFFSET = 16384L;
    public static final long SIGN_GOLD_COIN_PLAYED_OFFSET = 32768L;
    public static final long SIGN_CHEST_PLAYED_OFFSET = 65536L;
    public static final long SIGN_SMALLER_PLAYED_OFFSET = 131072L;
    public static final long SIGN_TOTEM1_PLAYED_OFFSET = 262144L;
    public static final long SIGN_TOTEM2_PLAYED_OFFSET = 524288L;
    public static final long SIGN_TOTEM3_PLAYED_OFFSET = 0x100000L;
    public static final long SIGN_STRONGER_PLAYED_OFFSET = 0x200000L;
    public static final long CHEST_OPENED_PLAYED_OFFSET = 22L;
    public static final long CHECKPOINT_PLAYED_OFFSET = 23L;
    public static final long LEVEL_COMPLETED_PLAYED_OFFSET = 24L;
    public static final long SLIPPERY_SURFACE_PLAYED_OFFSET = 25L;
    public static final long SILVER_COIN_LIFE_PLAYED_OFFSET = 26L;
    public static final long TOTEM1_TRANSITION_PLAYED_OFFSET = 27L;
    public static final long TOTEM2_TRANSITION_PLAYED_OFFSET = 28L;
    public static final long TOTEM3_TRANSITION_PLAYED_OFFSET = 29L;
    public static final long LOSE_LIFE_PLAYED_OFFSET = 30L;
    public static final long ALL_COLLECTED_PLAYED_OFFSET = 31L;
    public static final long LOCKED_TOTEM_PRESSED_PLAYED_OFFSET = 32L;
    public static int mSelectedSlotID = -1;
    public static byte mReachedLevel;
    public static byte mLives;
    public static byte mSilverCoins;
    public static long mScriptStateGlobal;
    public static byte mCutsceneState;
    public static byte mAnalogTouch;
    public static boolean mIsSingleTouch;
    public static short[] mGoldCoinsFound;
    public static byte[] mKeysFound;
    public static byte[] mChestsOpened;
    public static byte[] mNumGoldCoins;
    public static byte[] mNumUnusedKeys;
    public static byte[] mNumChestsOpened;
    public static int mPlayCutscene;
    public static byte mLastPlayedLevel;
    public static byte mActiveCheckpoint;
    public static short mMemGoldCoinsFound;
    public static byte mMemKeysFound;
    public static byte mMemChestsOpened;
    public static byte mMemNumGoldCoins;
    public static byte mMemNumUnusedKeys;
    public static byte mMemNumChestsOpened;
    public static short mActiveGoldCoinsFound;
    public static byte mActiveKeysFound;
    public static byte mActiveChestsOpened;
    public static byte mActiveNumGoldCoins;
    public static byte mActiveNumUnusedKeys;
    public static byte mActiveNumChestsOpened;
    public static boolean mAllCollectedInGame;
    public static boolean mAllGoldCoinsCollected;
    public static boolean mAllChestsOpened;
    public static byte mLevel;
    public static boolean mMovePixelineToNextLevel;

    public static void resetState() {
        mActiveCheckpoint = (byte)-1;
        mActiveGoldCoinsFound = mGoldCoinsFound[mLevel];
        mActiveKeysFound = mKeysFound[mLevel];
        mActiveChestsOpened = mChestsOpened[mLevel];
        mActiveNumGoldCoins = mNumGoldCoins[mLevel];
        mActiveNumUnusedKeys = mNumUnusedKeys[mLevel];
        mActiveNumChestsOpened = mNumChestsOpened[mLevel];
        mMemGoldCoinsFound = mActiveGoldCoinsFound;
        mMemKeysFound = mActiveKeysFound;
        mMemChestsOpened = mActiveChestsOpened;
        mMemNumGoldCoins = mActiveNumGoldCoins;
        mMemNumUnusedKeys = mActiveNumUnusedKeys;
        mMemNumChestsOpened = mActiveNumChestsOpened;
    }

    public static void restoreStoredState() {
        mActiveGoldCoinsFound = mMemGoldCoinsFound;
        mActiveKeysFound = mMemKeysFound;
        mActiveChestsOpened = mMemChestsOpened;
        mActiveNumGoldCoins = mMemNumGoldCoins;
        mActiveNumUnusedKeys = mMemNumUnusedKeys;
        mActiveNumChestsOpened = mMemNumChestsOpened;
    }

    public static void resetToDefault() {
        mReachedLevel = 0;
        mLevel = 0;
        mMovePixelineToNextLevel = false;
        mLives = (byte)5;
        mSilverCoins = 0;
        mScriptStateGlobal = 0L;
        mCutsceneState = 0;
        for (int i = 0; i < 23; ++i) {
            GameState.mGoldCoinsFound[i] = 0;
            GameState.mKeysFound[i] = 0;
            GameState.mChestsOpened[i] = 0;
            GameState.mNumGoldCoins[i] = 0;
            GameState.mNumUnusedKeys[i] = 0;
            GameState.mNumChestsOpened[i] = 0;
        }
        mPlayCutscene = 0;
        mLastPlayedLevel = (byte)-1;
        mActiveCheckpoint = (byte)-1;
        mMemGoldCoinsFound = 0;
        mMemKeysFound = 0;
        mMemChestsOpened = 0;
        mMemNumGoldCoins = 0;
        mMemNumUnusedKeys = 0;
        mMemNumChestsOpened = 0;
        mActiveGoldCoinsFound = 0;
        mActiveKeysFound = 0;
        mActiveChestsOpened = 0;
        mActiveNumGoldCoins = 0;
        mActiveNumUnusedKeys = 0;
        mActiveNumChestsOpened = 0;
        mAllCollectedInGame = false;
        mAllGoldCoinsCollected = false;
        mAllChestsOpened = false;
    }

    public static void updateCollectionState() {
        mAllCollectedInGame = true;
        for (int i = 0; i < 23; ++i) {
            if (mNumGoldCoins[i] < Defines.mNumGoldCoins[i]) {
                mAllCollectedInGame = false;
                return;
            }
            if (mNumChestsOpened[i] >= Defines.mNumChests[i]) continue;
            mAllCollectedInGame = false;
            return;
        }
    }

    public static boolean isTotem1Unlocked() {
        boolean bl = false;
        if (mReachedLevel >= 23) {
            bl = true;
        } else if (Defines.mWorldLookup[mReachedLevel] > 0) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTotem2Unlocked() {
        boolean bl = false;
        if (mReachedLevel >= 23) {
            bl = true;
        } else if (Defines.mWorldLookup[mReachedLevel] > 1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isTotem3Unlocked() {
        boolean bl = false;
        if (mReachedLevel >= 23) {
            bl = true;
        } else if (Defines.mWorldLookup[mReachedLevel] > 2) {
            bl = true;
        }
        return bl;
    }

    static {
        mGoldCoinsFound = new short[23];
        mKeysFound = new byte[23];
        mChestsOpened = new byte[23];
        mNumGoldCoins = new byte[23];
        mNumUnusedKeys = new byte[23];
        mNumChestsOpened = new byte[23];
    }
}

