/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.PlatformView;
import dk.progressivemedia.skeleton.game.PlatformViewCorrosive;
import dk.progressivemedia.skeleton.game.PlatformViewDisappearing;
import dk.progressivemedia.skeleton.game.PlatformViewMovable;
import dk.progressivemedia.skeleton.game.PlatformViewStatic;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceCtrl;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Platform {
    public static final int SOLIDITY_TYPE_NORMAL = 0;
    public static final int SOLIDITY_TYPE_CORROSIVE = 1;
    public static final int SOLIDITY_TYPE_DISAPPEARING = 2;
    private int mSolidityType;
    private SurfaceCtrl mMovementCtrl;
    private SurfaceCtrl mSolidityCtrl;
    private PlatformData mData;
    private PlatformView mView;

    public Platform(PlatformData platformData) {
        this.mData = platformData;
        this.mMovementCtrl = null;
        this.mSolidityCtrl = null;
        this.mSolidityType = 0;
    }

    public int getGroupIndex() {
        return this.mData.getGroupIndex();
    }

    public void assignMovementCtrl(SurfaceCtrl surfaceCtrl) {
        this.mMovementCtrl = surfaceCtrl;
    }

    public void assignSolidityCtrl(SurfaceCtrl surfaceCtrl, int n) {
        this.mSolidityCtrl = surfaceCtrl;
        this.mSolidityType = n;
    }

    public void generateView() {
        if (this.mSolidityType != 0) {
            if (this.mSolidityType == 1) {
                this.mView = new PlatformViewCorrosive(this.mData);
            } else if (this.mSolidityType == 2) {
                this.mView = new PlatformViewDisappearing(this.mData);
            }
        } else {
            this.mView = this.mMovementCtrl != null ? new PlatformViewMovable(this.mData) : new PlatformViewStatic(this.mData);
        }
    }

    public boolean collideUpdateZone(AABB aABB) {
        int n;
        Surface surface = this.mData.getSurface();
        int n2 = surface.getFirstY();
        int n3 = n2 < (n = surface.getLastY()) ? n2 : n;
        int n4 = n2 > n ? n2 : n;
        int n5 = surface.getMinX();
        int n6 = surface.getMaxX();
        if (n6 < aABB.mMinX || n5 > aABB.mMaxX) {
            return false;
        }
        return n4 >= aABB.mMinY && n3 <= aABB.mMaxY;
    }

    public void update() {
        if (this.mMovementCtrl != null) {
            this.mMovementCtrl.update();
        }
        if (this.mSolidityCtrl != null) {
            this.mSolidityCtrl.update();
        }
        this.mView.update();
    }

    public void draw(Vector2 vector2) {
        this.mView.draw(vector2);
    }
}

