/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceCtrl;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;

public class SurfaceMovementCtrlLinear
extends SurfaceCtrl {
    private Vector2 mDirection;
    private int mDistance;
    private int mSpeed;
    private boolean mGrowing;
    private int mInterp;
    private int mOffsetPrev;
    private int mOffset;
    private boolean mStarted;

    public SurfaceMovementCtrlLinear(PlatformData platformData, Vector2 vector2, int n, int n2, boolean bl) {
        this.mData = platformData;
        this.mDirection = vector2;
        this.mDistance = n;
        this.mSpeed = n2;
        this.mGrowing = true;
        this.mInterp = 0;
        this.mOffsetPrev = 0;
        this.mOffset = 0;
        this.mStarted = bl;
    }

    public void update() {
        Surface surface = this.mData.getSurface();
        if (!this.mStarted) {
            if (surface.getPlayerTouching()) {
                this.mStarted = true;
            }
        } else {
            int n = (this.mSpeed << 6) / 33 * Timer.mDt >> 6;
            if (this.mGrowing) {
                this.mInterp += n;
                if (this.mInterp > 65536) {
                    this.mInterp = 65536;
                    this.mGrowing = false;
                }
            } else {
                this.mInterp -= n;
                if (this.mInterp < 0) {
                    this.mInterp = 0;
                    this.mGrowing = true;
                }
            }
            this.mOffsetPrev = this.mOffset;
            this.mOffset = MathUtil.smoothStep(this.mInterp, this.mDistance);
            surface.move(PMMath.MUL(this.mDirection.mX, this.mOffset) - PMMath.MUL(this.mDirection.mX, this.mOffsetPrev), PMMath.MUL(this.mDirection.mY, this.mOffset) - PMMath.MUL(this.mDirection.mY, this.mOffsetPrev));
        }
    }
}

