/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy2Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy2State;
import dk.progressivemedia.skeleton.game.enemies.Enemy2StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy2View;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy2StateFalling
extends Enemy2State {
    private Vector2 mNextPos;
    private SurfaceIntersectionResult mIntersectionRes;
    private AABB mTileAABB;

    public Enemy2StateFalling(Enemy2Data enemy2Data, Enemy2View enemy2View, Enemy2StateController enemy2StateController) {
        this.mData = enemy2Data;
        this.mView = enemy2View;
        this.mController = enemy2StateController;
        this.mNextPos = new Vector2();
        this.mIntersectionRes = new SurfaceIntersectionResult();
        this.mTileAABB = new AABB();
    }

    public void enter() {
        this.mView.setAnimState(3);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        vector2.mY += Timer.mFeatureWorldGravity;
        if (vector2.mY > Timer.mFeatureWorldGravityMax) {
            vector2.mY = Timer.mFeatureWorldGravityMax;
        }
        this.mNextPos.set(vector22);
        this.mNextPos.add(vector2);
        this.mIntersectionRes.clear();
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector22.mX, vector22.mY, vector2.mX, vector2.mY, vector23.mX >> 1, this.mIntersectionRes);
        if (this.mIntersectionRes.mSurface != null) {
            this.mData.setSurface(this.mIntersectionRes.mSurface, this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset);
            Surface surface = this.mIntersectionRes.mSurface;
            surface.getSurfacePosition(this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset, vector23.mX >> 1, vector22);
            this.mController.requestStateChange(1);
        } else {
            vector22.set(this.mNextPos);
        }
    }
}

