/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.io.PMGameData;
import dk.progressivemedia.skeleton.GameState;

public class SaveGameHelper {
    public static byte[] slot1Raw;
    public static byte[] slot2Raw;
    public static byte[] slot3Raw;
    private static byte[] selectedSlot;
    private static final byte OFFSET_USED = 0;
    private static final byte OFFSET_REACHED_LEVEL = 1;
    private static final byte OFFSET_LIVES = 2;
    private static final byte OFFSET_SILVERCOINS = 3;
    private static final byte OFFSET_SCRIPT_STATE = 4;
    private static final byte OFFSET_CUTSCENE_STATE = 12;
    private static final byte OFFSET_GOLDCOINS_FOUND = 13;
    private static final byte OFFSET_KEYS_FOUND = 63;
    private static final byte OFFSET_CHESTS_OPENED = 88;
    private static final byte SAVEGAME_LENGTH = 113;

    public static void init() {
        boolean bl = false;
        boolean bl2 = PMGameData.load();
        if (bl2 && slot1Raw.length == 113 && slot2Raw.length == 113 && slot3Raw.length == 113) {
            bl = true;
        }
        if (!bl) {
            slot1Raw = new byte[113];
            slot2Raw = new byte[113];
            slot3Raw = new byte[113];
            PMGameData.save();
        }
    }

    public static void loadSlot(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        if (n == 0) {
            selectedSlot = slot1Raw;
        } else if (n == 1) {
            selectedSlot = slot2Raw;
        } else if (n == 2) {
            selectedSlot = slot3Raw;
        }
        if (selectedSlot[0] == 0) {
            GameState.resetToDefault();
            return;
        }
        GameState.mLastPlayedLevel = (byte)-1;
        GameState.mReachedLevel = selectedSlot[1];
        GameState.mLives = selectedSlot[2];
        GameState.mSilverCoins = selectedSlot[3];
        long l = ((long)selectedSlot[4] & 0xFFL) << 56;
        long l2 = ((long)selectedSlot[5] & 0xFFL) << 48;
        long l3 = ((long)selectedSlot[6] & 0xFFL) << 40;
        long l4 = ((long)selectedSlot[7] & 0xFFL) << 32;
        long l5 = ((long)selectedSlot[8] & 0xFFL) << 24;
        long l6 = ((long)selectedSlot[9] & 0xFFL) << 16;
        long l7 = ((long)selectedSlot[10] & 0xFFL) << 8;
        long l8 = (long)selectedSlot[11] & 0xFFL;
        GameState.mScriptStateGlobal = l | l2 | l3 | l4 | l5 | l6 | l7 | l8;
        GameState.mCutsceneState = selectedSlot[12];
        for (int i = 0; i < 23; ++i) {
            int n2;
            short s = (short)((short)selectedSlot[13 + i * 2 + 0] & 0xFF);
            short s2 = (short)((short)selectedSlot[13 + i * 2 + 1] & 0xFF);
            GameState.mGoldCoinsFound[i] = (short)(s << 8 | s2);
            short s3 = GameState.mGoldCoinsFound[i];
            GameState.mKeysFound[i] = selectedSlot[63 + i];
            GameState.mChestsOpened[i] = selectedSlot[88 + i];
            GameState.mNumGoldCoins[i] = 0;
            GameState.mNumUnusedKeys[i] = 0;
            GameState.mNumChestsOpened[i] = 0;
            for (n2 = 0; n2 < 16; n2 = (int)((byte)(n2 + 1))) {
                if ((GameState.mGoldCoinsFound[i] & 1 << n2) == 0) continue;
                int n3 = i;
                GameState.mNumGoldCoins[n3] = (byte)(GameState.mNumGoldCoins[n3] + 1);
            }
            for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                if ((GameState.mKeysFound[i] & 1 << n2) == 0) continue;
                int n4 = i;
                GameState.mNumUnusedKeys[n4] = (byte)(GameState.mNumUnusedKeys[n4] + 1);
            }
            for (n2 = 0; n2 < 8; n2 = (int)((byte)(n2 + 1))) {
                if ((GameState.mChestsOpened[i] & 1 << n2) == 0) continue;
                int n5 = i;
                GameState.mNumChestsOpened[n5] = (byte)(GameState.mNumChestsOpened[n5] + 1);
            }
            int n6 = i;
            GameState.mNumUnusedKeys[n6] = (byte)(GameState.mNumUnusedKeys[n6] - GameState.mNumChestsOpened[i]);
        }
        GameState.mLevel = GameState.mReachedLevel < 23 ? GameState.mReachedLevel : (byte)22;
    }

    public static void saveSlot() {
        SaveGameHelper.selectedSlot[0] = 1;
        SaveGameHelper.selectedSlot[1] = GameState.mReachedLevel;
        SaveGameHelper.selectedSlot[2] = GameState.mLives;
        SaveGameHelper.selectedSlot[3] = GameState.mSilverCoins;
        SaveGameHelper.selectedSlot[4] = (byte)(GameState.mScriptStateGlobal >> 56 & 0xFFL);
        SaveGameHelper.selectedSlot[5] = (byte)(GameState.mScriptStateGlobal >> 48 & 0xFFL);
        SaveGameHelper.selectedSlot[6] = (byte)(GameState.mScriptStateGlobal >> 40 & 0xFFL);
        SaveGameHelper.selectedSlot[7] = (byte)(GameState.mScriptStateGlobal >> 32 & 0xFFL);
        SaveGameHelper.selectedSlot[8] = (byte)(GameState.mScriptStateGlobal >> 24 & 0xFFL);
        SaveGameHelper.selectedSlot[9] = (byte)(GameState.mScriptStateGlobal >> 16 & 0xFFL);
        SaveGameHelper.selectedSlot[10] = (byte)(GameState.mScriptStateGlobal >> 8 & 0xFFL);
        SaveGameHelper.selectedSlot[11] = (byte)(GameState.mScriptStateGlobal & 0xFFL);
        SaveGameHelper.selectedSlot[12] = GameState.mCutsceneState;
        for (int i = 0; i < 23; ++i) {
            byte by = (byte)(GameState.mGoldCoinsFound[i] >> 8);
            byte by2 = (byte)GameState.mGoldCoinsFound[i];
            SaveGameHelper.selectedSlot[13 + i * 2 + 0] = by;
            SaveGameHelper.selectedSlot[13 + i * 2 + 1] = by2;
            SaveGameHelper.selectedSlot[63 + i] = GameState.mKeysFound[i];
            SaveGameHelper.selectedSlot[88 + i] = GameState.mChestsOpened[i];
        }
        PMGameData.save();
    }

    public static void deleteSlot(int n) {
        if (n < 0 || n > 2) {
            return;
        }
        if (n == 0) {
            slot1Raw = new byte[113];
        } else if (n == 1) {
            slot2Raw = new byte[113];
        } else if (n == 2) {
            slot3Raw = new byte[113];
        }
        PMGameData.save();
    }

    public static boolean slotInUse(int n) {
        if (n == 0) {
            return slot1Raw[0] == 1;
        }
        if (n == 1) {
            return slot2Raw[0] == 1;
        }
        if (n == 2) {
            return slot3Raw[0] == 1;
        }
        return false;
    }

    public static int slotLevel(int n) {
        if (n == 0) {
            return slot1Raw[1];
        }
        if (n == 1) {
            return slot2Raw[1];
        }
        if (n == 2) {
            return slot3Raw[1];
        }
        return 0;
    }

    public static int slotLives(int n) {
        if (n == 0) {
            return slot1Raw[2];
        }
        if (n == 1) {
            return slot2Raw[2];
        }
        if (n == 2) {
            return slot3Raw[2];
        }
        return 0;
    }
}

