/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.game.SegmentIntersectionResult;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.math.Vector2;

public class Surface {
    private int mNumSegments;
    private int[] mPointX;
    private int[] mPointY;
    private int[] mDirectionX;
    private int[] mDirectionY;
    private int[] mLengths;
    private Vector2 mVelocity;
    private Vector2 mLandingSegment;
    private SegmentIntersectionResult mSegmentResult;
    private Vector2 mTempVector;
    private boolean mSolidity;
    private boolean mSlippery;
    private boolean mPlayerTouching;
    private boolean mMoveable;

    public Surface(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, boolean bl, boolean bl2) {
        this.mNumSegments = nArray5.length;
        this.mPointX = nArray;
        this.mPointY = nArray2;
        this.mDirectionX = nArray3;
        this.mDirectionY = nArray4;
        this.mLengths = nArray5;
        this.mVelocity = new Vector2();
        this.mSlippery = bl;
        this.mMoveable = bl2;
        this.mSolidity = true;
        this.mPlayerTouching = false;
        this.mLandingSegment = new Vector2();
        this.mSegmentResult = new SegmentIntersectionResult();
        this.mTempVector = new Vector2();
    }

    public void setSolidity(boolean bl) {
        this.mSolidity = bl;
    }

    public boolean getSolidity() {
        return this.mSolidity;
    }

    public boolean getSlippery() {
        return this.mSlippery;
    }

    public void setPlayerTouching(boolean bl) {
        this.mPlayerTouching = bl;
    }

    public boolean getPlayerTouching() {
        return this.mPlayerTouching;
    }

    public boolean getMoveable() {
        return this.mMoveable;
    }

    public void move(int n, int n2) {
        int n3 = 0;
        while (n3 < this.mPointX.length) {
            int n4 = n3;
            this.mPointX[n4] = this.mPointX[n4] + n;
            int n5 = n3++;
            this.mPointY[n5] = this.mPointY[n5] + n2;
        }
        this.mVelocity.mX = n;
        this.mVelocity.mY = n2;
    }

    public int getNumSegments() {
        return this.mNumSegments;
    }

    public int getMinX() {
        return this.mPointX[1];
    }

    public int getFirstY() {
        return this.mPointY[1];
    }

    public int getMaxX() {
        return this.mPointX[this.mNumSegments - 1];
    }

    public int getLastY() {
        return this.mPointY[this.mNumSegments - 1];
    }

    public Vector2 getVelocity() {
        return this.mVelocity;
    }

    public int getSegmentLength(int n) {
        if (n < 0 || n >= this.mNumSegments) {
            return 0;
        }
        return this.mLengths[n];
    }

    public void getSurfacePosition(int n, int n2, int n3, Vector2 vector2) {
        if (n < 0 || n >= this.mNumSegments) {
            return;
        }
        if (n == 0) {
            vector2.mX = this.mPointX[1] - n3 + n2;
            vector2.mY = this.mPointY[1];
        } else if (n == this.mNumSegments - 1) {
            vector2.mX = this.mPointX[this.mNumSegments - 1] + n2;
            vector2.mY = this.mPointY[this.mNumSegments - 1];
        } else {
            vector2.mX = this.mPointX[n] + PMMath.MUL(n2, this.mDirectionX[n]);
            vector2.mY = this.mPointY[n] + PMMath.MUL(n2, this.mDirectionY[n]);
        }
    }

    public boolean intersectionTest(int n, int n2, int n3, int n4, int n5, SurfaceIntersectionResult surfaceIntersectionResult) {
        int n6 = this.mPointX[1] - (n5 -= 65536) - this.mVelocity.mX;
        int n7 = this.mPointX[this.mNumSegments - 1] + n5 - this.mVelocity.mX;
        if (n < n6 && n3 < n6 || n > n7 && n3 > n7) {
            return false;
        }
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        this.mSegmentResult.clear();
        for (int i = 0; i < this.mNumSegments; ++i) {
            int n12;
            int n13;
            if (i == 0) {
                n13 = this.mPointX[1];
                n12 = this.mPointY[1];
                n8 = n13 - n5;
                n9 = n12;
                n10 = n13;
                n11 = n12;
            } else if (i == this.mNumSegments - 1) {
                n13 = this.mPointX[this.mNumSegments - 1];
                n12 = this.mPointY[this.mNumSegments - 1];
                n8 = n13;
                n9 = n12;
                n10 = n13 + n5;
                n11 = n12;
            } else {
                n8 = this.mPointX[i];
                n9 = this.mPointY[i];
                n10 = this.mPointX[i + 1];
                n11 = this.mPointY[i + 1];
            }
            this.intersect(n8 - this.mVelocity.mX, n9 - this.mVelocity.mY, n10 - this.mVelocity.mX, n11 - this.mVelocity.mY, n, n2, n3, n4, this.mSegmentResult);
            if (this.mSegmentResult.mIntersectionResult != 2) continue;
            surfaceIntersectionResult.mSurface = this;
            surfaceIntersectionResult.mSegmentIndex = i;
            surfaceIntersectionResult.mLengthOffset = this.mSegmentResult.mOffset;
            return true;
        }
        return false;
    }

    private void intersect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, SegmentIntersectionResult segmentIntersectionResult) {
        short s;
        short s2;
        int n9 = n >> 16;
        int n10 = n2 >> 16;
        int n11 = n3 >> 16;
        int n12 = n4 >> 16;
        int n13 = n5 >> 16;
        int n14 = n6 >> 16;
        int n15 = n7 >> 16;
        int n16 = n8 >> 16;
        int n17 = n11 - n9;
        int n18 = n13 - n15;
        short s3 = n17 < 0 ? (short)n11 : (short)n9;
        short s4 = s2 = n17 < 0 ? (short)n9 : (short)n11;
        if (n18 > 0) {
            if (s2 < (short)n15 || (short)n13 < s3) {
                segmentIntersectionResult.mIntersectionResult = 0;
                return;
            }
        } else if (s2 < (short)n13 || (short)n15 < s3) {
            segmentIntersectionResult.mIntersectionResult = 0;
            return;
        }
        int n19 = n12 - n10;
        int n20 = n14 - n16;
        short s5 = n19 < 0 ? (short)n12 : (short)n10;
        short s6 = s = n19 < 0 ? (short)n10 : (short)n12;
        if (n20 > 0) {
            if (s < (short)n16 || (short)n14 < s5) {
                segmentIntersectionResult.mIntersectionResult = 0;
                return;
            }
        } else if (s < (short)n14 || (short)n16 < s5) {
            segmentIntersectionResult.mIntersectionResult = 0;
            return;
        }
        int n21 = n9 - n13;
        int n22 = n10 - n14;
        int n23 = n20 * n21 - n18 * n22;
        int n24 = n19 * n18 - n17 * n20;
        if (n24 > 0) {
            if (n23 < 0 || n23 > n24) {
                segmentIntersectionResult.mIntersectionResult = 0;
                return;
            }
        } else if (n23 > 0 || n23 < n24) {
            segmentIntersectionResult.mIntersectionResult = 0;
            return;
        }
        int n25 = n17 * n22 - n19 * n21;
        if (n24 > 0) {
            if (n25 < 0 || n25 > n24) {
                segmentIntersectionResult.mIntersectionResult = 0;
                return;
            }
        } else if (n25 > 0 || n25 < n24) {
            segmentIntersectionResult.mIntersectionResult = 0;
            return;
        }
        if (n24 == 0) {
            segmentIntersectionResult.mIntersectionResult = 1;
            return;
        }
        int n26 = n23 * n17;
        int n27 = (n26 ^ n24) >= 0 ? n24 >> 1 : -n24 >> 1;
        int n28 = n9 + (n26 + n27) / n24;
        n26 = n23 * n19;
        n27 = (n26 ^ n24) >= 0 ? n24 >> 1 : -n24 >> 1;
        int n29 = n10 + (n26 + n27) / n24;
        int n30 = n13 - n28;
        int n31 = n14 - n29;
        int n32 = n15 - n28;
        int n33 = n16 - n29;
        int n34 = n12 - n10;
        int n35 = -(n11 - n9);
        int n36 = n30 * n34 + n31 * n35;
        int n37 = n32 * n34 + n33 * n35;
        segmentIntersectionResult.mIntersectionResult = n36 >= 0 ? (n37 <= 0 ? (byte)2 : (byte)3) : (byte)3;
        long l = (n28 << 16) - n;
        long l2 = (n29 << 16) - n2;
        long l3 = l * l >> 16;
        long l4 = l2 * l2 >> 16;
        segmentIntersectionResult.mOffset = (int)PMMath.SQRT(l3 + l4);
    }

    public void draw(Vector2 vector2) {
        PMCanvas.PMGraphics_setColor(0xFF0000);
        for (int i = 1; i < this.mPointX.length - 1; ++i) {
            int n = this.mPointX[i];
            int n2 = this.mPointY[i];
            int n3 = this.mPointX[i + 1];
            int n4 = this.mPointY[i + 1];
            int n5 = (n >> 16) - vector2.mX;
            int n6 = (n2 >> 16) - vector2.mY;
            int n7 = (n3 >> 16) - vector2.mX;
            int n8 = (n4 >> 16) - vector2.mY;
            PMCanvas.PMGraphics_drawLine(n5, n6, n7, n8);
        }
    }
}

