/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.game.enemies.Enemy5Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy5State;
import dk.progressivemedia.skeleton.game.enemies.Enemy5StateDieing;
import dk.progressivemedia.skeleton.game.enemies.Enemy5StateFlying;
import dk.progressivemedia.skeleton.game.enemies.Enemy5View;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy5StateController {
    private Enemy5Data mData;
    private Enemy5View mView;
    public static final int STATE_FLYING = 0;
    public static final int STATE_DIEING = 1;
    private int mActiveStateID;
    private Enemy5State mActiveState;
    private Enemy5StateFlying mStateFlying;
    private Enemy5StateDieing mStateDieing;

    public Enemy5StateController(Enemy5Data enemy5Data, Enemy5View enemy5View) {
        this.mData = enemy5Data;
        this.mView = enemy5View;
        this.mStateFlying = new Enemy5StateFlying(enemy5Data, enemy5View, this);
        this.mStateDieing = new Enemy5StateDieing(enemy5Data, enemy5View, this);
        this.mActiveStateID = 0;
        this.mActiveState = this.mStateFlying;
        this.mActiveState.enter();
    }

    public void update() {
        Vector2 vector2 = this.mData.getPositionRef();
        this.mData.setPositionPrev(vector2);
        this.mActiveState.update();
    }

    public void requestStateChange(int n) {
        this.mActiveState.exit();
        this.mActiveStateID = n;
        switch (n) {
            case 0: {
                this.mActiveState = this.mStateFlying;
                break;
            }
            case 1: {
                this.mActiveState = this.mStateDieing;
            }
        }
        this.mActiveState.enter();
    }
}

