/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.util.PMTrigonometry;

public class Interpolation {
    public static final int TYPE_LINEAR = 0;
    public static final int TYPE_SMOOTH_START = 1;
    public static final int TYPE_SMOOTH_END = 2;
    public static final int TYPE_SMOOTH_MIDDLE = 3;
    public static final int TYPE_SMOOTH_START_AND_END = 4;

    public static int interpolate(int n, int n2, int n3, int n4, int n5) {
        if (n4 >= n5) {
            return n3;
        }
        if (n4 <= 0) {
            return n2;
        }
        switch (n) {
            case 0: {
                return n2 + (n3 - n2) * n4 / n5;
            }
            case 2: {
                int n6 = 90 * n4 / n5;
                return n2 + ((n3 - n2) * PMTrigonometry.sin(n6) >> 16);
            }
            case 1: {
                int n7 = 90 * n4 / n5;
                return n2 + ((n3 - n2) * (65536 - PMTrigonometry.cos(n7)) >> 16);
            }
            case 3: {
                int n8 = 180 * n4 / n5;
                if (n8 < 90) {
                    return n2 + ((n3 - n2) * (PMTrigonometry.sin(n8) / 2) >> 16);
                }
                return n2 + ((n3 - n2) * (65536 - PMTrigonometry.sin(n8) / 2) >> 16);
            }
            case 4: {
                int n9 = 90 + 180 * n4 / n5;
                return n2 + ((n3 - n2) * (32768 - PMTrigonometry.sin(n9) / 2) >> 16);
            }
        }
        PMDebug.println(1, "Interpolation.interpolate() failed! Unknown type: {0}", n);
        return -1;
    }
}

