/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.io.PMGameData;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMTimer;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.rflib.util.PMTrigonometry;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.SaveGameHelper;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.game.PauseMenu;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.j2memenus.StateAudioOnOff;
import dk.progressivemedia.skeleton.j2memenus.StateLanguageSelect;

public class Main {
    public static int loadBarWidth = 0;
    public static int counter = 0;
    public static String loadingStr = null;

    public static void init() {
        PMLocale.set(PMLocale.getDefault());
        PMTimer.setTick(0L);
        Main.preMenuInit();
        SaveGameHelper.init();
        PMAudio.initAudio(43);
        PMAudio.loadRegOnly(19, "TitleMusic", 8, 1803492);
        PMAudio.loadRegOnly(20, "StoryMusic", 8, 516178);
        PMAudio.loadRegOnly(21, "World1Music", 8, 1235068);
        PMAudio.loadRegOnly(18, "World2Music", 8, 1479156);
        PMAudio.loadRegOnly(15, "World3Music", 8, 1281879);
        PMAudio.loadRegOnly(16, "World4Music", 8, 1382190);
        PMAudio.loadRegOnly(17, "World5Music", 8, 1382190);
        PMAudio.loadRegOnly(26, "sfxPlayerJump", 6, 9498);
        PMAudio.loadRegOnly(25, "sfxPlayerJumpTotem1", 6, 11260);
        PMAudio.loadRegOnly(22, "sfxPlayerJumpTotem2", 6, 10854);
        PMAudio.loadRegOnly(23, "sfxPlayerJumpTotem3", 6, 11122);
        PMAudio.loadRegOnly(24, "sfxLandOnMonster", 6, 3872);
        PMAudio.loadRegOnly(0, "sfxPlayerLoseHealthMonster", 6, 4940);
        PMAudio.loadRegOnly(5, "sfxPlayerLoseLife", 6, 11114);
        PMAudio.loadRegOnly(6, "sfxPlayerGainLife", 6, 13744);
        PMAudio.loadRegOnly(7, "sfxPlayerGainSilverCoin", 6, 12926);
        PMAudio.loadRegOnly(4, "sfxPlayerGainGoldCoin", 6, 39090);
        PMAudio.loadRegOnly(1, "sfxPlayerGainKey", 6, 24190);
        PMAudio.loadRegOnly(2, "sfxPlayerOpenChest", 6, 21036);
        PMAudio.loadRegOnly(3, "sfxPlayerGainHealth", 6, 6892);
        PMAudio.loadRegOnly(12, "sfxPlayerCheckpoint", 6, 28366);
        PMAudio.loadRegOnly(13, "sfxPlayerExit1", 6, 60406);
        PMAudio.loadRegOnly(14, "sfxPlayerTotemTransition", 6, 11358);
        PMAudio.loadRegOnly(11, "sfxEnemyJump", 6, 4988);
        PMAudio.loadRegOnly(8, "sfxEnemyShoot", 6, 6204);
        PMAudio.loadRegOnly(9, "sfxEnemySpikes", 6, 19786);
        PMAudio.loadRegOnly(10, "sfxPauseMenuOpen", 6, 23404);
        PMAudio.loadRegOnly(27, "sfxPauseMenuClose", 6, 27788);
        PMAudio.loadRegOnly(33, "sfxPauseMenuSelectItem", 6, 2618);
        PMAudio.loadRegOnly(34, "sfxLevelSelectFootsteps", 6, 14990);
        PMAudio.loadRegOnly(35, "sfxLevelSelectStartLevel", 6, 23084);
        PMAudio.loadRegOnly(32, "sfxPushStartButton", 6, 2758);
        PMAudio.loadRegOnly(29, "sfxLevelSelectCannotWalk", 6, 7500);
        PMAudio.loadRegOnly(30, "sfxCutsceneSkip", 6, 5828);
        PMAudio.loadRegOnly(31, "sfxCutsceneChangePicture", 6, 2258);
        PMAudio.loadRegOnly(40, "sfxSceneSkip", 6, 2756);
        PMAudio.loadRegOnly(41, "sfxWorldChange1", 6, 7220);
        PMAudio.loadRegOnly(42, "sfxMainMenuDelete", 6, 10428);
        PMAudio.loadRegOnly(39, "sfxMainMenuNew", 6, 980);
        PMAudio.loadRegOnly(36, "sfxMainMenuLoad", 6, 11812);
        PMAudio.loadRegOnly(37, "sfxDanger2", 6, 9964);
        PMAudio.loadRegOnly(38, "sfxDanger3Rumble", 6, 59238);
        PMAudio.loadRegOnly(28, "sfxDanger3Hit", 6, 48464);
        MusicBuffer.init();
        Touch.init();
        PMStateManager.set(8, 0);
    }

    public static void preExit() {
        Dialog.deinit();
    }

    public static void preFlush() {
        SoundBuffer.update();
        MusicBuffer.update();
        Touch.clearReleased();
    }

    public static void toggleAnalogControls() {
        if (GameState.mIsSingleTouch) {
            GameState.mAnalogTouch = GameState.mAnalogTouch == 0 ? (byte)1 : 0;
            Touch.setControlOverlay();
        }
    }

    public static void preMenuInit() {
        PMRandom.init(0);
        PMFile.initBFC();
        GameState.mAnalogTouch = 0;
        GameState.mIsSingleTouch = true;
        PMGameData.load();
        PMImageManager.init();
        PMTrigonometry.init();
        PMFont.init(3);
        PMFont.load(0, (short)-17682, (short)30525, (short)-13740, (byte)14, (short)-31608, -1, -2, 0);
        PMFont.load(1, (short)11295, (short)-7732, (short)23717, (byte)8, (short)4729, -1, -2, 0);
        PMFont.load(2, (short)-32074, (short)20325, (short)-3572, (byte)8, (short)-17200, -1, -2, 0);
        InputProxy.init();
    }

    public static void externalEvent() {
    }

    public static void drawExternal() {
    }

    public static void drawIncorrectRotation() {
    }

    public static void drawLoading() {
        PMCanvas.PMGraphics_setColor(0, 0, 0);
        ++loadBarWidth;
        if (counter % 10 == 0) {
            PMCanvas.PMGraphics_fillRect(0, 0, 640, 360);
            if (loadBarWidth > 640) {
                loadBarWidth = 0;
            }
            PMCanvas.PMGraphics_setColor(255, 255, 255);
            PMCanvas.PMGraphics_fillRect(0, 348, loadBarWidth, 6);
            PMCanvas.PMGraphics_setColor(208, 139, 25);
            PMCanvas.PMGraphics_fillRect(0, 90, 640, 180);
            PMCanvas.PMGraphics_setColor(116, 79, 19);
            PMCanvas.PMGraphics_drawLine(0, 90, 640, 90);
            PMCanvas.PMGraphics_drawLine(0, 270, 640, 270);
            int n = PMMath.DIV(0x2800000, 0x220000);
            n = (n >> 16) + 1;
            boolean bl = PMFile.loadScreen;
            PMFile.loadScreen = false;
            for (int i = 0; i < n; ++i) {
                int n2 = 0 + i * 34;
                PMImageManager.draw(507, n2, 104);
                PMImageManager.draw(511, n2, 256);
            }
            if (loadingStr == null) {
                loadingStr = PMText.getText(196608);
            }
            PMCanvas.PMGraphics_drawStringBox(0, 153, 640, 360, loadingStr, 0, 0, 99, true);
            PMFile.loadScreen = bl;
        }
        ++counter;
        PMCanvas.PMInput_reset();
        PMCanvas.PMGraphics_flush();
    }

    public static void touchDown(int n, int n2, int n3, int n4) {
        Touch.mScreenPressed = true;
        for (int i = 0; i < PMCanvas.PMTouch_overlay.length; i += 7) {
            if (PMCanvas.PMTouch_overlay[i + 5] != n || PMCanvas.PMTouch_overlay[i + 0] != 2) continue;
            int n5 = PMCanvas.PMTouch_overlay[i + 5];
            if (n5 == 1) {
                Touch.setPushPos(n2, n3);
                continue;
            }
            Touch.touchDown(n, n2, n3);
        }
        PauseMenu.touchDown(n2, n3);
        if (PMStateManager.currentState == 8) {
            StateLanguageSelect.touchDown(n2, n3);
        }
        if (PMStateManager.currentState == 7) {
            StateAudioOnOff.touchDown(n2, n3);
        }
    }

    public static void touchMove(int n, int n2, int n3, int n4) {
        Touch.mScreenPressed = false;
        for (int i = 0; i < PMCanvas.PMTouch_overlay.length; i += 7) {
            if (PMCanvas.PMTouch_overlay[i + 5] != n || PMCanvas.PMTouch_overlay[i + 0] != 2) continue;
            int n5 = PMCanvas.PMTouch_overlay[i + 5];
            if (n5 == 1 && GameState.mAnalogTouch == 1) {
                Touch.setMovePos(n2, n3);
                continue;
            }
            Touch.touchMove(n, n2, n3);
        }
        PauseMenu.touchMove(n2, n3);
    }

    public static void touchUp(int n, int n2, int n3, int n4) {
        Touch.mScreenPressed = false;
        for (int i = 0; i < PMCanvas.PMTouch_overlay.length; i += 7) {
            if (PMCanvas.PMTouch_overlay[i + 5] != n || PMCanvas.PMTouch_overlay[i + 0] != 2) continue;
            int n5 = PMCanvas.PMTouch_overlay[i + 5];
            if (n5 == 1) {
                Touch.setPushPos(-1, -1);
                Touch.setMovePos(-1, -1);
                continue;
            }
            Touch.touchUp(n, n2, n3);
        }
        PauseMenu.touchUp(n2, n3);
        if (PMStateManager.currentState == 8) {
            StateLanguageSelect.touchUp(n2, n3);
        }
        if (PMStateManager.currentState == 7) {
            StateAudioOnOff.touchUp(n2, n3);
        }
    }

    public static void Complete_Level() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.runEndLevelCode();
        }
    }

    public static void Gain_Goldcoin() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.debugGainGoldcoin();
        }
    }

    public static void Gain_Chest() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.debugGainChest();
        }
    }

    public static void nextScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.nextScriptEvent();
        }
    }

    public static void prevScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.prevScriptEvent();
        }
    }

    public static void runScriptEvent() {
        if (StateGame.mWorld != null) {
            StateGame.mWorld.runScriptEvent();
        }
    }
}

