/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Camera;
import dk.progressivemedia.skeleton.game.GameTileMapping;
import dk.progressivemedia.skeleton.game.PlatformData;
import dk.progressivemedia.skeleton.game.PlatformView;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class PlatformViewMovable
extends PlatformView {
    private Movie mAnimLeftWings;
    private Movie mAnimRightWings;
    private int mLength;
    private byte[] mTilemapSlippery;

    public PlatformViewMovable(PlatformData platformData) {
        this.mData = platformData;
        this.mAnimLeftWings = Movie.load((short)17270);
        this.mAnimRightWings = Movie.load((short)-27028);
        this.mAnimLeftWings.loadGfx();
        this.mAnimLeftWings.gotoTick(0);
        this.mAnimRightWings.loadGfx();
        this.mAnimRightWings.gotoTick(0);
        Surface surface = this.mData.getSurface();
        switch (this.mData.getSize()) {
            case 0: {
                this.mLength = 2;
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new byte[2];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = 1;
                break;
            }
            case 1: {
                this.mLength = 3;
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new byte[3];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[2] = 1;
                break;
            }
            case 2: {
                this.mLength = 4;
                if (!surface.getSlippery()) break;
                this.mTilemapSlippery = new byte[4];
                this.mTilemapSlippery[0] = 0;
                this.mTilemapSlippery[1] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[2] = this.getRandomSlipperyMiddleTile();
                this.mTilemapSlippery[3] = 1;
            }
        }
    }

    public void update() {
        this.mAnimLeftWings.update(Timer.mDt);
        this.mAnimRightWings.update(Timer.mDt);
    }

    public void draw(Vector2 vector2) {
        int n;
        int n2;
        long l;
        long l2;
        int n3;
        long l3;
        Surface surface = this.mData.getSurface();
        long l4 = (long)surface.getMinX() * 5L >> 1;
        int n4 = (int)((l4 >> 16) - ((l3 = (long)vector2.mX * 5L >> 1) >> 16));
        if (Camera.isInside(n4, n3 = (int)(((l2 = (long)surface.getFirstY() * 5L >> 1) >> 16) - ((l = (long)vector2.mY * 5L >> 1) >> 16)), n2 = 40 * this.mLength, n = 40)) {
            int n5;
            int n6 = n4 + 20;
            int n7 = n3 + 20;
            this.mAnimLeftWings.draw(n6, n7);
            for (n5 = 0; n5 < this.mLength - 2; ++n5) {
                PMImageManager.draw(GameTileMapping.MOVEABLE_PLATFORM_TILES[Defines.mWorldLookup[GameState.mLevel]][0], n6 += 40, n3);
            }
            this.mAnimRightWings.draw(n6 += 40, n7);
            n6 = n4 + 20;
            if (this.mTilemapSlippery != null) {
                for (n5 = 0; n5 < this.mTilemapSlippery.length; ++n5) {
                    PMImageManager.draw(GameTileMapping.SLIPPERY_TILES[Defines.mWorldLookup[GameState.mLevel]][this.mTilemapSlippery[n5]], n6, n3);
                    n6 += 40;
                }
            }
        }
    }

    private byte getRandomSlipperyMiddleTile() {
        int n = PMRandom.get16() * 4 >> 16;
        return (byte)(n + 2);
    }
}

