/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.enemies;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.Surface;
import dk.progressivemedia.skeleton.game.SurfaceIntersectionResult;
import dk.progressivemedia.skeleton.game.World;
import dk.progressivemedia.skeleton.game.enemies.Enemy3Data;
import dk.progressivemedia.skeleton.game.enemies.Enemy3State;
import dk.progressivemedia.skeleton.game.enemies.Enemy3StateController;
import dk.progressivemedia.skeleton.game.enemies.Enemy3View;
import dk.progressivemedia.skeleton.math.AABB;
import dk.progressivemedia.skeleton.math.Vector2;

public class Enemy3StateFalling
extends Enemy3State {
    private Vector2 mNextPos;
    private SurfaceIntersectionResult mIntersectionRes;
    private AABB mTileAABB;

    public Enemy3StateFalling(Enemy3Data enemy3Data, Enemy3View enemy3View, Enemy3StateController enemy3StateController) {
        this.mData = enemy3Data;
        this.mView = enemy3View;
        this.mController = enemy3StateController;
        this.mNextPos = new Vector2();
        this.mIntersectionRes = new SurfaceIntersectionResult();
        this.mTileAABB = new AABB();
    }

    public void enter() {
        this.mView.setAnimState(0);
    }

    public void exit() {
    }

    public void update() {
        Vector2 vector2 = this.mData.getVelocityRef();
        Vector2 vector22 = this.mData.getPositionRef();
        Vector2 vector23 = this.mData.getDimensionRef();
        vector2.mY += Timer.mFeatureWorldGravity;
        if (vector2.mY > Timer.mFeatureWorldGravityMax) {
            vector2.mY = Timer.mFeatureWorldGravityMax;
        }
        this.mNextPos.set(vector22);
        this.mNextPos.add(vector2);
        World world = this.mData.getWorldRef();
        world.intersectionTest(vector22.mX, vector22.mY, vector2.mX, vector2.mY, vector23.mX >> 1, this.mIntersectionRes);
        if (this.mIntersectionRes.mSurface != null) {
            this.mData.setSurface(this.mIntersectionRes.mSurface, this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset);
            Surface surface = this.mIntersectionRes.mSurface;
            surface.getSurfacePosition(this.mIntersectionRes.mSegmentIndex, this.mIntersectionRes.mLengthOffset, vector23.mX >> 1, vector22);
            this.mController.requestStateChange(1);
        } else {
            boolean bl = false;
            boolean bl2 = false;
            int n = this.mNextPos.mX - (vector23.mX >> 1);
            int n2 = this.mNextPos.mY;
            if (world.collisionTest(n, n2, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMaxX + (vector23.mX >> 1);
                vector2.mX = 0;
                bl = true;
            }
            if (!bl && world.collisionTest(n = this.mNextPos.mX - (vector23.mX >> 1), n2 = this.mNextPos.mY - vector23.mY, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMaxX + (vector23.mX >> 1);
                vector2.mX = 0;
                bl = true;
            }
            if (world.collisionTest(n = this.mNextPos.mX + (vector23.mX >> 1), n2 = this.mNextPos.mY, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMinX - (vector23.mX >> 1);
                vector2.mX = 0;
                bl2 = true;
            }
            if (!bl2 && world.collisionTest(n = this.mNextPos.mX + (vector23.mX >> 1), n2 = this.mNextPos.mY - vector23.mY, this.mTileAABB)) {
                this.mNextPos.mX = this.mTileAABB.mMinX - (vector23.mX >> 1);
                vector2.mX = 0;
                bl2 = true;
            }
            vector22.set(this.mNextPos);
        }
    }
}

