/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineState;
import dk.progressivemedia.skeleton.game.pixeline.PixelineStateController;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewController;
import dk.progressivemedia.skeleton.math.Vector2;

public class PixelineStateIdle
extends PixelineState {
    public PixelineStateIdle(PixelineData pixelineData, PixelineViewController pixelineViewController, PixelineStateController pixelineStateController) {
        this.mData = pixelineData;
        this.mView = pixelineViewController;
        this.mController = pixelineStateController;
    }

    public void enter() {
        Vector2 vector2 = this.mData.getVelocityRef();
        vector2.mX = 0;
        vector2.mY = 0;
        this.mView.setAnimState(0, false);
    }

    public void exit() {
    }

    public void update() {
        if (PMCanvas.PMInput_isPressed(1) || PMCanvas.PMInput_isPressed(128) || PMCanvas.PMInput_isPressed(256) || this.mData.getJumpButtonPressed() || this.mData.getJumpButtonDown()) {
            Vector2 vector2 = this.mData.getVelocityRef();
            vector2.mY = this.mData.getJumpVelocity();
            this.mController.requestStateChange(3);
            switch (this.mData.getTotemState()) {
                case 0: {
                    SoundBuffer.play(26, 100);
                    break;
                }
                case 1: {
                    SoundBuffer.play(25, 100);
                    break;
                }
                case 2: {
                    SoundBuffer.play(22, 100);
                    break;
                }
                case 3: {
                    SoundBuffer.play(23, 100);
                }
            }
        } else if (InputProxy.isHeldLeft()) {
            this.mData.setDirection(0);
            this.mController.requestStateChange(1);
        } else if (InputProxy.isHeldRight()) {
            this.mData.setDirection(1);
            this.mController.requestStateChange(1);
        }
    }
}

