/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game.pixeline;

import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.game.pixeline.PixelineView;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewPixeline;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewTotem1;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewTotem2;
import dk.progressivemedia.skeleton.game.pixeline.PixelineViewTotem3;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class PixelineViewController {
    private PixelineData mData;
    private PixelineView mActiveView;
    private PixelineViewPixeline mViewPixeline;
    private PixelineViewTotem1 mViewTotem1;
    private PixelineViewTotem2 mViewTotem2;
    private PixelineViewTotem3 mViewTotem3;
    private Movie mAnimTotemTransition;
    private Vector2 mTransitionPosition;
    private boolean mTransitionActive;
    private boolean mBlinkActive;
    private boolean mBlinkDraw;
    private int mBlinkTime;
    private int mBlinkTimer;

    public PixelineViewController(PixelineData pixelineData) {
        this.mData = pixelineData;
        this.mViewPixeline = new PixelineViewPixeline(pixelineData);
        this.mViewTotem1 = new PixelineViewTotem1(pixelineData);
        this.mViewTotem2 = new PixelineViewTotem2(pixelineData);
        this.mViewTotem3 = new PixelineViewTotem3(pixelineData);
        this.mActiveView = this.mViewPixeline;
        this.mActiveView.enter();
        this.mAnimTotemTransition = Movie.load((short)-5759);
        this.mAnimTotemTransition.loadGfx();
        this.mTransitionPosition = new Vector2();
        this.mTransitionActive = false;
        this.mBlinkActive = false;
        this.mBlinkDraw = true;
        this.mBlinkTime = 0;
        this.mBlinkTimer = 0;
    }

    public void update() {
        if (this.mTransitionActive) {
            this.mAnimTotemTransition.update(Timer.mDt);
            if (this.mAnimTotemTransition.isDone()) {
                this.mTransitionActive = false;
            }
        }
        if (this.mBlinkActive) {
            this.mBlinkTimer -= Timer.mDt;
            if (this.mBlinkTimer <= 0) {
                this.mBlinkDraw = !this.mBlinkDraw;
                this.mBlinkTimer = this.mBlinkTime;
            }
        }
        this.mActiveView.update();
    }

    public void draw(Vector2 vector2) {
        if (this.mBlinkDraw) {
            this.mActiveView.draw(vector2);
        }
        if (this.mTransitionActive) {
            int n = (this.mTransitionPosition.mX >> 16) - (vector2.mX >> 16);
            int n2 = (this.mTransitionPosition.mY >> 16) - (vector2.mY >> 16);
            n = n * 5 >> 1;
            n2 = n2 * 5 >> 1;
            this.mAnimTotemTransition.draw(n, n2);
        }
    }

    public void setAnimState(int n, boolean bl) {
        this.mActiveView.setAnimState(n, bl);
    }

    public int getAnimTick() {
        return this.mActiveView.getAnimTick();
    }

    public boolean isAnimDone(int n) {
        return this.mActiveView.isAnimDone(n);
    }

    public void totemTransition(int n, boolean bl) {
        if (bl) {
            this.mAnimTotemTransition.gotoTick(0);
            this.mTransitionActive = true;
            this.mTransitionPosition.set(this.mData.getPositionRef());
        }
        this.mActiveView.exit();
        switch (n) {
            case 0: {
                this.mActiveView = this.mViewPixeline;
                break;
            }
            case 1: {
                this.mActiveView = this.mViewTotem1;
                break;
            }
            case 2: {
                this.mActiveView = this.mViewTotem2;
                break;
            }
            case 3: {
                this.mActiveView = this.mViewTotem3;
            }
        }
        this.mActiveView.enter();
    }

    public void setBlinkActive(boolean bl, int n) {
        this.mBlinkActive = bl;
        this.mBlinkDraw = true;
        this.mBlinkTimer = this.mBlinkTime = n;
    }
}

