/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.SweepTestResult;
import dk.progressivemedia.skeleton.math.Vector2;

public class SweepTest {
    private static Vector2 mSlabXNormal = new Vector2(65536, 0);
    private static Vector2 mSlabYNormal = new Vector2(0, 65536);
    private static Vector2 mTempVec = new Vector2();

    private static boolean PointSlabSweep(int n, int n2, int n3, int n4, Vector2 vector2, SweepTestResult sweepTestResult) {
        Vector2 vector22;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        boolean bl;
        int n10 = n - n3;
        int n11 = n2 - n3;
        boolean bl2 = bl = n10 < 0 && n11 > 0;
        if (bl) {
            n9 = MathUtil.abs(n10) < MathUtil.abs(n11) ? n10 : n11;
            mTempVec.set(vector2);
            mTempVec.scale(n9);
            long l = mTempVec.lengthSqr();
            if (l < sweepTestResult.mMTDSqr || sweepTestResult.mMTDSqr < 0L) {
                Vector2 vector23 = sweepTestResult.mMTD;
                vector23.set(mTempVec);
                sweepTestResult.mMTDSqr = l;
            }
        }
        if (MathUtil.abs(n4) < 8192) {
            return bl;
        }
        n9 = PMMath.DIV(n - n3, n4);
        if (n9 < (n8 = PMMath.DIV(n2 - n3, n4))) {
            n7 = n9;
            n6 = n8;
            n5 = -65536;
        } else {
            n7 = n8;
            n6 = n9;
            n5 = 65536;
        }
        if (n7 > sweepTestResult.mTimeFirst) {
            sweepTestResult.mTimeFirst = n7;
            mTempVec.set(vector2);
            mTempVec.scale(n5);
            vector22 = sweepTestResult.mNormalFirst;
            vector22.set(mTempVec);
            sweepTestResult.mCollision = true;
        }
        if (n6 < sweepTestResult.mTimeLast) {
            sweepTestResult.mTimeLast = n6;
            mTempVec.set(vector2);
            mTempVec.scale(-n5);
            vector22 = sweepTestResult.mNormalLast;
            vector22.set(mTempVec);
        }
        return sweepTestResult.mTimeLast >= sweepTestResult.mTimeFirst;
    }

    private static boolean PointBoxSweep(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, SweepTestResult sweepTestResult) {
        if (!SweepTest.PointSlabSweep(n, n3, n5, n7, mSlabXNormal, sweepTestResult)) {
            return false;
        }
        return SweepTest.PointSlabSweep(n2, n4, n6, n8, mSlabYNormal, sweepTestResult);
    }

    public static boolean BoxBoxSweep(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, SweepTestResult sweepTestResult) {
        sweepTestResult.reset();
        int n11 = n7 - n5 >> 1;
        int n12 = n8 - n6 >> 1;
        int n13 = n7 + n5 >> 1;
        int n14 = n8 + n6 >> 1;
        int n15 = n - n11;
        int n16 = n2 - n12;
        int n17 = n3 + n11;
        int n18 = n4 + n12;
        boolean bl = SweepTest.PointBoxSweep(n15, n16, n17, n18, n13, n14, n9, n10, sweepTestResult);
        if (!bl) {
            return false;
        }
        if (sweepTestResult.mCollision) {
            if (sweepTestResult.mTimeFirst < 0 || sweepTestResult.mTimeFirst > 65536) {
                return false;
            }
            sweepTestResult.mMTD.set(0, 0);
        } else {
            sweepTestResult.mTimeFirst = 0;
            sweepTestResult.mNormalFirst.set(sweepTestResult.mMTD);
            sweepTestResult.mNormalFirst.normalize();
        }
        return true;
    }
}

