/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.math;

import dk.progressivemedia.rflib.util.PMMath;

public class Vector2 {
    public int mX;
    public int mY;

    public Vector2() {
        this.mX = 0;
        this.mY = 0;
    }

    public Vector2(Vector2 vector2) {
        this.mX = vector2.mX;
        this.mY = vector2.mY;
    }

    public Vector2(int n, int n2) {
        this.mX = n;
        this.mY = n2;
    }

    public void set(Vector2 vector2) {
        this.mX = vector2.mX;
        this.mY = vector2.mY;
    }

    public void set(int n, int n2) {
        this.mX = n;
        this.mY = n2;
    }

    public void add(Vector2 vector2) {
        this.mX += vector2.mX;
        this.mY += vector2.mY;
    }

    public void add(int n, int n2) {
        this.mX += n;
        this.mY += n2;
    }

    public void sub(Vector2 vector2) {
        this.mX -= vector2.mX;
        this.mY -= vector2.mY;
    }

    public void sub(int n, int n2) {
        this.mX -= n;
        this.mY -= n2;
    }

    public void mul(Vector2 vector2) {
        this.mX = PMMath.MUL(this.mX, vector2.mX);
        this.mY = PMMath.MUL(this.mY, vector2.mY);
    }

    public void scale(int n) {
        this.mX = PMMath.MUL(this.mX, n);
        this.mY = PMMath.MUL(this.mY, n);
    }

    public long lengthSqr() {
        long l = (long)this.mX * (long)this.mX >> 16;
        long l2 = (long)this.mY * (long)this.mY >> 16;
        return l + l2;
    }

    public int length() {
        long l = (long)this.mX * (long)this.mX >> 16;
        long l2 = (long)this.mY * (long)this.mY >> 16;
        return (int)PMMath.SQRT(l + l2);
    }

    public int normalize() {
        int n = this.length();
        this.mX = PMMath.DIV(this.mX, n);
        this.mY = PMMath.DIV(this.mY, n);
        return n;
    }

    public int dot(Vector2 vector2) {
        return PMMath.MUL(this.mX, vector2.mX) + PMMath.MUL(this.mY, vector2.mY);
    }

    public static Vector2 add(Vector2 vector2, Vector2 vector22) {
        return new Vector2(vector2.mX + vector22.mX, vector2.mY + vector22.mY);
    }

    public static Vector2 sub(Vector2 vector2, Vector2 vector22) {
        return new Vector2(vector2.mX - vector22.mX, vector2.mY - vector22.mY);
    }

    public static Vector2 mul(Vector2 vector2, Vector2 vector22) {
        return new Vector2(PMMath.MUL(vector2.mX, vector22.mX), PMMath.MUL(vector2.mY, vector22.mY));
    }

    public static int dot(Vector2 vector2, Vector2 vector22) {
        return PMMath.MUL(vector2.mX, vector22.mX) + PMMath.MUL(vector2.mY, vector22.mY);
    }
}

