/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMText;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.TransitionEffect;

public class StateGameover {
    private static final int STATE_TRANSITION_IN = 0;
    private static final int STATE_FALLING = 1;
    private static final int STATE_GAMEOVER = 2;
    private static final int STATE_TRANSITION_OUT = 3;
    private static int mState;
    private static int mGameoverWidth;
    private static String mGameoverText;
    private static int mGameoverDisplayTimer;
    private static int mFallingVelocity;
    private static int mPixelinePosY;
    private static final int FALLING_DISTANCE = 225;

    public static void init(int n) {
        PMFile.loadScreen = true;
        mFallingVelocity = 455360;
        mPixelinePosY = -6356992;
        mGameoverText = PMText.getText(262145);
        mGameoverWidth = PMFont.stringWidth(mGameoverText, 0);
        mGameoverDisplayTimer = 3000;
        mState = 0;
        TransitionEffect.init(false);
        SoundBuffer.init();
        GameState.resetState();
        Timer.initTimer();
        Dialog.init(1, 0);
        PMFile.loadScreen = false;
    }

    public static void deinit() {
    }

    public static void update() {
        Timer.updateTimer();
        int n = 0;
        n = (mFallingVelocity << 6) / 33 * Timer.mDt >> 6;
        switch (mState) {
            case 0: {
                if (TransitionEffect.update()) {
                    mState = 1;
                }
                StateGameover.draw();
                TransitionEffect.draw();
                break;
            }
            case 1: {
                if ((mPixelinePosY += n) >> 16 > 225) {
                    mState = 2;
                }
                StateGameover.draw();
                break;
            }
            case 2: {
                if (mGameoverDisplayTimer > 0 && (mGameoverDisplayTimer -= Timer.mDt) <= 0) {
                    TransitionEffect.init(true);
                    mState = 3;
                }
                StateGameover.draw();
                break;
            }
            case 3: {
                if (TransitionEffect.update()) {
                    PMStateManager.set(1, 1);
                }
                StateGameover.draw();
                TransitionEffect.draw();
            }
        }
        PMSystem.nextFrame();
    }

    public static void draw() {
        PMCanvas.PMGraphics_setColor(0);
        PMCanvas.PMGraphics_fillRect(0, 0, 640, 360);
        PMImageManager.draw(567, 320, (mPixelinePosY >> 16) + 48);
        int n = mPixelinePosY - 0x5A0000 >> 16;
        PMCanvas.PMGraphics_drawString(320 - (mGameoverWidth >> 1), n - 33, mGameoverText, 0);
    }
}

