/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.debug.PMDebug;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMRandom;
import dk.progressivemedia.skeleton.Defines;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.math.Vector2;
import dk.progressivemedia.skeleton.menu.LevelSelectionCamera;
import dk.progressivemedia.skeleton.menu.LevelSelectionHUD;
import dk.progressivemedia.skeleton.menu.LevelSelectionScriptHelper;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class StateLevelSelection {
    private static final int STATE_TRANSITION_IN = 0;
    private static final int STATE_ENTER_PAN = 1;
    private static final int STATE_HUD_ENTERING = 2;
    private static final int STATE_LEVEL_SELECTION = 3;
    private static final int STATE_PIXELINE_MOVING = 4;
    private static final int STATE_TRANSITION_OUT_GAME = 5;
    private static final int STATE_TRANSITION_OUT_SLOT = 6;
    private static int mState;
    private static byte[][] mTilemapBack;
    private static byte[][] mTilemapFront;
    private static int mTilemapBackWidth;
    private static int mTilemapBackHeight;
    private static LevelSelectionCamera mCamera;
    private static int mPanDistance;
    private static boolean mPanningSkipped;
    private static LevelSelectionHUD mHUD;
    private static int mBlinkTimer;
    private static int mEyesClosedTimer;
    private static final int SQUID_EYES_X = 681;
    private static final int SQUID_EYES_Y = 81;
    private static final int HIPPO_EYES_X = 922;
    private static final int HIPPO_EYES_Y = 98;
    private static int[] mLevelPositionsX;
    private static int[] mLevelPositionsY;
    private static int mWalkingEffectID;
    private static boolean mMovementDenied;
    private static boolean mPixelineRight;
    private static Vector2 mPixelinePos;
    private static Vector2 mPixelineMovement;
    private static Vector2 mPixelineOffset;
    private static Movie mRunAnim;
    private static int mInterpPixeline;
    private static int mEnterParam;
    private static boolean mSuppresHUD;
    private static int mHUDAlpha;

    public static void init(int n) {
        Main.counter = 0;
        PMFile.loadScreen = true;
        Main.drawLoading();
        PMAudio.deInitAudio();
        MusicBuffer.play(19);
        MusicBuffer.update();
        mEnterParam = n;
        StateLevelSelection.loadTilemapBack();
        StateLevelSelection.loadTilemapFront();
        mHUD = new LevelSelectionHUD();
        mPixelinePos.set(mLevelPositionsX[GameState.mLevel] << 16, mLevelPositionsY[GameState.mLevel] << 16);
        mPixelineMovement.set(0, 0);
        mPixelineOffset.set(0, 0);
        mWalkingEffectID = -1;
        mMovementDenied = false;
        mPixelineRight = true;
        mInterpPixeline = 0;
        mBlinkTimer = (PMRandom.get16() * 2000 >> 16) + 2000;
        mState = 0;
        TransitionEffect.init(false);
        SoundBuffer.init();
        LevelSelectionScriptHelper.init();
        mRunAnim = Movie.load((short)-2826);
        mRunAnim.loadGfx();
        mSuppresHUD = true;
        mHUDAlpha = 0;
        Timer.initTimer();
        Dialog.init(1, 0);
        if ((mEnterParam == 0 || mEnterParam == 7) && Defines.mWorldLookup[GameState.mLevel] < 4) {
            int n2 = 0x400000 * mTilemapBackWidth - 0x800000;
            int n3 = StateLevelSelection.mPixelinePos.mY;
            mCamera = new LevelSelectionCamera(0x400000 * mTilemapBackWidth, 0x400000 * mTilemapBackHeight - 0x200000, n2, n3);
            mPanDistance = StateLevelSelection.mPixelinePos.mX - n2;
            mPanningSkipped = false;
        } else {
            mCamera = new LevelSelectionCamera(0x400000 * mTilemapBackWidth, 0x400000 * mTilemapBackHeight - 0x200000, StateLevelSelection.mPixelinePos.mX, StateLevelSelection.mPixelinePos.mY);
        }
        PMImageManager.load(988, 116);
        PMFile.loadScreen = false;
    }

    public static void deinit() {
        LevelSelectionScriptHelper.deinit();
        mTilemapBack = null;
        mTilemapFront = null;
        mRunAnim.unloadGfx();
        mRunAnim = null;
        mCamera = null;
        mHUD = null;
        Dialog.deinit();
        PMAudio.deInitAudio();
    }

    public static void update() {
        Timer.updateTimer();
        LevelSelectionScriptHelper.update();
        Dialog.update();
        mCamera.update();
        StateLevelSelection.updateAlpha();
        if (mState != 0 && mState != 1) {
            mHUD.update();
        }
        switch (mState) {
            case 0: {
                if (TransitionEffect.update()) {
                    if (!GameState.mMovePixelineToNextLevel) {
                        if ((mEnterParam == 0 || mEnterParam == 7) && Defines.mWorldLookup[GameState.mLevel] < 4) {
                            mState = 1;
                        } else {
                            mState = 3;
                            if (mEnterParam != 4) {
                                LevelSelectionScriptHelper.startScript(0, mEnterParam);
                                LevelSelectionScriptHelper.update();
                            } else if (GameState.mReachedLevel <= 1) {
                                LevelSelectionScriptHelper.startScript(0, mEnterParam);
                                LevelSelectionScriptHelper.update();
                            }
                            mSuppresHUD = false;
                        }
                    } else {
                        boolean bl = true;
                        if (bl) {
                            int n = mLevelPositionsX[GameState.mLevel] << 16;
                            int n2 = mLevelPositionsY[GameState.mLevel] << 16;
                            GameState.mLevel = (byte)(GameState.mLevel + 1);
                            int n3 = mLevelPositionsX[GameState.mLevel] << 16;
                            int n4 = mLevelPositionsY[GameState.mLevel] << 16;
                            StateLevelSelection.movePixeline(n, n2, n3, n4);
                            mPixelineRight = true;
                        } else {
                            mState = 3;
                        }
                        LevelSelectionScriptHelper.startScript(0, mEnterParam);
                        LevelSelectionScriptHelper.update();
                        GameState.mMovePixelineToNextLevel = false;
                        mSuppresHUD = false;
                    }
                }
                StateLevelSelection.draw();
                TransitionEffect.draw();
                break;
            }
            case 1: {
                int n;
                if (Touch.mScreenPressed) {
                    mPanningSkipped = true;
                }
                if (mPanDistance >= 0) {
                    mPanDistance = 0;
                    mState = 3;
                    LevelSelectionScriptHelper.startScript(0, mEnterParam);
                    LevelSelectionScriptHelper.update();
                    mSuppresHUD = false;
                } else {
                    n = 775757 * Timer.mDt >> 6;
                    mPanDistance += mPanningSkipped ? n << 1 : n;
                }
                n = StateLevelSelection.mPixelinePos.mX - mPanDistance;
                int n5 = StateLevelSelection.mPixelinePos.mY;
                mCamera.setTarget(n, n5);
                mCamera.update();
                StateLevelSelection.draw();
                break;
            }
            case 3: {
                if (mHUD.isHUDReady() && !Dialog.isActive()) {
                    boolean bl;
                    boolean bl2 = GameState.mLevel < GameState.mReachedLevel && GameState.mLevel < 22;
                    boolean bl3 = bl = GameState.mLevel > 0;
                    if (!mMovementDenied) {
                        int n;
                        int n6;
                        int n7;
                        int n8;
                        if (InputProxy.isHeldRight()) {
                            if (bl2) {
                                n8 = mLevelPositionsX[GameState.mLevel] << 16;
                                n7 = mLevelPositionsY[GameState.mLevel] << 16;
                                GameState.mLevel = (byte)(GameState.mLevel + 1);
                                n6 = mLevelPositionsX[GameState.mLevel] << 16;
                                n = mLevelPositionsY[GameState.mLevel] << 16;
                                StateLevelSelection.movePixeline(n8, n7, n6, n);
                                mPixelineRight = true;
                            } else {
                                SoundBuffer.play(29, 200);
                                mMovementDenied = true;
                            }
                        }
                        if (InputProxy.isHeldLeft()) {
                            if (bl) {
                                n8 = mLevelPositionsX[GameState.mLevel] << 16;
                                n7 = mLevelPositionsY[GameState.mLevel] << 16;
                                GameState.mLevel = (byte)(GameState.mLevel - 1);
                                n6 = mLevelPositionsX[GameState.mLevel] << 16;
                                n = mLevelPositionsY[GameState.mLevel] << 16;
                                StateLevelSelection.movePixeline(n8, n7, n6, n);
                                mPixelineRight = false;
                            } else {
                                SoundBuffer.play(29, 200);
                                mMovementDenied = true;
                            }
                        }
                    }
                    if (InputProxy.isPressedFire() || InputProxy.isPressedOK()) {
                        StateLevelSelection.transitionToGame();
                    }
                    if (InputProxy.isPressedCancel()) {
                        StateLevelSelection.transitionToSaveMenu();
                    }
                    if (!InputProxy.isHeldLeft() && !InputProxy.isHeldRight()) {
                        mMovementDenied = false;
                    }
                }
                if (mBlinkTimer > 0) {
                    if ((mBlinkTimer -= Timer.mDt) <= 0) {
                        mBlinkTimer = 0;
                        mEyesClosedTimer = 500;
                    }
                } else if ((mEyesClosedTimer -= Timer.mDt) <= 0) {
                    mEyesClosedTimer = 0;
                    mBlinkTimer = (PMRandom.get16() * 2000 >> 16) + 2000;
                }
                StateLevelSelection.draw();
                if (!Dialog.isActive()) break;
                Dialog.draw();
                break;
            }
            case 4: {
                if (!PMAudio.isPlaying(34, -1)) {
                    SoundBuffer.play(34, 500);
                }
                if ((mInterpPixeline += 7943 * Timer.mDt >> 6) >= 65536) {
                    StateLevelSelection.mPixelinePos.mX = mLevelPositionsX[GameState.mLevel] << 16;
                    StateLevelSelection.mPixelinePos.mY = mLevelPositionsY[GameState.mLevel] << 16;
                    mPixelineOffset.set(0, 0);
                    if (mWalkingEffectID != -1) {
                        PMAudio.stop(mWalkingEffectID);
                    }
                    mWalkingEffectID = -1;
                    mState = 3;
                } else {
                    StateLevelSelection.mPixelineOffset.mX = MathUtil.smoothStep(mInterpPixeline, StateLevelSelection.mPixelineMovement.mX);
                    StateLevelSelection.mPixelineOffset.mY = MathUtil.smoothStep(mInterpPixeline, StateLevelSelection.mPixelineMovement.mY);
                }
                mCamera.setTarget(StateLevelSelection.mPixelinePos.mX + StateLevelSelection.mPixelineOffset.mX, StateLevelSelection.mPixelinePos.mY + StateLevelSelection.mPixelineOffset.mY);
                StateLevelSelection.draw();
                break;
            }
            case 5: {
                if (!Dialog.isActive() && !LevelSelectionScriptHelper.isScriptPlaying()) {
                    if (TransitionEffect.update()) {
                        boolean bl = false;
                        Main.counter = 0;
                        if (!bl) {
                            PMStateManager.set(5, 0);
                        } else {
                            PMStateManager.set(6, 0);
                        }
                    }
                    StateLevelSelection.draw();
                    TransitionEffect.draw();
                    break;
                }
                StateLevelSelection.draw();
                Dialog.draw();
                break;
            }
            case 6: {
                if (!Dialog.isActive() && !LevelSelectionScriptHelper.isScriptPlaying()) {
                    if (TransitionEffect.update()) {
                        PMDebug.println("PMStateManager.set(): STATE_StateSlotSelection");
                        PMStateManager.set(1, 1);
                    }
                    StateLevelSelection.draw();
                    TransitionEffect.draw();
                    break;
                }
                StateLevelSelection.draw();
                Dialog.draw();
            }
        }
        PMSystem.nextFrame();
    }

    public static void draw() {
        long l;
        int n;
        long l2;
        int n2;
        int n3;
        int n4;
        int n5;
        Vector2 vector2 = mCamera.getTranslationFP();
        long l3 = (long)vector2.mX * 5L >> 1;
        long l4 = (long)vector2.mY * 5L >> 1;
        int n6 = 4;
        int n7 = (vector2.mX >> 16) / 64;
        int n8 = n7 + (n6 + 1);
        if (n7 < 0) {
            n7 = 0;
        }
        if (n8 > mTilemapBackWidth) {
            n8 = mTilemapBackWidth;
        }
        for (n5 = 0; n5 < mTilemapBackHeight; ++n5) {
            for (int i = n7; i < n8; ++i) {
                long l5 = (long)(i * 0x400000) * 5L >> 1;
                long l6 = (long)(n5 * 0x400000) * 5L >> 1;
                n4 = (int)((l5 >> 16) - (l3 >> 16));
                n3 = (int)((l6 >> 16) - (l4 >> 16));
                n2 = mTilemapBack[i][n5];
                if (n2 <= 0) continue;
                PMImageManager.draw(1020 + (n2 - 1), n4, n3);
            }
        }
        for (n5 = 0; n5 < 23; ++n5) {
            long l7 = (long)(mLevelPositionsX[n5] << 16) * 5L >> 1;
            l2 = (long)(mLevelPositionsY[n5] << 16) * 5L >> 1;
            n = (int)((l7 >> 16) - (l3 >> 16));
            n4 = (int)((l2 >> 16) - (l4 >> 16));
            if (n5 <= GameState.mReachedLevel) {
                PMImageManager.draw(993, n, n4);
                continue;
            }
            PMImageManager.draw(994, n, n4);
        }
        n5 = 1;
        if (mPixelineRight) {
            n5 = 0;
        }
        if (mState == 4) {
            l = (long)(StateLevelSelection.mPixelinePos.mX + StateLevelSelection.mPixelineOffset.mX) * 5L >> 1;
            l2 = (long)(StateLevelSelection.mPixelinePos.mY + StateLevelSelection.mPixelineOffset.mY) * 5L >> 1;
            n = (int)((l >> 16) - (l3 >> 16));
            n4 = (int)((l2 >> 16) - (l4 >> 16));
            mRunAnim.update(Timer.mDt);
            mRunAnim.draw(n, n4, n5 != 0);
        } else {
            l = (long)StateLevelSelection.mPixelinePos.mX * 5L >> 1;
            l2 = (long)StateLevelSelection.mPixelinePos.mY * 5L >> 1;
            n = (int)((l >> 16) - (l3 >> 16));
            n4 = (int)((l2 >> 16) - (l4 >> 16));
            PMImageManager.draw(988, n, n4, n5 != 0, 0);
        }
        if (mBlinkTimer <= 0) {
            l = 111575040L;
            l2 = 13271040L;
            n = (int)((l >> 16) - (l3 >> 16));
            n4 = (int)((l2 >> 16) - (l4 >> 16));
            if (n > 0 && n < 640) {
                PMImageManager.draw(995, n, n4);
            }
            l = 0x9010000L;
            l2 = 0xF50000L;
            n = (int)((l >> 16) - (l3 >> 16));
            n4 = (int)((l2 >> 16) - (l4 >> 16));
            if (n > 0 && n < 640) {
                PMImageManager.draw(996, n, n4);
            }
        }
        for (int i = 0; i < mTilemapBackHeight; ++i) {
            for (int j = n7; j < n8; ++j) {
                l2 = (long)(j * 0x400000) * 5L >> 1;
                long l8 = (long)(i * 0x400000) * 5L >> 1;
                n3 = (int)((l2 >> 16) - (l3 >> 16));
                n2 = (int)((l8 >> 16) - (l4 >> 16));
                byte by = mTilemapFront[j][i];
                if (by <= 0) continue;
                PMImageManager.draw(997 + (by - 1), n3, n2);
            }
        }
        mHUD.draw(mHUDAlpha);
        if (Dialog.isActive()) {
            Dialog.draw();
        }
    }

    private static void movePixeline(int n, int n2, int n3, int n4) {
        StateLevelSelection.mPixelineMovement.mX = n3 - n;
        StateLevelSelection.mPixelineMovement.mY = n4 - n2;
        mPixelinePos.set(n, n2);
        mPixelineOffset.set(0, 0);
        mInterpPixeline = 0;
        mState = 4;
    }

    public static void loadTilemapBack() {
        PMFile.openFile("levelSelectBackground.map");
        short s = PMFile.readShort();
        mTilemapBackWidth = s;
        short s2 = s;
        short s3 = PMFile.readShort();
        mTilemapBackHeight = s3;
        short s4 = s3;
        mTilemapBack = new byte[s2][s4];
        for (short s5 = 0; s5 < s4; s5 = (short)(s5 + 1)) {
            for (short s6 = 0; s6 < s2; s6 = (short)(s6 + 1)) {
                StateLevelSelection.mTilemapBack[s6][s5] = (byte)PMFile.readShort();
            }
        }
    }

    public static void loadTilemapFront() {
        PMFile.openFile("levelSelectForground.map");
        short s = PMFile.readShort();
        short s2 = PMFile.readShort();
        mTilemapFront = new byte[s][s2];
        for (short s3 = 0; s3 < s2; s3 = (short)(s3 + 1)) {
            for (short s4 = 0; s4 < s; s4 = (short)(s4 + 1)) {
                StateLevelSelection.mTilemapFront[s4][s3] = (byte)PMFile.readShort();
            }
        }
    }

    public static void transitionToGame() {
        if (mState == 3 && !Dialog.isActive()) {
            mState = 5;
            TransitionEffect.setFadeMusic(true);
            TransitionEffect.init(true);
            MusicBuffer.stop();
            SoundBuffer.play(35, 1000);
            mSuppresHUD = true;
        }
    }

    public static void transitionToSaveMenu() {
        if (mState == 3 && !Dialog.isActive()) {
            mState = 6;
            TransitionEffect.setFadeMusic(false);
            TransitionEffect.init(true);
            MusicBuffer.stop();
            SoundBuffer.play(32, 500);
            mSuppresHUD = true;
        }
    }

    private static void updateAlpha() {
        if (Dialog.isActive() || mSuppresHUD) {
            if (mHUDAlpha > 0 && (mHUDAlpha -= 15887 * Timer.mDt >> 6) < 0) {
                mHUDAlpha = 0;
            }
        } else if (mHUDAlpha < 65536 && (mHUDAlpha += 15887 * Timer.mDt >> 6) > 65536) {
            mHUDAlpha = 65536;
        }
    }

    static {
        mLevelPositionsX = new int[]{41, 136, 217, 278, 323, 347, 421, 465, 528, 568, 623, 664, 717, 784, 827, 876, 921, 983, 1052, 1095, 1143, 1192, 1240};
        mLevelPositionsY = new int[]{117, 117, 97, 95, 95, 118, 118, 118, 118, 145, 145, 119, 119, 118, 98, 98, 75, 118, 119, 98, 98, 119, 119};
        mPixelinePos = new Vector2();
        mPixelineMovement = new Vector2();
        mPixelineOffset = new Vector2();
    }
}

