/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.menu;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.util.PMLocale;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.Main;
import dk.progressivemedia.skeleton.MusicBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.TransitionEffect;

public class StateSplash {
    private static final int HALF_SCREEN_WIDTH = 320;
    private static final int HALF_SCREEN_HEIGHT = 180;
    private static final int MUSIC_FADE_TIME = 800;
    private static final int FADE_TIME = 800;
    private static final int IDLE_TIME = 1200;
    private static final int SCALE_SPEED = 100;
    private static final int STATE_SPLASH = 0;
    private static final int STATE_TRANSITION = 1;
    private static int mState;
    private static int mCurrent;
    private static int[] mLogoID;
    private static boolean[] mScaling;
    private static int mScale;
    private static final int FADE_IN = 0;
    private static final int FADE_IDLE = 1;
    private static final int FADE_OUT = 2;
    private static int mFadePhase;
    private static int mOpacity;
    private static int mFadeTimer;
    private static boolean mMusicStarted;
    private static int mMusicFadeTimer;
    private static int[] mSplashImgs;
    private static int[] mSplashImgsLogo;
    private static int[] mSplashImgsText;
    public static float screenWidthFrac;

    public static void init(int n) {
        PMFile.loadScreen = true;
        PMImageManager.load(1113, 18);
        Touch.init();
        Timer.initTimer();
        mState = 0;
        mFadePhase = 0;
        mScale = 65536;
        mOpacity = 0;
        mFadeTimer = 0;
        mMusicStarted = false;
        mMusicFadeTimer = 0;
        MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
        Main.drawLoading();
        MusicBuffer.play(19);
        MusicBuffer.update();
        PMAudio.update();
        Main.drawLoading();
        PMFile.loadScreen = false;
        Main.counter = 0;
    }

    public static void deinit() {
        PMCanvas.PMGraphics_setClip(0, 0, 640, 360);
        PMImageManager.unloadAll();
    }

    public static void update() {
        int n;
        Timer.updateTimer();
        PMCanvas.PMGraphics_setColor(0xFFFFFF);
        PMCanvas.PMGraphics_fillRect(0, 0, 640, 360);
        if (mMusicFadeTimer < 800 && mMusicStarted && (mMusicFadeTimer += Timer.mDt) > 800) {
            mMusicFadeTimer = 800;
        }
        if (mState == 0) {
            if (mScaling[mCurrent]) {
                mScale += 193 * Timer.mDt >> 6;
            }
            switch (mFadePhase) {
                case 0: {
                    if ((mFadeTimer += Timer.mDt) > 800) {
                        mFadePhase = 1;
                        mFadeTimer = 0;
                        mOpacity = 480;
                        break;
                    }
                    mOpacity = 480 * PMMath.DIV(mFadeTimer << 16, 0x3200000) >> 16;
                    break;
                }
                case 1: {
                    n = 0;
                    if (mCurrent < mLogoID.length - 1) {
                        if ((mFadeTimer += Timer.mDt) <= 1200 && !Touch.mScreenPressed && !PMCanvas.PMInput_isPressed(1) && !PMCanvas.PMInput_isReleased(1)) break;
                        mFadePhase = 2;
                        mFadeTimer = 800;
                        PMCanvas.PMGraphics_setClip(0, 0, 640, 360);
                        break;
                    }
                    if (!Touch.mScreenPressed && !PMCanvas.PMInput_isPressed(Integer.MAX_VALUE) && !PMCanvas.PMInput_isReleased(Integer.MAX_VALUE)) break;
                    TransitionEffect.setFadeMusic(false);
                    TransitionEffect.init(true);
                    mState = 1;
                    PMCanvas.PMGraphics_setClip(0, 0, 640, 360);
                    MusicBuffer.setVolume(MusicBuffer.DEFAULT_MUSIC_VOLUMEN);
                    break;
                }
                case 2: {
                    if ((mFadeTimer -= Timer.mDt) < 0) {
                        mFadePhase = 0;
                        mFadeTimer = 0;
                        mOpacity = 0;
                        mScale = 65536;
                        if (++mCurrent != mLogoID.length - 1) break;
                        mMusicStarted = true;
                        break;
                    }
                    mOpacity = 480 * PMMath.DIV(mFadeTimer << 16, 0x3200000) >> 16;
                }
            }
        } else if (TransitionEffect.update()) {
            PMStateManager.set(1, 0);
        }
        n = mScale;
        if (mCurrent < mLogoID.length - 1) {
            int n2 = (int)(screenWidthFrac * (float)mOpacity) - 160;
            PMImageManager.draw(mLogoID[mCurrent], n2, 180, false, 0, 255, 65536);
        } else {
            int n3 = (int)(screenWidthFrac * (float)mOpacity) - 160;
            PMImageManager.draw(mSplashImgs[PMLocale.get()], 320, 180, false, 0, 255, 65536);
            if (mState != 1) {
                PMCanvas.PMGraphics_setClip(0, 180, 640, 180);
            }
            PMImageManager.draw(mSplashImgsLogo[PMLocale.get()], n3 + 80, 260, false, 0, 255, 65536);
            PMImageManager.draw(mSplashImgsText[PMLocale.get()], n3 + 80, 260 + PMImageManager.getHeight(mSplashImgsLogo[PMLocale.get()]), false, 0, 255, 65536, 65536);
        }
        if (mState == 1) {
            TransitionEffect.draw();
        }
        PMSystem.nextFrame();
    }

    static {
        mCurrent = 0;
        mLogoID = new int[]{1128, 1129, 1130, 1130};
        mScaling = new boolean[]{true, false, false, false};
        mFadePhase = 0;
        mSplashImgs = new int[]{1113, 1114, 1116, 1117, 1115};
        mSplashImgsLogo = new int[]{1118, 1119, 1121, 1122, 1120};
        mSplashImgsText = new int[]{1123, 1124, 1126, 1127, 1125};
        screenWidthFrac = 1.0f;
    }
}

