/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.GMGmovieplayer;

import dk.progressivemedia.rflib.audio.PMAudio;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.io.PMFile;
import dk.progressivemedia.skeleton.GMGmovieplayer.GMGMovieItem;
import dk.progressivemedia.skeleton.Interpolation;

public class GMGMovie {
    public static final int TRACK_SIZE_FULL = 5;
    public static final int TRACK_SIZE_SHORT = 3;
    public static final int ID_ATTRIB = 0;
    public static final int FROM_TIMESTAMP = 1;
    public static final int FROM_VALUE = 2;
    public static final int TO_TIMESTAMP = 3;
    public static final int TO_VALUE = 4;
    public static final int ID_ATTRIB_ID_MASK = 65280;
    public static final int ID_ATTRIB_ID_SHIFT = 8;
    public static final int ID_ATTRIB_INTERPOLATE_MASK = 240;
    public static final int ID_ATTRIB_INTERPOLATE_SHIFT = 4;
    public static final int ID_ATTRIB_ATTRIB_MASK = 15;
    public static final int ID_ATTRIB_ATTRIB_SHIFT = 0;
    public static final int ID_EVENT_TAG = 255;
    public static final int ID_SPECIAL_TAG = 254;
    public static final int SPECIAL_SCENE_START = 1;
    public static final int SPECIAL_LOOP_POINT = 2;
    public static final int SPECIAL_KEYFRAME = 3;
    public static final int EVENT_AUDIO_PLAY = 0;
    public static final int EVENT_AUDIO_STOP = 1;
    public static final int EVENT_VIBRATION = 2;
    public static final int EVENT_TEXT = 3;
    public static final int INTERPOLATE_LINEAR = 0;
    public static final int INTERPOLATE_SMOOTH_START = 1;
    public static final int INTERPOLATE_SMOOTH_END = 2;
    public static final int INTERPOLATE_SMOOTH_MIDDLE = 3;
    public static final int INTERPOLATE_SMOOTH_START_AND_END = 4;
    public static final int INTERPOLATE_SHORT_TRACK = 15;
    public static final int ALLOCATION_EAGER = 0;
    public static final int ALLOCATION_LAZY = 1;
    public static final int ALLOCATION_INCREMENTAL = 2;
    public static final int ALLOCATION_PRECACHE_TIME = 60;
    private short[] mTimeline;
    private short[] mActive;
    private int mPosition;
    private int mTick;
    private int mTime;
    private int mLength;
    private int mLengthMs;
    private boolean mFastforward;
    private GMGMovieItem[] mItems;
    private short[] mModelId;
    private short[] mOrder;
    private int[] mSortedOrder;
    private boolean mLoop;
    private int mLoopMark;
    private int mAllocationType;
    private int mPrecacheTick;

    public static void event(int n, int n2) {
        if (n == 0) {
            PMAudio.play(n2);
        } else if (n == 1) {
            // empty if block
        }
    }

    public void draw(int n, int n2) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, false, 0, 65536, 65536, 65536);
        }
    }

    public void draw(int n, int n2, boolean bl, int n3) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, bl, n3, 65536, 65536, 65536);
        }
    }

    public void draw(int n, int n2, boolean bl, int n3, int n4, int n5) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, bl, n3, n4, n5, n5);
        }
    }

    public void draw(int n, int n2, int n3) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, false, 0, 65536, n3, n3);
        }
    }

    public void draw(int n, int n2, int n3, int n4) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, false, 0, 65536, n3, n4);
        }
    }

    public void draw(int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        for (int i = 0; i < this.mSortedOrder.length; ++i) {
            this.mItems[this.mSortedOrder[i]].draw(n, n2, bl, n3, n4, n5, n6);
        }
    }

    public boolean isDone() {
        return this.mTime >= this.mLength;
    }

    public boolean update(int n) {
        int n2;
        if (this.mTime >= this.mLength) {
            return true;
        }
        this.mTick += n;
        this.mTime = this.mTick / 10;
        if (this.mLoop && this.mTime >= this.mLength) {
            this.gotoTick(this.mLoopMark + this.mTick - this.mLengthMs);
        }
        for (n2 = 0; n2 < this.mSortedOrder.length; ++n2) {
            this.mSortedOrder[this.mOrder[n2]] = n2;
        }
        for (n2 = 0; n2 < this.mActive.length; ++n2) {
            if (this.mActive[n2] < 0) continue;
            this.updateItem(this.mActive[n2]);
            if (this.mTime < this.mTimeline[this.mActive[n2] + 3]) continue;
            this.mActive[n2] = -1;
        }
        while (this.mPosition < this.mTimeline.length && this.mTime >= this.mTimeline[this.mPosition + 1]) {
            if (this.updateItem(this.mPosition)) {
                if (this.mTime < this.mTimeline[this.mPosition + 3]) {
                    for (n2 = 0; n2 < this.mActive.length; ++n2) {
                        if (this.mActive[n2] != -1) continue;
                        this.mActive[n2] = (short)this.mPosition;
                        break;
                    }
                }
                this.mPosition += 5;
                continue;
            }
            this.mPosition += 3;
        }
        return this.mTime >= this.mLength;
    }

    public void gotoTick(int n) {
        int n2;
        this.mTick = 0;
        this.mTime = 0;
        this.mPosition = 0;
        for (n2 = 0; n2 < this.mItems.length; ++n2) {
            this.mItems[n2].reset();
            this.mOrder[n2] = (short)n2;
        }
        for (n2 = 0; n2 < this.mActive.length; ++n2) {
            this.mActive[n2] = -1;
        }
        this.mFastforward = true;
        this.update(n % this.mLengthMs);
        this.mFastforward = false;
    }

    private boolean updateItem(int n) {
        int n2 = (this.mTimeline[n + 0] & 0xFF00) >> 8;
        int n3 = (this.mTimeline[n + 0] & 0xF0) >> 4;
        int n4 = (this.mTimeline[n + 0] & 0xF) >> 0;
        if (n3 == 15) {
            if (n2 == 255) {
                GMGMovie.event(n4, this.mTimeline[n + 2]);
            } else if (n2 != 254) {
                if (n4 == 7) {
                    this.modifyOrder(n2, this.mTimeline[n + 2]);
                } else {
                    this.mItems[n2].setValue(n4, this.mTimeline[n + 2]);
                }
            }
            return false;
        }
        int n5 = this.mTime - this.mTimeline[n + 1];
        int n6 = this.mTimeline[n + 3] - this.mTimeline[n + 1];
        int n7 = this.mTimeline[n + 2];
        int n8 = this.mTimeline[n + 4];
        if (n4 == 3 || n4 == 9 || n4 == 10) {
            n7 &= 0xFFFF;
            n8 &= 0xFFFF;
        }
        int n9 = Interpolation.interpolate(n3, n7, n8, n5, n6);
        if (n2 == 255) {
            GMGMovie.event(n4, n9);
        } else if (n2 != 254) {
            this.mItems[n2].setValue(n4, (short)n9);
        }
        return true;
    }

    private void modifyOrder(int n, int n2) {
        int n3;
        int n4;
        int n5 = 0;
        for (n4 = 0; n4 < this.mOrder.length; ++n4) {
            if (this.mOrder[n4] != n) continue;
            n5 = n4;
            break;
        }
        n4 = n5 + n2;
        if (n2 < 0) {
            for (n3 = n5; n3 > n4; --n3) {
                this.mOrder[n3] = this.mOrder[n3 - 1];
            }
        }
        if (n2 > 0) {
            for (n3 = n5; n3 < n4; ++n3) {
                this.mOrder[n3] = this.mOrder[n3 + 1];
            }
        }
        this.mOrder[n4] = (short)n;
    }

    public void unloadGfx() {
        this.loadGfx(true);
    }

    public void loadGfx() {
        this.loadGfx(false);
    }

    private void loadGfx(boolean bl) {
        int n = 0;
        while (n < this.mTimeline.length) {
            int n2 = (this.mTimeline[n + 0] & 0xF0) >> 4;
            if (n2 == 15) {
                int n3;
                int n4 = (this.mTimeline[n + 0] & 0xF) >> 0;
                if (n4 == 0 && (n3 = (this.mTimeline[n + 0] & 0xFF00) >> 8) != 255 && n3 != 254) {
                    if (bl) {
                        PMImageManager.unload(this.mTimeline[n + 2]);
                    } else {
                        PMImageManager.load(this.mTimeline[n + 2]);
                    }
                }
                n += 3;
                continue;
            }
            n += 5;
        }
    }

    private void loadEffects(boolean bl) {
        int n = 0;
        while (n < this.mTimeline.length) {
            int n2 = (this.mTimeline[n + 0] & 0xF0) >> 4;
            if (n2 == 15) {
                int n3;
                int n4 = (this.mTimeline[n + 0] & 0xFF00) >> 8;
                if (n4 == 255 && (n3 = (this.mTimeline[n + 0] & 0xF) >> 0) == 0) {
                    short s = this.mTimeline[n + 2];
                    if (bl) {
                        PMAudio.unload(s);
                    }
                }
                n += 3;
                continue;
            }
            n += 5;
        }
    }

    public GMGMovie copy() {
        int n;
        GMGMovie gMGMovie = new GMGMovie();
        gMGMovie.mLength = this.mLength;
        gMGMovie.mLengthMs = this.mLengthMs;
        gMGMovie.mLoopMark = this.mLoopMark;
        int n2 = this.mOrder.length;
        gMGMovie.mOrder = new short[n2];
        gMGMovie.mSortedOrder = new int[n2];
        gMGMovie.mItems = new GMGMovieItem[n2];
        for (n = 0; n < n2; ++n) {
            gMGMovie.mItems[n] = new GMGMovieItem();
            gMGMovie.mOrder[n] = (short)n;
        }
        gMGMovie.mActive = new short[this.mActive.length];
        gMGMovie.mTimeline = this.mTimeline;
        gMGMovie.mTick = 0;
        gMGMovie.mTime = 0;
        gMGMovie.mPosition = 0;
        gMGMovie.mFastforward = false;
        for (n = 0; n < gMGMovie.mActive.length; ++n) {
            gMGMovie.mActive[n] = -1;
        }
        return gMGMovie;
    }

    public static GMGMovie load(String string) {
        return GMGMovie.load(PMFile.calcCRC(string));
    }

    public static GMGMovie load(short s) {
        int n;
        PMFile.openFile(s);
        GMGMovie gMGMovie = new GMGMovie();
        gMGMovie.mLength = PMFile.readShort();
        gMGMovie.mLengthMs = 10 * gMGMovie.mLength;
        int n2 = PMFile.readUnsignedByte();
        gMGMovie.mLoop = (n2 & 1) > 0;
        int n3 = PMFile.readUnsignedByte();
        gMGMovie.mOrder = new short[n3];
        gMGMovie.mSortedOrder = new int[n3];
        gMGMovie.mItems = new GMGMovieItem[n3];
        for (n = 0; n < n3; ++n) {
            gMGMovie.mItems[n] = new GMGMovieItem();
            gMGMovie.mOrder[n] = (short)n;
        }
        if (gMGMovie.mLoop) {
            gMGMovie.mLoopMark = 10 * (short)PMFile.readUnsignedShort();
        }
        gMGMovie.mActive = new short[PMFile.readShort()];
        gMGMovie.mTimeline = new short[PMFile.readShort()];
        for (n = 0; n < gMGMovie.mTimeline.length; ++n) {
            gMGMovie.mTimeline[n] = PMFile.readShort();
        }
        PMFile.closeFile();
        gMGMovie.mTick = 0;
        gMGMovie.mTime = 0;
        gMGMovie.mPosition = 0;
        gMGMovie.mFastforward = false;
        for (n = 0; n < gMGMovie.mActive.length; ++n) {
            gMGMovie.mActive[n] = -1;
        }
        gMGMovie.loadEffects(false);
        gMGMovie.gotoTick(0);
        return gMGMovie;
    }
}

