/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton;

import dk.progressivemedia.rflib.system.PMStateManager;
import dk.progressivemedia.rflib.util.PMMath;
import dk.progressivemedia.skeleton.InputProxy;

public class Touch {
    private static final int BUTTON_STATE_VOID = 0;
    private static final int BUTTON_STATE_PRESSED = 1;
    private static final int BUTTON_STATE_RELEASED = 2;
    private static final int BUTTON_STATE_PRESSED_B = 3;
    private static final int BUTTON_STATE_IS_OVER = 4;
    private static int mNumButtons;
    private static int[] mButtonIDMap;
    private static int[] mButtonCoords;
    private static int[] mButtonState;
    private static boolean mIgnoreHalf;
    public static final int OVERLAYID_DUMMY = 0;
    public static final int OVERLAYID_TOUCH_CONTROL = 1;
    public static final int OVERLAYID_TOUCH_CONTROL_DIGITAL = 2;
    public static final int VBUTTON_MASK_ID_DPAD = 1;
    public static final int VBUTTON_MASK_ID_ALL = 3;
    public static final int VBUTTON_MASK_ID_GMG = 65536;
    public static final int VBUTTON_MASK_ID_ZEEMOTE = 0x100000;
    public static int touchStartX;
    public static int touchStartY;
    public static int touchX;
    public static int touchY;
    public static boolean mScreenPressed;

    public static void init() {
        mNumButtons = 0;
        mButtonState = new int[mNumButtons];
        mIgnoreHalf = false;
        Touch.flush();
        Touch.setControlOverlay();
        InputProxy.init();
    }

    public static void init(int n, int[] nArray, int[] nArray2, boolean bl) {
        mNumButtons = n;
        mButtonIDMap = nArray2;
        mButtonCoords = nArray;
        mButtonState = new int[n];
        mIgnoreHalf = bl;
        Touch.flush();
        Touch.setControlOverlay();
        InputProxy.init();
    }

    public static void setControlOverlay() {
    }

    public static void flush() {
        for (int i = 0; i < mNumButtons; ++i) {
            Touch.mButtonState[i] = 0;
        }
        mScreenPressed = false;
    }

    public static void clearReleased() {
        for (int i = 0; i < mNumButtons; ++i) {
            int n = mButtonState[i];
            if (n == 2) {
                Touch.mButtonState[i] = 0;
                continue;
            }
            if (n != 1) continue;
            Touch.mButtonState[i] = 3;
        }
        mScreenPressed = false;
    }

    public static boolean isUp(int n) {
        int n2 = Touch.idxFromID(n);
        if (n2 < 0) {
            return false;
        }
        return mButtonState[n2] == 0;
    }

    public static boolean isOver(int n) {
        int n2 = Touch.idxFromID(n);
        if (n2 < 0) {
            return false;
        }
        return mButtonState[n2] == 4;
    }

    public static boolean isDown(int n) {
        int n2 = Touch.idxFromID(n);
        if (n2 < 0) {
            return false;
        }
        int n3 = mButtonState[n2];
        return n3 == 1 || n3 == 3;
    }

    public static boolean isPressed(int n) {
        int n2 = Touch.idxFromID(n);
        if (n2 < 0) {
            return false;
        }
        return mButtonState[n2] == 1;
    }

    public static boolean wasReleased(int n) {
        int n2 = Touch.idxFromID(n);
        if (n2 < 0) {
            return false;
        }
        return mButtonState[n2] == 2;
    }

    public static void touchDown(int n, int n2, int n3) {
        if (n2 < 32768 && n == 3 && mIgnoreHalf) {
            return;
        }
        int n4 = PMMath.MUL(n2, 0x1400000) >> 16;
        int n5 = PMMath.MUL(n3, 0xF00000) >> 16;
        int n6 = 0;
        int n7 = 0;
        while (n6 < mNumButtons) {
            if (Touch.insideRect(n4, n5, mButtonCoords[n7 + 0], mButtonCoords[n7 + 1], mButtonCoords[n7 + 2], mButtonCoords[n7 + 3])) {
                Touch.mButtonState[n6] = 1;
            }
            ++n6;
            n7 += 4;
        }
        if (PMStateManager.currentState == 1) {
            // empty if block
        }
    }

    public static void touchMove(int n, int n2, int n3) {
        if (n2 < 32768 && n == 3 && mIgnoreHalf) {
            return;
        }
        int n4 = PMMath.MUL(n2, 0x1400000) >> 16;
        int n5 = PMMath.MUL(n3, 0xF00000) >> 16;
        int n6 = 0;
        int n7 = 0;
        while (n6 < mNumButtons) {
            boolean bl = Touch.insideRect(n4, n5, mButtonCoords[n7 + 0], mButtonCoords[n7 + 1], mButtonCoords[n7 + 2], mButtonCoords[n7 + 3]);
            if (!bl) {
                Touch.mButtonState[n6] = 0;
            }
            ++n6;
            n7 += 4;
        }
    }

    public static void touchUp(int n, int n2, int n3) {
        int n4 = PMMath.MUL(n2, 0x1400000) >> 16;
        int n5 = PMMath.MUL(n3, 0xF00000) >> 16;
        int n6 = 0;
        int n7 = 0;
        while (n6 < mNumButtons) {
            if (Touch.insideRect(n4, n5, mButtonCoords[n7 + 0], mButtonCoords[n7 + 1], mButtonCoords[n7 + 2], mButtonCoords[n7 + 3])) {
                int n8 = mButtonState[n6];
                if (n8 == 1 || n8 == 3) {
                    Touch.mButtonState[n6] = 2;
                }
            } else {
                Touch.mButtonState[n6] = 0;
            }
            ++n6;
            n7 += 4;
        }
    }

    public static void setPushPos(int n, int n2) {
    }

    public static void setMovePos(int n, int n2) {
    }

    public static void releasePos() {
        Touch.setPushPos(-1, -1);
        Touch.setMovePos(-1, -1);
    }

    public static void debugDraw() {
    }

    public static boolean insideRect(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n5 && n2 >= n4 && n2 <= n6;
    }

    private static int idxFromID(int n) {
        int n2 = -1;
        int n3 = mNumButtons;
        while (--n3 >= 0) {
            if (mButtonIDMap[n3] != n) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    static {
        touchStartX = -1;
        touchStartY = -1;
        touchX = -1;
        touchY = -1;
    }
}

