/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.skeleton.game;

import dk.progressivemedia.rflib.graphics.PMFont;
import dk.progressivemedia.rflib.graphics.PMImageManager;
import dk.progressivemedia.rflib.platform.PMCanvas;
import dk.progressivemedia.skeleton.ButtonPulser;
import dk.progressivemedia.skeleton.Dialog;
import dk.progressivemedia.skeleton.GameState;
import dk.progressivemedia.skeleton.InputProxy;
import dk.progressivemedia.skeleton.SoundBuffer;
import dk.progressivemedia.skeleton.Timer;
import dk.progressivemedia.skeleton.Touch;
import dk.progressivemedia.skeleton.VarProxy;
import dk.progressivemedia.skeleton.game.StateGame;
import dk.progressivemedia.skeleton.game.pixeline.Pixeline;
import dk.progressivemedia.skeleton.game.pixeline.PixelineData;
import dk.progressivemedia.skeleton.math.InterpolatorSpring;
import dk.progressivemedia.skeleton.math.MathUtil;
import dk.progressivemedia.skeleton.movieplayer.Movie;

public class HUD {
    private static final int STATE_ENTERING = 0;
    private static final int STATE_IDLE = 1;
    private int mState;
    private InterpolatorSpring mSpringLifeBox;
    private InterpolatorSpring mSpringCoinBox;
    private Pixeline mPixeline;
    private boolean mTotembarEnabled;
    private int mSelectedButton = 0;
    private static final int TOTEM_BUTTON_COUNT = 4;
    private boolean[] mButtonPressed;
    private ButtonPulser mButtonPulser;
    private static final int PULSE_SCALE_SIZE = 3092;
    private static final int PULSE_SCALE_SPEED = 880000;
    private static final int BUTTON_ID_JUMP = 0;
    private static final int BUTTON_ID_TOTEM1 = 1;
    private static final int BUTTON_ID_TOTEM2 = 2;
    private static final int BUTTON_ID_TOTEM3 = 3;
    private static final int BUTTON_COUNT = 4;
    private static final int PRESSED_OFFSET = 2;
    private static final int STATE_BAR_HIDDEN = 0;
    private static final int STATE_BAR_ENTER = 1;
    private static final int STATE_BAR_VISIBLE = 2;
    private static final int STATE_BAR_EXIT = 3;
    private int mBarState;
    private int mInterp;
    private int mTotemBarHeight;
    private int mTotemRequested;
    private Movie mAnimGainLife;
    private boolean mAnimGainLifeActive;
    private Movie[] mAnimLoseHealth;
    private boolean[] mAnimLoseHealthActive;
    private static final int STATE_KEY_VOID = 0;
    private static final int STATE_KEY_ENTERING = 1;
    private static final int STATE_KEY_IDLE = 2;
    private static final int STATE_KEY_EXITING = 3;
    private int mKeyState;
    private Movie mAnimKeyEnter;
    private Movie mAnimKeyIdle;
    private Movie mAnimKeyExit;
    public static final int LIFEBOXSTART = -7208960;
    public static final int COINBOXSTART = -4587520;

    public HUD(Pixeline pixeline) {
        int n;
        this.mPixeline = pixeline;
        this.mState = 0;
        this.mBarState = 0;
        this.mTotembarEnabled = GameState.isTotem1Unlocked();
        this.mInterp = 0;
        this.mTotemRequested = -1;
        this.setupTouchOverlays();
        this.mButtonPressed = new boolean[4];
        for (n = 0; n < 4; ++n) {
            this.mButtonPressed[n] = false;
        }
        this.mButtonPulser = new ButtonPulser();
        this.mSelectedButton = 0;
        this.mSpringLifeBox = new InterpolatorSpring();
        this.mSpringCoinBox = new InterpolatorSpring();
        n = -7208960;
        int n2 = -4587520;
        int n3 = VarProxy.HUD_screenPadding * 65536;
        int n4 = VarProxy.HUD_silverCoinBoxX * 65536 + VarProxy.HUD_screenPadding * 65536;
        this.mSpringLifeBox.set(n, VarProxy.HUD_screenPadding * 65536, n3, VarProxy.HUD_screenPadding * 65536);
        this.mSpringCoinBox.set(n2, VarProxy.HUD_screenPadding * 65536, n4, VarProxy.HUD_screenPadding * 65536);
        this.mAnimGainLife = Movie.load((short)-23666);
        this.mAnimGainLifeActive = false;
        this.mAnimLoseHealth = new Movie[3];
        this.mAnimLoseHealthActive = new boolean[3];
        for (int i = 0; i < this.mAnimLoseHealth.length; ++i) {
            this.mAnimLoseHealth[i] = Movie.load((short)2675);
            this.mAnimLoseHealth[i].loadGfx();
            this.mAnimLoseHealth[i].gotoTick(0);
            this.mAnimLoseHealthActive[i] = false;
        }
        this.mAnimKeyEnter = Movie.load((short)-27532);
        this.mAnimKeyIdle = Movie.load((short)31807);
        this.mAnimKeyExit = Movie.load((short)18629);
        this.mAnimKeyEnter.loadGfx();
        this.mAnimKeyIdle.loadGfx();
        this.mAnimKeyExit.loadGfx();
        this.mAnimKeyEnter.gotoTick(0);
        this.mAnimKeyIdle.gotoTick(0);
        this.mAnimKeyExit.gotoTick(0);
        this.mKeyState = 0;
    }

    private void setupTouchOverlays() {
        int n = 168;
        n -= 41;
        this.mTotemBarHeight = 214 - (n -= 42);
    }

    private void handleTotem(int n) {
        switch (this.mBarState) {
            case 0: {
                boolean bl = false;
                if (this.mTotembarEnabled) {
                    int n2;
                    int n3;
                    if (InputProxy.isReleasedFire2() && this.mTotembarEnabled) {
                        bl = true;
                        this.mButtonPulser.reset();
                        this.mSelectedButton = n;
                    }
                    if (InputProxy.isPressedAltRight()) {
                        for (n3 = 1; n3 < 4; ++n3) {
                            n2 = (n + n3) % 4;
                            if (!GameState.isTotemUnlocked(n2) || n2 == n) continue;
                            this.mPixeline.eventRequestTransform(n2);
                            this.mSelectedButton = n2;
                            break;
                        }
                    }
                    if (InputProxy.isPressedAltLeft()) {
                        for (n3 = 1; n3 < 4; ++n3) {
                            n2 = (4 + n - n3) % 4;
                            if (!GameState.isTotemUnlocked(n2) || n2 == n) continue;
                            this.mPixeline.eventRequestTransform(n2);
                            this.mSelectedButton = n2;
                            break;
                        }
                    }
                }
                if (!bl) break;
                this.mBarState = 1;
                this.mInterp = 0;
                break;
            }
            case 1: {
                this.mInterp += 4960 * Timer.mDt >> 6;
                if (this.mInterp < 65536) break;
                this.mInterp = 65536;
                this.mBarState = 2;
                for (int i = 0; i < this.mButtonPressed.length; ++i) {
                    this.mButtonPressed[i] = false;
                }
                break;
            }
            case 2: {
                this.mButtonPulser.update(Timer.mDt);
                boolean bl = false;
                if (InputProxy.isReleasedFire() || InputProxy.isReleasedOK() || InputProxy.isReleasedFire2()) {
                    bl = this.selectTotem(this.mSelectedButton);
                } else if (InputProxy.isPressedUp() || InputProxy.isPressedAltRight()) {
                    ++this.mSelectedButton;
                    if (this.mSelectedButton >= 4) {
                        this.mSelectedButton = 0;
                    }
                    this.mButtonPulser.reset();
                } else if (InputProxy.isPressedDown() || InputProxy.isPressedAltLeft()) {
                    --this.mSelectedButton;
                    if (this.mSelectedButton < 0) {
                        this.mSelectedButton = 3;
                    }
                    this.mButtonPulser.reset();
                }
                if (!bl) break;
                this.mBarState = 3;
                this.mInterp = 65536;
                break;
            }
            case 3: {
                this.mInterp -= 4960 * Timer.mDt >> 6;
                if (this.mInterp > 0) break;
                if (this.mTotemRequested > -1) {
                    this.mPixeline.eventRequestTransform(this.mTotemRequested);
                    this.mTotemRequested = -1;
                }
                this.mInterp = 0;
                this.mBarState = 0;
            }
        }
    }

    private boolean selectTotem(int n) {
        this.mSelectedButton = n;
        if (GameState.isTotemUnlocked(n)) {
            this.mTotemRequested = n;
            SoundBuffer.play(18, 500);
            return true;
        }
        if (Touch.wasReleased(n)) {
            SoundBuffer.play(20, 500);
        }
        return false;
    }

    public void update() {
        if (this.mState == 1) {
            int n;
            PixelineData pixelineData = this.mPixeline.getDataRef();
            if (!Dialog.isActive() && pixelineData.isAlive() && !this.mPixeline.hasWon()) {
                if (this.mBarState == 2) {
                    for (n = 0; n < 4; ++n) {
                        this.mButtonPressed[n] = (InputProxy.isHeldFire() || InputProxy.isHeldOK() || InputProxy.isPressedOK()) && this.mSelectedButton == n;
                    }
                } else if (this.mBarState == 0) {
                    this.mButtonPressed[0] = InputProxy.isHeldFire2() || InputProxy.isPressedFire2();
                }
                this.handleTotem(pixelineData.getTotemState());
            }
            for (n = 0; n < this.mAnimLoseHealth.length; ++n) {
                if (!this.mAnimLoseHealthActive[n] || !this.mAnimLoseHealth[n].update(Timer.mDt)) continue;
                this.mAnimLoseHealth[n].gotoTick(0);
                this.mAnimLoseHealthActive[n] = false;
            }
            if (this.mAnimGainLifeActive && this.mAnimGainLife.update(Timer.mDt)) {
                this.mAnimGainLife.gotoTick(0);
                this.mAnimGainLifeActive = false;
            }
            switch (this.mKeyState) {
                case 0: {
                    if (GameState.mActiveNumUnusedKeys <= 0) break;
                    this.mAnimKeyEnter.gotoTick(0);
                    this.mKeyState = 1;
                    break;
                }
                case 1: {
                    if (GameState.mActiveNumUnusedKeys <= 0) {
                        this.mAnimKeyExit.gotoTick(0);
                        this.mKeyState = 3;
                        break;
                    }
                    if (!this.mAnimKeyEnter.update(Timer.mDt)) break;
                    this.mAnimKeyIdle.gotoTick(0);
                    this.mKeyState = 2;
                    break;
                }
                case 2: {
                    if (GameState.mActiveNumUnusedKeys <= 0) {
                        this.mAnimKeyExit.gotoTick(0);
                        this.mKeyState = 3;
                        break;
                    }
                    this.mAnimKeyIdle.update(Timer.mDt);
                    break;
                }
                case 3: {
                    if (GameState.mActiveNumUnusedKeys > 0) {
                        this.mAnimKeyEnter.gotoTick(0);
                        this.mKeyState = 1;
                        break;
                    }
                    if (!this.mAnimKeyExit.update(Timer.mDt)) break;
                    this.mKeyState = 0;
                }
            }
        } else {
            this.mSpringLifeBox.update(Timer.mDt);
            this.mSpringCoinBox.update(Timer.mDt);
            if (this.mSpringLifeBox.isDone() && this.mSpringCoinBox.isDone()) {
                this.mState = 1;
            }
        }
    }

    public void draw(int n) {
        if (StateGame.mState == 3) {
            return;
        }
        int n2 = this.mSpringLifeBox.getX() >> 16;
        int n3 = this.mSpringLifeBox.getY() >> 16;
        int n4 = this.mSpringCoinBox.getX() >> 16;
        int n5 = this.mSpringCoinBox.getY() >> 16;
        PMImageManager.draw(479, n2, n3);
        PMImageManager.draw(481, n4, n5);
        PixelineData pixelineData = this.mPixeline.getDataRef();
        int n6 = VarProxy.HUD_livesX + n2;
        int n7 = VarProxy.HUD_livesY;
        if (this.mAnimGainLifeActive) {
            this.mAnimGainLife.draw(n6, n7);
        } else {
            PMImageManager.draw(473, n6, n7);
        }
        PMImageManager.draw(478, n6 += 9, n7);
        PMCanvas.PMGraphics_drawString(n6 += 13, n7 - 9, "" + GameState.mLives, 0);
        int n8 = pixelineData.getHealth();
        for (int i = 0; i < 3; ++i) {
            switch (i) {
                case 0: {
                    n6 = VarProxy.HUD_health1X + n2;
                    n7 = VarProxy.HUD_health1Y;
                    break;
                }
                case 1: {
                    n6 = VarProxy.HUD_health2X + n2;
                    n7 = VarProxy.HUD_health2Y;
                    break;
                }
                case 2: {
                    n6 = VarProxy.HUD_health3X + n2;
                    n7 = VarProxy.HUD_health3Y;
                }
            }
            if (i < n8) {
                PMImageManager.draw(474, n6, n7);
            } else {
                PMImageManager.draw(475, n6, n7);
            }
            if (!this.mAnimLoseHealthActive[i]) continue;
            this.mAnimLoseHealth[i].draw(n6, n7);
        }
        String string = "" + GameState.mSilverCoins;
        int n9 = 29 + PMFont.stringWidth(string, 0);
        n6 = n4 - (n9 >> 1) + 8;
        n7 = VarProxy.HUD_silverCoinsY;
        PMImageManager.draw(476, n6, n7);
        PMImageManager.draw(478, n6 += 8, n7);
        PMCanvas.PMGraphics_drawString(n6 += 13, n7 - 9, string, 0);
        switch (this.mKeyState) {
            case 1: {
                this.mAnimKeyEnter.draw(VarProxy.HUD_keyBoxX, 0);
                break;
            }
            case 2: {
                this.mAnimKeyIdle.draw(VarProxy.HUD_keyBoxX, 0);
                break;
            }
            case 3: {
                this.mAnimKeyExit.draw(VarProxy.HUD_keyBoxX, 0);
            }
        }
        n6 = 294;
        n7 = 214;
        PMImageManager.draw(494, n6, n7);
        if (this.mBarState != 0 && this.mTotembarEnabled) {
            n6 = 200;
            n7 = 214 - MathUtil.smoothStep(this.mInterp, this.mTotemBarHeight);
            int n10 = pixelineData.getTotemState();
            int n11 = 490;
            int n12 = 490;
            int n13 = 490;
            int n14 = 489;
            if (GameState.isTotem1Unlocked()) {
                n11 = this.mSelectedButton == 1 ? 482 : 486;
            } else if (this.mSelectedButton == 1) {
                n11 = 491;
            }
            if (GameState.isTotem2Unlocked()) {
                n12 = this.mSelectedButton == 2 ? 483 : 487;
            } else if (this.mSelectedButton == 2) {
                n12 = 491;
            }
            if (GameState.isTotem3Unlocked()) {
                n13 = this.mSelectedButton == 3 ? 484 : 488;
            } else if (this.mSelectedButton == 3) {
                n13 = 491;
            }
            n14 = this.mSelectedButton == 0 ? 485 : 489;
            PMImageManager.draw(n13, n6 + (this.mBarState == 2 && this.mButtonPressed[3] ? 2 : 0), n7 + (this.mBarState == 2 && this.mButtonPressed[3] ? 2 : 0));
            PMImageManager.draw(n12, n6 + (this.mBarState == 2 && this.mButtonPressed[2] ? 2 : 0), (n7 += 42) + (this.mBarState == 2 && this.mButtonPressed[2] ? 2 : 0));
            PMImageManager.draw(n11, n6 + (this.mBarState == 2 && this.mButtonPressed[1] ? 2 : 0), (n7 += 42) + (this.mBarState == 2 && this.mButtonPressed[1] ? 2 : 0));
            PMImageManager.draw(n14, n6 + (this.mBarState == 2 && this.mButtonPressed[0] ? 2 : 0), (n7 += 41) + (this.mBarState == 2 && this.mButtonPressed[0] ? 2 : 0));
        } else if (this.mTotembarEnabled) {
            n6 = 200 + (this.mButtonPressed[0] ? 2 : 0);
            n7 = 214 + (this.mButtonPressed[0] ? 2 : 0);
            PMImageManager.draw(492, n6, n7);
        }
        if (this.mBarState == 0) {
            InputProxy.drawTouchInput(true);
        }
    }

    public void activateTouch() {
    }

    public boolean totemBarActive() {
        return this.mBarState != 0;
    }

    public boolean isHUDReady() {
        return this.mState == 1;
    }

    public void eventLoseHealth(int n) {
        if (!this.mAnimLoseHealthActive[n]) {
            this.mAnimLoseHealthActive[n] = true;
        }
    }

    public void eventGainLife() {
        if (!this.mAnimGainLifeActive) {
            this.mAnimGainLifeActive = true;
            this.mAnimGainLife.gotoTick(0);
        }
    }
}

