/*
 * Decompiled with CFR 0.152.
 */
package dk.progressivemedia.rflib.system;

import dk.progressivemedia.rflib.system.PMSystem;
import dk.progressivemedia.rflib.system.PMTimerNative;
import dk.progressivemedia.rflib.util.PMMath;

public class PMTimer {
    public static boolean paused = false;
    private static long pauseTime = 0L;
    private static long currentRealTime = 0L;
    private static long externalTime = 0L;
    private static int targetDelta;
    private static int lastDelta;
    private static int pastDelta;
    private static int currentDelta;
    private static long startTick;
    private static long holdTick;
    private static long lastTick;

    public static int delta() {
        return currentDelta;
    }

    public static long gameTime() {
        return currentRealTime - externalTime;
    }

    public static long realTime() {
        return currentRealTime;
    }

    public static void update() {
        if (PMSystem.externalPause && !paused) {
            PMTimer.rfPauseGameTime();
            return;
        }
        if (!PMSystem.externalPause && paused) {
            PMTimer.rfResumeGameTime();
            return;
        }
        long l = PMTimerNative.getTime();
        if (!paused) {
            long l2 = currentRealTime - externalTime;
            long l3 = l - externalTime;
            int n = (int)(l3 - l2);
            n <<= 16;
            int n2 = PMMath.MUL(currentDelta, 98304);
            if (n2 < targetDelta) {
                n2 = targetDelta;
            }
            if (n > n2) {
                n = n2;
            }
            int n3 = n + currentDelta + lastDelta + pastDelta;
            n3 = PMMath.DIV(n3, 262144);
            pastDelta = lastDelta;
            lastDelta = currentDelta;
            currentDelta = n3;
        }
        currentRealTime = l;
    }

    public static void rfPauseGameTime() {
        pauseTime = PMTimerNative.getTime();
        paused = true;
    }

    public static void rfResumeGameTime() {
        currentRealTime = PMTimerNative.getTime();
        long l = currentRealTime - pauseTime;
        externalTime += l;
        paused = false;
    }

    public static long tick() {
        return PMTimerNative.getTime();
    }

    public static void setTick(long l) {
        startTick = PMTimer.tick() - l;
        holdTick = -1L;
        lastTick = l;
    }

    public static void pauseTick(boolean bl) {
        if (bl && holdTick == -1L) {
            holdTick = PMTimer.getTick();
        } else if (holdTick != -1L) {
            startTick = PMTimer.tick() - holdTick;
            lastTick = holdTick;
            holdTick = -1L;
        }
    }

    public static long getTick() {
        if (holdTick == -1L) {
            long l = PMTimer.tick() - startTick;
            if (l - 1000L > lastTick) {
                startTick += l - lastTick;
                l = PMTimer.tick() - startTick;
            }
            lastTick = l;
            return l;
        }
        return holdTick;
    }

    public static boolean isPaused() {
        return holdTick != -1L;
    }

    static {
        lastDelta = targetDelta = Math.max(32, 16) << 16;
        pastDelta = targetDelta;
        currentDelta = targetDelta;
        holdTick = -1L;
    }
}

